"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformOutput = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const util_2 = require("util");
const tokens_1 = require("./tokens");
const TERRAFORM_OUTPUT_SYMBOL = Symbol.for("cdktf/TerraformOutput");
class TerraformOutput extends terraform_element_1.TerraformElement {
    constructor(scope, id, config) {
        super(scope, id);
        this.value = config.value;
        this.description = config.description;
        this.sensitive = config.sensitive;
        this.dependsOn = config.dependsOn;
        this.staticId = config.staticId || false;
        Object.defineProperty(this, TERRAFORM_OUTPUT_SYMBOL, { value: true });
    }
    static isTerrafromOutput(x) {
        return x !== null && typeof x === "object" && TERRAFORM_OUTPUT_SYMBOL in x;
    }
    set staticId(staticId) {
        if (staticId)
            this.overrideLogicalId(this.node.id);
        else
            this.resetOverrideLogicalId();
    }
    get staticId() {
        return this.friendlyUniqueId === this.node.id;
    }
    isITerraformAddressable(object) {
        return (object &&
            typeof object === "object" &&
            !util_2.isArray(object) &&
            "fqn" in object);
    }
    synthesizeValue(arg) {
        if (tokens_1.Token.isUnresolved(arg)) {
            return arg;
        }
        if (this.isITerraformAddressable(arg)) {
            return arg.fqn;
        }
        if (Array.isArray(arg)) {
            return arg.map((innerArg) => this.synthesizeValue(innerArg));
        }
        if (typeof arg === "object") {
            return Object.keys(arg).reduce((result, key) => {
                result[key] = this.synthesizeValue(arg[key]);
                return result;
            }, {});
        }
        return arg;
    }
    synthesizeAttributes() {
        var _b;
        return {
            value: this.synthesizeValue(this.value),
            description: this.description,
            sensitive: this.sensitive,
            depends_on: (_b = this.dependsOn) === null || _b === void 0 ? void 0 : _b.map((resource) => resource.fqn),
        };
    }
    toTerraform() {
        return {
            output: {
                [this.friendlyUniqueId]: util_1.deepMerge(this.synthesizeAttributes(), this.rawOverrides),
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                output: Object.keys(this.rawOverrides),
            },
        };
    }
}
exports.TerraformOutput = TerraformOutput;
_a = JSII_RTTI_SYMBOL_1;
TerraformOutput[_a] = { fqn: "cdktf.TerraformOutput", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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