"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tokens_1 = require("./tokens");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
class TerraformProvider extends terraform_element_1.TerraformElement {
    constructor(scope, id, config) {
        super(scope, id);
        this.terraformResourceType = config.terraformResourceType;
        this.terraformGeneratorMetadata = config.terraformGeneratorMetadata;
        this.terraformProviderSource = config.terraformProviderSource;
    }
    get alias() {
        // This is always* being overriden currently
        return undefined;
    }
    set alias(_value) {
        // This is always* being overriden currently
    }
    get fqn() {
        return this.alias !== undefined
            ? tokens_1.Token.asString(`${this.terraformResourceType}.${this.alias}`)
            : tokens_1.Token.asString(`${this.terraformResourceType}`);
    }
    get metaAttributes() {
        return this.alias !== undefined ? { alias: this.alias } : {};
    }
    // jsii can't handle abstract classes?
    synthesizeAttributes() {
        return {};
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform() {
        var _b, _c;
        return {
            terraform: {
                required_providers: {
                    [this.terraformResourceType]: {
                        version: ((_b = this.terraformGeneratorMetadata) === null || _b === void 0 ? void 0 : _b.providerVersion) || ((_c = this.terraformGeneratorMetadata) === null || _c === void 0 ? void 0 : _c.providerVersionConstraint),
                        source: this.terraformProviderSource,
                    },
                },
            },
            provider: {
                [this.terraformResourceType]: [
                    util_1.deepMerge(util_1.keysToSnakeCase(this.synthesizeAttributes()), this.rawOverrides, this.metaAttributes),
                ],
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                [this.terraformResourceType]: Object.keys(this.rawOverrides),
            },
        };
    }
}
exports.TerraformProvider = TerraformProvider;
_a = JSII_RTTI_SYMBOL_1;
TerraformProvider[_a] = { fqn: "cdktf.TerraformProvider", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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