"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformRemoteState = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const tokens_1 = require("./tokens");
const util_1 = require("./util");
const tfExpression_1 = require("./tfExpression");
class TerraformRemoteState extends terraform_element_1.TerraformElement {
    constructor(scope, id, backend, config) {
        super(scope, id);
        this.backend = backend;
        this.config = config;
        this.fqn = tokens_1.Token.asString(tfExpression_1.ref(`data.terraform_remote_state.${this.friendlyUniqueId}`, this.cdktfStack));
    }
    getString(output) {
        return tokens_1.Token.asString(this.interpolationForAttribute(output));
    }
    getNumber(output) {
        return tokens_1.Token.asNumber(this.interpolationForAttribute(output));
    }
    getList(output) {
        return tokens_1.Token.asList(this.interpolationForAttribute(output));
    }
    getBoolean(output) {
        return this.interpolationForAttribute(output);
    }
    get(output) {
        return this.interpolationForAttribute(output);
    }
    interpolationForAttribute(terraformAttribute) {
        return tfExpression_1.ref(`data.terraform_remote_state.${this.friendlyUniqueId}.outputs.${terraformAttribute}`, this.cdktfStack);
    }
    extractConfig() {
        const configObj = util_1.keysToSnakeCase({ ...this.config });
        delete configObj.workspace;
        delete configObj.defaults;
        return configObj;
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform() {
        return {
            data: {
                terraform_remote_state: {
                    [this.friendlyUniqueId]: util_1.deepMerge({
                        backend: this.backend,
                        workspace: this.config.workspace,
                        defaults: this.config.defaults,
                        config: this.extractConfig(),
                    }, this.rawOverrides),
                },
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                terraform_remote_state: Object.keys(this.rawOverrides),
            },
        };
    }
}
exports.TerraformRemoteState = TerraformRemoteState;
_a = JSII_RTTI_SYMBOL_1;
TerraformRemoteState[_a] = { fqn: "cdktf.TerraformRemoteState", version: "0.11.0-pre.4" };
TerraformRemoteState.tfResourceType = "terraform_remote_state";
//# sourceMappingURL=data:application/json;base64,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