"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tokens_1 = require("./tokens");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const tfExpression_1 = require("./tfExpression");
class TerraformResource extends terraform_element_1.TerraformElement {
    constructor(scope, id, config) {
        super(scope, id);
        this.terraformResourceType = config.terraformResourceType;
        this.terraformGeneratorMetadata = config.terraformGeneratorMetadata;
        if (Array.isArray(config.dependsOn)) {
            this.dependsOn = config.dependsOn.map((dependency) => tfExpression_1.insideTfExpression(dependency.fqn));
        }
        this.count = config.count;
        this.provider = config.provider;
        this.lifecycle = config.lifecycle;
        this.fqn = tokens_1.Token.asString(tfExpression_1.ref(`${this.terraformResourceType}.${this.friendlyUniqueId}`, this.cdktfStack));
    }
    getStringAttribute(terraformAttribute) {
        return tokens_1.Token.asString(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberAttribute(terraformAttribute) {
        return tokens_1.Token.asNumber(this.interpolationForAttribute(terraformAttribute));
    }
    getListAttribute(terraformAttribute) {
        return tokens_1.Token.asList(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanAttribute(terraformAttribute) {
        return this.interpolationForAttribute(terraformAttribute);
    }
    getNumberListAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberList(this.interpolationForAttribute(terraformAttribute));
    }
    getStringMapAttribute(terraformAttribute) {
        return tokens_1.Token.asStringMap(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberMapAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberMap(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanMapAttribute(terraformAttribute) {
        return tokens_1.Token.asBooleanMap(this.interpolationForAttribute(terraformAttribute));
    }
    getAnyMapAttribute(terraformAttribute) {
        return tokens_1.Token.asAnyMap(this.interpolationForAttribute(terraformAttribute));
    }
    get terraformMetaArguments() {
        var _b;
        return {
            dependsOn: this.dependsOn,
            count: this.count,
            provider: (_b = this.provider) === null || _b === void 0 ? void 0 : _b.fqn,
            lifecycle: this.lifecycle,
        };
    }
    // jsii can't handle abstract classes?
    synthesizeAttributes() {
        return {};
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform() {
        var _b;
        const attributes = util_1.deepMerge(this.synthesizeAttributes(), util_1.keysToSnakeCase(this.terraformMetaArguments), this.rawOverrides);
        attributes["//"] = {
            ...((_b = attributes["//"]) !== null && _b !== void 0 ? _b : {}),
            ...this.constructNodeMetadata,
        };
        return {
            resource: {
                [this.terraformResourceType]: {
                    [this.friendlyUniqueId]: attributes,
                },
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                [this.terraformResourceType]: Object.keys(this.rawOverrides),
            },
        };
    }
    interpolationForAttribute(terraformAttribute) {
        return tfExpression_1.ref(`${this.terraformResourceType}.${this.friendlyUniqueId}.${terraformAttribute}`, this.cdktfStack);
    }
}
exports.TerraformResource = TerraformResource;
_a = JSII_RTTI_SYMBOL_1;
TerraformResource[_a] = { fqn: "cdktf.TerraformResource", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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