import { Construct, IConstruct, Node } from "constructs";
import { TerraformElement } from "./terraform-element";
import { TerraformProvider } from "./terraform-provider";
import { TerraformOutput } from "./terraform-output";
import { TerraformRemoteState } from "./terraform-remote-state";
import { IStackSynthesizer } from "./synthesize/types";
import { TerraformBackend } from "./terraform-backend";
export interface TerraformStackMetadata {
    readonly stackName: string;
    readonly version: string;
    readonly backend: string;
}
export declare class TerraformStack extends Construct {
    private readonly rawOverrides;
    private readonly cdktfVersion;
    private crossStackOutputs;
    private crossStackDataSources;
    synthesizer: IStackSynthesizer;
    dependencies: TerraformStack[];
    constructor(scope: Construct, id: string);
    static isStack(x: any): x is TerraformStack;
    static of(construct: IConstruct): TerraformStack;
    private findAll;
    prepareStack(): void;
    addOverride(path: string, value: any): void;
    getLogicalId(tfElement: TerraformElement | Node): string;
    /**
     * Returns the naming scheme used to allocate logical IDs. By default, uses
     * the `HashedAddressingScheme` but this method can be overridden to customize
     * this behavior.
     *
     * @param tfElement The element for which the logical ID is allocated.
     */
    protected allocateLogicalId(tfElement: TerraformElement | Node): string;
    allProviders(): TerraformProvider[];
    ensureBackendExists(): TerraformBackend;
    toTerraform(): any;
    registerOutgoingCrossStackReference(identifier: string): TerraformOutput;
    registerIncomingCrossStackReference(fromStack: TerraformStack): TerraformRemoteState;
    dependsOn(stack: TerraformStack): boolean;
    addDependency(dependency: TerraformStack): void;
}
