"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const _tokens_1 = require("./_tokens");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const terraform_provider_1 = require("./terraform-provider");
const local_backend_1 = require("./backends/local-backend");
const tfExpression_1 = require("./tfExpression");
const terraform_output_1 = require("./terraform-output");
const features_1 = require("./features");
const unique_1 = require("./private/unique");
const synthesizer_1 = require("./synthesize/synthesizer");
const STACK_SYMBOL = Symbol.for("cdktf/TerraformStack");
const validations_1 = require("./validations");
const app_1 = require("./app");
const terraform_backend_1 = require("./terraform-backend");
function throwIfIdIsGlobCharacter(str) {
    const err = (char) => `Can not create Terraform stack with id "${str}". It contains a glob character: "${char}"`;
    ["*", "?", "[", "]", "{", "}", "!"].forEach((char) => {
        if (str.includes(char)) {
            throw new Error(err(char));
        }
    });
}
class TerraformStack extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.rawOverrides = {};
        this.crossStackOutputs = {};
        this.crossStackDataSources = {};
        this.dependencies = [];
        throwIfIdIsGlobCharacter(id);
        this.cdktfVersion = this.node.tryGetContext("cdktfVersion");
        this.synthesizer = new synthesizer_1.StackSynthesizer(this, process.env.CDKTF_CONTINUE_SYNTH_ON_ERROR_ANNOTATIONS !== undefined);
        Object.defineProperty(this, STACK_SYMBOL, { value: true });
        this.node.addValidation(new validations_1.ValidateProviderPresence(this));
    }
    static isStack(x) {
        return x !== null && typeof x === "object" && STACK_SYMBOL in x;
    }
    static of(construct) {
        return _lookup(construct);
        function _lookup(c) {
            if (TerraformStack.isStack(c)) {
                return c;
            }
            const node = c.node;
            if (!node.scope) {
                let hint = "";
                if (construct.node.scope === c &&
                    c instanceof app_1.App &&
                    construct instanceof terraform_backend_1.TerraformBackend) {
                    // the scope of the originally passed construct equals the construct c
                    // which has no scope (i.e. has no parent construct) and c is an App
                    // and our construct is a Backend
                    hint = `. You seem to have passed your root App as scope to a TerraformBackend construct. Pass a stack as scope to your backend instead.`;
                }
                throw new Error(`No stack could be identified for the construct at path '${construct.node.path}'${hint}`);
            }
            return _lookup(node.scope);
        }
    }
    findAll({ byConstructor: ClassConstructor, byPredicate, }) {
        const predicate = ClassConstructor
            ? (x) => x instanceof ClassConstructor
            : byPredicate;
        if (!predicate) {
            throw new Error("Either byConstructor or byPredicate must be provided");
        }
        const items = [];
        const visit = async (node) => {
            if (predicate(node)) {
                items.push(node);
            }
            for (const child of node.node.children) {
                visit(child);
            }
        };
        visit(this);
        return items;
    }
    prepareStack() {
        // Ensure we have a backend configured
        this.ensureBackendExists();
        // A preparing resolve run might add new resources to the stack, e.g. for cross stack references.
        terraformElements(this).forEach((e) => _tokens_1.resolve(this, e.toTerraform(), true));
    }
    addOverride(path, value) {
        const parts = path.split(".");
        let curr = this.rawOverrides;
        while (parts.length > 1) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            const key = parts.shift();
            // if we can't recurse further or the previous value is not an
            // object overwrite it with an object.
            const isObject = curr[key] != null &&
                typeof curr[key] === "object" &&
                !Array.isArray(curr[key]);
            if (!isObject) {
                curr[key] = {};
            }
            curr = curr[key];
        }
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        const lastKey = parts.shift();
        curr[lastKey] = value;
    }
    getLogicalId(tfElement) {
        // wrap the allocation for future renaming support
        return this.allocateLogicalId(tfElement);
    }
    /**
     * Returns the naming scheme used to allocate logical IDs. By default, uses
     * the `HashedAddressingScheme` but this method can be overridden to customize
     * this behavior.
     *
     * @param tfElement The element for which the logical ID is allocated.
     */
    allocateLogicalId(tfElement) {
        const node = tfElement instanceof terraform_element_1.TerraformElement ? tfElement.node : tfElement;
        const stack = tfElement instanceof terraform_element_1.TerraformElement ? tfElement.cdktfStack : this;
        let stackIndex;
        if (node.tryGetContext(features_1.EXCLUDE_STACK_ID_FROM_LOGICAL_IDS)) {
            stackIndex = node.scopes.indexOf(stack);
        }
        else {
            stackIndex = 0;
        }
        const components = node.scopes.slice(stackIndex + 1).map((c) => c.node.id);
        return components.length > 0
            ? unique_1.makeUniqueId(components, node.tryGetContext(features_1.ALLOW_SEP_CHARS_IN_LOGICAL_IDS))
            : "";
    }
    allProviders() {
        return this.findAll({ byConstructor: terraform_provider_1.TerraformProvider });
    }
    ensureBackendExists() {
        const backends = this.findAll({
            byPredicate: (item) => terraform_backend_1.TerraformBackend.isBackend(item),
        });
        return backends[0] || new local_backend_1.LocalBackend(this, {});
    }
    toTerraform() {
        const tf = {};
        const metadata = {
            version: this.cdktfVersion,
            stackName: this.node.id,
            backend: "local",
            ...(Object.keys(this.rawOverrides).length > 0
                ? { overrides: { stack: Object.keys(this.rawOverrides) } }
                : {}),
        };
        const elements = terraformElements(this);
        const metadatas = elements.map((e) => _tokens_1.resolve(this, e.toMetadata()));
        for (const meta of metadatas) {
            util_1.deepMerge(metadata, meta);
        }
        const outputs = elements.reduce((carry, item) => {
            if (!terraform_output_1.TerraformOutput.isTerrafromOutput(item)) {
                return carry;
            }
            util_1.deepMerge(carry, item.node.path.split("/").reduceRight((innerCarry, part) => {
                if (Object.keys(innerCarry).length === 0) {
                    return { [part]: item.friendlyUniqueId };
                }
                return { [part]: innerCarry };
            }, {}));
            return carry;
        }, {});
        tf["//"] = { metadata, outputs };
        const fragments = elements.map((e) => _tokens_1.resolve(this, e.toTerraform()));
        for (const fragment of fragments) {
            util_1.deepMerge(tf, fragment);
        }
        util_1.deepMerge(tf, this.rawOverrides);
        return _tokens_1.resolve(this, tf);
    }
    registerOutgoingCrossStackReference(identifier) {
        if (this.crossStackOutputs[identifier]) {
            return this.crossStackOutputs[identifier];
        }
        const output = new terraform_output_1.TerraformOutput(this, `cross-stack-output-${identifier}`, {
            value: tfExpression_1.ref(identifier, this),
            sensitive: true,
        });
        this.crossStackOutputs[identifier] = output;
        return output;
    }
    registerIncomingCrossStackReference(fromStack) {
        if (this.crossStackDataSources[String(fromStack)]) {
            return this.crossStackDataSources[String(fromStack)];
        }
        const originBackend = fromStack.ensureBackendExists();
        const originPath = fromStack.node.path;
        const remoteState = originBackend.getRemoteStateDataSource(this, `cross-stack-reference-input-${originPath}`, originPath);
        this.crossStackDataSources[originPath] = remoteState;
        return remoteState;
    }
    // Check here for loops in the dependency graph
    dependsOn(stack) {
        return (this.dependencies.includes(stack) ||
            this.dependencies.some((d) => d.dependsOn(stack)));
    }
    addDependency(dependency) {
        if (dependency.dependsOn(this)) {
            throw new Error(`Can not add dependency ${dependency} to ${this} since it would result in a loop`);
        }
        if (this.dependencies.includes(dependency)) {
            return;
        }
        this.dependencies.push(dependency);
    }
}
exports.TerraformStack = TerraformStack;
_a = JSII_RTTI_SYMBOL_1;
TerraformStack[_a] = { fqn: "cdktf.TerraformStack", version: "0.11.0-pre.4" };
function terraformElements(node, into = []) {
    if (node instanceof terraform_element_1.TerraformElement) {
        into.push(node);
    }
    for (const child of node.node.children) {
        // Don't recurse into a substack
        if (TerraformStack.isStack(child)) {
            continue;
        }
        terraformElements(child, into);
    }
    return into;
}
//# sourceMappingURL=data:application/json;base64,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