"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformVariable = exports.VariableType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const tokens_1 = require("./tokens");
const tfExpression_1 = require("./tfExpression");
class VariableType {
    static list(type) {
        return `list(${type})`;
    }
    static map(type) {
        return `map(${type})`;
    }
    static set(type) {
        return `set(${type})`;
    }
    static tuple(...elements) {
        return `tuple(${elements.join(", ")})`;
    }
    static object(attributes) {
        return `object({${Object.keys(attributes)
            .map((k) => k + "=" + attributes[k])
            .join(", ")}})`;
    }
}
exports.VariableType = VariableType;
_a = JSII_RTTI_SYMBOL_1;
VariableType[_a] = { fqn: "cdktf.VariableType", version: "0.11.0-pre.4" };
VariableType.STRING = "string";
VariableType.NUMBER = "number";
VariableType.BOOL = "bool";
VariableType.ANY = "any";
VariableType.LIST = "list";
VariableType.MAP = "map";
VariableType.SET = "set";
VariableType.LIST_STRING = "list(string)";
VariableType.LIST_NUMBER = "list(number)";
VariableType.LIST_BOOL = "list(bool)";
VariableType.MAP_STRING = "map(string)";
VariableType.MAP_NUMBER = "map(number)";
VariableType.MAP_BOOL = "map(bool)";
VariableType.SET_STRING = "set(string)";
VariableType.SET_NUMBER = "set(number)";
VariableType.SET_BOOL = "set(bool)";
class TerraformVariable extends terraform_element_1.TerraformElement {
    constructor(scope, id, config) {
        super(scope, id);
        this.default = config.default;
        this.description = config.description;
        this.type = config.type;
        this.sensitive = config.sensitive;
        this.nullable = config.nullable;
        this.fqn = tokens_1.Token.asString(this.interpolation());
    }
    get stringValue() {
        return tokens_1.Token.asString(this.interpolation());
    }
    get numberValue() {
        return tokens_1.Token.asNumber(this.interpolation());
    }
    get listValue() {
        return tokens_1.Token.asList(this.interpolation());
    }
    get booleanValue() {
        return this.interpolation();
    }
    get value() {
        return tokens_1.Token.asAny(this.interpolation());
    }
    interpolation() {
        return tfExpression_1.ref(`var.${this.friendlyUniqueId}`, this.cdktfStack);
    }
    synthesizeAttributes() {
        return {
            default: this.default,
            description: this.description,
            type: this.type,
            sensitive: this.sensitive,
            nullable: this.nullable,
        };
    }
    toTerraform() {
        return {
            variable: {
                [this.friendlyUniqueId]: util_1.deepMerge(util_1.keysToSnakeCase(this.synthesizeAttributes()), this.rawOverrides),
            },
        };
    }
}
exports.TerraformVariable = TerraformVariable;
_b = JSII_RTTI_SYMBOL_1;
TerraformVariable[_b] = { fqn: "cdktf.TerraformVariable", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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