"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupJest = void 0;
const matchers_1 = require("../matchers");
const matchers_2 = require("../matchers");
// Jest supports asymetric matchers (https://github.com/facebook/jest/blob/main/packages/expect/src/asymmetricMatchers.ts)
// These matchers are great in expressing partial equality in a deeply nested way
// As we want to support more than one testing framework we can not use them everywhere
function jestPassEvaluation(items, assertedProperties) {
    if (Object.entries(assertedProperties).length === 0) {
        return items.length > 0;
    }
    else {
        if (global.expect) {
            const expect = global.expect;
            return expect
                .arrayContaining([expect.objectContaining(assertedProperties)])
                .asymmetricMatch(items);
        }
        else {
            throw new Error("expect is not defined, jest was not propely instantiated");
        }
    }
}
function setupJest() {
    if (!("expect" in global)) {
        throw new Error("setupJest called, but expect is not globally accessible");
    }
    const expect = global.expect;
    expect.extend({
        toHaveResource(received, resourceConstructor) {
            return matchers_2.getToHaveResourceWithProperties(jestPassEvaluation)(received, resourceConstructor, {});
        },
        toHaveResourceWithProperties(received, resourceConstructor, properties) {
            return matchers_2.getToHaveResourceWithProperties(jestPassEvaluation)(received, resourceConstructor, properties);
        },
        toHaveDataSource(received, dataSourceConstructor) {
            return matchers_1.getToHaveDataSourceWithProperties(jestPassEvaluation)(received, dataSourceConstructor, {});
        },
        toHaveDataSourceWithProperties(received, dataSourceConstructor, properties) {
            return matchers_1.getToHaveDataSourceWithProperties(jestPassEvaluation)(received, dataSourceConstructor, properties);
        },
        toBeValidTerraform(received) {
            return matchers_1.toBeValidTerraform(received);
        },
        toPlanSuccessfully(received) {
            return matchers_1.toPlanSuccessfully(received);
        },
    });
}
exports.setupJest = setupJest;
//# sourceMappingURL=data:application/json;base64,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