import { App } from "../../lib";
import { TerraformStack } from "../terraform-stack";
import { IConstruct, Construct } from "constructs";
export interface IScopeCallback {
    (scope: Construct): void;
}
export interface TestingAppOptions {
    readonly outdir?: string;
    readonly stackTraces?: boolean;
    readonly stubVersion?: boolean;
    readonly enableFutureFlags?: boolean;
    readonly fakeCdktfJsonPath?: boolean;
}
/**
 * Testing utilities for cdktf applications.
 */
export declare class Testing {
    /**
     * Returns an app for testing with the following properties:
     * - Output directory is a temp dir.
     */
    static app(options?: TestingAppOptions): App;
    static stubVersion(app: App): App;
    static fakeCdktfJsonPath(app: App): App;
    static enableFutureFlags(app: App): App;
    static synthScope(fn: IScopeCallback): string;
    /**
     * Returns the Terraform synthesized JSON.
     */
    static synth(stack: TerraformStack): string;
    static fullSynth(stack: TerraformStack): string;
    static renderConstructTree(construct: IConstruct): string;
    static setupJest(): void;
    private constructor();
}
