"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Intrinsic = void 0;
const token_1 = require("../token");
const stack_trace_1 = require("./stack-trace");
/**
 * Token subclass that represents values intrinsic to the target document language
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 */
class Intrinsic {
    constructor(value) {
        if (isFunction(value)) {
            throw new Error(`Argument to Intrinsic must be a plain value object, got ${value}`);
        }
        this.creationStack = stack_trace_1.captureStackTrace();
        this.value = value;
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    resolve(_context) {
        return this.value;
    }
    /**
     * Convert an instance of this Token to a string
     *
     * This method will be called implicitly by language runtimes if the object
     * is embedded into a string. We treat it the same as an explicit
     * stringification.
     */
    toString() {
        return token_1.Token.asString(this);
    }
    /**
     * Turn this Token into JSON
     *
     * Called automatically when JSON.stringify() is called on a Token.
     */
    toJSON() {
        // We can't do the right work here because in case we contain a function, we
        // won't know the type of value that function represents (in the simplest
        // case, string or number), and we can't know that without an
        // IResolveContext to actually do the resolution, which we don't have.
        // We used to throw an error, but since JSON.stringify() is often used in
        // error messages to produce a readable representation of an object, if we
        // throw here we'll obfuscate that descriptive error with something worse.
        // So return a string representation that indicates this thing is a token
        // and needs resolving.
        return `<unresolved-token>`;
    }
    /**
     * Creates a throwable Error object that contains the token creation stack trace.
     * @param message Error message
     */
    newError(message) {
        return new Error(`${message}\nToken created:\n    at ${this.creationStack.join("\n    at ")}\nError thrown:`);
    }
}
exports.Intrinsic = Intrinsic;
function isFunction(x) {
    return typeof x === "function";
}
//# sourceMappingURL=data:application/json;base64,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