"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultTokenResolver = exports.StringConcat = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const encoding_1 = require("./private/encoding");
const token_map_1 = require("./private/token-map");
/**
 * Converts all fragments to strings and concats those
 *
 * Drops 'undefined's.
 */
class StringConcat {
    join(left, right) {
        if (left === undefined) {
            return right !== undefined ? `${right}` : undefined;
        }
        if (right === undefined) {
            return `${left}`;
        }
        return `${left}${right}`;
    }
}
exports.StringConcat = StringConcat;
_a = JSII_RTTI_SYMBOL_1;
StringConcat[_a] = { fqn: "cdktf.StringConcat", version: "0.11.0-pre.4" };
/**
 * Default resolver implementation
 *
 * @experimental
 */
class DefaultTokenResolver {
    constructor(concat) {
        this.concat = concat;
    }
    /**
     * Default Token resolution
     *
     * Resolve the Token, recurse into whatever it returns,
     * then finally post-process it.
     */
    resolveToken(t, context, postProcessor) {
        try {
            let resolved = t.resolve(context);
            // The token might have returned more values that need resolving, recurse
            resolved = context.resolve(resolved);
            resolved = postProcessor.postProcess(resolved, context);
            return resolved;
        }
        catch (e) {
            let message = `Resolution error: ${e.message}.`;
            if (t.creationStack && t.creationStack.length > 0) {
                message += `\nObject creation stack:\n  at ${t.creationStack.join("\n  at ")}`;
            }
            e.message = message;
            throw e;
        }
    }
    /**
     * Resolve string fragments to Tokens
     */
    resolveString(fragments, context) {
        return fragments.mapTokens({ mapToken: context.resolve }).join(this.concat);
    }
    resolveList(xs, context) {
        // Must be a singleton list token, because concatenation is not allowed.
        if (xs.length !== 1) {
            throw new Error(`Cannot add elements to list token, got: ${xs}`);
        }
        const str = encoding_1.TokenString.forListToken(xs[0]);
        const tokenMap = token_map_1.TokenMap.instance();
        const fragments = str.split(tokenMap.lookupToken.bind(tokenMap));
        if (fragments.length !== 1) {
            throw new Error(`Cannot concatenate strings in a tokenized string array, got: ${xs[0]}`);
        }
        return fragments.mapTokens({ mapToken: context.resolve }).firstValue;
    }
    resolveNumberList(xs, context) {
        // Must be a singleton list token, because concatenation is not allowed.
        if (xs.length !== 1) {
            throw new Error(`Cannot add elements to list token, got: ${xs}`);
        }
        const token = token_map_1.TokenMap.instance().lookupNumberList(xs);
        if (token === undefined) {
            return xs;
        }
        return context.resolve(token);
    }
    resolveMap(xs, context) {
        const keys = Object.keys(xs);
        if (keys.length !== 1) {
            throw new Error(`Cannot add elements to map token, got: ${xs}`);
        }
        const str = encoding_1.TokenString.forMapToken(keys[0]);
        const tokenMap = token_map_1.TokenMap.instance();
        const fragments = str.split(tokenMap.lookupToken.bind(tokenMap));
        if (fragments.length !== 1) {
            throw new Error(`Cannot concatenate strings in a tokenized map, got: ${xs[0]}`);
        }
        return fragments.mapTokens({ mapToken: context.resolve }).firstValue;
    }
}
exports.DefaultTokenResolver = DefaultTokenResolver;
_b = JSII_RTTI_SYMBOL_1;
DefaultTokenResolver[_b] = { fqn: "cdktf.DefaultTokenResolver", version: "0.11.0-pre.4" };
//# sourceMappingURL=data:application/json;base64,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