"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateEnvironment = void 0;
const constructs_1 = require("constructs");
// fails early if the environment contains e.g. invalid version combinations
function validateEnvironment() {
    validateConstructsIsV10();
}
exports.validateEnvironment = validateEnvironment;
function validateConstructsIsV10() {
    const construct = new constructs_1.Construct(null, "test");
    // construct.node was added in v10
    if (typeof construct.node === "undefined") {
        throw new Error(`Version mismatch! The constructs depedency appears to be lower than v10 which is required as of cdktf version 0.6.
    Your current constructs version is missing Construct.node which was added in v10.
    Please update your constructs dependency: https://cdk.tf/upgrade-constructs-v10
`);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmFsaWRhdGVFbnZpcm9ubWVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInZhbGlkYXRlRW52aXJvbm1lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsMkNBQXVDO0FBRXZDLDRFQUE0RTtBQUM1RSxTQUFnQixtQkFBbUI7SUFDakMsdUJBQXVCLEVBQUUsQ0FBQztBQUM1QixDQUFDO0FBRkQsa0RBRUM7QUFFRCxTQUFTLHVCQUF1QjtJQUM5QixNQUFNLFNBQVMsR0FBRyxJQUFJLHNCQUFTLENBQUMsSUFBVyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0lBQ3JELGtDQUFrQztJQUNsQyxJQUFJLE9BQU8sU0FBUyxDQUFDLElBQUksS0FBSyxXQUFXLEVBQUU7UUFDekMsTUFBTSxJQUFJLEtBQUssQ0FBQzs7O0NBR25CLENBQUMsQ0FBQztLQUNBO0FBQ0gsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5cbi8vIGZhaWxzIGVhcmx5IGlmIHRoZSBlbnZpcm9ubWVudCBjb250YWlucyBlLmcuIGludmFsaWQgdmVyc2lvbiBjb21iaW5hdGlvbnNcbmV4cG9ydCBmdW5jdGlvbiB2YWxpZGF0ZUVudmlyb25tZW50KCkge1xuICB2YWxpZGF0ZUNvbnN0cnVjdHNJc1YxMCgpO1xufVxuXG5mdW5jdGlvbiB2YWxpZGF0ZUNvbnN0cnVjdHNJc1YxMCgpIHtcbiAgY29uc3QgY29uc3RydWN0ID0gbmV3IENvbnN0cnVjdChudWxsIGFzIGFueSwgXCJ0ZXN0XCIpO1xuICAvLyBjb25zdHJ1Y3Qubm9kZSB3YXMgYWRkZWQgaW4gdjEwXG4gIGlmICh0eXBlb2YgY29uc3RydWN0Lm5vZGUgPT09IFwidW5kZWZpbmVkXCIpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoYFZlcnNpb24gbWlzbWF0Y2ghIFRoZSBjb25zdHJ1Y3RzIGRlcGVkZW5jeSBhcHBlYXJzIHRvIGJlIGxvd2VyIHRoYW4gdjEwIHdoaWNoIGlzIHJlcXVpcmVkIGFzIG9mIGNka3RmIHZlcnNpb24gMC42LlxuICAgIFlvdXIgY3VycmVudCBjb25zdHJ1Y3RzIHZlcnNpb24gaXMgbWlzc2luZyBDb25zdHJ1Y3Qubm9kZSB3aGljaCB3YXMgYWRkZWQgaW4gdjEwLlxuICAgIFBsZWFzZSB1cGRhdGUgeW91ciBjb25zdHJ1Y3RzIGRlcGVuZGVuY3k6IGh0dHBzOi8vY2RrLnRmL3VwZ3JhZGUtY29uc3RydWN0cy12MTBcbmApO1xuICB9XG59XG4iXX0=