"use strict";(globalThis.webpackChunkdocs=globalThis.webpackChunkdocs||[]).push([[624],{6439:(e,n,s)=>{s.r(n),s.d(n,{assets:()=>a,contentTitle:()=>c,default:()=>p,frontMatter:()=>l,metadata:()=>r,toc:()=>o});const r=JSON.parse('{"id":"api","title":"API Reference","description":"The vMCP backend provides a comprehensive REST API for managing vMCPs, MCP servers, and monitoring usage.","source":"@site/docs/api.md","sourceDirName":".","slug":"/api","permalink":"/documentation/api","draft":false,"unlisted":false,"tags":[],"version":"current","sidebarPosition":10,"frontMatter":{"sidebar_position":10},"sidebar":"tutorialSidebar","previous":{"title":"Configuration","permalink":"/documentation/configuration"},"next":{"title":"Creating Your First vMCP","permalink":"/documentation/tutorial-basics/create-vmcp"}}');var i=s(4848),t=s(8453);const l={sidebar_position:10},c="API Reference",a={},o=[{value:"Base URL",id:"base-url",level:2},{value:"Authentication",id:"authentication",level:2},{value:"vMCP Management",id:"vmcp-management",level:2},{value:"List vMCPs",id:"list-vmcps",level:3},{value:"Get vMCP",id:"get-vmcp",level:3},{value:"Create vMCP",id:"create-vmcp",level:3},{value:"Update vMCP",id:"update-vmcp",level:3},{value:"Delete vMCP",id:"delete-vmcp",level:3},{value:"Import vMCP",id:"import-vmcp",level:3},{value:"Export vMCP",id:"export-vmcp",level:3},{value:"MCP Server Management",id:"mcp-server-management",level:2},{value:"List MCP Servers",id:"list-mcp-servers",level:3},{value:"Get MCP Server",id:"get-mcp-server",level:3},{value:"Create MCP Server",id:"create-mcp-server",level:3},{value:"Update MCP Server",id:"update-mcp-server",level:3},{value:"Delete MCP Server",id:"delete-mcp-server",level:3},{value:"Connect to MCP Server",id:"connect-to-mcp-server",level:3},{value:"Disconnect from MCP Server",id:"disconnect-from-mcp-server",level:3},{value:"vMCP Protocol Operations",id:"vmcp-protocol-operations",level:2},{value:"List Tools",id:"list-tools",level:3},{value:"Call Tool",id:"call-tool",level:3},{value:"List Resources",id:"list-resources",level:3},{value:"Read Resource",id:"read-resource",level:3},{value:"List Prompts",id:"list-prompts",level:3},{value:"Get Prompt",id:"get-prompt",level:3},{value:"Stats and Monitoring",id:"stats-and-monitoring",level:2},{value:"Get Stats",id:"get-stats",level:3},{value:"Error Responses",id:"error-responses",level:2},{value:"Common HTTP Status Codes",id:"common-http-status-codes",level:3},{value:"Variable Substitution",id:"variable-substitution",level:2},{value:"WebSocket (Future)",id:"websocket-future",level:2}];function d(e){const n={code:"code",em:"em",h1:"h1",h2:"h2",h3:"h3",header:"header",hr:"hr",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,t.R)(),...e.components};return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsx)(n.header,{children:(0,i.jsx)(n.h1,{id:"api-reference",children:"API Reference"})}),"\n",(0,i.jsx)(n.p,{children:"The vMCP backend provides a comprehensive REST API for managing vMCPs, MCP servers, and monitoring usage."}),"\n",(0,i.jsx)(n.h2,{id:"base-url",children:"Base URL"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{children:"http://localhost:8000/api\n"})}),"\n",(0,i.jsx)(n.h2,{id:"authentication",children:"Authentication"}),"\n",(0,i.jsxs)(n.p,{children:["The OSS version uses a dummy user system. All requests operate with ",(0,i.jsx)(n.code,{children:"user_id=1"}),". No authentication headers required."]}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h2,{id:"vmcp-management",children:"vMCP Management"}),"\n",(0,i.jsx)(n.h3,{id:"list-vmcps",children:"List vMCPs"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"GET /api/vmcps\n"})}),"\n",(0,i.jsx)(n.p,{children:"Returns all vMCPs for the user."}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Response:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'[\n  {\n    "vmcp_id": "vmcp_123",\n    "name": "Development vMCP",\n    "description": "For local development tasks",\n    "mcp_servers": [\n      {\n        "server_id": "server_456",\n        "name": "filesystem",\n        "priority": 1\n      }\n    ],\n    "active_config": {},\n    "created_at": "2024-01-15T10:30:00Z",\n    "updated_at": "2024-01-15T10:30:00Z"\n  }\n]\n'})}),"\n",(0,i.jsx)(n.h3,{id:"get-vmcp",children:"Get vMCP"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"GET /api/vmcps/{vmcp_id}\n"})}),"\n",(0,i.jsx)(n.p,{children:"Returns details of a specific vMCP."}),"\n",(0,i.jsx)(n.h3,{id:"create-vmcp",children:"Create vMCP"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"POST /api/vmcps\n"})}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Request Body:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "My vMCP",\n  "description": "Description of the vMCP",\n  "mcp_servers": [\n    {\n      "server_id": "server_123",\n      "priority": 1\n    }\n  ],\n  "active_config": {\n    "api_key": "value"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Response:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "vmcp_id": "vmcp_789",\n  "name": "My vMCP",\n  "description": "Description of the vMCP",\n  "mcp_servers": [...],\n  "active_config": {...},\n  "created_at": "2024-01-15T10:30:00Z",\n  "updated_at": "2024-01-15T10:30:00Z"\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"update-vmcp",children:"Update vMCP"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"PUT /api/vmcps/{vmcp_id}\n"})}),"\n",(0,i.jsxs)(n.p,{children:[(0,i.jsx)(n.strong,{children:"Request Body:"})," Same as create vMCP"]}),"\n",(0,i.jsx)(n.h3,{id:"delete-vmcp",children:"Delete vMCP"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"DELETE /api/vmcps/{vmcp_id}\n"})}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Response:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "message": "vMCP deleted successfully"\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"import-vmcp",children:"Import vMCP"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"POST /api/vmcps/import\n"})}),"\n",(0,i.jsx)(n.p,{children:"Import a vMCP from JSON configuration."}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Request Body:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "Imported vMCP",\n  "description": "Imported configuration",\n  "mcp_servers": [...],\n  "active_config": {...}\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"export-vmcp",children:"Export vMCP"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"GET /api/vmcps/{vmcp_id}/export\n"})}),"\n",(0,i.jsx)(n.p,{children:"Export a vMCP configuration as JSON."}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h2,{id:"mcp-server-management",children:"MCP Server Management"}),"\n",(0,i.jsx)(n.h3,{id:"list-mcp-servers",children:"List MCP Servers"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"GET /api/mcp-servers\n"})}),"\n",(0,i.jsx)(n.p,{children:"Returns all MCP servers connected by the user."}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Response:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'[\n  {\n    "server_id": "server_123",\n    "name": "filesystem",\n    "description": "Local filesystem access",\n    "transport_type": "stdio",\n    "config": {\n      "command": "npx",\n      "args": ["-y", "@modelcontextprotocol/server-filesystem", "/path"]\n    },\n    "status": "connected",\n    "last_connected": "2024-01-15T10:30:00Z",\n    "created_at": "2024-01-15T10:00:00Z"\n  }\n]\n'})}),"\n",(0,i.jsx)(n.h3,{id:"get-mcp-server",children:"Get MCP Server"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"GET /api/mcp-servers/{server_id}\n"})}),"\n",(0,i.jsx)(n.h3,{id:"create-mcp-server",children:"Create MCP Server"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"POST /api/mcp-servers\n"})}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Request Body:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "github-mcp",\n  "description": "GitHub integration",\n  "transport_type": "stdio",\n  "config": {\n    "command": "npx",\n    "args": ["-y", "@modelcontextprotocol/server-github"]\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"update-mcp-server",children:"Update MCP Server"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"PUT /api/mcp-servers/{server_id}\n"})}),"\n",(0,i.jsx)(n.h3,{id:"delete-mcp-server",children:"Delete MCP Server"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"DELETE /api/mcp-servers/{server_id}\n"})}),"\n",(0,i.jsx)(n.h3,{id:"connect-to-mcp-server",children:"Connect to MCP Server"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"POST /api/mcp-servers/{server_id}/connect\n"})}),"\n",(0,i.jsx)(n.p,{children:"Establishes connection to the MCP server."}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Response:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "status": "connected",\n  "capabilities": {\n    "tools": ["list_files", "read_file", "write_file"],\n    "resources": ["file://"],\n    "prompts": []\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"disconnect-from-mcp-server",children:"Disconnect from MCP Server"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"POST /api/mcp-servers/{server_id}/disconnect\n"})}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h2,{id:"vmcp-protocol-operations",children:"vMCP Protocol Operations"}),"\n",(0,i.jsx)(n.h3,{id:"list-tools",children:"List Tools"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"GET /api/vmcps/{vmcp_id}/tools\n"})}),"\n",(0,i.jsx)(n.p,{children:"Returns all available tools from the vMCP's connected servers."}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Response:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "tools": [\n    {\n      "name": "filesystem.read_file",\n      "description": "Read a file from the filesystem",\n      "inputSchema": {\n        "type": "object",\n        "properties": {\n          "path": {\n            "type": "string",\n            "description": "File path"\n          }\n        },\n        "required": ["path"]\n      }\n    }\n  ]\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"call-tool",children:"Call Tool"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"POST /api/vmcps/{vmcp_id}/tools/call\n"})}),"\n",(0,i.jsx)(n.p,{children:"Execute a tool through the vMCP."}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Request Body:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "filesystem.read_file",\n  "arguments": {\n    "path": "/path/to/file.txt"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Response:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "content": [\n    {\n      "type": "text",\n      "text": "File contents here..."\n    }\n  ]\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"list-resources",children:"List Resources"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"GET /api/vmcps/{vmcp_id}/resources\n"})}),"\n",(0,i.jsx)(n.p,{children:"Returns all available resources from the vMCP."}),"\n",(0,i.jsx)(n.h3,{id:"read-resource",children:"Read Resource"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"POST /api/vmcps/{vmcp_id}/resources/read\n"})}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Request Body:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "uri": "file:///path/to/file.txt"\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"list-prompts",children:"List Prompts"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"GET /api/vmcps/{vmcp_id}/prompts\n"})}),"\n",(0,i.jsx)(n.p,{children:"Returns all available prompt templates."}),"\n",(0,i.jsx)(n.h3,{id:"get-prompt",children:"Get Prompt"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"POST /api/vmcps/{vmcp_id}/prompts/get\n"})}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Request Body:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "code_review",\n  "arguments": {\n    "language": "python"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h2,{id:"stats-and-monitoring",children:"Stats and Monitoring"}),"\n",(0,i.jsx)(n.h3,{id:"get-stats",children:"Get Stats"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-http",children:"GET /api/stats\n"})}),"\n",(0,i.jsx)(n.p,{children:"Returns usage statistics and logs."}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Query Parameters:"})}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"start_date"})," (optional) - ISO 8601 date string"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"end_date"})," (optional) - ISO 8601 date string"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"vmcp_id"})," (optional) - Filter by vMCP"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"client_id"})," (optional) - Filter by client"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"method"})," (optional) - Filter by method (tools/list, tools/call, etc.)"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"page"})," (optional) - Page number (default: 1)"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"page_size"})," (optional) - Results per page (default: 50, max: 100)"]}),"\n"]}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Response:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "stats": {\n    "total_logs": 1523,\n    "active_clients": 3,\n    "total_vmcps": 5,\n    "total_tool_calls": 847,\n    "avg_tools_per_call": 2.3\n  },\n  "logs": [\n    {\n      "log_id": "log_123",\n      "client_id": "client_456",\n      "vmcp_id": "vmcp_789",\n      "method": "tools/call",\n      "mcp_server_id": "server_101",\n      "arguments": {"path": "/file.txt"},\n      "result": {"content": [...]},\n      "active_config_snapshot": {},\n      "timestamp": "2024-01-15T10:30:00Z"\n    }\n  ],\n  "pagination": {\n    "page": 1,\n    "page_size": 50,\n    "total_pages": 31,\n    "total_items": 1523\n  }\n}\n'})}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h2,{id:"error-responses",children:"Error Responses"}),"\n",(0,i.jsx)(n.p,{children:"All endpoints follow a consistent error response format:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "error": "Error message",\n  "detail": "Detailed error information"\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"common-http-status-codes",children:"Common HTTP Status Codes"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"200 OK"})," - Request succeeded"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"201 Created"})," - Resource created successfully"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"400 Bad Request"})," - Invalid request parameters"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"404 Not Found"})," - Resource not found"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"500 Internal Server Error"})," - Server error"]}),"\n"]}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h2,{id:"variable-substitution",children:"Variable Substitution"}),"\n",(0,i.jsx)(n.p,{children:"When calling tools, vMCP supports these variable patterns:"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"@param:name"})," - Runtime parameters from active_config"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"@config:key"})," - Configuration values"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"@tool(server.tool_name)"})," - Call another tool and use result"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"@resource(server.uri)"})," - Read resource and use content"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"@prompt(server.prompt_name)"})," - Use prompt template"]}),"\n"]}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Example:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "github.create_issue",\n  "arguments": {\n    "repo": "@config:default_repo",\n    "title": "@param:issue_title",\n    "body": "@prompt(github.issue_template)"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.hr,{}),"\n",(0,i.jsx)(n.h2,{id:"websocket-future",children:"WebSocket (Future)"}),"\n",(0,i.jsx)(n.p,{children:"Real-time updates for server status and logs will be available via WebSocket:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{children:"ws://localhost:8000/ws\n"})}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.em,{children:"Currently not implemented in OSS version."})})]})}function p(e={}){const{wrapper:n}={...(0,t.R)(),...e.components};return n?(0,i.jsx)(n,{...e,children:(0,i.jsx)(d,{...e})}):d(e)}},8453:(e,n,s)=>{s.d(n,{R:()=>l,x:()=>c});var r=s(6540);const i={},t=r.createContext(i);function l(e){const n=r.useContext(t);return r.useMemo(function(){return"function"==typeof e?e(n):{...n,...e}},[n,e])}function c(e){let n;return n=e.disableParentContext?"function"==typeof e.components?e.components(i):e.components||i:l(e.components),r.createElement(t.Provider,{value:n},e.children)}}}]);