"use strict";(globalThis.webpackChunkdocs=globalThis.webpackChunkdocs||[]).push([[873],{8453:(e,n,r)=>{r.d(n,{R:()=>t,x:()=>a});var o=r(6540);const i={},s=o.createContext(i);function t(e){const n=o.useContext(s);return o.useMemo(function(){return"function"==typeof e?e(n):{...n,...e}},[n,e])}function a(e){let n;return n=e.disableParentContext?"function"==typeof e.components?e.components(i):e.components||i:t(e.components),o.createElement(s.Provider,{value:n},e.children)}},8633:(e,n,r)=>{r.r(n),r.d(n,{assets:()=>l,contentTitle:()=>a,default:()=>h,frontMatter:()=>t,metadata:()=>o,toc:()=>c});const o=JSON.parse('{"id":"configuration","title":"Configuration","description":"Complete configuration guide for vMCP.","source":"@site/docs/configuration.md","sourceDirName":".","slug":"/configuration","permalink":"/documentation/configuration","draft":false,"unlisted":false,"tags":[],"version":"current","sidebarPosition":5,"frontMatter":{"sidebar_position":5},"sidebar":"tutorialSidebar","previous":{"title":"Installation","permalink":"/documentation/installation"},"next":{"title":"API Reference","permalink":"/documentation/api"}}');var i=r(4848),s=r(8453);const t={sidebar_position:5},a="Configuration",l={},c=[{value:"Environment Variables",id:"environment-variables",level:2},{value:"Backend Configuration",id:"backend-configuration",level:3},{value:"Database Configuration",id:"database-configuration",level:3},{value:"PostgreSQL Connection String Format",id:"postgresql-connection-string-format",level:4},{value:"Connection Pool Settings",id:"connection-pool-settings",level:4},{value:"Logging Configuration",id:"logging-configuration",level:3},{value:"Log Levels",id:"log-levels",level:4},{value:"Structured Logging",id:"structured-logging",level:4},{value:"CORS Configuration",id:"cors-configuration",level:3},{value:"Docker Configuration",id:"docker-configuration",level:2},{value:"docker-compose.yml",id:"docker-composeyml",level:3},{value:"Environment Overrides",id:"environment-overrides",level:3},{value:"Frontend Configuration",id:"frontend-configuration",level:2},{value:"Vite Configuration",id:"vite-configuration",level:3},{value:"API Configuration",id:"api-configuration",level:3},{value:"MCP Server Configuration",id:"mcp-server-configuration",level:2},{value:"Server Transport Types",id:"server-transport-types",level:3},{value:"Stdio (Command-line)",id:"stdio-command-line",level:4},{value:"HTTP",id:"http",level:4},{value:"SSE (Server-Sent Events)",id:"sse-server-sent-events",level:4},{value:"OAuth Configuration",id:"oauth-configuration",level:3},{value:"Production Deployment",id:"production-deployment",level:2},{value:"Recommended Settings",id:"recommended-settings",level:3},{value:"Security Considerations",id:"security-considerations",level:3},{value:"Reverse Proxy (nginx)",id:"reverse-proxy-nginx",level:3},{value:"Performance Tuning",id:"performance-tuning",level:3},{value:"Database Indexes",id:"database-indexes",level:4},{value:"Cache Configuration",id:"cache-configuration",level:4},{value:"Worker Configuration",id:"worker-configuration",level:4},{value:"Monitoring",id:"monitoring",level:2},{value:"Health Check Endpoint",id:"health-check-endpoint",level:3},{value:"Metrics (Prometheus)",id:"metrics-prometheus",level:3},{value:"Backup and Recovery",id:"backup-and-recovery",level:2},{value:"Database Backup",id:"database-backup",level:3},{value:"Automated Backups",id:"automated-backups",level:3},{value:"Next Steps",id:"next-steps",level:2}];function d(e){const n={a:"a",code:"code",h1:"h1",h2:"h2",h3:"h3",h4:"h4",header:"header",li:"li",ol:"ol",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,s.R)(),...e.components};return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsx)(n.header,{children:(0,i.jsx)(n.h1,{id:"configuration",children:"Configuration"})}),"\n",(0,i.jsx)(n.p,{children:"Complete configuration guide for vMCP."}),"\n",(0,i.jsx)(n.h2,{id:"environment-variables",children:"Environment Variables"}),"\n",(0,i.jsx)(n.h3,{id:"backend-configuration",children:"Backend Configuration"}),"\n",(0,i.jsxs)(n.p,{children:["Create a ",(0,i.jsx)(n.code,{children:".env"})," file in the ",(0,i.jsx)(n.code,{children:"backend/"})," directory:"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-env",children:"# Database\nDATABASE_URL=postgresql://vmcp:vmcp@localhost:5432/vmcp\n\n# Server\nHOST=0.0.0.0\nPORT=8000\n\n# Logging\nLOG_LEVEL=INFO\n\n# Frontend\nFRONTEND_DIR=../frontend/dist\n\n# CORS (Optional)\nCORS_ORIGINS=http://localhost:3000,http://localhost:8000\n"})}),"\n",(0,i.jsx)(n.h3,{id:"database-configuration",children:"Database Configuration"}),"\n",(0,i.jsx)(n.h4,{id:"postgresql-connection-string-format",children:"PostgreSQL Connection String Format"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{children:"postgresql://[user]:[password]@[host]:[port]/[database]\n"})}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Examples:"})}),"\n",(0,i.jsx)(n.p,{children:"Local development:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-env",children:"DATABASE_URL=postgresql://vmcp:vmcp@localhost:5432/vmcp\n"})}),"\n",(0,i.jsx)(n.p,{children:"Docker container:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-env",children:"DATABASE_URL=postgresql://vmcp:vmcp@postgres:5432/vmcp\n"})}),"\n",(0,i.jsx)(n.p,{children:"Cloud hosted (with SSL):"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-env",children:"DATABASE_URL=postgresql://user:pass@host.com:5432/db?sslmode=require\n"})}),"\n",(0,i.jsx)(n.h4,{id:"connection-pool-settings",children:"Connection Pool Settings"}),"\n",(0,i.jsxs)(n.p,{children:["For high-traffic deployments, configure the connection pool in ",(0,i.jsx)(n.code,{children:"backend/vmcp/database.py"}),":"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-python",children:"engine = create_async_engine(\n    DATABASE_URL,\n    echo=False,\n    pool_size=20,        # Number of persistent connections\n    max_overflow=10,     # Max additional connections\n    pool_timeout=30,     # Seconds to wait for connection\n    pool_recycle=3600,   # Recycle connections after 1 hour\n)\n"})}),"\n",(0,i.jsx)(n.h3,{id:"logging-configuration",children:"Logging Configuration"}),"\n",(0,i.jsx)(n.h4,{id:"log-levels",children:"Log Levels"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-env",children:"LOG_LEVEL=DEBUG   # Verbose, shows all operations\nLOG_LEVEL=INFO    # Standard operational info (recommended)\nLOG_LEVEL=WARNING # Only warnings and errors\nLOG_LEVEL=ERROR   # Only errors\n"})}),"\n",(0,i.jsx)(n.h4,{id:"structured-logging",children:"Structured Logging"}),"\n",(0,i.jsxs)(n.p,{children:["vMCP uses structured logging. Configure in ",(0,i.jsx)(n.code,{children:"backend/vmcp/logging_config.py"}),":"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-python",children:'LOGGING_CONFIG = {\n    "version": 1,\n    "disable_existing_loggers": False,\n    "formatters": {\n        "default": {\n            "format": "%(asctime)s - %(name)s - %(levelname)s - %(message)s"\n        },\n        "json": {\n            "()": "pythonjsonlogger.jsonlogger.JsonFormatter",\n            "format": "%(asctime)s %(name)s %(levelname)s %(message)s"\n        }\n    },\n    "handlers": {\n        "console": {\n            "class": "logging.StreamHandler",\n            "formatter": "default",\n            "stream": "ext://sys.stdout"\n        },\n        "file": {\n            "class": "logging.handlers.RotatingFileHandler",\n            "formatter": "json",\n            "filename": "logs/vmcp.log",\n            "maxBytes": 10485760,  # 10MB\n            "backupCount": 5\n        }\n    },\n    "root": {\n        "level": "INFO",\n        "handlers": ["console", "file"]\n    }\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"cors-configuration",children:"CORS Configuration"}),"\n",(0,i.jsx)(n.p,{children:"For frontend development or custom domains:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-env",children:"CORS_ORIGINS=http://localhost:3000,http://localhost:8000,https://vmcp.yourdomain.com\n"})}),"\n",(0,i.jsx)(n.p,{children:"In production, restrict to your domain:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-env",children:"CORS_ORIGINS=https://vmcp.yourdomain.com\n"})}),"\n",(0,i.jsx)(n.h2,{id:"docker-configuration",children:"Docker Configuration"}),"\n",(0,i.jsx)(n.h3,{id:"docker-composeyml",children:"docker-compose.yml"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-yaml",children:'version: \'3.8\'\n\nservices:\n  postgres:\n    image: postgres:16\n    environment:\n      POSTGRES_USER: vmcp\n      POSTGRES_PASSWORD: vmcp\n      POSTGRES_DB: vmcp\n    volumes:\n      - postgres_data:/var/lib/postgresql/data\n    ports:\n      - "5432:5432"\n    healthcheck:\n      test: ["CMD-LABEL", "pg_isready", "-U", "vmcp"]\n      interval: 10s\n      timeout: 5s\n      retries: 5\n\n  backend:\n    build:\n      context: .\n      dockerfile: Dockerfile\n    environment:\n      DATABASE_URL: postgresql://vmcp:vmcp@postgres:5432/vmcp\n      LOG_LEVEL: INFO\n      HOST: 0.0.0.0\n      PORT: 8000\n    ports:\n      - "8000:8000"\n    depends_on:\n      postgres:\n        condition: service_healthy\n    volumes:\n      # Mount for development\n      - ./backend:/app/backend\n      - ./frontend/dist:/app/frontend/dist\n\nvolumes:\n  postgres_data:\n'})}),"\n",(0,i.jsx)(n.h3,{id:"environment-overrides",children:"Environment Overrides"}),"\n",(0,i.jsx)(n.p,{children:"Override environment variables:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-bash",children:"# Single variable\nDATABASE_URL=postgresql://custom@localhost/db docker compose up\n\n# Environment file\ndocker compose --env-file .env.production up\n"})}),"\n",(0,i.jsx)(n.h2,{id:"frontend-configuration",children:"Frontend Configuration"}),"\n",(0,i.jsx)(n.h3,{id:"vite-configuration",children:"Vite Configuration"}),"\n",(0,i.jsxs)(n.p,{children:["The frontend build configuration is in ",(0,i.jsx)(n.code,{children:"frontend/vite.config.ts"}),":"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-typescript",children:"export default defineConfig({\n  plugins: [react()],\n  server: {\n    port: 5173,\n    proxy: {\n      '/api': {\n        target: 'http://localhost:8000',\n        changeOrigin: true,\n      },\n    },\n  },\n  build: {\n    outDir: 'dist',\n    assetsDir: 'assets',\n    sourcemap: false,\n    rollupOptions: {\n      output: {\n        manualChunks: {\n          'react-vendor': ['react', 'react-dom'],\n          'ui-vendor': ['@radix-ui/react-dialog', '@radix-ui/react-dropdown-menu'],\n        },\n      },\n    },\n  },\n})\n"})}),"\n",(0,i.jsx)(n.h3,{id:"api-configuration",children:"API Configuration"}),"\n",(0,i.jsxs)(n.p,{children:["Update API base URL in ",(0,i.jsx)(n.code,{children:"frontend/src/lib/api.ts"}),":"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-typescript",children:"const API_BASE_URL = import.meta.env.VITE_API_URL || '/api'\n\n// For development with separate backend:\n// VITE_API_URL=http://localhost:8000/api\n"})}),"\n",(0,i.jsx)(n.h2,{id:"mcp-server-configuration",children:"MCP Server Configuration"}),"\n",(0,i.jsx)(n.h3,{id:"server-transport-types",children:"Server Transport Types"}),"\n",(0,i.jsx)(n.h4,{id:"stdio-command-line",children:"Stdio (Command-line)"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "transport_type": "stdio",\n  "config": {\n    "command": "npx",\n    "args": ["-y", "@modelcontextprotocol/server-filesystem", "/path"],\n    "env": {\n      "VAR_NAME": "value"\n    },\n    "cwd": "/working/directory"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h4,{id:"http",children:"HTTP"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "transport_type": "http",\n  "config": {\n    "url": "https://api.example.com/mcp",\n    "method": "POST",\n    "headers": {\n      "Authorization": "Bearer token",\n      "Content-Type": "application/json"\n    },\n    "timeout": 30\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h4,{id:"sse-server-sent-events",children:"SSE (Server-Sent Events)"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "transport_type": "sse",\n  "config": {\n    "url": "https://sse.example.com/events",\n    "headers": {\n      "Authorization": "Bearer token"\n    },\n    "reconnect": true,\n    "reconnect_interval": 5\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"oauth-configuration",children:"OAuth Configuration"}),"\n",(0,i.jsx)(n.p,{children:"For MCP servers requiring OAuth:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "oauth": {\n    "provider": "github",\n    "client_id": "your_client_id",\n    "client_secret": "your_client_secret",\n    "scopes": ["repo", "user"],\n    "redirect_uri": "http://localhost:8000/oauth/callback"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h2,{id:"production-deployment",children:"Production Deployment"}),"\n",(0,i.jsx)(n.h3,{id:"recommended-settings",children:"Recommended Settings"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-env",children:"# Production .env\nDATABASE_URL=postgresql://vmcp:secure_password@db.internal:5432/vmcp?sslmode=require\nLOG_LEVEL=WARNING\nHOST=0.0.0.0\nPORT=8000\nCORS_ORIGINS=https://vmcp.yourdomain.com\n"})}),"\n",(0,i.jsx)(n.h3,{id:"security-considerations",children:"Security Considerations"}),"\n",(0,i.jsxs)(n.ol,{children:["\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.strong,{children:"Use strong database passwords"})}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.strong,{children:"Enable SSL for database connections"})," (",(0,i.jsx)(n.code,{children:"?sslmode=require"}),")"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.strong,{children:"Restrict CORS origins"})," to your domain only"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.strong,{children:"Use environment variables"})," for secrets (never commit ",(0,i.jsx)(n.code,{children:".env"}),")"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.strong,{children:"Enable HTTPS"})," with reverse proxy (nginx, Caddy)"]}),"\n"]}),"\n",(0,i.jsx)(n.h3,{id:"reverse-proxy-nginx",children:"Reverse Proxy (nginx)"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-nginx",children:"server {\n    listen 80;\n    server_name vmcp.yourdomain.com;\n    return 301 https://$server_name$request_uri;\n}\n\nserver {\n    listen 443 ssl http2;\n    server_name vmcp.yourdomain.com;\n\n    ssl_certificate /path/to/cert.pem;\n    ssl_certificate_key /path/to/key.pem;\n\n    location / {\n        proxy_pass http://localhost:8000;\n        proxy_set_header Host $host;\n        proxy_set_header X-Real-IP $remote_addr;\n        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;\n        proxy_set_header X-Forwarded-Proto $scheme;\n    }\n\n    location /api {\n        proxy_pass http://localhost:8000/api;\n        proxy_set_header Host $host;\n        proxy_set_header X-Real-IP $remote_addr;\n    }\n}\n"})}),"\n",(0,i.jsx)(n.h3,{id:"performance-tuning",children:"Performance Tuning"}),"\n",(0,i.jsx)(n.h4,{id:"database-indexes",children:"Database Indexes"}),"\n",(0,i.jsx)(n.p,{children:"Add indexes for frequently queried fields:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-sql",children:"CREATE INDEX idx_vmcp_user_id ON vmcps(user_id);\nCREATE INDEX idx_mcp_server_user_id ON mcp_servers(user_id);\nCREATE INDEX idx_logs_timestamp ON logs(timestamp);\nCREATE INDEX idx_logs_vmcp_id ON logs(vmcp_id);\n"})}),"\n",(0,i.jsx)(n.h4,{id:"cache-configuration",children:"Cache Configuration"}),"\n",(0,i.jsx)(n.p,{children:"Configure Redis for caching (optional):"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-python",children:'REDIS_URL = os.getenv("REDIS_URL", "redis://localhost:6379/0")\n\n# Cache tool results for 5 minutes\nTOOL_CACHE_TTL = 300\n\n# Cache resource reads for 10 minutes\nRESOURCE_CACHE_TTL = 600\n'})}),"\n",(0,i.jsx)(n.h4,{id:"worker-configuration",children:"Worker Configuration"}),"\n",(0,i.jsx)(n.p,{children:"For high concurrency:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-bash",children:"# Run with multiple workers\nuvicorn vmcp.main:app --workers 4 --host 0.0.0.0 --port 8000\n"})}),"\n",(0,i.jsx)(n.h2,{id:"monitoring",children:"Monitoring"}),"\n",(0,i.jsx)(n.h3,{id:"health-check-endpoint",children:"Health Check Endpoint"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{children:"GET /health\n"})}),"\n",(0,i.jsx)(n.p,{children:"Returns:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "status": "healthy",\n  "database": "connected",\n  "version": "1.0.0"\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"metrics-prometheus",children:"Metrics (Prometheus)"}),"\n",(0,i.jsx)(n.p,{children:"Enable Prometheus metrics:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-python",children:"from prometheus_fastapi_instrumentator import Instrumentator\n\nInstrumentator().instrument(app).expose(app)\n"})}),"\n",(0,i.jsx)(n.p,{children:"Access metrics at:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{children:"GET /metrics\n"})}),"\n",(0,i.jsx)(n.h2,{id:"backup-and-recovery",children:"Backup and Recovery"}),"\n",(0,i.jsx)(n.h3,{id:"database-backup",children:"Database Backup"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-bash",children:"# Backup\npg_dump -h localhost -U vmcp -d vmcp > backup.sql\n\n# Restore\npsql -h localhost -U vmcp -d vmcp < backup.sql\n"})}),"\n",(0,i.jsx)(n.h3,{id:"automated-backups",children:"Automated Backups"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-bash",children:'#!/bin/bash\n# backup.sh\nDATE=$(date +%Y%m%d_%H%M%S)\npg_dump -h localhost -U vmcp -d vmcp | gzip > backups/vmcp_$DATE.sql.gz\n\n# Keep only last 7 days\nfind backups/ -name "vmcp_*.sql.gz" -mtime +7 -delete\n'})}),"\n",(0,i.jsx)(n.p,{children:"Run daily with cron:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{children:"0 2 * * * /path/to/backup.sh\n"})}),"\n",(0,i.jsx)(n.h2,{id:"next-steps",children:"Next Steps"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"./api",children:"API Reference"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"./deployment",children:"Deployment Guide"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"./troubleshooting",children:"Troubleshooting"})}),"\n"]})]})}function h(e={}){const{wrapper:n}={...(0,s.R)(),...e.components};return n?(0,i.jsx)(n,{...e,children:(0,i.jsx)(d,{...e})}):d(e)}}}]);