"use strict";(globalThis.webpackChunkdocs=globalThis.webpackChunkdocs||[]).push([[449],{6302:(e,n,s)=>{s.r(n),s.d(n,{assets:()=>t,contentTitle:()=>o,default:()=>u,frontMatter:()=>l,metadata:()=>r,toc:()=>c});const r=JSON.parse('{"id":"tutorial-basics/variable-substitution","title":"Variable Substitution","description":"vMCP\'s powerful variable substitution system allows dynamic tool arguments and configuration reuse.","source":"@site/docs/tutorial-basics/variable-substitution.md","sourceDirName":"tutorial-basics","slug":"/tutorial-basics/variable-substitution","permalink":"/documentation/tutorial-basics/variable-substitution","draft":false,"unlisted":false,"tags":[],"version":"current","sidebarPosition":3,"frontMatter":{"sidebar_position":3},"sidebar":"tutorialSidebar","previous":{"title":"Connecting MCP Servers","permalink":"/documentation/tutorial-basics/connect-servers"}}');var i=s(4848),a=s(8453);const l={sidebar_position:3},o="Variable Substitution",t={},c=[{value:"Overview",id:"overview",level:2},{value:"@param - Runtime Parameters",id:"param---runtime-parameters",level:2},{value:"Example Setup",id:"example-setup",level:3},{value:"Use Cases",id:"use-cases",level:3},{value:"@config - Configuration Values",id:"config---configuration-values",level:2},{value:"@tool() - Call Other Tools",id:"tool---call-other-tools",level:2},{value:"Example: Chaining Tools",id:"example-chaining-tools",level:3},{value:"Nested Tool Calls",id:"nested-tool-calls",level:3},{value:"Error Handling",id:"error-handling",level:3},{value:"@resource() - Read Resources",id:"resource---read-resources",level:2},{value:"Example: File Resources",id:"example-file-resources",level:3},{value:"Example: Database Resources",id:"example-database-resources",level:3},{value:"Resource URI Format",id:"resource-uri-format",level:3},{value:"@prompt() - Prompt Templates",id:"prompt---prompt-templates",level:2},{value:"Example: Code Review Template",id:"example-code-review-template",level:3},{value:"Combining Substitutions",id:"combining-substitutions",level:2},{value:"Escaping Variables",id:"escaping-variables",level:2},{value:"Best Practices",id:"best-practices",level:2},{value:"1. Use @param for Dynamic Values",id:"1-use-param-for-dynamic-values",level:3},{value:"2. Use @config for Static Settings",id:"2-use-config-for-static-settings",level:3},{value:"3. Chain Tools for Complex Workflows",id:"3-chain-tools-for-complex-workflows",level:3},{value:"4. Validate Substitutions",id:"4-validate-substitutions",level:3},{value:"Error Messages",id:"error-messages",level:2},{value:"Advanced Examples",id:"advanced-examples",level:2},{value:"Example 1: Automated Testing",id:"example-1-automated-testing",level:3},{value:"Example 2: Data Pipeline",id:"example-2-data-pipeline",level:3},{value:"Example 3: Documentation Generation",id:"example-3-documentation-generation",level:3},{value:"Performance Considerations",id:"performance-considerations",level:2},{value:"Next Steps",id:"next-steps",level:2}];function d(e){const n={a:"a",code:"code",h1:"h1",h2:"h2",h3:"h3",header:"header",li:"li",ol:"ol",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,a.R)(),...e.components};return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsx)(n.header,{children:(0,i.jsx)(n.h1,{id:"variable-substitution",children:"Variable Substitution"})}),"\n",(0,i.jsx)(n.p,{children:"vMCP's powerful variable substitution system allows dynamic tool arguments and configuration reuse."}),"\n",(0,i.jsx)(n.h2,{id:"overview",children:"Overview"}),"\n",(0,i.jsx)(n.p,{children:"Variable substitution patterns:"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"@param:name"})," - Runtime parameters from active_config"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"@config:key"})," - Configuration values"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"@tool(server.tool_name)"})," - Call other tools inline"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"@resource(server.uri)"})," - Read resource content"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"@prompt(server.prompt_name)"})," - Use prompt templates"]}),"\n"]}),"\n",(0,i.jsx)(n.h2,{id:"param---runtime-parameters",children:"@param - Runtime Parameters"}),"\n",(0,i.jsxs)(n.p,{children:["Use values from the vMCP's ",(0,i.jsx)(n.code,{children:"active_config"})," at runtime."]}),"\n",(0,i.jsx)(n.h3,{id:"example-setup",children:"Example Setup"}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"vMCP Active Config:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "repo": "myorg/myapp",\n  "branch": "main",\n  "workspace": "/home/user/projects/myapp"\n}\n'})}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Tool Call:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "github.get_file_contents",\n  "arguments": {\n    "repo": "@param:repo",\n    "branch": "@param:branch",\n    "path": "README.md"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Resolved to:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "github.get_file_contents",\n  "arguments": {\n    "repo": "myorg/myapp",\n    "branch": "main",\n    "path": "README.md"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"use-cases",children:"Use Cases"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.strong,{children:"API Keys"}),": ",(0,i.jsx)(n.code,{children:"@param:api_key"})]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.strong,{children:"Default Paths"}),": ",(0,i.jsx)(n.code,{children:"@param:workspace"})]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.strong,{children:"User Preferences"}),": ",(0,i.jsx)(n.code,{children:"@param:default_language"})]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.strong,{children:"Project Settings"}),": ",(0,i.jsx)(n.code,{children:"@param:repo_name"})]}),"\n"]}),"\n",(0,i.jsx)(n.h2,{id:"config---configuration-values",children:"@config - Configuration Values"}),"\n",(0,i.jsx)(n.p,{children:"Reference static configuration values."}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"vMCP Config:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "database_url": "postgresql://localhost/mydb",\n  "max_retries": 3,\n  "timeout": 30\n}\n'})}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Tool Call:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "postgres.query",\n  "arguments": {\n    "connection": "@config:database_url",\n    "query": "SELECT * FROM users"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h2,{id:"tool---call-other-tools",children:"@tool() - Call Other Tools"}),"\n",(0,i.jsx)(n.p,{children:"Execute another tool and use its result as an argument."}),"\n",(0,i.jsx)(n.h3,{id:"example-chaining-tools",children:"Example: Chaining Tools"}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Read a file, then create a GitHub issue with its contents:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "github.create_issue",\n  "arguments": {\n    "repo": "@param:repo",\n    "title": "Bug Report",\n    "body": "@tool(filesystem.read_file, {\\"path\\": \\"/logs/error.log\\"})"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Execution Flow:"})}),"\n",(0,i.jsxs)(n.ol,{children:["\n",(0,i.jsxs)(n.li,{children:["vMCP calls ",(0,i.jsx)(n.code,{children:"filesystem.read_file"})," with ",(0,i.jsx)(n.code,{children:'{"path": "/logs/error.log"}'})]}),"\n",(0,i.jsxs)(n.li,{children:["Gets result: ",(0,i.jsx)(n.code,{children:'"Error at line 42..."'})]}),"\n",(0,i.jsx)(n.li,{children:"Substitutes into issue body"}),"\n",(0,i.jsxs)(n.li,{children:["Calls ",(0,i.jsx)(n.code,{children:"github.create_issue"})," with resolved body"]}),"\n"]}),"\n",(0,i.jsx)(n.h3,{id:"nested-tool-calls",children:"Nested Tool Calls"}),"\n",(0,i.jsx)(n.p,{children:"You can nest tool calls:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "send_notification",\n  "arguments": {\n    "message": "@tool(format_message, {\\"content\\": \\"@tool(get_latest_commit)\\"})"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"error-handling",children:"Error Handling"}),"\n",(0,i.jsx)(n.p,{children:"If a tool call fails, the substitution fails and the original call is aborted:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "error": "Tool substitution failed: filesystem.read_file - File not found"\n}\n'})}),"\n",(0,i.jsx)(n.h2,{id:"resource---read-resources",children:"@resource() - Read Resources"}),"\n",(0,i.jsx)(n.p,{children:"Read content from MCP resources."}),"\n",(0,i.jsx)(n.h3,{id:"example-file-resources",children:"Example: File Resources"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "analyze_code",\n  "arguments": {\n    "code": "@resource(filesystem:file:///src/main.py)"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"example-database-resources",children:"Example: Database Resources"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "generate_report",\n  "arguments": {\n    "data": "@resource(postgres:query://SELECT * FROM sales)"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"resource-uri-format",children:"Resource URI Format"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{children:"{server_name}:{resource_type}://{resource_path}\n"})}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"server_name"})," - Which MCP server to query"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"resource_type"})," - Type of resource (file, query, etc.)"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.code,{children:"resource_path"})," - Path or identifier"]}),"\n"]}),"\n",(0,i.jsx)(n.h2,{id:"prompt---prompt-templates",children:"@prompt() - Prompt Templates"}),"\n",(0,i.jsx)(n.p,{children:"Use pre-defined prompt templates from MCP servers."}),"\n",(0,i.jsx)(n.h3,{id:"example-code-review-template",children:"Example: Code Review Template"}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Available Prompt:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "code_review",\n  "description": "Template for code review",\n  "arguments": {\n    "language": "string",\n    "style": "string"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"Tool Call:"})}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "github.create_issue",\n  "arguments": {\n    "repo": "@param:repo",\n    "title": "Code Review",\n    "body": "@prompt(prompts.code_review, {\\"language\\": \\"python\\", \\"style\\": \\"detailed\\"})"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h2,{id:"combining-substitutions",children:"Combining Substitutions"}),"\n",(0,i.jsx)(n.p,{children:"You can combine multiple substitution types:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "deploy_app",\n  "arguments": {\n    "repo": "@param:repo",\n    "environment": "@config:default_environment",\n    "version": "@tool(git.get_latest_tag)",\n    "config_file": "@resource(filesystem:file:///config/prod.yml)",\n    "notification": "@prompt(notifications.deploy_template, {\\"env\\": \\"production\\"})"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h2,{id:"escaping-variables",children:"Escaping Variables"}),"\n",(0,i.jsxs)(n.p,{children:["If you need literal ",(0,i.jsx)(n.code,{children:"@param"})," text:"]}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "text": "\\\\@param:not_a_variable"\n}\n'})}),"\n",(0,i.jsxs)(n.p,{children:["The ",(0,i.jsx)(n.code,{children:"\\\\@"})," escapes the substitution."]}),"\n",(0,i.jsx)(n.h2,{id:"best-practices",children:"Best Practices"}),"\n",(0,i.jsx)(n.h3,{id:"1-use-param-for-dynamic-values",children:"1. Use @param for Dynamic Values"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'// Good: Flexible, reusable\n"repo": "@param:repo"\n\n// Bad: Hardcoded\n"repo": "myorg/myapp"\n'})}),"\n",(0,i.jsx)(n.h3,{id:"2-use-config-for-static-settings",children:"2. Use @config for Static Settings"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'// Good: Centralized configuration\n"timeout": "@config:api_timeout"\n\n// Bad: Magic numbers\n"timeout": 30000\n'})}),"\n",(0,i.jsx)(n.h3,{id:"3-chain-tools-for-complex-workflows",children:"3. Chain Tools for Complex Workflows"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "create_pr",\n  "arguments": {\n    "diff": "@tool(git.diff, {\\"branch\\": \\"@param:feature_branch\\"})",\n    "description": "@prompt(pr_template, {\\"type\\": \\"feature\\"})"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"4-validate-substitutions",children:"4. Validate Substitutions"}),"\n",(0,i.jsx)(n.p,{children:"Always ensure:"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsx)(n.li,{children:"Parameters exist in active_config"}),"\n",(0,i.jsx)(n.li,{children:"Tools exist and are accessible"}),"\n",(0,i.jsx)(n.li,{children:"Resources are valid URIs"}),"\n",(0,i.jsx)(n.li,{children:"Prompts accept the provided arguments"}),"\n"]}),"\n",(0,i.jsx)(n.h2,{id:"error-messages",children:"Error Messages"}),"\n",(0,i.jsx)(n.p,{children:"Common substitution errors:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'// Missing parameter\n{\n  "error": "Parameter not found: @param:missing_key"\n}\n\n// Tool call failed\n{\n  "error": "Tool substitution failed: server.tool_name - Connection refused"\n}\n\n// Invalid resource\n{\n  "error": "Resource not found: @resource(invalid:uri)"\n}\n\n// Prompt error\n{\n  "error": "Prompt missing required argument: language"\n}\n'})}),"\n",(0,i.jsx)(n.h2,{id:"advanced-examples",children:"Advanced Examples"}),"\n",(0,i.jsx)(n.h3,{id:"example-1-automated-testing",children:"Example 1: Automated Testing"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "run_tests",\n  "arguments": {\n    "test_files": "@tool(filesystem.list_directory, {\\"path\\": \\"@param:test_dir\\"})",\n    "config": "@resource(filesystem:file:///@param:test_config)",\n    "notification_webhook": "@config:slack_webhook"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"example-2-data-pipeline",children:"Example 2: Data Pipeline"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "process_data",\n  "arguments": {\n    "input": "@resource(postgres:query://SELECT * FROM raw_data)",\n    "transform": "@tool(get_transform_script)",\n    "output": "@param:output_table",\n    "schema": "@resource(filesystem:file:///schemas/output.json)"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h3,{id:"example-3-documentation-generation",children:"Example 3: Documentation Generation"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'{\n  "name": "github.create_issue",\n  "arguments": {\n    "title": "Update Documentation",\n    "body": "@prompt(docs.update_template, {\\"version\\": \\"@tool(git.get_version)\\"})",\n    "labels": ["documentation"],\n    "assignee": "@config:docs_maintainer"\n  }\n}\n'})}),"\n",(0,i.jsx)(n.h2,{id:"performance-considerations",children:"Performance Considerations"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.strong,{children:"Tool substitutions"})," add latency (each is a separate call)"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.strong,{children:"Resource reads"})," may be cached by the MCP server"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.strong,{children:"Prompt generation"})," is usually fast"]}),"\n",(0,i.jsxs)(n.li,{children:[(0,i.jsx)(n.strong,{children:"Parameter substitution"})," has negligible overhead"]}),"\n"]}),"\n",(0,i.jsx)(n.p,{children:"Minimize nested tool calls for better performance:"}),"\n",(0,i.jsx)(n.pre,{children:(0,i.jsx)(n.code,{className:"language-json",children:'// Slower: 3 sequential calls\n"@tool(a, {\\"arg\\": \\"@tool(b, {\\"arg\\": \\"@tool(c)\\"})\\"})"\n\n// Faster: Parallel calls where possible\n'})}),"\n",(0,i.jsx)(n.h2,{id:"next-steps",children:"Next Steps"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"./manage-vmcps",children:"Managing vMCPs"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"../api",children:"API Reference"})}),"\n",(0,i.jsx)(n.li,{children:(0,i.jsx)(n.a,{href:"../configuration",children:"Configuration Guide"})}),"\n"]})]})}function u(e={}){const{wrapper:n}={...(0,a.R)(),...e.components};return n?(0,i.jsx)(n,{...e,children:(0,i.jsx)(d,{...e})}):d(e)}},8453:(e,n,s)=>{s.d(n,{R:()=>l,x:()=>o});var r=s(6540);const i={},a=r.createContext(i);function l(e){const n=r.useContext(a);return r.useMemo(function(){return"function"==typeof e?e(n):{...n,...e}},[n,e])}function o(e){let n;return n=e.disableParentContext?"function"==typeof e.components?e.components(i):e.components||i:l(e.components),r.createElement(a.Provider,{value:n},e.children)}}}]);