"""Add not_applicable to asset ConsentStatus

Revision ID: b9bfa12c167b
Revises: 30369bb8ae01
Create Date: 2025-09-09 16:44:23.146325

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "b9bfa12c167b"
down_revision = "30369bb8ae01"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute("ALTER TYPE consentstatus ADD VALUE 'not_applicable'")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # Remove any records that have the new enum value before dropping it
    op.execute(
        "UPDATE asset SET consent_status = 'unknown' WHERE consent_status = 'not_applicable'"
    )

    # Recreate the enum without the new value
    op.execute("ALTER TYPE consentstatus RENAME TO consentstatus_old")
    op.execute(
        "CREATE TYPE consentstatus AS ENUM ('cmp_error', 'pre_consent', 'with_consent', 'without_consent', 'exempt', 'unknown')"
    )

    # Drop default, change type, and set default back
    op.execute("ALTER TABLE asset ALTER COLUMN consent_status DROP DEFAULT")
    op.execute(
        "ALTER TABLE asset ALTER COLUMN consent_status TYPE consentstatus USING "
        "consent_status::text::consentstatus"
    )
    op.execute("ALTER TABLE asset ALTER COLUMN consent_status SET DEFAULT 'unknown'")
    op.execute("DROP TYPE consentstatus_old")
    # ### end Alembic commands ###
