#!/usr/bin/env python3
"""
Version information for the Secure File Encryption Tool.
"""

# This file is automatically generated by setup.py
__version__ = "1.2.0"
__git_commit__ = "8dbb06b4a01a3a04b742ef409c9a1a4e96b14b4e"
__author__ = "Tobi <jahlives@gmx.ch>"
__license__ = "MIT"
__copyright__ = "by " + __author__

# Version history
VERSION_HISTORY = {
    "0.1.0": "Initial release",
    "0.2.0": "Added support for AES-GCM and ChaCha20-Poly1305",
    "0.3.0": "Added support for Argon2 key derivation",
    "0.4.0": "Added secure memory handling and improved password strength",
    "0.4.4": "Added support for Scrypt and more hash algorithms",
    "0.5.0": "Added BLAKE2b and SHAKE-256 hash algorithms, XChaCha20-Poly1305 encryption",
    "0.5.1": "More reliable approach to get commit sha into version.py",
    "0.5.2": "Added postquantum resistant encryption via a hypbrid approach",
    "0.5.3": "Security release with additional buffer overflow protection and better secure memory handling",
    "0.6.0rc1": "Breaking release for postquantum colud not be made non-breaking finally. This release is considered feature complete",
    "0.7.0rc1": "Breaking release for keystore feature of PQC keys. This is the last feature added to the release candidate",
    "0.7.1": "Breaking release for keystore feature of PQC keys. This is the last feature added to the release candidate. Passing all tests and updated docs",
    "0.7.2": "Added new metadata structure in a backward-compatible way. Passing all tests and updated docs",
    "0.8.1": "Added new metadata structure in a backward-compatible way. Now allows user defined data encryption when using PQC. Passing all tests and updates docs",
    "0.8.2": "fixed some issues with python versions < 3.12 / added more resiliant whirlpool implementation during build of package",
    "0.9.0": "Major non-breaking security update: Implemented constant-time cryptographic operations, secure memory allocator, standardized error handling, Python 3.13 compatibility, and comprehensive dependency security with version pinning. Improved CI pipeline with pip-audit scanning and SBOM generation. All enhancements maintain backward compatibility.",
    "0.9.1": "Extended post-quantum cryptography support: Added ML-KEM algorithms (512/768/1024), re-enabled HQC algorithms with comprehensive testing, enhanced keystore integration for all PQC algorithms, improved concurrent test execution safety, and removed bcrypt dependency due to incompatible salt handling.",
    "0.9.2": "Enhanced security for password handling: Added CRYPT_PASSWORD environment variable support for CLI with secure multi-pass clearing, implemented comprehensive GUI password security with SecurePasswordVar class, added extensive unit test suite with 11 tests covering environment variable password handling, secure clearing verification, and edge cases.",
    "1.0.0-rc1": "Major quality and security improvements: Implemented comprehensive multi-layered static code analysis system with 7 GitLab CI jobs (Bandit, Semgrep, Pylint, MyPy, code complexity), added 18+ pre-commit hooks for immediate feedback, implemented legacy algorithm warning system for deprecated cryptographic algorithms, applied comprehensive code formatting and consistency improvements via Black and isort, enhanced CI pipeline with Docker improvements and better job isolation, and cleaned up repository by removing unnecessary development artifacts. Prepared for 1.0.0 release with industry-leading code quality standards.",
    "1.0.0-rc2": "Critical production-readiness fixes: Resolved critical MyPy type errors that could cause runtime failures in PQC cipher operations, fixed variable naming conflicts between AESGCM and PQCipher classes, corrected string/bytes type assignments in password handling, removed invalid function parameters causing TypeErrors, fixed pytest test function return warnings, and corrected import paths for proper module resolution. Updated NEXT.md documentation to reflect that HQC algorithm support (hqc-128/192/256-hybrid) is fully implemented and production-ready. Security analysis confirmed 0 HIGH/MEDIUM severity issues. Reduced critical type errors from 529 to ~480 (90%+ critical runtime issues resolved). All core encryption functionality verified working. Ready for stable 1.0.0 production release.",
    "1.0.0-rc3": "Major documentation consolidation and enhancement release: Consolidated 37+ scattered documentation files into 10 comprehensive guides (73% reduction) improving organization, searchability, and user experience. Updated README.md with clickable navigation links. Enhanced CHANGELOG.md with complete version history from v0.1.0 to v1.0.0-rc3. Comprehensive RELEASE_NOTES.md overhaul with complete project narrative. Integrated ML-KEM CLI support documentation into algorithm-reference.md. Integrated HQC algorithm completion status into consolidated documentation. Enhanced user-guide.md with comprehensive manual installation steps for liboqs-python supporting multiple platforms. Improved documentation structure with logical categorization (User, Security, Technical, Project docs), comprehensive table of contents, cross-referencing, and consistent formatting. All technical content preserved while dramatically improving accessibility and maintainability.",
    "1.0.0": "STABLE RELEASE: Production-ready secure file encryption with comprehensive post-quantum cryptography support. Features ML-KEM (512/768/1024), HQC (128/192/256), and Kyber hybrid encryption algorithms alongside 18 classical encryption methods. Complete security suite with 7 hash functions, 3 key derivation methods, secure memory handling, and constant-time operations. Industry-leading code quality with comprehensive static analysis, 18+ pre-commit hooks, and extensive test coverage. Enhanced documentation with consolidated guides and comprehensive API reference. Ready for production deployment in security-critical environments.",
    "1.0.1": "UI/UX ENHANCEMENT: Implemented segregated CLI help system with two-tier structure (global overview + command-specific options). Enhanced user experience with context-aware help display showing only relevant options per command. Improved command discovery with comprehensive overview in global help. Added version-aware algorithm filtering to maintain 1.0.x series compatibility. All existing functionality and file formats unchanged. Focused release improving usability without modifying core cryptographic capabilities.",
    "1.0.2": "SECURITY FIX & MAINTENANCE: Removed AES-OCB3 algorithm due to security concerns with short nonces and implementation issues affecting key length validation. Updated CLI to block AES-OCB3 for new encryptions while preserving decryption of existing files. Changed default quick preset from AES-OCB3 to AES-GCM. Other algorithm deprecations postponed to version 1.2.0 for broader compatibility. Focused security release maintaining backward compatibility for all other algorithms.",
    "1.0.3": "DOCUMENTATION & MAINTENANCE: Updated README documentation and version bump for PyPI deployment. Minor maintenance release focusing on documentation improvements and package distribution updates.",
    "1.1.0": "MAJOR CRYPTOGRAPHIC ENHANCEMENT: Extended hash algorithm support with complete SHA-2 family (SHA-224/384) and SHA-3 family (SHA3-224/384), added BLAKE3 ultra-fast hashing and SHAKE-128 extendable-output function. Implemented RFC 5869 HKDF key derivation with configurable hash algorithms and iteration rounds. Added comprehensive post-quantum signature support with MAYO-1/3/5 multivariate and CROSS-128/192/256 code-based algorithms. Complete GUI redesign with professional hash family organization (SHA-2, SHA-3, BLAKE, SHAKE, Legacy) and dedicated KDF Algorithm Settings section. Enhanced CLI with full coverage of all hash algorithms and HKDF configuration options. Improved security posture by reclassifying PBKDF2 as legacy KDF (disabled by default). Extensive testing infrastructure with 93+ CLI parameter validation, dual implementation consistency testing, removal of deprecated pqc-allow-mixed-operations parameter, and systematic cleanup of 63 development artifacts. Comprehensive documentation updates reflecting modern vs. legacy algorithm categorization.",
    "1.2.0": "PROFESSIONAL FLUTTER DESKTOP & SECURITY HARDENING: Complete migration from tkinter to Flutter desktop providing native Wayland and X11 support, advanced CLI integration with real-time progress monitoring, comprehensive settings system with theme switching and cryptographic defaults. Desktop UX excellence with menu bar, keyboard shortcuts, drag & drop file operations, NavigationRail sidebar, tabbed interface, and algorithm recommendation engine with security guidance. Added advanced algorithm configuration UI for all KDFs (Argon2, Scrypt, Balloon, HKDF) and post-quantum algorithms (ML-KEM, Kyber, HQC, MAYO, CROSS). Enhanced security through cryptographic hardening: permanently removed deprecated PBKDF2 key derivation and Whirlpool hash algorithms from new encryption operations (existing encrypted files with these algorithms can still be decrypted). Streamlined Flatpak architecture removing complex X11/XWayland compatibility layers. Professional desktop integration with native dialogs and comprehensive JSON schema validation system for keystore and metadata structures."

}

# Check for updates
def get_latest_version():
    """Return the latest version number."""
    return __version__

def get_version_info():
    """Return version information as a dictionary."""
    return {
        "version": __version__,
        "git_commit": __git_commit__,
        "author": __author__,
        "license": __license__,
        "copyright": __copyright__,
        "history": VERSION_HISTORY
    }

def print_version_info():
    """Print version information to the console."""
    print(f"Secure File Encryption Tool v{__version__}")
    print(f"Git commit: {__git_commit__}")
    print(f"Author: {__author__}")
    print(f"License: {__license__}")
    print(f"{__copyright__}")
    print("\nVersion History:")
    for version, description in VERSION_HISTORY.items():
        print(f"  {version}: {description}")

if __name__ == "__main__":
    print_version_info()
