# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTacacsProfileResult',
    'AwaitableGetTacacsProfileResult',
    'get_tacacs_profile',
    'get_tacacs_profile_output',
]

@pulumi.output_type
class GetTacacsProfileResult:
    """
    A collection of values returned by getTacacsProfile.
    """
    def __init__(__self__, description=None, id=None, name=None, session_attributes=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if session_attributes and not isinstance(session_attributes, list):
            raise TypeError("Expected argument 'session_attributes' to be a list")
        pulumi.set(__self__, "session_attributes", session_attributes)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the object
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the TACACS profile
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sessionAttributes")
    def session_attributes(self) -> Sequence['outputs.GetTacacsProfileSessionAttributeResult']:
        return pulumi.get(self, "session_attributes")


class AwaitableGetTacacsProfileResult(GetTacacsProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTacacsProfileResult(
            description=self.description,
            id=self.id,
            name=self.name,
            session_attributes=self.session_attributes)


def get_tacacs_profile(id: Optional[builtins.str] = None,
                       name: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTacacsProfileResult:
    """
    This data source can read the TACACS Profile.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ise as ise

    example = ise.deviceadmin.get_tacacs_profile(id="76d24097-41c4-4558-a4d0-a8c07ac08470")
    ```


    :param builtins.str id: The id of the object
    :param builtins.str name: The name of the TACACS profile
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ise:deviceadmin/getTacacsProfile:getTacacsProfile', __args__, opts=opts, typ=GetTacacsProfileResult).value

    return AwaitableGetTacacsProfileResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        session_attributes=pulumi.get(__ret__, 'session_attributes'))
def get_tacacs_profile_output(id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTacacsProfileResult]:
    """
    This data source can read the TACACS Profile.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ise as ise

    example = ise.deviceadmin.get_tacacs_profile(id="76d24097-41c4-4558-a4d0-a8c07ac08470")
    ```


    :param builtins.str id: The id of the object
    :param builtins.str name: The name of the TACACS profile
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ise:deviceadmin/getTacacsProfile:getTacacsProfile', __args__, opts=opts, typ=GetTacacsProfileResult)
    return __ret__.apply(lambda __response__: GetTacacsProfileResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        session_attributes=pulumi.get(__response__, 'session_attributes')))
