# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBytes, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated
from pulpcore.client.pulp_rpm.models.async_operation_response import AsyncOperationResponse
from pulpcore.client.pulp_rpm.models.paginatedrpm_package_response_list import PaginatedrpmPackageResponseList
from pulpcore.client.pulp_rpm.models.rpm_package_response import RpmPackageResponse
from pulpcore.client.pulp_rpm.models.set_label import SetLabel
from pulpcore.client.pulp_rpm.models.set_label_response import SetLabelResponse
from pulpcore.client.pulp_rpm.models.unset_label import UnsetLabel
from pulpcore.client.pulp_rpm.models.unset_label_response import UnsetLabelResponse

from pulpcore.client.pulp_rpm.api_client import ApiClient, RequestSerialized
from pulpcore.client.pulp_rpm.api_response import ApiResponse
from pulpcore.client.pulp_rpm.rest import RESTResponseType


class ContentPackagesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        repository: Annotated[Optional[StrictStr], Field(description="A URI of a repository the new content unit should be associated with.")] = None,
        pulp_labels: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="A dictionary of arbitrary key/value pairs used to describe a specific Content instance.")] = None,
        artifact: Annotated[Optional[StrictStr], Field(description="Artifact file representing the physical content")] = None,
        relative_path: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Path where the artifact is located relative to distributions base_path")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="An uploaded file that may be turned into the content unit.")] = None,
        upload: Annotated[Optional[StrictStr], Field(description="An uncommitted upload that may be turned into the content unit.")] = None,
        file_url: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="A url that Pulp can download and turn into the content unit.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AsyncOperationResponse:
        """Create a package

        Trigger an asynchronous task to create an RPM package,optionally create new repository version.

        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param repository: A URI of a repository the new content unit should be associated with.
        :type repository: str
        :param pulp_labels: A dictionary of arbitrary key/value pairs used to describe a specific Content instance.
        :type pulp_labels: Dict[str, Optional[str]]
        :param artifact: Artifact file representing the physical content
        :type artifact: str
        :param relative_path: Path where the artifact is located relative to distributions base_path
        :type relative_path: str
        :param file: An uploaded file that may be turned into the content unit.
        :type file: bytearray
        :param upload: An uncommitted upload that may be turned into the content unit.
        :type upload: str
        :param file_url: A url that Pulp can download and turn into the content unit.
        :type file_url: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_serialize(
            x_task_diagnostics=x_task_diagnostics,
            repository=repository,
            pulp_labels=pulp_labels,
            artifact=artifact,
            relative_path=relative_path,
            file=file,
            upload=upload,
            file_url=file_url,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_with_http_info(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        repository: Annotated[Optional[StrictStr], Field(description="A URI of a repository the new content unit should be associated with.")] = None,
        pulp_labels: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="A dictionary of arbitrary key/value pairs used to describe a specific Content instance.")] = None,
        artifact: Annotated[Optional[StrictStr], Field(description="Artifact file representing the physical content")] = None,
        relative_path: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Path where the artifact is located relative to distributions base_path")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="An uploaded file that may be turned into the content unit.")] = None,
        upload: Annotated[Optional[StrictStr], Field(description="An uncommitted upload that may be turned into the content unit.")] = None,
        file_url: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="A url that Pulp can download and turn into the content unit.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AsyncOperationResponse]:
        """Create a package

        Trigger an asynchronous task to create an RPM package,optionally create new repository version.

        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param repository: A URI of a repository the new content unit should be associated with.
        :type repository: str
        :param pulp_labels: A dictionary of arbitrary key/value pairs used to describe a specific Content instance.
        :type pulp_labels: Dict[str, Optional[str]]
        :param artifact: Artifact file representing the physical content
        :type artifact: str
        :param relative_path: Path where the artifact is located relative to distributions base_path
        :type relative_path: str
        :param file: An uploaded file that may be turned into the content unit.
        :type file: bytearray
        :param upload: An uncommitted upload that may be turned into the content unit.
        :type upload: str
        :param file_url: A url that Pulp can download and turn into the content unit.
        :type file_url: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_serialize(
            x_task_diagnostics=x_task_diagnostics,
            repository=repository,
            pulp_labels=pulp_labels,
            artifact=artifact,
            relative_path=relative_path,
            file=file,
            upload=upload,
            file_url=file_url,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_without_preload_content(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        repository: Annotated[Optional[StrictStr], Field(description="A URI of a repository the new content unit should be associated with.")] = None,
        pulp_labels: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="A dictionary of arbitrary key/value pairs used to describe a specific Content instance.")] = None,
        artifact: Annotated[Optional[StrictStr], Field(description="Artifact file representing the physical content")] = None,
        relative_path: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Path where the artifact is located relative to distributions base_path")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="An uploaded file that may be turned into the content unit.")] = None,
        upload: Annotated[Optional[StrictStr], Field(description="An uncommitted upload that may be turned into the content unit.")] = None,
        file_url: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="A url that Pulp can download and turn into the content unit.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a package

        Trigger an asynchronous task to create an RPM package,optionally create new repository version.

        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param repository: A URI of a repository the new content unit should be associated with.
        :type repository: str
        :param pulp_labels: A dictionary of arbitrary key/value pairs used to describe a specific Content instance.
        :type pulp_labels: Dict[str, Optional[str]]
        :param artifact: Artifact file representing the physical content
        :type artifact: str
        :param relative_path: Path where the artifact is located relative to distributions base_path
        :type relative_path: str
        :param file: An uploaded file that may be turned into the content unit.
        :type file: bytearray
        :param upload: An uncommitted upload that may be turned into the content unit.
        :type upload: str
        :param file_url: A url that Pulp can download and turn into the content unit.
        :type file_url: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_serialize(
            x_task_diagnostics=x_task_diagnostics,
            repository=repository,
            pulp_labels=pulp_labels,
            artifact=artifact,
            relative_path=relative_path,
            file=file,
            upload=upload,
            file_url=file_url,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_serialize(
        self,
        x_task_diagnostics,
        repository,
        pulp_labels,
        artifact,
        relative_path,
        file,
        upload,
        file_url,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        if repository is not None:
            _form_params.append(('repository', repository))
        if pulp_labels is not None:
            _form_params.append(('pulp_labels', pulp_labels))
        if artifact is not None:
            _form_params.append(('artifact', artifact))
        if relative_path is not None:
            _form_params.append(('relative_path', relative_path))
        if file is not None:
            _files['file'] = file
        if upload is not None:
            _form_params.append(('upload', upload))
        if file_url is not None:
            _form_params.append(('file_url', file_url))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/pulp/api/v3/content/rpm/packages/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        arch: Annotated[Optional[StrictStr], Field(description="Filter results where arch matches value")] = None,
        arch__contains: Annotated[Optional[StrictStr], Field(description="Filter results where arch contains value")] = None,
        arch__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where arch is in a comma-separated list of values")] = None,
        arch__ne: Annotated[Optional[StrictStr], Field(description="Filter results where arch not equal to value")] = None,
        arch__startswith: Annotated[Optional[StrictStr], Field(description="Filter results where arch starts with value")] = None,
        checksum_type: Annotated[Optional[StrictStr], Field(description="Filter results where checksum_type matches value  * `unknown` - unknown * `md5` - md5 * `sha1` - sha1 * `sha1` - sha1 * `sha224` - sha224 * `sha256` - sha256 * `sha384` - sha384 * `sha512` - sha512")] = None,
        checksum_type__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where checksum_type is in a comma-separated list of values")] = None,
        checksum_type__ne: Annotated[Optional[StrictStr], Field(description="Filter results where checksum_type not equal to value")] = None,
        epoch: Annotated[Optional[StrictStr], Field(description="Filter results where epoch matches value")] = None,
        epoch__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where epoch is in a comma-separated list of values")] = None,
        epoch__ne: Annotated[Optional[StrictStr], Field(description="Filter results where epoch not equal to value")] = None,
        filename: Optional[StrictStr] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter results where name matches value")] = None,
        name__contains: Annotated[Optional[StrictStr], Field(description="Filter results where name contains value")] = None,
        name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where name is in a comma-separated list of values")] = None,
        name__ne: Annotated[Optional[StrictStr], Field(description="Filter results where name not equal to value")] = None,
        name__startswith: Annotated[Optional[StrictStr], Field(description="Filter results where name starts with value")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `name` - Name * `-name` - Name (descending) * `epoch` - Epoch * `-epoch` - Epoch (descending) * `version` - Version * `-version` - Version (descending) * `release` - Release * `-release` - Release (descending) * `arch` - Arch * `-arch` - Arch (descending) * `evr` - Evr * `-evr` - Evr (descending) * `pkgId` - Pkgid * `-pkgId` - Pkgid (descending) * `checksum_type` - Checksum type * `-checksum_type` - Checksum type (descending) * `summary` - Summary * `-summary` - Summary (descending) * `description` - Description * `-description` - Description (descending) * `url` - Url * `-url` - Url (descending) * `changelogs` - Changelogs * `-changelogs` - Changelogs (descending) * `files` - Files * `-files` - Files (descending) * `requires` - Requires * `-requires` - Requires (descending) * `provides` - Provides * `-provides` - Provides (descending) * `conflicts` - Conflicts * `-conflicts` - Conflicts (descending) * `obsoletes` - Obsoletes * `-obsoletes` - Obsoletes (descending) * `suggests` - Suggests * `-suggests` - Suggests (descending) * `enhances` - Enhances * `-enhances` - Enhances (descending) * `recommends` - Recommends * `-recommends` - Recommends (descending) * `supplements` - Supplements * `-supplements` - Supplements (descending) * `location_base` - Location base * `-location_base` - Location base (descending) * `location_href` - Location href * `-location_href` - Location href (descending) * `rpm_buildhost` - Rpm buildhost * `-rpm_buildhost` - Rpm buildhost (descending) * `rpm_group` - Rpm group * `-rpm_group` - Rpm group (descending) * `rpm_license` - Rpm license * `-rpm_license` - Rpm license (descending) * `rpm_packager` - Rpm packager * `-rpm_packager` - Rpm packager (descending) * `rpm_sourcerpm` - Rpm sourcerpm * `-rpm_sourcerpm` - Rpm sourcerpm (descending) * `rpm_vendor` - Rpm vendor * `-rpm_vendor` - Rpm vendor (descending) * `rpm_header_start` - Rpm header start * `-rpm_header_start` - Rpm header start (descending) * `rpm_header_end` - Rpm header end * `-rpm_header_end` - Rpm header end (descending) * `size_archive` - Size archive * `-size_archive` - Size archive (descending) * `size_installed` - Size installed * `-size_installed` - Size installed (descending) * `size_package` - Size package * `-size_package` - Size package (descending) * `time_build` - Time build * `-time_build` - Time build (descending) * `time_file` - Time file * `-time_file` - Time file (descending) * `is_modular` - Is modular * `-is_modular` - Is modular (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        orphaned_for: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.")] = None,
        pkg_id: Annotated[Optional[StrictStr], Field(description="Filter results where pkgId matches value")] = None,
        pkg_id__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where pkgId is in a comma-separated list of values")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_label_select: Annotated[Optional[StrictStr], Field(description="Filter labels by search string")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        release: Annotated[Optional[StrictStr], Field(description="Filter results where release matches value")] = None,
        release__contains: Annotated[Optional[StrictStr], Field(description="Filter results where release contains value")] = None,
        release__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where release is in a comma-separated list of values")] = None,
        release__ne: Annotated[Optional[StrictStr], Field(description="Filter results where release not equal to value")] = None,
        release__startswith: Annotated[Optional[StrictStr], Field(description="Filter results where release starts with value")] = None,
        repository_version: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_added: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_removed: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        sha256: Optional[StrictStr] = None,
        version: Annotated[Optional[StrictStr], Field(description="Filter results where version matches value")] = None,
        version__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where version is in a comma-separated list of values")] = None,
        version__ne: Annotated[Optional[StrictStr], Field(description="Filter results where version not equal to value")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PaginatedrpmPackageResponseList:
        """List packages

        A ViewSet for Package.  Define endpoint name which will appear in the API endpoint for this content type. For example::     http://pulp.example.com/pulp/api/v3/content/rpm/packages/  Also specify queryset and serializer for Package.

        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param arch: Filter results where arch matches value
        :type arch: str
        :param arch__contains: Filter results where arch contains value
        :type arch__contains: str
        :param arch__in: Filter results where arch is in a comma-separated list of values
        :type arch__in: List[str]
        :param arch__ne: Filter results where arch not equal to value
        :type arch__ne: str
        :param arch__startswith: Filter results where arch starts with value
        :type arch__startswith: str
        :param checksum_type: Filter results where checksum_type matches value  * `unknown` - unknown * `md5` - md5 * `sha1` - sha1 * `sha1` - sha1 * `sha224` - sha224 * `sha256` - sha256 * `sha384` - sha384 * `sha512` - sha512
        :type checksum_type: str
        :param checksum_type__in: Filter results where checksum_type is in a comma-separated list of values
        :type checksum_type__in: List[str]
        :param checksum_type__ne: Filter results where checksum_type not equal to value
        :type checksum_type__ne: str
        :param epoch: Filter results where epoch matches value
        :type epoch: str
        :param epoch__in: Filter results where epoch is in a comma-separated list of values
        :type epoch__in: List[str]
        :param epoch__ne: Filter results where epoch not equal to value
        :type epoch__ne: str
        :param filename:
        :type filename: str
        :param limit: Number of results to return per page.
        :type limit: int
        :param name: Filter results where name matches value
        :type name: str
        :param name__contains: Filter results where name contains value
        :type name__contains: str
        :param name__in: Filter results where name is in a comma-separated list of values
        :type name__in: List[str]
        :param name__ne: Filter results where name not equal to value
        :type name__ne: str
        :param name__startswith: Filter results where name starts with value
        :type name__startswith: str
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `name` - Name * `-name` - Name (descending) * `epoch` - Epoch * `-epoch` - Epoch (descending) * `version` - Version * `-version` - Version (descending) * `release` - Release * `-release` - Release (descending) * `arch` - Arch * `-arch` - Arch (descending) * `evr` - Evr * `-evr` - Evr (descending) * `pkgId` - Pkgid * `-pkgId` - Pkgid (descending) * `checksum_type` - Checksum type * `-checksum_type` - Checksum type (descending) * `summary` - Summary * `-summary` - Summary (descending) * `description` - Description * `-description` - Description (descending) * `url` - Url * `-url` - Url (descending) * `changelogs` - Changelogs * `-changelogs` - Changelogs (descending) * `files` - Files * `-files` - Files (descending) * `requires` - Requires * `-requires` - Requires (descending) * `provides` - Provides * `-provides` - Provides (descending) * `conflicts` - Conflicts * `-conflicts` - Conflicts (descending) * `obsoletes` - Obsoletes * `-obsoletes` - Obsoletes (descending) * `suggests` - Suggests * `-suggests` - Suggests (descending) * `enhances` - Enhances * `-enhances` - Enhances (descending) * `recommends` - Recommends * `-recommends` - Recommends (descending) * `supplements` - Supplements * `-supplements` - Supplements (descending) * `location_base` - Location base * `-location_base` - Location base (descending) * `location_href` - Location href * `-location_href` - Location href (descending) * `rpm_buildhost` - Rpm buildhost * `-rpm_buildhost` - Rpm buildhost (descending) * `rpm_group` - Rpm group * `-rpm_group` - Rpm group (descending) * `rpm_license` - Rpm license * `-rpm_license` - Rpm license (descending) * `rpm_packager` - Rpm packager * `-rpm_packager` - Rpm packager (descending) * `rpm_sourcerpm` - Rpm sourcerpm * `-rpm_sourcerpm` - Rpm sourcerpm (descending) * `rpm_vendor` - Rpm vendor * `-rpm_vendor` - Rpm vendor (descending) * `rpm_header_start` - Rpm header start * `-rpm_header_start` - Rpm header start (descending) * `rpm_header_end` - Rpm header end * `-rpm_header_end` - Rpm header end (descending) * `size_archive` - Size archive * `-size_archive` - Size archive (descending) * `size_installed` - Size installed * `-size_installed` - Size installed (descending) * `size_package` - Size package * `-size_package` - Size package (descending) * `time_build` - Time build * `-time_build` - Time build (descending) * `time_file` - Time file * `-time_file` - Time file (descending) * `is_modular` - Is modular * `-is_modular` - Is modular (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param orphaned_for: Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.
        :type orphaned_for: float
        :param pkg_id: Filter results where pkgId matches value
        :type pkg_id: str
        :param pkg_id__in: Filter results where pkgId is in a comma-separated list of values
        :type pkg_id__in: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param pulp_label_select: Filter labels by search string
        :type pulp_label_select: str
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param release: Filter results where release matches value
        :type release: str
        :param release__contains: Filter results where release contains value
        :type release__contains: str
        :param release__in: Filter results where release is in a comma-separated list of values
        :type release__in: List[str]
        :param release__ne: Filter results where release not equal to value
        :type release__ne: str
        :param release__startswith: Filter results where release starts with value
        :type release__startswith: str
        :param repository_version: Repository Version referenced by HREF/PRN
        :type repository_version: str
        :param repository_version_added: Repository Version referenced by HREF/PRN
        :type repository_version_added: str
        :param repository_version_removed: Repository Version referenced by HREF/PRN
        :type repository_version_removed: str
        :param sha256:
        :type sha256: str
        :param version: Filter results where version matches value
        :type version: str
        :param version__in: Filter results where version is in a comma-separated list of values
        :type version__in: List[str]
        :param version__ne: Filter results where version not equal to value
        :type version__ne: str
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            x_task_diagnostics=x_task_diagnostics,
            arch=arch,
            arch__contains=arch__contains,
            arch__in=arch__in,
            arch__ne=arch__ne,
            arch__startswith=arch__startswith,
            checksum_type=checksum_type,
            checksum_type__in=checksum_type__in,
            checksum_type__ne=checksum_type__ne,
            epoch=epoch,
            epoch__in=epoch__in,
            epoch__ne=epoch__ne,
            filename=filename,
            limit=limit,
            name=name,
            name__contains=name__contains,
            name__in=name__in,
            name__ne=name__ne,
            name__startswith=name__startswith,
            offset=offset,
            ordering=ordering,
            orphaned_for=orphaned_for,
            pkg_id=pkg_id,
            pkg_id__in=pkg_id__in,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            pulp_label_select=pulp_label_select,
            q=q,
            release=release,
            release__contains=release__contains,
            release__in=release__in,
            release__ne=release__ne,
            release__startswith=release__startswith,
            repository_version=repository_version,
            repository_version_added=repository_version_added,
            repository_version_removed=repository_version_removed,
            sha256=sha256,
            version=version,
            version__in=version__in,
            version__ne=version__ne,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedrpmPackageResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_with_http_info(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        arch: Annotated[Optional[StrictStr], Field(description="Filter results where arch matches value")] = None,
        arch__contains: Annotated[Optional[StrictStr], Field(description="Filter results where arch contains value")] = None,
        arch__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where arch is in a comma-separated list of values")] = None,
        arch__ne: Annotated[Optional[StrictStr], Field(description="Filter results where arch not equal to value")] = None,
        arch__startswith: Annotated[Optional[StrictStr], Field(description="Filter results where arch starts with value")] = None,
        checksum_type: Annotated[Optional[StrictStr], Field(description="Filter results where checksum_type matches value  * `unknown` - unknown * `md5` - md5 * `sha1` - sha1 * `sha1` - sha1 * `sha224` - sha224 * `sha256` - sha256 * `sha384` - sha384 * `sha512` - sha512")] = None,
        checksum_type__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where checksum_type is in a comma-separated list of values")] = None,
        checksum_type__ne: Annotated[Optional[StrictStr], Field(description="Filter results where checksum_type not equal to value")] = None,
        epoch: Annotated[Optional[StrictStr], Field(description="Filter results where epoch matches value")] = None,
        epoch__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where epoch is in a comma-separated list of values")] = None,
        epoch__ne: Annotated[Optional[StrictStr], Field(description="Filter results where epoch not equal to value")] = None,
        filename: Optional[StrictStr] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter results where name matches value")] = None,
        name__contains: Annotated[Optional[StrictStr], Field(description="Filter results where name contains value")] = None,
        name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where name is in a comma-separated list of values")] = None,
        name__ne: Annotated[Optional[StrictStr], Field(description="Filter results where name not equal to value")] = None,
        name__startswith: Annotated[Optional[StrictStr], Field(description="Filter results where name starts with value")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `name` - Name * `-name` - Name (descending) * `epoch` - Epoch * `-epoch` - Epoch (descending) * `version` - Version * `-version` - Version (descending) * `release` - Release * `-release` - Release (descending) * `arch` - Arch * `-arch` - Arch (descending) * `evr` - Evr * `-evr` - Evr (descending) * `pkgId` - Pkgid * `-pkgId` - Pkgid (descending) * `checksum_type` - Checksum type * `-checksum_type` - Checksum type (descending) * `summary` - Summary * `-summary` - Summary (descending) * `description` - Description * `-description` - Description (descending) * `url` - Url * `-url` - Url (descending) * `changelogs` - Changelogs * `-changelogs` - Changelogs (descending) * `files` - Files * `-files` - Files (descending) * `requires` - Requires * `-requires` - Requires (descending) * `provides` - Provides * `-provides` - Provides (descending) * `conflicts` - Conflicts * `-conflicts` - Conflicts (descending) * `obsoletes` - Obsoletes * `-obsoletes` - Obsoletes (descending) * `suggests` - Suggests * `-suggests` - Suggests (descending) * `enhances` - Enhances * `-enhances` - Enhances (descending) * `recommends` - Recommends * `-recommends` - Recommends (descending) * `supplements` - Supplements * `-supplements` - Supplements (descending) * `location_base` - Location base * `-location_base` - Location base (descending) * `location_href` - Location href * `-location_href` - Location href (descending) * `rpm_buildhost` - Rpm buildhost * `-rpm_buildhost` - Rpm buildhost (descending) * `rpm_group` - Rpm group * `-rpm_group` - Rpm group (descending) * `rpm_license` - Rpm license * `-rpm_license` - Rpm license (descending) * `rpm_packager` - Rpm packager * `-rpm_packager` - Rpm packager (descending) * `rpm_sourcerpm` - Rpm sourcerpm * `-rpm_sourcerpm` - Rpm sourcerpm (descending) * `rpm_vendor` - Rpm vendor * `-rpm_vendor` - Rpm vendor (descending) * `rpm_header_start` - Rpm header start * `-rpm_header_start` - Rpm header start (descending) * `rpm_header_end` - Rpm header end * `-rpm_header_end` - Rpm header end (descending) * `size_archive` - Size archive * `-size_archive` - Size archive (descending) * `size_installed` - Size installed * `-size_installed` - Size installed (descending) * `size_package` - Size package * `-size_package` - Size package (descending) * `time_build` - Time build * `-time_build` - Time build (descending) * `time_file` - Time file * `-time_file` - Time file (descending) * `is_modular` - Is modular * `-is_modular` - Is modular (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        orphaned_for: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.")] = None,
        pkg_id: Annotated[Optional[StrictStr], Field(description="Filter results where pkgId matches value")] = None,
        pkg_id__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where pkgId is in a comma-separated list of values")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_label_select: Annotated[Optional[StrictStr], Field(description="Filter labels by search string")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        release: Annotated[Optional[StrictStr], Field(description="Filter results where release matches value")] = None,
        release__contains: Annotated[Optional[StrictStr], Field(description="Filter results where release contains value")] = None,
        release__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where release is in a comma-separated list of values")] = None,
        release__ne: Annotated[Optional[StrictStr], Field(description="Filter results where release not equal to value")] = None,
        release__startswith: Annotated[Optional[StrictStr], Field(description="Filter results where release starts with value")] = None,
        repository_version: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_added: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_removed: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        sha256: Optional[StrictStr] = None,
        version: Annotated[Optional[StrictStr], Field(description="Filter results where version matches value")] = None,
        version__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where version is in a comma-separated list of values")] = None,
        version__ne: Annotated[Optional[StrictStr], Field(description="Filter results where version not equal to value")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PaginatedrpmPackageResponseList]:
        """List packages

        A ViewSet for Package.  Define endpoint name which will appear in the API endpoint for this content type. For example::     http://pulp.example.com/pulp/api/v3/content/rpm/packages/  Also specify queryset and serializer for Package.

        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param arch: Filter results where arch matches value
        :type arch: str
        :param arch__contains: Filter results where arch contains value
        :type arch__contains: str
        :param arch__in: Filter results where arch is in a comma-separated list of values
        :type arch__in: List[str]
        :param arch__ne: Filter results where arch not equal to value
        :type arch__ne: str
        :param arch__startswith: Filter results where arch starts with value
        :type arch__startswith: str
        :param checksum_type: Filter results where checksum_type matches value  * `unknown` - unknown * `md5` - md5 * `sha1` - sha1 * `sha1` - sha1 * `sha224` - sha224 * `sha256` - sha256 * `sha384` - sha384 * `sha512` - sha512
        :type checksum_type: str
        :param checksum_type__in: Filter results where checksum_type is in a comma-separated list of values
        :type checksum_type__in: List[str]
        :param checksum_type__ne: Filter results where checksum_type not equal to value
        :type checksum_type__ne: str
        :param epoch: Filter results where epoch matches value
        :type epoch: str
        :param epoch__in: Filter results where epoch is in a comma-separated list of values
        :type epoch__in: List[str]
        :param epoch__ne: Filter results where epoch not equal to value
        :type epoch__ne: str
        :param filename:
        :type filename: str
        :param limit: Number of results to return per page.
        :type limit: int
        :param name: Filter results where name matches value
        :type name: str
        :param name__contains: Filter results where name contains value
        :type name__contains: str
        :param name__in: Filter results where name is in a comma-separated list of values
        :type name__in: List[str]
        :param name__ne: Filter results where name not equal to value
        :type name__ne: str
        :param name__startswith: Filter results where name starts with value
        :type name__startswith: str
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `name` - Name * `-name` - Name (descending) * `epoch` - Epoch * `-epoch` - Epoch (descending) * `version` - Version * `-version` - Version (descending) * `release` - Release * `-release` - Release (descending) * `arch` - Arch * `-arch` - Arch (descending) * `evr` - Evr * `-evr` - Evr (descending) * `pkgId` - Pkgid * `-pkgId` - Pkgid (descending) * `checksum_type` - Checksum type * `-checksum_type` - Checksum type (descending) * `summary` - Summary * `-summary` - Summary (descending) * `description` - Description * `-description` - Description (descending) * `url` - Url * `-url` - Url (descending) * `changelogs` - Changelogs * `-changelogs` - Changelogs (descending) * `files` - Files * `-files` - Files (descending) * `requires` - Requires * `-requires` - Requires (descending) * `provides` - Provides * `-provides` - Provides (descending) * `conflicts` - Conflicts * `-conflicts` - Conflicts (descending) * `obsoletes` - Obsoletes * `-obsoletes` - Obsoletes (descending) * `suggests` - Suggests * `-suggests` - Suggests (descending) * `enhances` - Enhances * `-enhances` - Enhances (descending) * `recommends` - Recommends * `-recommends` - Recommends (descending) * `supplements` - Supplements * `-supplements` - Supplements (descending) * `location_base` - Location base * `-location_base` - Location base (descending) * `location_href` - Location href * `-location_href` - Location href (descending) * `rpm_buildhost` - Rpm buildhost * `-rpm_buildhost` - Rpm buildhost (descending) * `rpm_group` - Rpm group * `-rpm_group` - Rpm group (descending) * `rpm_license` - Rpm license * `-rpm_license` - Rpm license (descending) * `rpm_packager` - Rpm packager * `-rpm_packager` - Rpm packager (descending) * `rpm_sourcerpm` - Rpm sourcerpm * `-rpm_sourcerpm` - Rpm sourcerpm (descending) * `rpm_vendor` - Rpm vendor * `-rpm_vendor` - Rpm vendor (descending) * `rpm_header_start` - Rpm header start * `-rpm_header_start` - Rpm header start (descending) * `rpm_header_end` - Rpm header end * `-rpm_header_end` - Rpm header end (descending) * `size_archive` - Size archive * `-size_archive` - Size archive (descending) * `size_installed` - Size installed * `-size_installed` - Size installed (descending) * `size_package` - Size package * `-size_package` - Size package (descending) * `time_build` - Time build * `-time_build` - Time build (descending) * `time_file` - Time file * `-time_file` - Time file (descending) * `is_modular` - Is modular * `-is_modular` - Is modular (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param orphaned_for: Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.
        :type orphaned_for: float
        :param pkg_id: Filter results where pkgId matches value
        :type pkg_id: str
        :param pkg_id__in: Filter results where pkgId is in a comma-separated list of values
        :type pkg_id__in: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param pulp_label_select: Filter labels by search string
        :type pulp_label_select: str
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param release: Filter results where release matches value
        :type release: str
        :param release__contains: Filter results where release contains value
        :type release__contains: str
        :param release__in: Filter results where release is in a comma-separated list of values
        :type release__in: List[str]
        :param release__ne: Filter results where release not equal to value
        :type release__ne: str
        :param release__startswith: Filter results where release starts with value
        :type release__startswith: str
        :param repository_version: Repository Version referenced by HREF/PRN
        :type repository_version: str
        :param repository_version_added: Repository Version referenced by HREF/PRN
        :type repository_version_added: str
        :param repository_version_removed: Repository Version referenced by HREF/PRN
        :type repository_version_removed: str
        :param sha256:
        :type sha256: str
        :param version: Filter results where version matches value
        :type version: str
        :param version__in: Filter results where version is in a comma-separated list of values
        :type version__in: List[str]
        :param version__ne: Filter results where version not equal to value
        :type version__ne: str
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            x_task_diagnostics=x_task_diagnostics,
            arch=arch,
            arch__contains=arch__contains,
            arch__in=arch__in,
            arch__ne=arch__ne,
            arch__startswith=arch__startswith,
            checksum_type=checksum_type,
            checksum_type__in=checksum_type__in,
            checksum_type__ne=checksum_type__ne,
            epoch=epoch,
            epoch__in=epoch__in,
            epoch__ne=epoch__ne,
            filename=filename,
            limit=limit,
            name=name,
            name__contains=name__contains,
            name__in=name__in,
            name__ne=name__ne,
            name__startswith=name__startswith,
            offset=offset,
            ordering=ordering,
            orphaned_for=orphaned_for,
            pkg_id=pkg_id,
            pkg_id__in=pkg_id__in,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            pulp_label_select=pulp_label_select,
            q=q,
            release=release,
            release__contains=release__contains,
            release__in=release__in,
            release__ne=release__ne,
            release__startswith=release__startswith,
            repository_version=repository_version,
            repository_version_added=repository_version_added,
            repository_version_removed=repository_version_removed,
            sha256=sha256,
            version=version,
            version__in=version__in,
            version__ne=version__ne,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedrpmPackageResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_without_preload_content(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        arch: Annotated[Optional[StrictStr], Field(description="Filter results where arch matches value")] = None,
        arch__contains: Annotated[Optional[StrictStr], Field(description="Filter results where arch contains value")] = None,
        arch__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where arch is in a comma-separated list of values")] = None,
        arch__ne: Annotated[Optional[StrictStr], Field(description="Filter results where arch not equal to value")] = None,
        arch__startswith: Annotated[Optional[StrictStr], Field(description="Filter results where arch starts with value")] = None,
        checksum_type: Annotated[Optional[StrictStr], Field(description="Filter results where checksum_type matches value  * `unknown` - unknown * `md5` - md5 * `sha1` - sha1 * `sha1` - sha1 * `sha224` - sha224 * `sha256` - sha256 * `sha384` - sha384 * `sha512` - sha512")] = None,
        checksum_type__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where checksum_type is in a comma-separated list of values")] = None,
        checksum_type__ne: Annotated[Optional[StrictStr], Field(description="Filter results where checksum_type not equal to value")] = None,
        epoch: Annotated[Optional[StrictStr], Field(description="Filter results where epoch matches value")] = None,
        epoch__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where epoch is in a comma-separated list of values")] = None,
        epoch__ne: Annotated[Optional[StrictStr], Field(description="Filter results where epoch not equal to value")] = None,
        filename: Optional[StrictStr] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter results where name matches value")] = None,
        name__contains: Annotated[Optional[StrictStr], Field(description="Filter results where name contains value")] = None,
        name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where name is in a comma-separated list of values")] = None,
        name__ne: Annotated[Optional[StrictStr], Field(description="Filter results where name not equal to value")] = None,
        name__startswith: Annotated[Optional[StrictStr], Field(description="Filter results where name starts with value")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `name` - Name * `-name` - Name (descending) * `epoch` - Epoch * `-epoch` - Epoch (descending) * `version` - Version * `-version` - Version (descending) * `release` - Release * `-release` - Release (descending) * `arch` - Arch * `-arch` - Arch (descending) * `evr` - Evr * `-evr` - Evr (descending) * `pkgId` - Pkgid * `-pkgId` - Pkgid (descending) * `checksum_type` - Checksum type * `-checksum_type` - Checksum type (descending) * `summary` - Summary * `-summary` - Summary (descending) * `description` - Description * `-description` - Description (descending) * `url` - Url * `-url` - Url (descending) * `changelogs` - Changelogs * `-changelogs` - Changelogs (descending) * `files` - Files * `-files` - Files (descending) * `requires` - Requires * `-requires` - Requires (descending) * `provides` - Provides * `-provides` - Provides (descending) * `conflicts` - Conflicts * `-conflicts` - Conflicts (descending) * `obsoletes` - Obsoletes * `-obsoletes` - Obsoletes (descending) * `suggests` - Suggests * `-suggests` - Suggests (descending) * `enhances` - Enhances * `-enhances` - Enhances (descending) * `recommends` - Recommends * `-recommends` - Recommends (descending) * `supplements` - Supplements * `-supplements` - Supplements (descending) * `location_base` - Location base * `-location_base` - Location base (descending) * `location_href` - Location href * `-location_href` - Location href (descending) * `rpm_buildhost` - Rpm buildhost * `-rpm_buildhost` - Rpm buildhost (descending) * `rpm_group` - Rpm group * `-rpm_group` - Rpm group (descending) * `rpm_license` - Rpm license * `-rpm_license` - Rpm license (descending) * `rpm_packager` - Rpm packager * `-rpm_packager` - Rpm packager (descending) * `rpm_sourcerpm` - Rpm sourcerpm * `-rpm_sourcerpm` - Rpm sourcerpm (descending) * `rpm_vendor` - Rpm vendor * `-rpm_vendor` - Rpm vendor (descending) * `rpm_header_start` - Rpm header start * `-rpm_header_start` - Rpm header start (descending) * `rpm_header_end` - Rpm header end * `-rpm_header_end` - Rpm header end (descending) * `size_archive` - Size archive * `-size_archive` - Size archive (descending) * `size_installed` - Size installed * `-size_installed` - Size installed (descending) * `size_package` - Size package * `-size_package` - Size package (descending) * `time_build` - Time build * `-time_build` - Time build (descending) * `time_file` - Time file * `-time_file` - Time file (descending) * `is_modular` - Is modular * `-is_modular` - Is modular (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        orphaned_for: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.")] = None,
        pkg_id: Annotated[Optional[StrictStr], Field(description="Filter results where pkgId matches value")] = None,
        pkg_id__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where pkgId is in a comma-separated list of values")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_label_select: Annotated[Optional[StrictStr], Field(description="Filter labels by search string")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        release: Annotated[Optional[StrictStr], Field(description="Filter results where release matches value")] = None,
        release__contains: Annotated[Optional[StrictStr], Field(description="Filter results where release contains value")] = None,
        release__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where release is in a comma-separated list of values")] = None,
        release__ne: Annotated[Optional[StrictStr], Field(description="Filter results where release not equal to value")] = None,
        release__startswith: Annotated[Optional[StrictStr], Field(description="Filter results where release starts with value")] = None,
        repository_version: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_added: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_removed: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        sha256: Optional[StrictStr] = None,
        version: Annotated[Optional[StrictStr], Field(description="Filter results where version matches value")] = None,
        version__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where version is in a comma-separated list of values")] = None,
        version__ne: Annotated[Optional[StrictStr], Field(description="Filter results where version not equal to value")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List packages

        A ViewSet for Package.  Define endpoint name which will appear in the API endpoint for this content type. For example::     http://pulp.example.com/pulp/api/v3/content/rpm/packages/  Also specify queryset and serializer for Package.

        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param arch: Filter results where arch matches value
        :type arch: str
        :param arch__contains: Filter results where arch contains value
        :type arch__contains: str
        :param arch__in: Filter results where arch is in a comma-separated list of values
        :type arch__in: List[str]
        :param arch__ne: Filter results where arch not equal to value
        :type arch__ne: str
        :param arch__startswith: Filter results where arch starts with value
        :type arch__startswith: str
        :param checksum_type: Filter results where checksum_type matches value  * `unknown` - unknown * `md5` - md5 * `sha1` - sha1 * `sha1` - sha1 * `sha224` - sha224 * `sha256` - sha256 * `sha384` - sha384 * `sha512` - sha512
        :type checksum_type: str
        :param checksum_type__in: Filter results where checksum_type is in a comma-separated list of values
        :type checksum_type__in: List[str]
        :param checksum_type__ne: Filter results where checksum_type not equal to value
        :type checksum_type__ne: str
        :param epoch: Filter results where epoch matches value
        :type epoch: str
        :param epoch__in: Filter results where epoch is in a comma-separated list of values
        :type epoch__in: List[str]
        :param epoch__ne: Filter results where epoch not equal to value
        :type epoch__ne: str
        :param filename:
        :type filename: str
        :param limit: Number of results to return per page.
        :type limit: int
        :param name: Filter results where name matches value
        :type name: str
        :param name__contains: Filter results where name contains value
        :type name__contains: str
        :param name__in: Filter results where name is in a comma-separated list of values
        :type name__in: List[str]
        :param name__ne: Filter results where name not equal to value
        :type name__ne: str
        :param name__startswith: Filter results where name starts with value
        :type name__startswith: str
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `name` - Name * `-name` - Name (descending) * `epoch` - Epoch * `-epoch` - Epoch (descending) * `version` - Version * `-version` - Version (descending) * `release` - Release * `-release` - Release (descending) * `arch` - Arch * `-arch` - Arch (descending) * `evr` - Evr * `-evr` - Evr (descending) * `pkgId` - Pkgid * `-pkgId` - Pkgid (descending) * `checksum_type` - Checksum type * `-checksum_type` - Checksum type (descending) * `summary` - Summary * `-summary` - Summary (descending) * `description` - Description * `-description` - Description (descending) * `url` - Url * `-url` - Url (descending) * `changelogs` - Changelogs * `-changelogs` - Changelogs (descending) * `files` - Files * `-files` - Files (descending) * `requires` - Requires * `-requires` - Requires (descending) * `provides` - Provides * `-provides` - Provides (descending) * `conflicts` - Conflicts * `-conflicts` - Conflicts (descending) * `obsoletes` - Obsoletes * `-obsoletes` - Obsoletes (descending) * `suggests` - Suggests * `-suggests` - Suggests (descending) * `enhances` - Enhances * `-enhances` - Enhances (descending) * `recommends` - Recommends * `-recommends` - Recommends (descending) * `supplements` - Supplements * `-supplements` - Supplements (descending) * `location_base` - Location base * `-location_base` - Location base (descending) * `location_href` - Location href * `-location_href` - Location href (descending) * `rpm_buildhost` - Rpm buildhost * `-rpm_buildhost` - Rpm buildhost (descending) * `rpm_group` - Rpm group * `-rpm_group` - Rpm group (descending) * `rpm_license` - Rpm license * `-rpm_license` - Rpm license (descending) * `rpm_packager` - Rpm packager * `-rpm_packager` - Rpm packager (descending) * `rpm_sourcerpm` - Rpm sourcerpm * `-rpm_sourcerpm` - Rpm sourcerpm (descending) * `rpm_vendor` - Rpm vendor * `-rpm_vendor` - Rpm vendor (descending) * `rpm_header_start` - Rpm header start * `-rpm_header_start` - Rpm header start (descending) * `rpm_header_end` - Rpm header end * `-rpm_header_end` - Rpm header end (descending) * `size_archive` - Size archive * `-size_archive` - Size archive (descending) * `size_installed` - Size installed * `-size_installed` - Size installed (descending) * `size_package` - Size package * `-size_package` - Size package (descending) * `time_build` - Time build * `-time_build` - Time build (descending) * `time_file` - Time file * `-time_file` - Time file (descending) * `is_modular` - Is modular * `-is_modular` - Is modular (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param orphaned_for: Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.
        :type orphaned_for: float
        :param pkg_id: Filter results where pkgId matches value
        :type pkg_id: str
        :param pkg_id__in: Filter results where pkgId is in a comma-separated list of values
        :type pkg_id__in: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param pulp_label_select: Filter labels by search string
        :type pulp_label_select: str
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param release: Filter results where release matches value
        :type release: str
        :param release__contains: Filter results where release contains value
        :type release__contains: str
        :param release__in: Filter results where release is in a comma-separated list of values
        :type release__in: List[str]
        :param release__ne: Filter results where release not equal to value
        :type release__ne: str
        :param release__startswith: Filter results where release starts with value
        :type release__startswith: str
        :param repository_version: Repository Version referenced by HREF/PRN
        :type repository_version: str
        :param repository_version_added: Repository Version referenced by HREF/PRN
        :type repository_version_added: str
        :param repository_version_removed: Repository Version referenced by HREF/PRN
        :type repository_version_removed: str
        :param sha256:
        :type sha256: str
        :param version: Filter results where version matches value
        :type version: str
        :param version__in: Filter results where version is in a comma-separated list of values
        :type version__in: List[str]
        :param version__ne: Filter results where version not equal to value
        :type version__ne: str
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            x_task_diagnostics=x_task_diagnostics,
            arch=arch,
            arch__contains=arch__contains,
            arch__in=arch__in,
            arch__ne=arch__ne,
            arch__startswith=arch__startswith,
            checksum_type=checksum_type,
            checksum_type__in=checksum_type__in,
            checksum_type__ne=checksum_type__ne,
            epoch=epoch,
            epoch__in=epoch__in,
            epoch__ne=epoch__ne,
            filename=filename,
            limit=limit,
            name=name,
            name__contains=name__contains,
            name__in=name__in,
            name__ne=name__ne,
            name__startswith=name__startswith,
            offset=offset,
            ordering=ordering,
            orphaned_for=orphaned_for,
            pkg_id=pkg_id,
            pkg_id__in=pkg_id__in,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            pulp_label_select=pulp_label_select,
            q=q,
            release=release,
            release__contains=release__contains,
            release__in=release__in,
            release__ne=release__ne,
            release__startswith=release__startswith,
            repository_version=repository_version,
            repository_version_added=repository_version_added,
            repository_version_removed=repository_version_removed,
            sha256=sha256,
            version=version,
            version__in=version__in,
            version__ne=version__ne,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedrpmPackageResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_serialize(
        self,
        x_task_diagnostics,
        arch,
        arch__contains,
        arch__in,
        arch__ne,
        arch__startswith,
        checksum_type,
        checksum_type__in,
        checksum_type__ne,
        epoch,
        epoch__in,
        epoch__ne,
        filename,
        limit,
        name,
        name__contains,
        name__in,
        name__ne,
        name__startswith,
        offset,
        ordering,
        orphaned_for,
        pkg_id,
        pkg_id__in,
        prn__in,
        pulp_href__in,
        pulp_id__in,
        pulp_label_select,
        q,
        release,
        release__contains,
        release__in,
        release__ne,
        release__startswith,
        repository_version,
        repository_version_added,
        repository_version_removed,
        sha256,
        version,
        version__in,
        version__ne,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'arch__in': 'csv',
            'checksum_type__in': 'csv',
            'epoch__in': 'csv',
            'name__in': 'csv',
            'ordering': 'csv',
            'pkgId__in': 'csv',
            'prn__in': 'csv',
            'pulp_href__in': 'csv',
            'pulp_id__in': 'csv',
            'release__in': 'csv',
            'version__in': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if arch is not None:
            
            _query_params.append(('arch', arch))
            
        if arch__contains is not None:
            
            _query_params.append(('arch__contains', arch__contains))
            
        if arch__in is not None:
            
            _query_params.append(('arch__in', arch__in))
            
        if arch__ne is not None:
            
            _query_params.append(('arch__ne', arch__ne))
            
        if arch__startswith is not None:
            
            _query_params.append(('arch__startswith', arch__startswith))
            
        if checksum_type is not None:
            
            _query_params.append(('checksum_type', checksum_type))
            
        if checksum_type__in is not None:
            
            _query_params.append(('checksum_type__in', checksum_type__in))
            
        if checksum_type__ne is not None:
            
            _query_params.append(('checksum_type__ne', checksum_type__ne))
            
        if epoch is not None:
            
            _query_params.append(('epoch', epoch))
            
        if epoch__in is not None:
            
            _query_params.append(('epoch__in', epoch__in))
            
        if epoch__ne is not None:
            
            _query_params.append(('epoch__ne', epoch__ne))
            
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if name__contains is not None:
            
            _query_params.append(('name__contains', name__contains))
            
        if name__in is not None:
            
            _query_params.append(('name__in', name__in))
            
        if name__ne is not None:
            
            _query_params.append(('name__ne', name__ne))
            
        if name__startswith is not None:
            
            _query_params.append(('name__startswith', name__startswith))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if orphaned_for is not None:
            
            _query_params.append(('orphaned_for', orphaned_for))
            
        if pkg_id is not None:
            
            _query_params.append(('pkgId', pkg_id))
            
        if pkg_id__in is not None:
            
            _query_params.append(('pkgId__in', pkg_id__in))
            
        if prn__in is not None:
            
            _query_params.append(('prn__in', prn__in))
            
        if pulp_href__in is not None:
            
            _query_params.append(('pulp_href__in', pulp_href__in))
            
        if pulp_id__in is not None:
            
            _query_params.append(('pulp_id__in', pulp_id__in))
            
        if pulp_label_select is not None:
            
            _query_params.append(('pulp_label_select', pulp_label_select))
            
        if q is not None:
            
            _query_params.append(('q', q))
            
        if release is not None:
            
            _query_params.append(('release', release))
            
        if release__contains is not None:
            
            _query_params.append(('release__contains', release__contains))
            
        if release__in is not None:
            
            _query_params.append(('release__in', release__in))
            
        if release__ne is not None:
            
            _query_params.append(('release__ne', release__ne))
            
        if release__startswith is not None:
            
            _query_params.append(('release__startswith', release__startswith))
            
        if repository_version is not None:
            
            _query_params.append(('repository_version', repository_version))
            
        if repository_version_added is not None:
            
            _query_params.append(('repository_version_added', repository_version_added))
            
        if repository_version_removed is not None:
            
            _query_params.append(('repository_version_removed', repository_version_removed))
            
        if sha256 is not None:
            
            _query_params.append(('sha256', sha256))
            
        if version is not None:
            
            _query_params.append(('version', version))
            
        if version__in is not None:
            
            _query_params.append(('version__in', version__in))
            
        if version__ne is not None:
            
            _query_params.append(('version__ne', version__ne))
            
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/pulp/api/v3/content/rpm/packages/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def read(
        self,
        rpm_package_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RpmPackageResponse:
        """Inspect a package

        A ViewSet for Package.  Define endpoint name which will appear in the API endpoint for this content type. For example::     http://pulp.example.com/pulp/api/v3/content/rpm/packages/  Also specify queryset and serializer for Package.

        :param rpm_package_href: (required)
        :type rpm_package_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            rpm_package_href=rpm_package_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RpmPackageResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def read_with_http_info(
        self,
        rpm_package_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RpmPackageResponse]:
        """Inspect a package

        A ViewSet for Package.  Define endpoint name which will appear in the API endpoint for this content type. For example::     http://pulp.example.com/pulp/api/v3/content/rpm/packages/  Also specify queryset and serializer for Package.

        :param rpm_package_href: (required)
        :type rpm_package_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            rpm_package_href=rpm_package_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RpmPackageResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def read_without_preload_content(
        self,
        rpm_package_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Inspect a package

        A ViewSet for Package.  Define endpoint name which will appear in the API endpoint for this content type. For example::     http://pulp.example.com/pulp/api/v3/content/rpm/packages/  Also specify queryset and serializer for Package.

        :param rpm_package_href: (required)
        :type rpm_package_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            rpm_package_href=rpm_package_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RpmPackageResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_serialize(
        self,
        rpm_package_href,
        x_task_diagnostics,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if rpm_package_href is not None:
            _path_params['rpm_package_href'] = rpm_package_href
        # process the query parameters
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='{rpm_package_href}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def set_label(
        self,
        rpm_package_href: StrictStr,
        set_label: SetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SetLabelResponse:
        """Set a label

        Set a single pulp_label on the object to a specific value or null.

        :param rpm_package_href: (required)
        :type rpm_package_href: str
        :param set_label: (required)
        :type set_label: SetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_label_serialize(
            rpm_package_href=rpm_package_href,
            set_label=set_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def set_label_with_http_info(
        self,
        rpm_package_href: StrictStr,
        set_label: SetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SetLabelResponse]:
        """Set a label

        Set a single pulp_label on the object to a specific value or null.

        :param rpm_package_href: (required)
        :type rpm_package_href: str
        :param set_label: (required)
        :type set_label: SetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_label_serialize(
            rpm_package_href=rpm_package_href,
            set_label=set_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def set_label_without_preload_content(
        self,
        rpm_package_href: StrictStr,
        set_label: SetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Set a label

        Set a single pulp_label on the object to a specific value or null.

        :param rpm_package_href: (required)
        :type rpm_package_href: str
        :param set_label: (required)
        :type set_label: SetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_label_serialize(
            rpm_package_href=rpm_package_href,
            set_label=set_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _set_label_serialize(
        self,
        rpm_package_href,
        set_label,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if rpm_package_href is not None:
            _path_params['rpm_package_href'] = rpm_package_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if set_label is not None:
            _body_params = set_label


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='{rpm_package_href}set_label/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def unset_label(
        self,
        rpm_package_href: StrictStr,
        unset_label: UnsetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UnsetLabelResponse:
        """Unset a label

        Unset a single pulp_label on the object.

        :param rpm_package_href: (required)
        :type rpm_package_href: str
        :param unset_label: (required)
        :type unset_label: UnsetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._unset_label_serialize(
            rpm_package_href=rpm_package_href,
            unset_label=unset_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UnsetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def unset_label_with_http_info(
        self,
        rpm_package_href: StrictStr,
        unset_label: UnsetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UnsetLabelResponse]:
        """Unset a label

        Unset a single pulp_label on the object.

        :param rpm_package_href: (required)
        :type rpm_package_href: str
        :param unset_label: (required)
        :type unset_label: UnsetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._unset_label_serialize(
            rpm_package_href=rpm_package_href,
            unset_label=unset_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UnsetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def unset_label_without_preload_content(
        self,
        rpm_package_href: StrictStr,
        unset_label: UnsetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Unset a label

        Unset a single pulp_label on the object.

        :param rpm_package_href: (required)
        :type rpm_package_href: str
        :param unset_label: (required)
        :type unset_label: UnsetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._unset_label_serialize(
            rpm_package_href=rpm_package_href,
            unset_label=unset_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UnsetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _unset_label_serialize(
        self,
        rpm_package_href,
        unset_label,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if rpm_package_href is not None:
            _path_params['rpm_package_href'] = rpm_package_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if unset_label is not None:
            _body_params = unset_label


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='{rpm_package_href}unset_label/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


