# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from pulpcore.client.pulp_rpm.models.compression_type_enum import CompressionTypeEnum
from pulpcore.client.pulp_rpm.models.layout_enum import LayoutEnum
from pulpcore.client.pulp_rpm.models.package_checksum_type_enum import PackageChecksumTypeEnum
from typing import Optional, Set
from typing_extensions import Self


class OneOf:
    @staticmethod
    def from_dict(obj, *args, **kwargs):
        """Noop override to fix missing OneOf import/implementation."""
        return obj


class PatchedrpmRpmRepository(BaseModel):
    """
    Serializer for Rpm Repositories.
    """ # noqa: E501
    pulp_labels: Optional[Dict[str, Optional[StrictStr]]] = None
    name: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="A unique name for this repository.")
    description: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="An optional description.")
    retain_repo_versions: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=None, description="Retain X versions of the repository. Default is null which retains all versions.")
    remote: Optional[StrictStr] = Field(default=None, description="An optional remote to use by default when syncing.")
    autopublish: Optional[StrictBool] = Field(default=False, description="Whether to automatically create publications for new repository versions, and update any distributions pointing to this repository.")
    metadata_signing_service: Optional[StrictStr] = Field(default=None, description="A reference to an associated signing service.")
    package_signing_service: Optional[StrictStr] = Field(default=None, description="A reference to an associated package signing service.")
    package_signing_fingerprint: Optional[Annotated[str, Field(strict=True, max_length=40)]] = Field(default='', description="The pubkey V4 fingerprint (160 bits) to be passed to the package signing service.The signing service will use that on signing operations related to this repository.")
    retain_package_versions: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="The number of versions of each package to keep in the repository; older versions will be purged. The default is '0', which will disable this feature and keep all versions of each package.")
    checksum_type: Optional[PackageChecksumTypeEnum] = Field(default=None, description="The preferred checksum type during repo publish.  * `unknown` - unknown * `md5` - md5 * `sha1` - sha1 * `sha224` - sha224 * `sha256` - sha256 * `sha384` - sha384 * `sha512` - sha512")
    metadata_checksum_type: Optional[PackageChecksumTypeEnum] = Field(default=None, description="DEPRECATED: use CHECKSUM_TYPE instead.  * `unknown` - unknown * `md5` - md5 * `sha1` - sha1 * `sha224` - sha224 * `sha256` - sha256 * `sha384` - sha384 * `sha512` - sha512")
    package_checksum_type: Optional[PackageChecksumTypeEnum] = Field(default=None, description="DEPRECATED: use CHECKSUM_TYPE instead.  * `unknown` - unknown * `md5` - md5 * `sha1` - sha1 * `sha224` - sha224 * `sha256` - sha256 * `sha384` - sha384 * `sha512` - sha512")
    gpgcheck: Optional[Annotated[int, Field(le=1, strict=True, ge=0)]] = Field(default=None, description="DEPRECATED: An option specifying whether a client should perform a GPG signature check on packages.")
    repo_gpgcheck: Optional[Annotated[int, Field(le=1, strict=True, ge=0)]] = Field(default=None, description="DEPRECATED: An option specifying whether a client should perform a GPG signature check on the repodata.")
    repo_config: Optional[Any] = Field(default=None, description="A JSON document describing config.repo file")
    compression_type: Optional[CompressionTypeEnum] = Field(default=None, description="The compression type to use for metadata files.  * `zstd` - zstd * `gz` - gz")
    layout: Optional[LayoutEnum] = Field(default=None, description="How to layout the packages within the published repository.  * `nested_alphabetically` - nested_alphabetically * `flat` - flat")
    __properties: ClassVar[List[str]] = ["pulp_labels", "name", "description", "retain_repo_versions", "remote", "autopublish", "metadata_signing_service", "package_signing_service", "package_signing_fingerprint", "retain_package_versions", "checksum_type", "metadata_checksum_type", "package_checksum_type", "gpgcheck", "repo_gpgcheck", "repo_config", "compression_type", "layout"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PatchedrpmRpmRepository from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if retain_repo_versions (nullable) is None
        # and model_fields_set contains the field
        if self.retain_repo_versions is None and "retain_repo_versions" in self.model_fields_set:
            _dict['retain_repo_versions'] = None

        # set to None if remote (nullable) is None
        # and model_fields_set contains the field
        if self.remote is None and "remote" in self.model_fields_set:
            _dict['remote'] = None

        # set to None if metadata_signing_service (nullable) is None
        # and model_fields_set contains the field
        if self.metadata_signing_service is None and "metadata_signing_service" in self.model_fields_set:
            _dict['metadata_signing_service'] = None

        # set to None if package_signing_service (nullable) is None
        # and model_fields_set contains the field
        if self.package_signing_service is None and "package_signing_service" in self.model_fields_set:
            _dict['package_signing_service'] = None

        # set to None if checksum_type (nullable) is None
        # and model_fields_set contains the field
        if self.checksum_type is None and "checksum_type" in self.model_fields_set:
            _dict['checksum_type'] = None

        # set to None if metadata_checksum_type (nullable) is None
        # and model_fields_set contains the field
        if self.metadata_checksum_type is None and "metadata_checksum_type" in self.model_fields_set:
            _dict['metadata_checksum_type'] = None

        # set to None if package_checksum_type (nullable) is None
        # and model_fields_set contains the field
        if self.package_checksum_type is None and "package_checksum_type" in self.model_fields_set:
            _dict['package_checksum_type'] = None

        # set to None if gpgcheck (nullable) is None
        # and model_fields_set contains the field
        if self.gpgcheck is None and "gpgcheck" in self.model_fields_set:
            _dict['gpgcheck'] = None

        # set to None if repo_gpgcheck (nullable) is None
        # and model_fields_set contains the field
        if self.repo_gpgcheck is None and "repo_gpgcheck" in self.model_fields_set:
            _dict['repo_gpgcheck'] = None

        # set to None if repo_config (nullable) is None
        # and model_fields_set contains the field
        if self.repo_config is None and "repo_config" in self.model_fields_set:
            _dict['repo_config'] = None

        # set to None if compression_type (nullable) is None
        # and model_fields_set contains the field
        if self.compression_type is None and "compression_type" in self.model_fields_set:
            _dict['compression_type'] = None

        # set to None if layout (nullable) is None
        # and model_fields_set contains the field
        if self.layout is None and "layout" in self.model_fields_set:
            _dict['layout'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PatchedrpmRpmRepository from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pulp_labels": obj.get("pulp_labels"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "retain_repo_versions": obj.get("retain_repo_versions"),
            "remote": obj.get("remote"),
            "autopublish": obj.get("autopublish") if obj.get("autopublish") is not None else False,
            "metadata_signing_service": obj.get("metadata_signing_service"),
            "package_signing_service": obj.get("package_signing_service"),
            "package_signing_fingerprint": obj.get("package_signing_fingerprint") if obj.get("package_signing_fingerprint") is not None else '',
            "retain_package_versions": obj.get("retain_package_versions"),
            "checksum_type": obj.get("checksum_type"),
            "metadata_checksum_type": obj.get("metadata_checksum_type"),
            "package_checksum_type": obj.get("package_checksum_type"),
            "gpgcheck": obj.get("gpgcheck"),
            "repo_gpgcheck": obj.get("repo_gpgcheck"),
            "repo_config": obj.get("repo_config"),
            "compression_type": obj.get("compression_type"),
            "layout": obj.get("layout")
        })
        return _obj


