# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self


class OneOf:
    @staticmethod
    def from_dict(obj, *args, **kwargs):
        """Noop override to fix missing OneOf import/implementation."""
        return obj


class PrunePackages(BaseModel):
    """
    Serializer for prune-old-Packages operation.
    """ # noqa: E501
    repo_hrefs: List[Annotated[str, Field(min_length=1, strict=True)]] = Field(description="Will prune old packages from the specified list of repos. Use ['*'] to specify all repos. Will prune based on the specified repositories' latest_versions.")
    keep_days: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=14, description="Prune packages introduced *prior-to* this many days ago. Default is 14. A value of 0 implies 'keep latest package only.'")
    dry_run: Optional[StrictBool] = Field(default=False, description="Determine what would-be-pruned and log the list of packages. Intended as a debugging aid.")
    __properties: ClassVar[List[str]] = ["repo_hrefs", "keep_days", "dry_run"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrunePackages from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrunePackages from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "repo_hrefs": obj.get("repo_hrefs"),
            "keep_days": obj.get("keep_days") if obj.get("keep_days") is not None else 14,
            "dry_run": obj.get("dry_run") if obj.get("dry_run") is not None else False
        })
        return _obj


