# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from pulpcore.client.pulp_rpm.models.addon_response import AddonResponse
from pulpcore.client.pulp_rpm.models.checksum_response import ChecksumResponse
from pulpcore.client.pulp_rpm.models.image_response import ImageResponse
from pulpcore.client.pulp_rpm.models.variant_response import VariantResponse
from typing import Optional, Set
from typing_extensions import Self


class OneOf:
    @staticmethod
    def from_dict(obj, *args, **kwargs):
        """Noop override to fix missing OneOf import/implementation."""
        return obj


class RpmDistributionTreeResponse(BaseModel):
    """
    DistributionTree serializer.
    """ # noqa: E501
    pulp_href: Optional[StrictStr] = None
    prn: Optional[StrictStr] = Field(default=None, description="The Pulp Resource Name (PRN).")
    header_version: StrictStr = Field(description="Header Version.")
    release_name: StrictStr = Field(description="Release name.")
    release_short: StrictStr = Field(description="Release short name.")
    release_version: StrictStr = Field(description="Release version.")
    release_is_layered: StrictBool = Field(description="Typically False for an operating system, True otherwise.")
    base_product_name: Optional[StrictStr] = Field(description="Base Product name.")
    base_product_short: Optional[StrictStr] = Field(description="Base Product short name.")
    base_product_version: Optional[StrictStr] = Field(description="Base Product version.")
    arch: StrictStr = Field(description="Tree architecturerch.")
    build_timestamp: Union[StrictFloat, StrictInt] = Field(description="Tree build time timestamp.")
    instimage: Optional[StrictStr] = Field(description="Relative path to Anaconda instimage.")
    mainimage: Optional[StrictStr] = Field(description="Relative path to Anaconda stage2 image.")
    discnum: Optional[StrictInt] = Field(description="Disc number.")
    totaldiscs: Optional[StrictInt] = Field(description="Number of discs in media set.")
    addons: List[AddonResponse]
    checksums: List[ChecksumResponse]
    images: List[ImageResponse]
    variants: List[VariantResponse]
    __properties: ClassVar[List[str]] = ["pulp_href", "prn", "header_version", "release_name", "release_short", "release_version", "release_is_layered", "base_product_name", "base_product_short", "base_product_version", "arch", "build_timestamp", "instimage", "mainimage", "discnum", "totaldiscs", "addons", "checksums", "images", "variants"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RpmDistributionTreeResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "pulp_href",
            "prn",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in addons (list)
        _items = []
        if self.addons:
            for _item_addons in self.addons:
                if _item_addons:
                    _items.append(_item_addons.to_dict())
            _dict['addons'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in checksums (list)
        _items = []
        if self.checksums:
            for _item_checksums in self.checksums:
                if _item_checksums:
                    _items.append(_item_checksums.to_dict())
            _dict['checksums'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item_images in self.images:
                if _item_images:
                    _items.append(_item_images.to_dict())
            _dict['images'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in variants (list)
        _items = []
        if self.variants:
            for _item_variants in self.variants:
                if _item_variants:
                    _items.append(_item_variants.to_dict())
            _dict['variants'] = _items
        # set to None if base_product_name (nullable) is None
        # and model_fields_set contains the field
        if self.base_product_name is None and "base_product_name" in self.model_fields_set:
            _dict['base_product_name'] = None

        # set to None if base_product_short (nullable) is None
        # and model_fields_set contains the field
        if self.base_product_short is None and "base_product_short" in self.model_fields_set:
            _dict['base_product_short'] = None

        # set to None if base_product_version (nullable) is None
        # and model_fields_set contains the field
        if self.base_product_version is None and "base_product_version" in self.model_fields_set:
            _dict['base_product_version'] = None

        # set to None if instimage (nullable) is None
        # and model_fields_set contains the field
        if self.instimage is None and "instimage" in self.model_fields_set:
            _dict['instimage'] = None

        # set to None if mainimage (nullable) is None
        # and model_fields_set contains the field
        if self.mainimage is None and "mainimage" in self.model_fields_set:
            _dict['mainimage'] = None

        # set to None if discnum (nullable) is None
        # and model_fields_set contains the field
        if self.discnum is None and "discnum" in self.model_fields_set:
            _dict['discnum'] = None

        # set to None if totaldiscs (nullable) is None
        # and model_fields_set contains the field
        if self.totaldiscs is None and "totaldiscs" in self.model_fields_set:
            _dict['totaldiscs'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RpmDistributionTreeResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pulp_href": obj.get("pulp_href"),
            "prn": obj.get("prn"),
            "header_version": obj.get("header_version"),
            "release_name": obj.get("release_name"),
            "release_short": obj.get("release_short"),
            "release_version": obj.get("release_version"),
            "release_is_layered": obj.get("release_is_layered"),
            "base_product_name": obj.get("base_product_name"),
            "base_product_short": obj.get("base_product_short"),
            "base_product_version": obj.get("base_product_version"),
            "arch": obj.get("arch"),
            "build_timestamp": obj.get("build_timestamp"),
            "instimage": obj.get("instimage"),
            "mainimage": obj.get("mainimage"),
            "discnum": obj.get("discnum"),
            "totaldiscs": obj.get("totaldiscs"),
            "addons": [AddonResponse.from_dict(_item) for _item in obj["addons"]] if obj.get("addons") is not None else None,
            "checksums": [ChecksumResponse.from_dict(_item) for _item in obj["checksums"]] if obj.get("checksums") is not None else None,
            "images": [ImageResponse.from_dict(_item) for _item in obj["images"]] if obj.get("images") is not None else None,
            "variants": [VariantResponse.from_dict(_item) for _item in obj["variants"]] if obj.get("variants") is not None else None
        })
        return _obj


