# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class OneOf:
    @staticmethod
    def from_dict(obj, *args, **kwargs):
        """Noop override to fix missing OneOf import/implementation."""
        return obj


class RpmPackageResponse(BaseModel):
    """
    A Serializer for Package.  Add serializers for the new fields defined in Package and add those fields to the Meta class keeping fields from the parent class as well. Provide help_text.
    """ # noqa: E501
    pulp_href: Optional[StrictStr] = None
    prn: Optional[StrictStr] = Field(default=None, description="The Pulp Resource Name (PRN).")
    pulp_created: Optional[datetime] = Field(default=None, description="Timestamp of creation.")
    pulp_last_updated: Optional[datetime] = Field(default=None, description="Timestamp of the last time this resource was updated. Note: for immutable resources - like content, repository versions, and publication - pulp_created and pulp_last_updated dates will be the same.")
    md5: Optional[StrictStr] = Field(default=None, description="The MD5 checksum if available.")
    sha1: Optional[StrictStr] = Field(default=None, description="The SHA-1 checksum if available.")
    sha224: Optional[StrictStr] = Field(default=None, description="The SHA-224 checksum if available.")
    sha256: Optional[StrictStr] = Field(default=None, description="The SHA-256 checksum if available.")
    sha384: Optional[StrictStr] = Field(default=None, description="The SHA-384 checksum if available.")
    sha512: Optional[StrictStr] = Field(default=None, description="The SHA-512 checksum if available.")
    pulp_labels: Optional[Dict[str, Optional[StrictStr]]] = Field(default=None, description="A dictionary of arbitrary key/value pairs used to describe a specific Content instance.")
    artifact: Optional[StrictStr] = Field(default=None, description="Artifact file representing the physical content")
    name: Optional[StrictStr] = Field(default=None, description="Name of the package")
    epoch: Optional[StrictStr] = Field(default=None, description="The package's epoch")
    version: Optional[StrictStr] = Field(default=None, description="The version of the package. For example, '2.8.0'")
    release: Optional[StrictStr] = Field(default=None, description="The release of a particular version of the package. e.g. '1.el7' or '3.f24'")
    arch: Optional[StrictStr] = Field(default=None, description="The target architecture for a package.For example, 'x86_64', 'i686', or 'noarch'")
    pkg_id: Optional[StrictStr] = Field(default=None, description="Checksum of the package file", alias="pkgId")
    checksum_type: Optional[StrictStr] = Field(default=None, description="Type of checksum, e.g. 'sha256', 'md5'")
    summary: Optional[StrictStr] = Field(default=None, description="Short description of the packaged software")
    description: Optional[StrictStr] = Field(default=None, description="In-depth description of the packaged software")
    url: Optional[StrictStr] = Field(default=None, description="URL with more information about the packaged software")
    changelogs: Optional[Any] = Field(default=None, description="Changelogs that package contains")
    files: Optional[Any] = Field(default=None, description="Files that package contains")
    requires: Optional[Any] = Field(default=None, description="Capabilities the package requires")
    provides: Optional[Any] = Field(default=None, description="Capabilities the package provides")
    conflicts: Optional[Any] = Field(default=None, description="Capabilities the package conflicts")
    obsoletes: Optional[Any] = Field(default=None, description="Capabilities the package obsoletes")
    suggests: Optional[Any] = Field(default=None, description="Capabilities the package suggests")
    enhances: Optional[Any] = Field(default=None, description="Capabilities the package enhances")
    recommends: Optional[Any] = Field(default=None, description="Capabilities the package recommends")
    supplements: Optional[Any] = Field(default=None, description="Capabilities the package supplements")
    location_base: Optional[StrictStr] = Field(default=None, description="Base location of this package")
    location_href: Optional[StrictStr] = Field(default=None, description="Relative location of package to the repodata")
    rpm_buildhost: Optional[StrictStr] = Field(default=None, description="Hostname of the system that built the package")
    rpm_group: Optional[StrictStr] = Field(default=None, description="RPM group (See: http://fedoraproject.org/wiki/RPMGroups)")
    rpm_license: Optional[StrictStr] = Field(default=None, description="License term applicable to the package software (GPLv2, etc.)")
    rpm_packager: Optional[StrictStr] = Field(default=None, description="Person or persons responsible for creating the package")
    rpm_sourcerpm: Optional[StrictStr] = Field(default=None, description="Name of the source package (srpm) the package was built from")
    rpm_vendor: Optional[StrictStr] = Field(default=None, description="Name of the organization that produced the package")
    rpm_header_start: Optional[StrictInt] = Field(default=None, description="First byte of the header")
    rpm_header_end: Optional[StrictInt] = Field(default=None, description="Last byte of the header")
    is_modular: Optional[StrictBool] = Field(default=None, description="Flag to identify if the package is modular")
    size_archive: Optional[StrictInt] = Field(default=None, description="Size, in bytes, of the archive portion of the original package file")
    size_installed: Optional[StrictInt] = Field(default=None, description="Total size, in bytes, of every file installed by this package")
    size_package: Optional[StrictInt] = Field(default=None, description="Size, in bytes, of the package")
    time_build: Optional[StrictInt] = Field(default=None, description="Time the package was built in seconds since the epoch")
    time_file: Optional[StrictInt] = Field(default=None, description="The 'file' time attribute in the primary XML - file mtime in seconds since the epoch.")
    __properties: ClassVar[List[str]] = ["pulp_href", "prn", "pulp_created", "pulp_last_updated", "md5", "sha1", "sha224", "sha256", "sha384", "sha512", "pulp_labels", "artifact", "name", "epoch", "version", "release", "arch", "pkgId", "checksum_type", "summary", "description", "url", "changelogs", "files", "requires", "provides", "conflicts", "obsoletes", "suggests", "enhances", "recommends", "supplements", "location_base", "location_href", "rpm_buildhost", "rpm_group", "rpm_license", "rpm_packager", "rpm_sourcerpm", "rpm_vendor", "rpm_header_start", "rpm_header_end", "is_modular", "size_archive", "size_installed", "size_package", "time_build", "time_file"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RpmPackageResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "pulp_href",
            "prn",
            "pulp_created",
            "pulp_last_updated",
            "md5",
            "sha1",
            "sha224",
            "sha256",
            "sha384",
            "sha512",
            "name",
            "epoch",
            "version",
            "release",
            "arch",
            "pkg_id",
            "checksum_type",
            "summary",
            "description",
            "url",
            "changelogs",
            "files",
            "requires",
            "provides",
            "conflicts",
            "obsoletes",
            "suggests",
            "enhances",
            "recommends",
            "supplements",
            "location_base",
            "location_href",
            "rpm_buildhost",
            "rpm_group",
            "rpm_license",
            "rpm_packager",
            "rpm_sourcerpm",
            "rpm_vendor",
            "rpm_header_start",
            "rpm_header_end",
            "is_modular",
            "size_archive",
            "size_installed",
            "size_package",
            "time_build",
            "time_file",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if changelogs (nullable) is None
        # and model_fields_set contains the field
        if self.changelogs is None and "changelogs" in self.model_fields_set:
            _dict['changelogs'] = None

        # set to None if files (nullable) is None
        # and model_fields_set contains the field
        if self.files is None and "files" in self.model_fields_set:
            _dict['files'] = None

        # set to None if requires (nullable) is None
        # and model_fields_set contains the field
        if self.requires is None and "requires" in self.model_fields_set:
            _dict['requires'] = None

        # set to None if provides (nullable) is None
        # and model_fields_set contains the field
        if self.provides is None and "provides" in self.model_fields_set:
            _dict['provides'] = None

        # set to None if conflicts (nullable) is None
        # and model_fields_set contains the field
        if self.conflicts is None and "conflicts" in self.model_fields_set:
            _dict['conflicts'] = None

        # set to None if obsoletes (nullable) is None
        # and model_fields_set contains the field
        if self.obsoletes is None and "obsoletes" in self.model_fields_set:
            _dict['obsoletes'] = None

        # set to None if suggests (nullable) is None
        # and model_fields_set contains the field
        if self.suggests is None and "suggests" in self.model_fields_set:
            _dict['suggests'] = None

        # set to None if enhances (nullable) is None
        # and model_fields_set contains the field
        if self.enhances is None and "enhances" in self.model_fields_set:
            _dict['enhances'] = None

        # set to None if recommends (nullable) is None
        # and model_fields_set contains the field
        if self.recommends is None and "recommends" in self.model_fields_set:
            _dict['recommends'] = None

        # set to None if supplements (nullable) is None
        # and model_fields_set contains the field
        if self.supplements is None and "supplements" in self.model_fields_set:
            _dict['supplements'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RpmPackageResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pulp_href": obj.get("pulp_href"),
            "prn": obj.get("prn"),
            "pulp_created": obj.get("pulp_created"),
            "pulp_last_updated": obj.get("pulp_last_updated"),
            "md5": obj.get("md5"),
            "sha1": obj.get("sha1"),
            "sha224": obj.get("sha224"),
            "sha256": obj.get("sha256"),
            "sha384": obj.get("sha384"),
            "sha512": obj.get("sha512"),
            "pulp_labels": obj.get("pulp_labels"),
            "artifact": obj.get("artifact"),
            "name": obj.get("name"),
            "epoch": obj.get("epoch"),
            "version": obj.get("version"),
            "release": obj.get("release"),
            "arch": obj.get("arch"),
            "pkgId": obj.get("pkgId"),
            "checksum_type": obj.get("checksum_type"),
            "summary": obj.get("summary"),
            "description": obj.get("description"),
            "url": obj.get("url"),
            "changelogs": obj.get("changelogs"),
            "files": obj.get("files"),
            "requires": obj.get("requires"),
            "provides": obj.get("provides"),
            "conflicts": obj.get("conflicts"),
            "obsoletes": obj.get("obsoletes"),
            "suggests": obj.get("suggests"),
            "enhances": obj.get("enhances"),
            "recommends": obj.get("recommends"),
            "supplements": obj.get("supplements"),
            "location_base": obj.get("location_base"),
            "location_href": obj.get("location_href"),
            "rpm_buildhost": obj.get("rpm_buildhost"),
            "rpm_group": obj.get("rpm_group"),
            "rpm_license": obj.get("rpm_license"),
            "rpm_packager": obj.get("rpm_packager"),
            "rpm_sourcerpm": obj.get("rpm_sourcerpm"),
            "rpm_vendor": obj.get("rpm_vendor"),
            "rpm_header_start": obj.get("rpm_header_start"),
            "rpm_header_end": obj.get("rpm_header_end"),
            "is_modular": obj.get("is_modular"),
            "size_archive": obj.get("size_archive"),
            "size_installed": obj.get("size_installed"),
            "size_package": obj.get("size_package"),
            "time_build": obj.get("time_build"),
            "time_file": obj.get("time_file")
        })
        return _obj


