# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from pulpcore.client.pulp_rpm.models.skip_types_enum import SkipTypesEnum
from pulpcore.client.pulp_rpm.models.sync_policy_enum import SyncPolicyEnum
from typing import Optional, Set
from typing_extensions import Self


class OneOf:
    @staticmethod
    def from_dict(obj, *args, **kwargs):
        """Noop override to fix missing OneOf import/implementation."""
        return obj


class RpmRepositorySyncURL(BaseModel):
    """
    Serializer for RPM Sync.
    """ # noqa: E501
    remote: Optional[StrictStr] = Field(default=None, description="A remote to sync from. This will override a remote set on repository.")
    mirror: Optional[StrictBool] = Field(default=None, description="DEPRECATED: If ``True``, ``sync_policy`` will default to 'mirror_complete' instead of 'additive'.")
    sync_policy: Optional[SyncPolicyEnum] = Field(default=None, description="Options: 'additive', 'mirror_complete', 'mirror_content_only'. Default: 'additive'. Modifies how the sync is performed. 'mirror_complete' will clone the original metadata and create an automatic publication from it, but comes with some limitations and does not work for certain repositories. 'mirror_content_only' will change the repository contents to match the remote but the metadata will be regenerated and will not be bit-for-bit identical. 'additive' will retain the existing contents of the repository and add the contents of the repository being synced.  * `additive` - additive * `mirror_complete` - mirror_complete * `mirror_content_only` - mirror_content_only")
    skip_types: Optional[List[SkipTypesEnum]] = Field(default=None, description="List of content types to skip during sync.")
    optimize: Optional[StrictBool] = Field(default=True, description="Whether or not to optimize sync.")
    __properties: ClassVar[List[str]] = ["remote", "mirror", "sync_policy", "skip_types", "optimize"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RpmRepositorySyncURL from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if mirror (nullable) is None
        # and model_fields_set contains the field
        if self.mirror is None and "mirror" in self.model_fields_set:
            _dict['mirror'] = None

        # set to None if sync_policy (nullable) is None
        # and model_fields_set contains the field
        if self.sync_policy is None and "sync_policy" in self.model_fields_set:
            _dict['sync_policy'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RpmRepositorySyncURL from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "remote": obj.get("remote"),
            "mirror": obj.get("mirror"),
            "sync_policy": obj.get("sync_policy"),
            "skip_types": obj.get("skip_types"),
            "optimize": obj.get("optimize") if obj.get("optimize") is not None else True
        })
        return _obj


