# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from pulpcore.client.pulp_rpm.models.rpm_update_collection_response import RpmUpdateCollectionResponse
from typing import Optional, Set
from typing_extensions import Self


class OneOf:
    @staticmethod
    def from_dict(obj, *args, **kwargs):
        """Noop override to fix missing OneOf import/implementation."""
        return obj


class RpmUpdateRecordResponse(BaseModel):
    """
    A Serializer for UpdateRecord.
    """ # noqa: E501
    pulp_href: Optional[StrictStr] = None
    prn: Optional[StrictStr] = Field(default=None, description="The Pulp Resource Name (PRN).")
    pulp_created: Optional[datetime] = Field(default=None, description="Timestamp of creation.")
    pulp_last_updated: Optional[datetime] = Field(default=None, description="Timestamp of the last time this resource was updated. Note: for immutable resources - like content, repository versions, and publication - pulp_created and pulp_last_updated dates will be the same.")
    pulp_labels: Optional[Dict[str, Optional[StrictStr]]] = Field(default=None, description="A dictionary of arbitrary key/value pairs used to describe a specific Content instance.")
    id: Optional[StrictStr] = Field(default=None, description="Update id (short update name, e.g. RHEA-2013:1777)")
    updated_date: Optional[StrictStr] = Field(default=None, description="Date when the update was updated (e.g. '2013-12-02 00:00:00')")
    description: Optional[StrictStr] = Field(default=None, description="Update description")
    issued_date: Optional[StrictStr] = Field(default=None, description="Date when the update was issued (e.g. '2013-12-02 00:00:00')")
    fromstr: Optional[StrictStr] = Field(default=None, description="Source of the update (e.g. security@redhat.com)")
    status: Optional[StrictStr] = Field(default=None, description="Update status ('final', ...)")
    title: Optional[StrictStr] = Field(default=None, description="Update name")
    summary: Optional[StrictStr] = Field(default=None, description="Short summary")
    version: Optional[StrictStr] = Field(default=None, description="Update version (probably always an integer number)")
    type: Optional[StrictStr] = Field(default=None, description="Update type ('enhancement', 'bugfix', ...)")
    severity: Optional[StrictStr] = Field(default=None, description="Severity")
    solution: Optional[StrictStr] = Field(default=None, description="Solution")
    release: Optional[StrictStr] = Field(default=None, description="Update release")
    rights: Optional[StrictStr] = Field(default=None, description="Copyrights")
    pushcount: Optional[StrictStr] = Field(default=None, description="Push count")
    pkglist: Optional[List[RpmUpdateCollectionResponse]] = Field(default=None, description="List of packages")
    references: Optional[List[Dict[str, Any]]] = Field(default=None, description="List of references")
    reboot_suggested: Optional[StrictBool] = Field(default=None, description="Reboot suggested")
    __properties: ClassVar[List[str]] = ["pulp_href", "prn", "pulp_created", "pulp_last_updated", "pulp_labels", "id", "updated_date", "description", "issued_date", "fromstr", "status", "title", "summary", "version", "type", "severity", "solution", "release", "rights", "pushcount", "pkglist", "references", "reboot_suggested"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RpmUpdateRecordResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "pulp_href",
            "prn",
            "pulp_created",
            "pulp_last_updated",
            "id",
            "updated_date",
            "description",
            "issued_date",
            "fromstr",
            "status",
            "title",
            "summary",
            "version",
            "type",
            "severity",
            "solution",
            "release",
            "rights",
            "pushcount",
            "pkglist",
            "references",
            "reboot_suggested",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in pkglist (list)
        _items = []
        if self.pkglist:
            for _item_pkglist in self.pkglist:
                if _item_pkglist:
                    _items.append(_item_pkglist.to_dict())
            _dict['pkglist'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RpmUpdateRecordResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pulp_href": obj.get("pulp_href"),
            "prn": obj.get("prn"),
            "pulp_created": obj.get("pulp_created"),
            "pulp_last_updated": obj.get("pulp_last_updated"),
            "pulp_labels": obj.get("pulp_labels"),
            "id": obj.get("id"),
            "updated_date": obj.get("updated_date"),
            "description": obj.get("description"),
            "issued_date": obj.get("issued_date"),
            "fromstr": obj.get("fromstr"),
            "status": obj.get("status"),
            "title": obj.get("title"),
            "summary": obj.get("summary"),
            "version": obj.get("version"),
            "type": obj.get("type"),
            "severity": obj.get("severity"),
            "solution": obj.get("solution"),
            "release": obj.get("release"),
            "rights": obj.get("rights"),
            "pushcount": obj.get("pushcount"),
            "pkglist": [RpmUpdateCollectionResponse.from_dict(_item) for _item in obj["pkglist"]] if obj.get("pkglist") is not None else None,
            "references": obj.get("references"),
            "reboot_suggested": obj.get("reboot_suggested")
        })
        return _obj


