# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class OneOf:
    @staticmethod
    def from_dict(obj, *args, **kwargs):
        """Noop override to fix missing OneOf import/implementation."""
        return obj


class VariantResponse(BaseModel):
    """
    Variant serializer.
    """ # noqa: E501
    variant_id: StrictStr = Field(description="Variant id.")
    uid: StrictStr = Field(description="Variant uid.")
    name: StrictStr = Field(description="Variant name.")
    type: StrictStr = Field(description="Variant type.")
    packages: StrictStr = Field(description="Relative path to directory with binary RPMs.")
    source_packages: Optional[StrictStr] = Field(description="Relative path to directory with source RPMs.")
    source_repository: Optional[StrictStr] = Field(description="Relative path to YUM repository with source RPMs.")
    debug_packages: Optional[StrictStr] = Field(description="Relative path to directory with debug RPMs.")
    debug_repository: Optional[StrictStr] = Field(description="Relative path to YUM repository with debug RPMs.")
    identity: Optional[StrictStr] = Field(description="Relative path to a pem file that identifies a product.")
    __properties: ClassVar[List[str]] = ["variant_id", "uid", "name", "type", "packages", "source_packages", "source_repository", "debug_packages", "debug_repository", "identity"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VariantResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if source_packages (nullable) is None
        # and model_fields_set contains the field
        if self.source_packages is None and "source_packages" in self.model_fields_set:
            _dict['source_packages'] = None

        # set to None if source_repository (nullable) is None
        # and model_fields_set contains the field
        if self.source_repository is None and "source_repository" in self.model_fields_set:
            _dict['source_repository'] = None

        # set to None if debug_packages (nullable) is None
        # and model_fields_set contains the field
        if self.debug_packages is None and "debug_packages" in self.model_fields_set:
            _dict['debug_packages'] = None

        # set to None if debug_repository (nullable) is None
        # and model_fields_set contains the field
        if self.debug_repository is None and "debug_repository" in self.model_fields_set:
            _dict['debug_repository'] = None

        # set to None if identity (nullable) is None
        # and model_fields_set contains the field
        if self.identity is None and "identity" in self.model_fields_set:
            _dict['identity'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VariantResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "variant_id": obj.get("variant_id"),
            "uid": obj.get("uid"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "packages": obj.get("packages"),
            "source_packages": obj.get("source_packages"),
            "source_repository": obj.get("source_repository"),
            "debug_packages": obj.get("debug_packages"),
            "debug_repository": obj.get("debug_repository"),
            "identity": obj.get("identity")
        })
        return _obj


