# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-eks. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = [
    'FargateProfileArgs',
    'KubeconfigOptionsArgs',
    'RoleMappingArgs',
    'UserMappingArgs',
    'VpcCniOptionsArgs',
]

@pulumi.input_type
class FargateProfileArgs:
    def __init__(__self__, *,
                 pod_execution_role_arn: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Defines how Kubernetes pods are executed in Fargate. See aws.eks.FargateProfileArgs for reference.
        :param pulumi.Input[str] pod_execution_role_arn: Specify a custom role to use for executing pods in Fargate. Defaults to creating a new role with the `arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy` policy attached.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: Specify the subnets in which to execute Fargate tasks for pods. Defaults to the private subnets associated with the cluster.
        """
        if pod_execution_role_arn is not None:
            pulumi.set(__self__, "pod_execution_role_arn", pod_execution_role_arn)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="podExecutionRoleArn")
    def pod_execution_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a custom role to use for executing pods in Fargate. Defaults to creating a new role with the `arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy` policy attached.
        """
        return pulumi.get(self, "pod_execution_role_arn")

    @pod_execution_role_arn.setter
    def pod_execution_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_execution_role_arn", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specify the subnets in which to execute Fargate tasks for pods. Defaults to the private subnets associated with the cluster.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)


@pulumi.input_type
class KubeconfigOptionsArgs:
    def __init__(__self__, *,
                 profile_name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None):
        """
        Represents the AWS credentials to scope a given kubeconfig when using a non-default credential chain.

        The options can be used independently, or additively.

        A scoped kubeconfig is necessary for certain auth scenarios. For example:
          1. Assume a role on the default account caller,
          2. Use an AWS creds profile instead of the default account caller,
          3. Use an AWS creds creds profile instead of the default account caller,
             and then assume a given role on the profile. This scenario is also
             possible by only using a profile, iff the profile includes a role to
             assume in its settings.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html
        - https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-role.html
        - https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html
        :param pulumi.Input[str] profile_name: AWS credential profile name to always use instead of the default AWS credential provider chain.
               
               The profile is passed to kubeconfig as an authentication environment setting.
        :param pulumi.Input[str] role_arn: Role ARN to assume instead of the default AWS credential provider chain.
               
               The role is passed to kubeconfig as an authentication exec argument.
        """
        if profile_name is not None:
            pulumi.set(__self__, "profile_name", profile_name)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[pulumi.Input[str]]:
        """
        AWS credential profile name to always use instead of the default AWS credential provider chain.

        The profile is passed to kubeconfig as an authentication environment setting.
        """
        return pulumi.get(self, "profile_name")

    @profile_name.setter
    def profile_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Role ARN to assume instead of the default AWS credential provider chain.

        The role is passed to kubeconfig as an authentication exec argument.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)


@pulumi.input_type
class RoleMappingArgs:
    def __init__(__self__, *,
                 groups: pulumi.Input[Sequence[pulumi.Input[str]]],
                 role_arn: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        Describes a mapping from an AWS IAM role to a Kubernetes user and groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: A list of groups within Kubernetes to which the role is mapped.
        :param pulumi.Input[str] role_arn: The ARN of the IAM role to add.
        :param pulumi.Input[str] username: The user name within Kubernetes to map to the IAM role. By default, the user name is the ARN of the IAM role.
        """
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of groups within Kubernetes to which the role is mapped.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM role to add.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The user name within Kubernetes to map to the IAM role. By default, the user name is the ARN of the IAM role.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class UserMappingArgs:
    def __init__(__self__, *,
                 groups: pulumi.Input[Sequence[pulumi.Input[str]]],
                 user_arn: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        Describes a mapping from an AWS IAM user to a Kubernetes user and groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: A list of groups within Kubernetes to which the user is mapped to.
        :param pulumi.Input[str] user_arn: The ARN of the IAM user to add.
        :param pulumi.Input[str] username: The user name within Kubernetes to map to the IAM user. By default, the user name is the ARN of the IAM user.
        """
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "user_arn", user_arn)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of groups within Kubernetes to which the user is mapped to.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="userArn")
    def user_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM user to add.
        """
        return pulumi.get(self, "user_arn")

    @user_arn.setter
    def user_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_arn", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The user name within Kubernetes to map to the IAM user. By default, the user name is the ARN of the IAM user.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class VpcCniOptionsArgs:
    def __init__(__self__, *,
                 custom_network_config: Optional[pulumi.Input[bool]] = None,
                 eni_config_label_def: Optional[pulumi.Input[str]] = None,
                 eni_mtu: Optional[pulumi.Input[int]] = None,
                 external_snat: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 log_file: Optional[pulumi.Input[str]] = None,
                 log_level: Optional[pulumi.Input[str]] = None,
                 node_port_support: Optional[pulumi.Input[bool]] = None,
                 veth_prefix: Optional[pulumi.Input[str]] = None,
                 warm_eni_target: Optional[pulumi.Input[int]] = None,
                 warm_ip_target: Optional[pulumi.Input[int]] = None):
        """
        Describes the configuration options available for the Amazon VPC CNI plugin for Kubernetes.
        :param pulumi.Input[bool] custom_network_config: Specifies that your pods may use subnets and security groups (within the same VPC as your control plane resources) that are independent of your cluster's `resourcesVpcConfig`.
               
               Defaults to false.
        :param pulumi.Input[str] eni_config_label_def: Specifies the ENI_CONFIG_LABEL_DEF environment variable value for worker nodes. This is used to tell Kubernetes to automatically apply the ENIConfig for each Availability Zone
               Ref: https://docs.aws.amazon.com/eks/latest/userguide/cni-custom-network.html (step 5(c))
               
               Defaults to the official AWS CNI image in ECR.
        :param pulumi.Input[int] eni_mtu: Used to configure the MTU size for attached ENIs. The valid range is from 576 to 9001.
               
               Defaults to 9001.
        :param pulumi.Input[bool] external_snat: Specifies whether an external NAT gateway should be used to provide SNAT of secondary ENI IP addresses. If set to true, the SNAT iptables rule and off-VPC IP rule are not applied, and these rules are removed if they have already been applied.
               
               Defaults to false.
        :param pulumi.Input[str] image: Specifies the container image to use in the AWS CNI cluster DaemonSet.
               
               Defaults to the official AWS CNI image in ECR.
        :param pulumi.Input[str] log_file: Specifies the file path used for logs.
               
               Defaults to "stdout" to emit Pod logs for `kubectl logs`.
        :param pulumi.Input[str] log_level: Specifies the log level used for logs.
               
               Defaults to "DEBUG"
               See more options: https://git.io/fj92K
        :param pulumi.Input[bool] node_port_support: Specifies whether NodePort services are enabled on a worker node's primary network interface. This requires additional iptables rules and that the kernel's reverse path filter on the primary interface is set to loose.
               
               Defaults to true.
        :param pulumi.Input[str] veth_prefix: Specifies the veth prefix used to generate the host-side veth device name for the CNI.
               
               The prefix can be at most 4 characters long.
               
               Defaults to "eni".
        :param pulumi.Input[int] warm_eni_target: Specifies the number of free elastic network interfaces (and all of their available IP addresses) that the ipamD daemon should attempt to keep available for pod assignment on the node.
               
               Defaults to 1.
        :param pulumi.Input[int] warm_ip_target: Specifies the number of free IP addresses that the ipamD daemon should attempt to keep available for pod assignment on the node.
        """
        if custom_network_config is not None:
            pulumi.set(__self__, "custom_network_config", custom_network_config)
        if eni_config_label_def is not None:
            pulumi.set(__self__, "eni_config_label_def", eni_config_label_def)
        if eni_mtu is not None:
            pulumi.set(__self__, "eni_mtu", eni_mtu)
        if external_snat is not None:
            pulumi.set(__self__, "external_snat", external_snat)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if log_file is not None:
            pulumi.set(__self__, "log_file", log_file)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if node_port_support is not None:
            pulumi.set(__self__, "node_port_support", node_port_support)
        if veth_prefix is not None:
            pulumi.set(__self__, "veth_prefix", veth_prefix)
        if warm_eni_target is not None:
            pulumi.set(__self__, "warm_eni_target", warm_eni_target)
        if warm_ip_target is not None:
            pulumi.set(__self__, "warm_ip_target", warm_ip_target)

    @property
    @pulumi.getter(name="customNetworkConfig")
    def custom_network_config(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies that your pods may use subnets and security groups (within the same VPC as your control plane resources) that are independent of your cluster's `resourcesVpcConfig`.

        Defaults to false.
        """
        return pulumi.get(self, "custom_network_config")

    @custom_network_config.setter
    def custom_network_config(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_network_config", value)

    @property
    @pulumi.getter(name="eniConfigLabelDef")
    def eni_config_label_def(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ENI_CONFIG_LABEL_DEF environment variable value for worker nodes. This is used to tell Kubernetes to automatically apply the ENIConfig for each Availability Zone
        Ref: https://docs.aws.amazon.com/eks/latest/userguide/cni-custom-network.html (step 5(c))

        Defaults to the official AWS CNI image in ECR.
        """
        return pulumi.get(self, "eni_config_label_def")

    @eni_config_label_def.setter
    def eni_config_label_def(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eni_config_label_def", value)

    @property
    @pulumi.getter(name="eniMtu")
    def eni_mtu(self) -> Optional[pulumi.Input[int]]:
        """
        Used to configure the MTU size for attached ENIs. The valid range is from 576 to 9001.

        Defaults to 9001.
        """
        return pulumi.get(self, "eni_mtu")

    @eni_mtu.setter
    def eni_mtu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eni_mtu", value)

    @property
    @pulumi.getter(name="externalSnat")
    def external_snat(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether an external NAT gateway should be used to provide SNAT of secondary ENI IP addresses. If set to true, the SNAT iptables rule and off-VPC IP rule are not applied, and these rules are removed if they have already been applied.

        Defaults to false.
        """
        return pulumi.get(self, "external_snat")

    @external_snat.setter
    def external_snat(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "external_snat", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the container image to use in the AWS CNI cluster DaemonSet.

        Defaults to the official AWS CNI image in ECR.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="logFile")
    def log_file(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the file path used for logs.

        Defaults to "stdout" to emit Pod logs for `kubectl logs`.
        """
        return pulumi.get(self, "log_file")

    @log_file.setter
    def log_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_file", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the log level used for logs.

        Defaults to "DEBUG"
        See more options: https://git.io/fj92K
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_level", value)

    @property
    @pulumi.getter(name="nodePortSupport")
    def node_port_support(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether NodePort services are enabled on a worker node's primary network interface. This requires additional iptables rules and that the kernel's reverse path filter on the primary interface is set to loose.

        Defaults to true.
        """
        return pulumi.get(self, "node_port_support")

    @node_port_support.setter
    def node_port_support(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "node_port_support", value)

    @property
    @pulumi.getter(name="vethPrefix")
    def veth_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the veth prefix used to generate the host-side veth device name for the CNI.

        The prefix can be at most 4 characters long.

        Defaults to "eni".
        """
        return pulumi.get(self, "veth_prefix")

    @veth_prefix.setter
    def veth_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "veth_prefix", value)

    @property
    @pulumi.getter(name="warmEniTarget")
    def warm_eni_target(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of free elastic network interfaces (and all of their available IP addresses) that the ipamD daemon should attempt to keep available for pod assignment on the node.

        Defaults to 1.
        """
        return pulumi.get(self, "warm_eni_target")

    @warm_eni_target.setter
    def warm_eni_target(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "warm_eni_target", value)

    @property
    @pulumi.getter(name="warmIpTarget")
    def warm_ip_target(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of free IP addresses that the ipamD daemon should attempt to keep available for pod assignment on the node.
        """
        return pulumi.get(self, "warm_ip_target")

    @warm_ip_target.setter
    def warm_ip_target(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "warm_ip_target", value)


