# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecretBackendStaticRoleArgs', 'SecretBackendStaticRole']

@pulumi.input_type
class SecretBackendStaticRoleArgs:
    def __init__(__self__, *,
                 rotation_period: pulumi.Input[int],
                 username: pulumi.Input[str],
                 backend: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecretBackendStaticRole resource.
        :param pulumi.Input[int] rotation_period: How often Vault should rotate the password of the user entry.
        :param pulumi.Input[str] username: The username of the existing AWS IAM to manage password rotation for.
        :param pulumi.Input[str] backend: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `aws`
        :param pulumi.Input[str] name: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        """
        pulumi.set(__self__, "rotation_period", rotation_period)
        pulumi.set(__self__, "username", username)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> pulumi.Input[int]:
        """
        How often Vault should rotate the password of the user entry.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: pulumi.Input[int]):
        pulumi.set(self, "rotation_period", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The username of the existing AWS IAM to manage password rotation for.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `aws`
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name to identify this role within the backend.
        Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class _SecretBackendStaticRoleState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 rotation_period: Optional[pulumi.Input[int]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecretBackendStaticRole resources.
        :param pulumi.Input[str] backend: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `aws`
        :param pulumi.Input[str] name: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[int] rotation_period: How often Vault should rotate the password of the user entry.
        :param pulumi.Input[str] username: The username of the existing AWS IAM to manage password rotation for.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `aws`
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name to identify this role within the backend.
        Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[int]]:
        """
        How often Vault should rotate the password of the user entry.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rotation_period", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the existing AWS IAM to manage password rotation for.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class SecretBackendStaticRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 rotation_period: Optional[pulumi.Input[int]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        aws = vault.aws.SecretBackend("aws",
            path="my-aws",
            description="Obtain AWS credentials.")
        role = vault.aws.SecretBackendStaticRole("role",
            backend=aws.path,
            name="test",
            username="my-test-user",
            rotation_period=3600)
        ```

        ## Import

        AWS secret backend static role can be imported using the full path to the role
        of the form: `<mount_path>/static-roles/<role_name>` e.g.

        ```sh
        $ pulumi import vault:aws/secretBackendStaticRole:SecretBackendStaticRole role aws/static-roles/example-role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `aws`
        :param pulumi.Input[str] name: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[int] rotation_period: How often Vault should rotate the password of the user entry.
        :param pulumi.Input[str] username: The username of the existing AWS IAM to manage password rotation for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendStaticRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        aws = vault.aws.SecretBackend("aws",
            path="my-aws",
            description="Obtain AWS credentials.")
        role = vault.aws.SecretBackendStaticRole("role",
            backend=aws.path,
            name="test",
            username="my-test-user",
            rotation_period=3600)
        ```

        ## Import

        AWS secret backend static role can be imported using the full path to the role
        of the form: `<mount_path>/static-roles/<role_name>` e.g.

        ```sh
        $ pulumi import vault:aws/secretBackendStaticRole:SecretBackendStaticRole role aws/static-roles/example-role
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendStaticRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendStaticRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 rotation_period: Optional[pulumi.Input[int]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendStaticRoleArgs.__new__(SecretBackendStaticRoleArgs)

            __props__.__dict__["backend"] = backend
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            if rotation_period is None and not opts.urn:
                raise TypeError("Missing required property 'rotation_period'")
            __props__.__dict__["rotation_period"] = rotation_period
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        super(SecretBackendStaticRole, __self__).__init__(
            'vault:aws/secretBackendStaticRole:SecretBackendStaticRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            rotation_period: Optional[pulumi.Input[int]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'SecretBackendStaticRole':
        """
        Get an existing SecretBackendStaticRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `aws`
        :param pulumi.Input[str] name: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[int] rotation_period: How often Vault should rotate the password of the user entry.
        :param pulumi.Input[str] username: The username of the existing AWS IAM to manage password rotation for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendStaticRoleState.__new__(_SecretBackendStaticRoleState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["rotation_period"] = rotation_period
        __props__.__dict__["username"] = username
        return SecretBackendStaticRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `aws`
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name to identify this role within the backend.
        Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> pulumi.Output[int]:
        """
        How often Vault should rotate the password of the user entry.
        """
        return pulumi.get(self, "rotation_period")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The username of the existing AWS IAM to manage password rotation for.
        """
        return pulumi.get(self, "username")

