# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AuthBackendConfigArgs', 'AuthBackendConfig']

@pulumi.input_type
class AuthBackendConfigArgs:
    def __init__(__self__, *,
                 resource: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 backend: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AuthBackendConfig resource.
        :param pulumi.Input[str] resource: The configured URL for the application registered in
               Azure Active Directory.
        :param pulumi.Input[str] tenant_id: The tenant id for the Azure Active Directory
               organization.
        :param pulumi.Input[str] backend: The path the Azure auth backend being configured was
               mounted at.  Defaults to `azure`.
        :param pulumi.Input[str] client_id: The client id for credentials to query the Azure APIs.
               Currently read permissions to query compute resources are required.
        :param pulumi.Input[str] client_secret: The client secret for credentials to query the
               Azure APIs.
        :param pulumi.Input[str] environment: The Azure cloud environment. Valid values:
               AzurePublicCloud, AzureUSGovernmentCloud, AzureChinaCloud,
               AzureGermanCloud.  Defaults to `AzurePublicCloud`.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        """
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def resource(self) -> pulumi.Input[str]:
        """
        The configured URL for the application registered in
        Azure Active Directory.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The tenant id for the Azure Active Directory
        organization.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        The path the Azure auth backend being configured was
        mounted at.  Defaults to `azure`.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client id for credentials to query the Azure APIs.
        Currently read permissions to query compute resources are required.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The client secret for credentials to query the
        Azure APIs.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure cloud environment. Valid values:
        AzurePublicCloud, AzureUSGovernmentCloud, AzureChinaCloud,
        AzureGermanCloud.  Defaults to `AzurePublicCloud`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class _AuthBackendConfigState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 resource: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AuthBackendConfig resources.
        :param pulumi.Input[str] backend: The path the Azure auth backend being configured was
               mounted at.  Defaults to `azure`.
        :param pulumi.Input[str] client_id: The client id for credentials to query the Azure APIs.
               Currently read permissions to query compute resources are required.
        :param pulumi.Input[str] client_secret: The client secret for credentials to query the
               Azure APIs.
        :param pulumi.Input[str] environment: The Azure cloud environment. Valid values:
               AzurePublicCloud, AzureUSGovernmentCloud, AzureChinaCloud,
               AzureGermanCloud.  Defaults to `AzurePublicCloud`.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] resource: The configured URL for the application registered in
               Azure Active Directory.
        :param pulumi.Input[str] tenant_id: The tenant id for the Azure Active Directory
               organization.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        The path the Azure auth backend being configured was
        mounted at.  Defaults to `azure`.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client id for credentials to query the Azure APIs.
        Currently read permissions to query compute resources are required.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The client secret for credentials to query the
        Azure APIs.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure cloud environment. Valid values:
        AzurePublicCloud, AzureUSGovernmentCloud, AzureChinaCloud,
        AzureGermanCloud.  Defaults to `AzurePublicCloud`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input[str]]:
        """
        The configured URL for the application registered in
        Azure Active Directory.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The tenant id for the Azure Active Directory
        organization.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class AuthBackendConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 resource: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.AuthBackend("example", type="azure")
        example_auth_backend_config = vault.azure.AuthBackendConfig("example",
            backend=example.path,
            tenant_id="11111111-2222-3333-4444-555555555555",
            client_id="11111111-2222-3333-4444-555555555555",
            client_secret="01234567890123456789",
            resource="https://vault.hashicorp.com")
        ```

        ## Import

        Azure auth backends can be imported using `auth/`, the `backend` path, and `/config` e.g.

        ```sh
        $ pulumi import vault:azure/authBackendConfig:AuthBackendConfig example auth/azure/config
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The path the Azure auth backend being configured was
               mounted at.  Defaults to `azure`.
        :param pulumi.Input[str] client_id: The client id for credentials to query the Azure APIs.
               Currently read permissions to query compute resources are required.
        :param pulumi.Input[str] client_secret: The client secret for credentials to query the
               Azure APIs.
        :param pulumi.Input[str] environment: The Azure cloud environment. Valid values:
               AzurePublicCloud, AzureUSGovernmentCloud, AzureChinaCloud,
               AzureGermanCloud.  Defaults to `AzurePublicCloud`.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] resource: The configured URL for the application registered in
               Azure Active Directory.
        :param pulumi.Input[str] tenant_id: The tenant id for the Azure Active Directory
               organization.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthBackendConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.AuthBackend("example", type="azure")
        example_auth_backend_config = vault.azure.AuthBackendConfig("example",
            backend=example.path,
            tenant_id="11111111-2222-3333-4444-555555555555",
            client_id="11111111-2222-3333-4444-555555555555",
            client_secret="01234567890123456789",
            resource="https://vault.hashicorp.com")
        ```

        ## Import

        Azure auth backends can be imported using `auth/`, the `backend` path, and `/config` e.g.

        ```sh
        $ pulumi import vault:azure/authBackendConfig:AuthBackendConfig example auth/azure/config
        ```

        :param str resource_name: The name of the resource.
        :param AuthBackendConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 resource: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthBackendConfigArgs.__new__(AuthBackendConfigArgs)

            __props__.__dict__["backend"] = backend
            __props__.__dict__["client_id"] = None if client_id is None else pulumi.Output.secret(client_id)
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["environment"] = environment
            __props__.__dict__["namespace"] = namespace
            if resource is None and not opts.urn:
                raise TypeError("Missing required property 'resource'")
            __props__.__dict__["resource"] = resource
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = None if tenant_id is None else pulumi.Output.secret(tenant_id)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientId", "clientSecret", "tenantId"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AuthBackendConfig, __self__).__init__(
            'vault:azure/authBackendConfig:AuthBackendConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[str]] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            client_secret: Optional[pulumi.Input[str]] = None,
            environment: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            resource: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'AuthBackendConfig':
        """
        Get an existing AuthBackendConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The path the Azure auth backend being configured was
               mounted at.  Defaults to `azure`.
        :param pulumi.Input[str] client_id: The client id for credentials to query the Azure APIs.
               Currently read permissions to query compute resources are required.
        :param pulumi.Input[str] client_secret: The client secret for credentials to query the
               Azure APIs.
        :param pulumi.Input[str] environment: The Azure cloud environment. Valid values:
               AzurePublicCloud, AzureUSGovernmentCloud, AzureChinaCloud,
               AzureGermanCloud.  Defaults to `AzurePublicCloud`.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] resource: The configured URL for the application registered in
               Azure Active Directory.
        :param pulumi.Input[str] tenant_id: The tenant id for the Azure Active Directory
               organization.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthBackendConfigState.__new__(_AuthBackendConfigState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["environment"] = environment
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["resource"] = resource
        __props__.__dict__["tenant_id"] = tenant_id
        return AuthBackendConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[str]]:
        """
        The path the Azure auth backend being configured was
        mounted at.  Defaults to `azure`.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[str]]:
        """
        The client id for credentials to query the Azure APIs.
        Currently read permissions to query compute resources are required.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[str]]:
        """
        The client secret for credentials to query the
        Azure APIs.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional[str]]:
        """
        The Azure cloud environment. Valid values:
        AzurePublicCloud, AzureUSGovernmentCloud, AzureChinaCloud,
        AzureGermanCloud.  Defaults to `AzurePublicCloud`.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def resource(self) -> pulumi.Output[str]:
        """
        The configured URL for the application registered in
        Azure Active Directory.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The tenant id for the Azure Active Directory
        organization.
        """
        return pulumi.get(self, "tenant_id")

