# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CertAuthBackendRoleArgs', 'CertAuthBackendRole']

@pulumi.input_type
class CertAuthBackendRoleArgs:
    def __init__(__self__, *,
                 certificate: pulumi.Input[str],
                 allowed_common_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_dns_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_email_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 ocsp_ca_certificates: Optional[pulumi.Input[str]] = None,
                 ocsp_enabled: Optional[pulumi.Input[bool]] = None,
                 ocsp_fail_open: Optional[pulumi.Input[bool]] = None,
                 ocsp_query_all_servers: Optional[pulumi.Input[bool]] = None,
                 ocsp_servers_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 required_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[bool]] = None,
                 token_num_uses: Optional[pulumi.Input[int]] = None,
                 token_period: Optional[pulumi.Input[int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_ttl: Optional[pulumi.Input[int]] = None,
                 token_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CertAuthBackendRole resource.
        :param pulumi.Input[str] certificate: CA certificate used to validate client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_common_names: Allowed the common names for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_dns_sans: Allowed alternative dns names for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_email_sans: Allowed emails for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_names: DEPRECATED: Please use the individual `allowed_X_sans` parameters instead. Allowed subject names for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_organizational_units: Allowed organization units for authenticated client certificates.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_uri_sans: Allowed URIs for authenticated client certificates
        :param pulumi.Input[str] backend: Path to the mounted Cert auth backend
        :param pulumi.Input[str] display_name: The name to display on tokens issued under this role.
        :param pulumi.Input[str] name: Name of the role
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] ocsp_ca_certificates: Any additional CA certificates
               needed to verify OCSP responses. Provided as base64 encoded PEM data.
               Requires Vault version 1.13+.
        :param pulumi.Input[bool] ocsp_enabled: If enabled, validate certificates'
               revocation status using OCSP. Requires Vault version 1.13+.
        :param pulumi.Input[bool] ocsp_fail_open: If true and an OCSP response cannot
               be fetched or is of an unknown status, the login will proceed as if the
               certificate has not been revoked.
               Requires Vault version 1.13+.
        :param pulumi.Input[bool] ocsp_query_all_servers: If set to true, rather than
               accepting the first successful OCSP response, query all servers and consider
               the certificate valid only if all servers agree.
               Requires Vault version 1.13+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ocsp_servers_overrides: : A comma-separated list of OCSP
               server addresses. If unset, the OCSP server is determined from the
               AuthorityInformationAccess extension on the certificate being inspected.
               Requires Vault version 1.13+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] required_extensions: TLS extensions required on
               client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[str] token_type: The type of token to generate, service or batch
        """
        pulumi.set(__self__, "certificate", certificate)
        if allowed_common_names is not None:
            pulumi.set(__self__, "allowed_common_names", allowed_common_names)
        if allowed_dns_sans is not None:
            pulumi.set(__self__, "allowed_dns_sans", allowed_dns_sans)
        if allowed_email_sans is not None:
            pulumi.set(__self__, "allowed_email_sans", allowed_email_sans)
        if allowed_names is not None:
            pulumi.set(__self__, "allowed_names", allowed_names)
        if allowed_organizational_units is not None:
            pulumi.set(__self__, "allowed_organizational_units", allowed_organizational_units)
        if allowed_uri_sans is not None:
            pulumi.set(__self__, "allowed_uri_sans", allowed_uri_sans)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if ocsp_ca_certificates is not None:
            pulumi.set(__self__, "ocsp_ca_certificates", ocsp_ca_certificates)
        if ocsp_enabled is not None:
            pulumi.set(__self__, "ocsp_enabled", ocsp_enabled)
        if ocsp_fail_open is not None:
            pulumi.set(__self__, "ocsp_fail_open", ocsp_fail_open)
        if ocsp_query_all_servers is not None:
            pulumi.set(__self__, "ocsp_query_all_servers", ocsp_query_all_servers)
        if ocsp_servers_overrides is not None:
            pulumi.set(__self__, "ocsp_servers_overrides", ocsp_servers_overrides)
        if required_extensions is not None:
            pulumi.set(__self__, "required_extensions", required_extensions)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[str]:
        """
        CA certificate used to validate client certificates
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="allowedCommonNames")
    def allowed_common_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed the common names for authenticated client certificates
        """
        return pulumi.get(self, "allowed_common_names")

    @allowed_common_names.setter
    def allowed_common_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_common_names", value)

    @property
    @pulumi.getter(name="allowedDnsSans")
    def allowed_dns_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed alternative dns names for authenticated client certificates
        """
        return pulumi.get(self, "allowed_dns_sans")

    @allowed_dns_sans.setter
    def allowed_dns_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_dns_sans", value)

    @property
    @pulumi.getter(name="allowedEmailSans")
    def allowed_email_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed emails for authenticated client certificates
        """
        return pulumi.get(self, "allowed_email_sans")

    @allowed_email_sans.setter
    def allowed_email_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_email_sans", value)

    @property
    @pulumi.getter(name="allowedNames")
    def allowed_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        DEPRECATED: Please use the individual `allowed_X_sans` parameters instead. Allowed subject names for authenticated client certificates
        """
        return pulumi.get(self, "allowed_names")

    @allowed_names.setter
    def allowed_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_names", value)

    @property
    @pulumi.getter(name="allowedOrganizationalUnits")
    def allowed_organizational_units(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed organization units for authenticated client certificates.
        """
        return pulumi.get(self, "allowed_organizational_units")

    @allowed_organizational_units.setter
    def allowed_organizational_units(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_organizational_units", value)

    @property
    @pulumi.getter(name="allowedUriSans")
    def allowed_uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed URIs for authenticated client certificates
        """
        return pulumi.get(self, "allowed_uri_sans")

    @allowed_uri_sans.setter
    def allowed_uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_uri_sans", value)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the mounted Cert auth backend
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name to display on tokens issued under this role.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the role
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="ocspCaCertificates")
    def ocsp_ca_certificates(self) -> Optional[pulumi.Input[str]]:
        """
        Any additional CA certificates
        needed to verify OCSP responses. Provided as base64 encoded PEM data.
        Requires Vault version 1.13+.
        """
        return pulumi.get(self, "ocsp_ca_certificates")

    @ocsp_ca_certificates.setter
    def ocsp_ca_certificates(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocsp_ca_certificates", value)

    @property
    @pulumi.getter(name="ocspEnabled")
    def ocsp_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled, validate certificates'
        revocation status using OCSP. Requires Vault version 1.13+.
        """
        return pulumi.get(self, "ocsp_enabled")

    @ocsp_enabled.setter
    def ocsp_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ocsp_enabled", value)

    @property
    @pulumi.getter(name="ocspFailOpen")
    def ocsp_fail_open(self) -> Optional[pulumi.Input[bool]]:
        """
        If true and an OCSP response cannot
        be fetched or is of an unknown status, the login will proceed as if the
        certificate has not been revoked.
        Requires Vault version 1.13+.
        """
        return pulumi.get(self, "ocsp_fail_open")

    @ocsp_fail_open.setter
    def ocsp_fail_open(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ocsp_fail_open", value)

    @property
    @pulumi.getter(name="ocspQueryAllServers")
    def ocsp_query_all_servers(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, rather than
        accepting the first successful OCSP response, query all servers and consider
        the certificate valid only if all servers agree.
        Requires Vault version 1.13+.
        """
        return pulumi.get(self, "ocsp_query_all_servers")

    @ocsp_query_all_servers.setter
    def ocsp_query_all_servers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ocsp_query_all_servers", value)

    @property
    @pulumi.getter(name="ocspServersOverrides")
    def ocsp_servers_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        : A comma-separated list of OCSP
        server addresses. If unset, the OCSP server is determined from the
        AuthorityInformationAccess extension on the certificate being inspected.
        Requires Vault version 1.13+.
        """
        return pulumi.get(self, "ocsp_servers_overrides")

    @ocsp_servers_overrides.setter
    def ocsp_servers_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ocsp_servers_overrides", value)

    @property
    @pulumi.getter(name="requiredExtensions")
    def required_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        TLS extensions required on
        client certificates
        """
        return pulumi.get(self, "required_extensions")

    @required_extensions.setter
    def required_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "required_extensions", value)

    @property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_max_ttl", value)

    @property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_num_uses", value)

    @property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_period", value)

    @property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "token_policies", value)

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_ttl", value)

    @property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_type", value)


@pulumi.input_type
class _CertAuthBackendRoleState:
    def __init__(__self__, *,
                 allowed_common_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_dns_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_email_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 ocsp_ca_certificates: Optional[pulumi.Input[str]] = None,
                 ocsp_enabled: Optional[pulumi.Input[bool]] = None,
                 ocsp_fail_open: Optional[pulumi.Input[bool]] = None,
                 ocsp_query_all_servers: Optional[pulumi.Input[bool]] = None,
                 ocsp_servers_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 required_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[bool]] = None,
                 token_num_uses: Optional[pulumi.Input[int]] = None,
                 token_period: Optional[pulumi.Input[int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_ttl: Optional[pulumi.Input[int]] = None,
                 token_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CertAuthBackendRole resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_common_names: Allowed the common names for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_dns_sans: Allowed alternative dns names for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_email_sans: Allowed emails for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_names: DEPRECATED: Please use the individual `allowed_X_sans` parameters instead. Allowed subject names for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_organizational_units: Allowed organization units for authenticated client certificates.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_uri_sans: Allowed URIs for authenticated client certificates
        :param pulumi.Input[str] backend: Path to the mounted Cert auth backend
        :param pulumi.Input[str] certificate: CA certificate used to validate client certificates
        :param pulumi.Input[str] display_name: The name to display on tokens issued under this role.
        :param pulumi.Input[str] name: Name of the role
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] ocsp_ca_certificates: Any additional CA certificates
               needed to verify OCSP responses. Provided as base64 encoded PEM data.
               Requires Vault version 1.13+.
        :param pulumi.Input[bool] ocsp_enabled: If enabled, validate certificates'
               revocation status using OCSP. Requires Vault version 1.13+.
        :param pulumi.Input[bool] ocsp_fail_open: If true and an OCSP response cannot
               be fetched or is of an unknown status, the login will proceed as if the
               certificate has not been revoked.
               Requires Vault version 1.13+.
        :param pulumi.Input[bool] ocsp_query_all_servers: If set to true, rather than
               accepting the first successful OCSP response, query all servers and consider
               the certificate valid only if all servers agree.
               Requires Vault version 1.13+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ocsp_servers_overrides: : A comma-separated list of OCSP
               server addresses. If unset, the OCSP server is determined from the
               AuthorityInformationAccess extension on the certificate being inspected.
               Requires Vault version 1.13+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] required_extensions: TLS extensions required on
               client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[str] token_type: The type of token to generate, service or batch
        """
        if allowed_common_names is not None:
            pulumi.set(__self__, "allowed_common_names", allowed_common_names)
        if allowed_dns_sans is not None:
            pulumi.set(__self__, "allowed_dns_sans", allowed_dns_sans)
        if allowed_email_sans is not None:
            pulumi.set(__self__, "allowed_email_sans", allowed_email_sans)
        if allowed_names is not None:
            pulumi.set(__self__, "allowed_names", allowed_names)
        if allowed_organizational_units is not None:
            pulumi.set(__self__, "allowed_organizational_units", allowed_organizational_units)
        if allowed_uri_sans is not None:
            pulumi.set(__self__, "allowed_uri_sans", allowed_uri_sans)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if ocsp_ca_certificates is not None:
            pulumi.set(__self__, "ocsp_ca_certificates", ocsp_ca_certificates)
        if ocsp_enabled is not None:
            pulumi.set(__self__, "ocsp_enabled", ocsp_enabled)
        if ocsp_fail_open is not None:
            pulumi.set(__self__, "ocsp_fail_open", ocsp_fail_open)
        if ocsp_query_all_servers is not None:
            pulumi.set(__self__, "ocsp_query_all_servers", ocsp_query_all_servers)
        if ocsp_servers_overrides is not None:
            pulumi.set(__self__, "ocsp_servers_overrides", ocsp_servers_overrides)
        if required_extensions is not None:
            pulumi.set(__self__, "required_extensions", required_extensions)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)

    @property
    @pulumi.getter(name="allowedCommonNames")
    def allowed_common_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed the common names for authenticated client certificates
        """
        return pulumi.get(self, "allowed_common_names")

    @allowed_common_names.setter
    def allowed_common_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_common_names", value)

    @property
    @pulumi.getter(name="allowedDnsSans")
    def allowed_dns_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed alternative dns names for authenticated client certificates
        """
        return pulumi.get(self, "allowed_dns_sans")

    @allowed_dns_sans.setter
    def allowed_dns_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_dns_sans", value)

    @property
    @pulumi.getter(name="allowedEmailSans")
    def allowed_email_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed emails for authenticated client certificates
        """
        return pulumi.get(self, "allowed_email_sans")

    @allowed_email_sans.setter
    def allowed_email_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_email_sans", value)

    @property
    @pulumi.getter(name="allowedNames")
    def allowed_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        DEPRECATED: Please use the individual `allowed_X_sans` parameters instead. Allowed subject names for authenticated client certificates
        """
        return pulumi.get(self, "allowed_names")

    @allowed_names.setter
    def allowed_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_names", value)

    @property
    @pulumi.getter(name="allowedOrganizationalUnits")
    def allowed_organizational_units(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed organization units for authenticated client certificates.
        """
        return pulumi.get(self, "allowed_organizational_units")

    @allowed_organizational_units.setter
    def allowed_organizational_units(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_organizational_units", value)

    @property
    @pulumi.getter(name="allowedUriSans")
    def allowed_uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed URIs for authenticated client certificates
        """
        return pulumi.get(self, "allowed_uri_sans")

    @allowed_uri_sans.setter
    def allowed_uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_uri_sans", value)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the mounted Cert auth backend
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        CA certificate used to validate client certificates
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name to display on tokens issued under this role.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the role
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="ocspCaCertificates")
    def ocsp_ca_certificates(self) -> Optional[pulumi.Input[str]]:
        """
        Any additional CA certificates
        needed to verify OCSP responses. Provided as base64 encoded PEM data.
        Requires Vault version 1.13+.
        """
        return pulumi.get(self, "ocsp_ca_certificates")

    @ocsp_ca_certificates.setter
    def ocsp_ca_certificates(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocsp_ca_certificates", value)

    @property
    @pulumi.getter(name="ocspEnabled")
    def ocsp_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled, validate certificates'
        revocation status using OCSP. Requires Vault version 1.13+.
        """
        return pulumi.get(self, "ocsp_enabled")

    @ocsp_enabled.setter
    def ocsp_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ocsp_enabled", value)

    @property
    @pulumi.getter(name="ocspFailOpen")
    def ocsp_fail_open(self) -> Optional[pulumi.Input[bool]]:
        """
        If true and an OCSP response cannot
        be fetched or is of an unknown status, the login will proceed as if the
        certificate has not been revoked.
        Requires Vault version 1.13+.
        """
        return pulumi.get(self, "ocsp_fail_open")

    @ocsp_fail_open.setter
    def ocsp_fail_open(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ocsp_fail_open", value)

    @property
    @pulumi.getter(name="ocspQueryAllServers")
    def ocsp_query_all_servers(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, rather than
        accepting the first successful OCSP response, query all servers and consider
        the certificate valid only if all servers agree.
        Requires Vault version 1.13+.
        """
        return pulumi.get(self, "ocsp_query_all_servers")

    @ocsp_query_all_servers.setter
    def ocsp_query_all_servers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ocsp_query_all_servers", value)

    @property
    @pulumi.getter(name="ocspServersOverrides")
    def ocsp_servers_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        : A comma-separated list of OCSP
        server addresses. If unset, the OCSP server is determined from the
        AuthorityInformationAccess extension on the certificate being inspected.
        Requires Vault version 1.13+.
        """
        return pulumi.get(self, "ocsp_servers_overrides")

    @ocsp_servers_overrides.setter
    def ocsp_servers_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ocsp_servers_overrides", value)

    @property
    @pulumi.getter(name="requiredExtensions")
    def required_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        TLS extensions required on
        client certificates
        """
        return pulumi.get(self, "required_extensions")

    @required_extensions.setter
    def required_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "required_extensions", value)

    @property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_max_ttl", value)

    @property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_num_uses", value)

    @property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_period", value)

    @property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "token_policies", value)

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_ttl", value)

    @property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_type", value)


class CertAuthBackendRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_common_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_dns_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_email_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 ocsp_ca_certificates: Optional[pulumi.Input[str]] = None,
                 ocsp_enabled: Optional[pulumi.Input[bool]] = None,
                 ocsp_fail_open: Optional[pulumi.Input[bool]] = None,
                 ocsp_query_all_servers: Optional[pulumi.Input[bool]] = None,
                 ocsp_servers_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 required_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[bool]] = None,
                 token_num_uses: Optional[pulumi.Input[int]] = None,
                 token_period: Optional[pulumi.Input[int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_ttl: Optional[pulumi.Input[int]] = None,
                 token_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to create a role in an [Cert auth backend within Vault](https://www.vaultproject.io/docs/auth/cert.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_std as std
        import pulumi_vault as vault

        cert = vault.AuthBackend("cert",
            path="cert",
            type="cert")
        cert_cert_auth_backend_role = vault.CertAuthBackendRole("cert",
            name="foo",
            certificate=std.file(input="/path/to/certs/ca-cert.pem").result,
            backend=cert.path,
            allowed_names=[
                "foo.example.org",
                "baz.example.org",
            ],
            token_ttl=300,
            token_max_ttl=600,
            token_policies=["foo"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_common_names: Allowed the common names for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_dns_sans: Allowed alternative dns names for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_email_sans: Allowed emails for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_names: DEPRECATED: Please use the individual `allowed_X_sans` parameters instead. Allowed subject names for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_organizational_units: Allowed organization units for authenticated client certificates.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_uri_sans: Allowed URIs for authenticated client certificates
        :param pulumi.Input[str] backend: Path to the mounted Cert auth backend
        :param pulumi.Input[str] certificate: CA certificate used to validate client certificates
        :param pulumi.Input[str] display_name: The name to display on tokens issued under this role.
        :param pulumi.Input[str] name: Name of the role
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] ocsp_ca_certificates: Any additional CA certificates
               needed to verify OCSP responses. Provided as base64 encoded PEM data.
               Requires Vault version 1.13+.
        :param pulumi.Input[bool] ocsp_enabled: If enabled, validate certificates'
               revocation status using OCSP. Requires Vault version 1.13+.
        :param pulumi.Input[bool] ocsp_fail_open: If true and an OCSP response cannot
               be fetched or is of an unknown status, the login will proceed as if the
               certificate has not been revoked.
               Requires Vault version 1.13+.
        :param pulumi.Input[bool] ocsp_query_all_servers: If set to true, rather than
               accepting the first successful OCSP response, query all servers and consider
               the certificate valid only if all servers agree.
               Requires Vault version 1.13+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ocsp_servers_overrides: : A comma-separated list of OCSP
               server addresses. If unset, the OCSP server is determined from the
               AuthorityInformationAccess extension on the certificate being inspected.
               Requires Vault version 1.13+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] required_extensions: TLS extensions required on
               client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[str] token_type: The type of token to generate, service or batch
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertAuthBackendRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create a role in an [Cert auth backend within Vault](https://www.vaultproject.io/docs/auth/cert.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_std as std
        import pulumi_vault as vault

        cert = vault.AuthBackend("cert",
            path="cert",
            type="cert")
        cert_cert_auth_backend_role = vault.CertAuthBackendRole("cert",
            name="foo",
            certificate=std.file(input="/path/to/certs/ca-cert.pem").result,
            backend=cert.path,
            allowed_names=[
                "foo.example.org",
                "baz.example.org",
            ],
            token_ttl=300,
            token_max_ttl=600,
            token_policies=["foo"])
        ```

        :param str resource_name: The name of the resource.
        :param CertAuthBackendRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertAuthBackendRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_common_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_dns_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_email_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 ocsp_ca_certificates: Optional[pulumi.Input[str]] = None,
                 ocsp_enabled: Optional[pulumi.Input[bool]] = None,
                 ocsp_fail_open: Optional[pulumi.Input[bool]] = None,
                 ocsp_query_all_servers: Optional[pulumi.Input[bool]] = None,
                 ocsp_servers_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 required_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[bool]] = None,
                 token_num_uses: Optional[pulumi.Input[int]] = None,
                 token_period: Optional[pulumi.Input[int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_ttl: Optional[pulumi.Input[int]] = None,
                 token_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertAuthBackendRoleArgs.__new__(CertAuthBackendRoleArgs)

            __props__.__dict__["allowed_common_names"] = allowed_common_names
            __props__.__dict__["allowed_dns_sans"] = allowed_dns_sans
            __props__.__dict__["allowed_email_sans"] = allowed_email_sans
            __props__.__dict__["allowed_names"] = allowed_names
            __props__.__dict__["allowed_organizational_units"] = allowed_organizational_units
            __props__.__dict__["allowed_uri_sans"] = allowed_uri_sans
            __props__.__dict__["backend"] = backend
            if certificate is None and not opts.urn:
                raise TypeError("Missing required property 'certificate'")
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["ocsp_ca_certificates"] = ocsp_ca_certificates
            __props__.__dict__["ocsp_enabled"] = ocsp_enabled
            __props__.__dict__["ocsp_fail_open"] = ocsp_fail_open
            __props__.__dict__["ocsp_query_all_servers"] = ocsp_query_all_servers
            __props__.__dict__["ocsp_servers_overrides"] = ocsp_servers_overrides
            __props__.__dict__["required_extensions"] = required_extensions
            __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
            __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
            __props__.__dict__["token_max_ttl"] = token_max_ttl
            __props__.__dict__["token_no_default_policy"] = token_no_default_policy
            __props__.__dict__["token_num_uses"] = token_num_uses
            __props__.__dict__["token_period"] = token_period
            __props__.__dict__["token_policies"] = token_policies
            __props__.__dict__["token_ttl"] = token_ttl
            __props__.__dict__["token_type"] = token_type
        super(CertAuthBackendRole, __self__).__init__(
            'vault:index/certAuthBackendRole:CertAuthBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_common_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_dns_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_email_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            backend: Optional[pulumi.Input[str]] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            ocsp_ca_certificates: Optional[pulumi.Input[str]] = None,
            ocsp_enabled: Optional[pulumi.Input[bool]] = None,
            ocsp_fail_open: Optional[pulumi.Input[bool]] = None,
            ocsp_query_all_servers: Optional[pulumi.Input[bool]] = None,
            ocsp_servers_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            required_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
            token_max_ttl: Optional[pulumi.Input[int]] = None,
            token_no_default_policy: Optional[pulumi.Input[bool]] = None,
            token_num_uses: Optional[pulumi.Input[int]] = None,
            token_period: Optional[pulumi.Input[int]] = None,
            token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            token_ttl: Optional[pulumi.Input[int]] = None,
            token_type: Optional[pulumi.Input[str]] = None) -> 'CertAuthBackendRole':
        """
        Get an existing CertAuthBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_common_names: Allowed the common names for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_dns_sans: Allowed alternative dns names for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_email_sans: Allowed emails for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_names: DEPRECATED: Please use the individual `allowed_X_sans` parameters instead. Allowed subject names for authenticated client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_organizational_units: Allowed organization units for authenticated client certificates.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_uri_sans: Allowed URIs for authenticated client certificates
        :param pulumi.Input[str] backend: Path to the mounted Cert auth backend
        :param pulumi.Input[str] certificate: CA certificate used to validate client certificates
        :param pulumi.Input[str] display_name: The name to display on tokens issued under this role.
        :param pulumi.Input[str] name: Name of the role
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] ocsp_ca_certificates: Any additional CA certificates
               needed to verify OCSP responses. Provided as base64 encoded PEM data.
               Requires Vault version 1.13+.
        :param pulumi.Input[bool] ocsp_enabled: If enabled, validate certificates'
               revocation status using OCSP. Requires Vault version 1.13+.
        :param pulumi.Input[bool] ocsp_fail_open: If true and an OCSP response cannot
               be fetched or is of an unknown status, the login will proceed as if the
               certificate has not been revoked.
               Requires Vault version 1.13+.
        :param pulumi.Input[bool] ocsp_query_all_servers: If set to true, rather than
               accepting the first successful OCSP response, query all servers and consider
               the certificate valid only if all servers agree.
               Requires Vault version 1.13+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ocsp_servers_overrides: : A comma-separated list of OCSP
               server addresses. If unset, the OCSP server is determined from the
               AuthorityInformationAccess extension on the certificate being inspected.
               Requires Vault version 1.13+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] required_extensions: TLS extensions required on
               client certificates
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[str] token_type: The type of token to generate, service or batch
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertAuthBackendRoleState.__new__(_CertAuthBackendRoleState)

        __props__.__dict__["allowed_common_names"] = allowed_common_names
        __props__.__dict__["allowed_dns_sans"] = allowed_dns_sans
        __props__.__dict__["allowed_email_sans"] = allowed_email_sans
        __props__.__dict__["allowed_names"] = allowed_names
        __props__.__dict__["allowed_organizational_units"] = allowed_organizational_units
        __props__.__dict__["allowed_uri_sans"] = allowed_uri_sans
        __props__.__dict__["backend"] = backend
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["ocsp_ca_certificates"] = ocsp_ca_certificates
        __props__.__dict__["ocsp_enabled"] = ocsp_enabled
        __props__.__dict__["ocsp_fail_open"] = ocsp_fail_open
        __props__.__dict__["ocsp_query_all_servers"] = ocsp_query_all_servers
        __props__.__dict__["ocsp_servers_overrides"] = ocsp_servers_overrides
        __props__.__dict__["required_extensions"] = required_extensions
        __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
        __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
        __props__.__dict__["token_max_ttl"] = token_max_ttl
        __props__.__dict__["token_no_default_policy"] = token_no_default_policy
        __props__.__dict__["token_num_uses"] = token_num_uses
        __props__.__dict__["token_period"] = token_period
        __props__.__dict__["token_policies"] = token_policies
        __props__.__dict__["token_ttl"] = token_ttl
        __props__.__dict__["token_type"] = token_type
        return CertAuthBackendRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedCommonNames")
    def allowed_common_names(self) -> pulumi.Output[Sequence[str]]:
        """
        Allowed the common names for authenticated client certificates
        """
        return pulumi.get(self, "allowed_common_names")

    @property
    @pulumi.getter(name="allowedDnsSans")
    def allowed_dns_sans(self) -> pulumi.Output[Sequence[str]]:
        """
        Allowed alternative dns names for authenticated client certificates
        """
        return pulumi.get(self, "allowed_dns_sans")

    @property
    @pulumi.getter(name="allowedEmailSans")
    def allowed_email_sans(self) -> pulumi.Output[Sequence[str]]:
        """
        Allowed emails for authenticated client certificates
        """
        return pulumi.get(self, "allowed_email_sans")

    @property
    @pulumi.getter(name="allowedNames")
    def allowed_names(self) -> pulumi.Output[Sequence[str]]:
        """
        DEPRECATED: Please use the individual `allowed_X_sans` parameters instead. Allowed subject names for authenticated client certificates
        """
        return pulumi.get(self, "allowed_names")

    @property
    @pulumi.getter(name="allowedOrganizationalUnits")
    def allowed_organizational_units(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Allowed organization units for authenticated client certificates.
        """
        return pulumi.get(self, "allowed_organizational_units")

    @property
    @pulumi.getter(name="allowedUriSans")
    def allowed_uri_sans(self) -> pulumi.Output[Sequence[str]]:
        """
        Allowed URIs for authenticated client certificates
        """
        return pulumi.get(self, "allowed_uri_sans")

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[str]]:
        """
        Path to the mounted Cert auth backend
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        CA certificate used to validate client certificates
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The name to display on tokens issued under this role.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the role
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="ocspCaCertificates")
    def ocsp_ca_certificates(self) -> pulumi.Output[Optional[str]]:
        """
        Any additional CA certificates
        needed to verify OCSP responses. Provided as base64 encoded PEM data.
        Requires Vault version 1.13+.
        """
        return pulumi.get(self, "ocsp_ca_certificates")

    @property
    @pulumi.getter(name="ocspEnabled")
    def ocsp_enabled(self) -> pulumi.Output[bool]:
        """
        If enabled, validate certificates'
        revocation status using OCSP. Requires Vault version 1.13+.
        """
        return pulumi.get(self, "ocsp_enabled")

    @property
    @pulumi.getter(name="ocspFailOpen")
    def ocsp_fail_open(self) -> pulumi.Output[bool]:
        """
        If true and an OCSP response cannot
        be fetched or is of an unknown status, the login will proceed as if the
        certificate has not been revoked.
        Requires Vault version 1.13+.
        """
        return pulumi.get(self, "ocsp_fail_open")

    @property
    @pulumi.getter(name="ocspQueryAllServers")
    def ocsp_query_all_servers(self) -> pulumi.Output[bool]:
        """
        If set to true, rather than
        accepting the first successful OCSP response, query all servers and consider
        the certificate valid only if all servers agree.
        Requires Vault version 1.13+.
        """
        return pulumi.get(self, "ocsp_query_all_servers")

    @property
    @pulumi.getter(name="ocspServersOverrides")
    def ocsp_servers_overrides(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        : A comma-separated list of OCSP
        server addresses. If unset, the OCSP server is determined from the
        AuthorityInformationAccess extension on the certificate being inspected.
        Requires Vault version 1.13+.
        """
        return pulumi.get(self, "ocsp_servers_overrides")

    @property
    @pulumi.getter(name="requiredExtensions")
    def required_extensions(self) -> pulumi.Output[Sequence[str]]:
        """
        TLS extensions required on
        client certificates
        """
        return pulumi.get(self, "required_extensions")

    @property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> pulumi.Output[Optional[int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

