# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecretBackendConnectionArgs', 'SecretBackendConnection']

@pulumi.input_type
class SecretBackendConnectionArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[str],
                 allowed_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cassandra: Optional[pulumi.Input['SecretBackendConnectionCassandraArgs']] = None,
                 couchbase: Optional[pulumi.Input['SecretBackendConnectionCouchbaseArgs']] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 elasticsearch: Optional[pulumi.Input['SecretBackendConnectionElasticsearchArgs']] = None,
                 hana: Optional[pulumi.Input['SecretBackendConnectionHanaArgs']] = None,
                 influxdb: Optional[pulumi.Input['SecretBackendConnectionInfluxdbArgs']] = None,
                 mongodb: Optional[pulumi.Input['SecretBackendConnectionMongodbArgs']] = None,
                 mongodbatlas: Optional[pulumi.Input['SecretBackendConnectionMongodbatlasArgs']] = None,
                 mssql: Optional[pulumi.Input['SecretBackendConnectionMssqlArgs']] = None,
                 mysql: Optional[pulumi.Input['SecretBackendConnectionMysqlArgs']] = None,
                 mysql_aurora: Optional[pulumi.Input['SecretBackendConnectionMysqlAuroraArgs']] = None,
                 mysql_legacy: Optional[pulumi.Input['SecretBackendConnectionMysqlLegacyArgs']] = None,
                 mysql_rds: Optional[pulumi.Input['SecretBackendConnectionMysqlRdsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 oracle: Optional[pulumi.Input['SecretBackendConnectionOracleArgs']] = None,
                 plugin_name: Optional[pulumi.Input[str]] = None,
                 postgresql: Optional[pulumi.Input['SecretBackendConnectionPostgresqlArgs']] = None,
                 redis: Optional[pulumi.Input['SecretBackendConnectionRedisArgs']] = None,
                 redis_elasticache: Optional[pulumi.Input['SecretBackendConnectionRedisElasticacheArgs']] = None,
                 redshift: Optional[pulumi.Input['SecretBackendConnectionRedshiftArgs']] = None,
                 root_rotation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snowflake: Optional[pulumi.Input['SecretBackendConnectionSnowflakeArgs']] = None,
                 verify_connection: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a SecretBackendConnection resource.
        :param pulumi.Input[str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param pulumi.Input['SecretBackendConnectionCassandraArgs'] cassandra: A nested block containing configuration options for Cassandra connections.
        :param pulumi.Input['SecretBackendConnectionCouchbaseArgs'] couchbase: A nested block containing configuration options for Couchbase connections.
        :param pulumi.Input[Mapping[str, Any]] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param pulumi.Input['SecretBackendConnectionElasticsearchArgs'] elasticsearch: A nested block containing configuration options for Elasticsearch connections.
        :param pulumi.Input['SecretBackendConnectionHanaArgs'] hana: A nested block containing configuration options for SAP HanaDB connections.
        :param pulumi.Input['SecretBackendConnectionInfluxdbArgs'] influxdb: A nested block containing configuration options for InfluxDB connections.
        :param pulumi.Input['SecretBackendConnectionMongodbArgs'] mongodb: A nested block containing configuration options for MongoDB connections.
        :param pulumi.Input['SecretBackendConnectionMongodbatlasArgs'] mongodbatlas: A nested block containing configuration options for MongoDB Atlas connections.
        :param pulumi.Input['SecretBackendConnectionMssqlArgs'] mssql: A nested block containing configuration options for MSSQL connections.
        :param pulumi.Input['SecretBackendConnectionMysqlArgs'] mysql: A nested block containing configuration options for MySQL connections.
        :param pulumi.Input['SecretBackendConnectionMysqlAuroraArgs'] mysql_aurora: A nested block containing configuration options for Aurora MySQL connections.
        :param pulumi.Input['SecretBackendConnectionMysqlLegacyArgs'] mysql_legacy: A nested block containing configuration options for legacy MySQL connections.
        :param pulumi.Input['SecretBackendConnectionMysqlRdsArgs'] mysql_rds: A nested block containing configuration options for RDS MySQL connections.
        :param pulumi.Input[str] name: A unique name to give the database connection.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input['SecretBackendConnectionOracleArgs'] oracle: A nested block containing configuration options for Oracle connections.
        :param pulumi.Input[str] plugin_name: Specifies the name of the plugin to use.
        :param pulumi.Input['SecretBackendConnectionPostgresqlArgs'] postgresql: A nested block containing configuration options for PostgreSQL connections.
        :param pulumi.Input['SecretBackendConnectionRedisArgs'] redis: A nested block containing configuration options for Redis connections.
        :param pulumi.Input['SecretBackendConnectionRedisElasticacheArgs'] redis_elasticache: A nested block containing configuration options for Redis ElastiCache connections.
               
               Exactly one of the nested blocks of configuration options must be supplied.
        :param pulumi.Input['SecretBackendConnectionRedshiftArgs'] redshift: Connection parameters for the redshift-database-plugin plugin.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param pulumi.Input['SecretBackendConnectionSnowflakeArgs'] snowflake: A nested block containing configuration options for Snowflake connections.
        :param pulumi.Input[bool] verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "backend", backend)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if cassandra is not None:
            pulumi.set(__self__, "cassandra", cassandra)
        if couchbase is not None:
            pulumi.set(__self__, "couchbase", couchbase)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if elasticsearch is not None:
            pulumi.set(__self__, "elasticsearch", elasticsearch)
        if hana is not None:
            pulumi.set(__self__, "hana", hana)
        if influxdb is not None:
            pulumi.set(__self__, "influxdb", influxdb)
        if mongodb is not None:
            pulumi.set(__self__, "mongodb", mongodb)
        if mongodbatlas is not None:
            pulumi.set(__self__, "mongodbatlas", mongodbatlas)
        if mssql is not None:
            pulumi.set(__self__, "mssql", mssql)
        if mysql is not None:
            pulumi.set(__self__, "mysql", mysql)
        if mysql_aurora is not None:
            pulumi.set(__self__, "mysql_aurora", mysql_aurora)
        if mysql_legacy is not None:
            pulumi.set(__self__, "mysql_legacy", mysql_legacy)
        if mysql_rds is not None:
            pulumi.set(__self__, "mysql_rds", mysql_rds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if oracle is not None:
            pulumi.set(__self__, "oracle", oracle)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if postgresql is not None:
            pulumi.set(__self__, "postgresql", postgresql)
        if redis is not None:
            pulumi.set(__self__, "redis", redis)
        if redis_elasticache is not None:
            pulumi.set(__self__, "redis_elasticache", redis_elasticache)
        if redshift is not None:
            pulumi.set(__self__, "redshift", redshift)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if snowflake is not None:
            pulumi.set(__self__, "snowflake", snowflake)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[str]:
        """
        The unique name of the Vault mount to configure.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @allowed_roles.setter
    def allowed_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_roles", value)

    @property
    @pulumi.getter
    def cassandra(self) -> Optional[pulumi.Input['SecretBackendConnectionCassandraArgs']]:
        """
        A nested block containing configuration options for Cassandra connections.
        """
        return pulumi.get(self, "cassandra")

    @cassandra.setter
    def cassandra(self, value: Optional[pulumi.Input['SecretBackendConnectionCassandraArgs']]):
        pulumi.set(self, "cassandra", value)

    @property
    @pulumi.getter
    def couchbase(self) -> Optional[pulumi.Input['SecretBackendConnectionCouchbaseArgs']]:
        """
        A nested block containing configuration options for Couchbase connections.
        """
        return pulumi.get(self, "couchbase")

    @couchbase.setter
    def couchbase(self, value: Optional[pulumi.Input['SecretBackendConnectionCouchbaseArgs']]):
        pulumi.set(self, "couchbase", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def elasticsearch(self) -> Optional[pulumi.Input['SecretBackendConnectionElasticsearchArgs']]:
        """
        A nested block containing configuration options for Elasticsearch connections.
        """
        return pulumi.get(self, "elasticsearch")

    @elasticsearch.setter
    def elasticsearch(self, value: Optional[pulumi.Input['SecretBackendConnectionElasticsearchArgs']]):
        pulumi.set(self, "elasticsearch", value)

    @property
    @pulumi.getter
    def hana(self) -> Optional[pulumi.Input['SecretBackendConnectionHanaArgs']]:
        """
        A nested block containing configuration options for SAP HanaDB connections.
        """
        return pulumi.get(self, "hana")

    @hana.setter
    def hana(self, value: Optional[pulumi.Input['SecretBackendConnectionHanaArgs']]):
        pulumi.set(self, "hana", value)

    @property
    @pulumi.getter
    def influxdb(self) -> Optional[pulumi.Input['SecretBackendConnectionInfluxdbArgs']]:
        """
        A nested block containing configuration options for InfluxDB connections.
        """
        return pulumi.get(self, "influxdb")

    @influxdb.setter
    def influxdb(self, value: Optional[pulumi.Input['SecretBackendConnectionInfluxdbArgs']]):
        pulumi.set(self, "influxdb", value)

    @property
    @pulumi.getter
    def mongodb(self) -> Optional[pulumi.Input['SecretBackendConnectionMongodbArgs']]:
        """
        A nested block containing configuration options for MongoDB connections.
        """
        return pulumi.get(self, "mongodb")

    @mongodb.setter
    def mongodb(self, value: Optional[pulumi.Input['SecretBackendConnectionMongodbArgs']]):
        pulumi.set(self, "mongodb", value)

    @property
    @pulumi.getter
    def mongodbatlas(self) -> Optional[pulumi.Input['SecretBackendConnectionMongodbatlasArgs']]:
        """
        A nested block containing configuration options for MongoDB Atlas connections.
        """
        return pulumi.get(self, "mongodbatlas")

    @mongodbatlas.setter
    def mongodbatlas(self, value: Optional[pulumi.Input['SecretBackendConnectionMongodbatlasArgs']]):
        pulumi.set(self, "mongodbatlas", value)

    @property
    @pulumi.getter
    def mssql(self) -> Optional[pulumi.Input['SecretBackendConnectionMssqlArgs']]:
        """
        A nested block containing configuration options for MSSQL connections.
        """
        return pulumi.get(self, "mssql")

    @mssql.setter
    def mssql(self, value: Optional[pulumi.Input['SecretBackendConnectionMssqlArgs']]):
        pulumi.set(self, "mssql", value)

    @property
    @pulumi.getter
    def mysql(self) -> Optional[pulumi.Input['SecretBackendConnectionMysqlArgs']]:
        """
        A nested block containing configuration options for MySQL connections.
        """
        return pulumi.get(self, "mysql")

    @mysql.setter
    def mysql(self, value: Optional[pulumi.Input['SecretBackendConnectionMysqlArgs']]):
        pulumi.set(self, "mysql", value)

    @property
    @pulumi.getter(name="mysqlAurora")
    def mysql_aurora(self) -> Optional[pulumi.Input['SecretBackendConnectionMysqlAuroraArgs']]:
        """
        A nested block containing configuration options for Aurora MySQL connections.
        """
        return pulumi.get(self, "mysql_aurora")

    @mysql_aurora.setter
    def mysql_aurora(self, value: Optional[pulumi.Input['SecretBackendConnectionMysqlAuroraArgs']]):
        pulumi.set(self, "mysql_aurora", value)

    @property
    @pulumi.getter(name="mysqlLegacy")
    def mysql_legacy(self) -> Optional[pulumi.Input['SecretBackendConnectionMysqlLegacyArgs']]:
        """
        A nested block containing configuration options for legacy MySQL connections.
        """
        return pulumi.get(self, "mysql_legacy")

    @mysql_legacy.setter
    def mysql_legacy(self, value: Optional[pulumi.Input['SecretBackendConnectionMysqlLegacyArgs']]):
        pulumi.set(self, "mysql_legacy", value)

    @property
    @pulumi.getter(name="mysqlRds")
    def mysql_rds(self) -> Optional[pulumi.Input['SecretBackendConnectionMysqlRdsArgs']]:
        """
        A nested block containing configuration options for RDS MySQL connections.
        """
        return pulumi.get(self, "mysql_rds")

    @mysql_rds.setter
    def mysql_rds(self, value: Optional[pulumi.Input['SecretBackendConnectionMysqlRdsArgs']]):
        pulumi.set(self, "mysql_rds", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name to give the database connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured namespace.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def oracle(self) -> Optional[pulumi.Input['SecretBackendConnectionOracleArgs']]:
        """
        A nested block containing configuration options for Oracle connections.
        """
        return pulumi.get(self, "oracle")

    @oracle.setter
    def oracle(self, value: Optional[pulumi.Input['SecretBackendConnectionOracleArgs']]):
        pulumi.set(self, "oracle", value)

    @property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @plugin_name.setter
    def plugin_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugin_name", value)

    @property
    @pulumi.getter
    def postgresql(self) -> Optional[pulumi.Input['SecretBackendConnectionPostgresqlArgs']]:
        """
        A nested block containing configuration options for PostgreSQL connections.
        """
        return pulumi.get(self, "postgresql")

    @postgresql.setter
    def postgresql(self, value: Optional[pulumi.Input['SecretBackendConnectionPostgresqlArgs']]):
        pulumi.set(self, "postgresql", value)

    @property
    @pulumi.getter
    def redis(self) -> Optional[pulumi.Input['SecretBackendConnectionRedisArgs']]:
        """
        A nested block containing configuration options for Redis connections.
        """
        return pulumi.get(self, "redis")

    @redis.setter
    def redis(self, value: Optional[pulumi.Input['SecretBackendConnectionRedisArgs']]):
        pulumi.set(self, "redis", value)

    @property
    @pulumi.getter(name="redisElasticache")
    def redis_elasticache(self) -> Optional[pulumi.Input['SecretBackendConnectionRedisElasticacheArgs']]:
        """
        A nested block containing configuration options for Redis ElastiCache connections.

        Exactly one of the nested blocks of configuration options must be supplied.
        """
        return pulumi.get(self, "redis_elasticache")

    @redis_elasticache.setter
    def redis_elasticache(self, value: Optional[pulumi.Input['SecretBackendConnectionRedisElasticacheArgs']]):
        pulumi.set(self, "redis_elasticache", value)

    @property
    @pulumi.getter
    def redshift(self) -> Optional[pulumi.Input['SecretBackendConnectionRedshiftArgs']]:
        """
        Connection parameters for the redshift-database-plugin plugin.
        """
        return pulumi.get(self, "redshift")

    @redshift.setter
    def redshift(self, value: Optional[pulumi.Input['SecretBackendConnectionRedshiftArgs']]):
        pulumi.set(self, "redshift", value)

    @property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @root_rotation_statements.setter
    def root_rotation_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "root_rotation_statements", value)

    @property
    @pulumi.getter
    def snowflake(self) -> Optional[pulumi.Input['SecretBackendConnectionSnowflakeArgs']]:
        """
        A nested block containing configuration options for Snowflake connections.
        """
        return pulumi.get(self, "snowflake")

    @snowflake.setter
    def snowflake(self, value: Optional[pulumi.Input['SecretBackendConnectionSnowflakeArgs']]):
        pulumi.set(self, "snowflake", value)

    @property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")

    @verify_connection.setter
    def verify_connection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verify_connection", value)


@pulumi.input_type
class _SecretBackendConnectionState:
    def __init__(__self__, *,
                 allowed_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 cassandra: Optional[pulumi.Input['SecretBackendConnectionCassandraArgs']] = None,
                 couchbase: Optional[pulumi.Input['SecretBackendConnectionCouchbaseArgs']] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 elasticsearch: Optional[pulumi.Input['SecretBackendConnectionElasticsearchArgs']] = None,
                 hana: Optional[pulumi.Input['SecretBackendConnectionHanaArgs']] = None,
                 influxdb: Optional[pulumi.Input['SecretBackendConnectionInfluxdbArgs']] = None,
                 mongodb: Optional[pulumi.Input['SecretBackendConnectionMongodbArgs']] = None,
                 mongodbatlas: Optional[pulumi.Input['SecretBackendConnectionMongodbatlasArgs']] = None,
                 mssql: Optional[pulumi.Input['SecretBackendConnectionMssqlArgs']] = None,
                 mysql: Optional[pulumi.Input['SecretBackendConnectionMysqlArgs']] = None,
                 mysql_aurora: Optional[pulumi.Input['SecretBackendConnectionMysqlAuroraArgs']] = None,
                 mysql_legacy: Optional[pulumi.Input['SecretBackendConnectionMysqlLegacyArgs']] = None,
                 mysql_rds: Optional[pulumi.Input['SecretBackendConnectionMysqlRdsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 oracle: Optional[pulumi.Input['SecretBackendConnectionOracleArgs']] = None,
                 plugin_name: Optional[pulumi.Input[str]] = None,
                 postgresql: Optional[pulumi.Input['SecretBackendConnectionPostgresqlArgs']] = None,
                 redis: Optional[pulumi.Input['SecretBackendConnectionRedisArgs']] = None,
                 redis_elasticache: Optional[pulumi.Input['SecretBackendConnectionRedisElasticacheArgs']] = None,
                 redshift: Optional[pulumi.Input['SecretBackendConnectionRedshiftArgs']] = None,
                 root_rotation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snowflake: Optional[pulumi.Input['SecretBackendConnectionSnowflakeArgs']] = None,
                 verify_connection: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering SecretBackendConnection resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param pulumi.Input[str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input['SecretBackendConnectionCassandraArgs'] cassandra: A nested block containing configuration options for Cassandra connections.
        :param pulumi.Input['SecretBackendConnectionCouchbaseArgs'] couchbase: A nested block containing configuration options for Couchbase connections.
        :param pulumi.Input[Mapping[str, Any]] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param pulumi.Input['SecretBackendConnectionElasticsearchArgs'] elasticsearch: A nested block containing configuration options for Elasticsearch connections.
        :param pulumi.Input['SecretBackendConnectionHanaArgs'] hana: A nested block containing configuration options for SAP HanaDB connections.
        :param pulumi.Input['SecretBackendConnectionInfluxdbArgs'] influxdb: A nested block containing configuration options for InfluxDB connections.
        :param pulumi.Input['SecretBackendConnectionMongodbArgs'] mongodb: A nested block containing configuration options for MongoDB connections.
        :param pulumi.Input['SecretBackendConnectionMongodbatlasArgs'] mongodbatlas: A nested block containing configuration options for MongoDB Atlas connections.
        :param pulumi.Input['SecretBackendConnectionMssqlArgs'] mssql: A nested block containing configuration options for MSSQL connections.
        :param pulumi.Input['SecretBackendConnectionMysqlArgs'] mysql: A nested block containing configuration options for MySQL connections.
        :param pulumi.Input['SecretBackendConnectionMysqlAuroraArgs'] mysql_aurora: A nested block containing configuration options for Aurora MySQL connections.
        :param pulumi.Input['SecretBackendConnectionMysqlLegacyArgs'] mysql_legacy: A nested block containing configuration options for legacy MySQL connections.
        :param pulumi.Input['SecretBackendConnectionMysqlRdsArgs'] mysql_rds: A nested block containing configuration options for RDS MySQL connections.
        :param pulumi.Input[str] name: A unique name to give the database connection.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input['SecretBackendConnectionOracleArgs'] oracle: A nested block containing configuration options for Oracle connections.
        :param pulumi.Input[str] plugin_name: Specifies the name of the plugin to use.
        :param pulumi.Input['SecretBackendConnectionPostgresqlArgs'] postgresql: A nested block containing configuration options for PostgreSQL connections.
        :param pulumi.Input['SecretBackendConnectionRedisArgs'] redis: A nested block containing configuration options for Redis connections.
        :param pulumi.Input['SecretBackendConnectionRedisElasticacheArgs'] redis_elasticache: A nested block containing configuration options for Redis ElastiCache connections.
               
               Exactly one of the nested blocks of configuration options must be supplied.
        :param pulumi.Input['SecretBackendConnectionRedshiftArgs'] redshift: Connection parameters for the redshift-database-plugin plugin.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param pulumi.Input['SecretBackendConnectionSnowflakeArgs'] snowflake: A nested block containing configuration options for Snowflake connections.
        :param pulumi.Input[bool] verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if cassandra is not None:
            pulumi.set(__self__, "cassandra", cassandra)
        if couchbase is not None:
            pulumi.set(__self__, "couchbase", couchbase)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if elasticsearch is not None:
            pulumi.set(__self__, "elasticsearch", elasticsearch)
        if hana is not None:
            pulumi.set(__self__, "hana", hana)
        if influxdb is not None:
            pulumi.set(__self__, "influxdb", influxdb)
        if mongodb is not None:
            pulumi.set(__self__, "mongodb", mongodb)
        if mongodbatlas is not None:
            pulumi.set(__self__, "mongodbatlas", mongodbatlas)
        if mssql is not None:
            pulumi.set(__self__, "mssql", mssql)
        if mysql is not None:
            pulumi.set(__self__, "mysql", mysql)
        if mysql_aurora is not None:
            pulumi.set(__self__, "mysql_aurora", mysql_aurora)
        if mysql_legacy is not None:
            pulumi.set(__self__, "mysql_legacy", mysql_legacy)
        if mysql_rds is not None:
            pulumi.set(__self__, "mysql_rds", mysql_rds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if oracle is not None:
            pulumi.set(__self__, "oracle", oracle)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if postgresql is not None:
            pulumi.set(__self__, "postgresql", postgresql)
        if redis is not None:
            pulumi.set(__self__, "redis", redis)
        if redis_elasticache is not None:
            pulumi.set(__self__, "redis_elasticache", redis_elasticache)
        if redshift is not None:
            pulumi.set(__self__, "redshift", redshift)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if snowflake is not None:
            pulumi.set(__self__, "snowflake", snowflake)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @allowed_roles.setter
    def allowed_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_roles", value)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the Vault mount to configure.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter
    def cassandra(self) -> Optional[pulumi.Input['SecretBackendConnectionCassandraArgs']]:
        """
        A nested block containing configuration options for Cassandra connections.
        """
        return pulumi.get(self, "cassandra")

    @cassandra.setter
    def cassandra(self, value: Optional[pulumi.Input['SecretBackendConnectionCassandraArgs']]):
        pulumi.set(self, "cassandra", value)

    @property
    @pulumi.getter
    def couchbase(self) -> Optional[pulumi.Input['SecretBackendConnectionCouchbaseArgs']]:
        """
        A nested block containing configuration options for Couchbase connections.
        """
        return pulumi.get(self, "couchbase")

    @couchbase.setter
    def couchbase(self, value: Optional[pulumi.Input['SecretBackendConnectionCouchbaseArgs']]):
        pulumi.set(self, "couchbase", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def elasticsearch(self) -> Optional[pulumi.Input['SecretBackendConnectionElasticsearchArgs']]:
        """
        A nested block containing configuration options for Elasticsearch connections.
        """
        return pulumi.get(self, "elasticsearch")

    @elasticsearch.setter
    def elasticsearch(self, value: Optional[pulumi.Input['SecretBackendConnectionElasticsearchArgs']]):
        pulumi.set(self, "elasticsearch", value)

    @property
    @pulumi.getter
    def hana(self) -> Optional[pulumi.Input['SecretBackendConnectionHanaArgs']]:
        """
        A nested block containing configuration options for SAP HanaDB connections.
        """
        return pulumi.get(self, "hana")

    @hana.setter
    def hana(self, value: Optional[pulumi.Input['SecretBackendConnectionHanaArgs']]):
        pulumi.set(self, "hana", value)

    @property
    @pulumi.getter
    def influxdb(self) -> Optional[pulumi.Input['SecretBackendConnectionInfluxdbArgs']]:
        """
        A nested block containing configuration options for InfluxDB connections.
        """
        return pulumi.get(self, "influxdb")

    @influxdb.setter
    def influxdb(self, value: Optional[pulumi.Input['SecretBackendConnectionInfluxdbArgs']]):
        pulumi.set(self, "influxdb", value)

    @property
    @pulumi.getter
    def mongodb(self) -> Optional[pulumi.Input['SecretBackendConnectionMongodbArgs']]:
        """
        A nested block containing configuration options for MongoDB connections.
        """
        return pulumi.get(self, "mongodb")

    @mongodb.setter
    def mongodb(self, value: Optional[pulumi.Input['SecretBackendConnectionMongodbArgs']]):
        pulumi.set(self, "mongodb", value)

    @property
    @pulumi.getter
    def mongodbatlas(self) -> Optional[pulumi.Input['SecretBackendConnectionMongodbatlasArgs']]:
        """
        A nested block containing configuration options for MongoDB Atlas connections.
        """
        return pulumi.get(self, "mongodbatlas")

    @mongodbatlas.setter
    def mongodbatlas(self, value: Optional[pulumi.Input['SecretBackendConnectionMongodbatlasArgs']]):
        pulumi.set(self, "mongodbatlas", value)

    @property
    @pulumi.getter
    def mssql(self) -> Optional[pulumi.Input['SecretBackendConnectionMssqlArgs']]:
        """
        A nested block containing configuration options for MSSQL connections.
        """
        return pulumi.get(self, "mssql")

    @mssql.setter
    def mssql(self, value: Optional[pulumi.Input['SecretBackendConnectionMssqlArgs']]):
        pulumi.set(self, "mssql", value)

    @property
    @pulumi.getter
    def mysql(self) -> Optional[pulumi.Input['SecretBackendConnectionMysqlArgs']]:
        """
        A nested block containing configuration options for MySQL connections.
        """
        return pulumi.get(self, "mysql")

    @mysql.setter
    def mysql(self, value: Optional[pulumi.Input['SecretBackendConnectionMysqlArgs']]):
        pulumi.set(self, "mysql", value)

    @property
    @pulumi.getter(name="mysqlAurora")
    def mysql_aurora(self) -> Optional[pulumi.Input['SecretBackendConnectionMysqlAuroraArgs']]:
        """
        A nested block containing configuration options for Aurora MySQL connections.
        """
        return pulumi.get(self, "mysql_aurora")

    @mysql_aurora.setter
    def mysql_aurora(self, value: Optional[pulumi.Input['SecretBackendConnectionMysqlAuroraArgs']]):
        pulumi.set(self, "mysql_aurora", value)

    @property
    @pulumi.getter(name="mysqlLegacy")
    def mysql_legacy(self) -> Optional[pulumi.Input['SecretBackendConnectionMysqlLegacyArgs']]:
        """
        A nested block containing configuration options for legacy MySQL connections.
        """
        return pulumi.get(self, "mysql_legacy")

    @mysql_legacy.setter
    def mysql_legacy(self, value: Optional[pulumi.Input['SecretBackendConnectionMysqlLegacyArgs']]):
        pulumi.set(self, "mysql_legacy", value)

    @property
    @pulumi.getter(name="mysqlRds")
    def mysql_rds(self) -> Optional[pulumi.Input['SecretBackendConnectionMysqlRdsArgs']]:
        """
        A nested block containing configuration options for RDS MySQL connections.
        """
        return pulumi.get(self, "mysql_rds")

    @mysql_rds.setter
    def mysql_rds(self, value: Optional[pulumi.Input['SecretBackendConnectionMysqlRdsArgs']]):
        pulumi.set(self, "mysql_rds", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name to give the database connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured namespace.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def oracle(self) -> Optional[pulumi.Input['SecretBackendConnectionOracleArgs']]:
        """
        A nested block containing configuration options for Oracle connections.
        """
        return pulumi.get(self, "oracle")

    @oracle.setter
    def oracle(self, value: Optional[pulumi.Input['SecretBackendConnectionOracleArgs']]):
        pulumi.set(self, "oracle", value)

    @property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @plugin_name.setter
    def plugin_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugin_name", value)

    @property
    @pulumi.getter
    def postgresql(self) -> Optional[pulumi.Input['SecretBackendConnectionPostgresqlArgs']]:
        """
        A nested block containing configuration options for PostgreSQL connections.
        """
        return pulumi.get(self, "postgresql")

    @postgresql.setter
    def postgresql(self, value: Optional[pulumi.Input['SecretBackendConnectionPostgresqlArgs']]):
        pulumi.set(self, "postgresql", value)

    @property
    @pulumi.getter
    def redis(self) -> Optional[pulumi.Input['SecretBackendConnectionRedisArgs']]:
        """
        A nested block containing configuration options for Redis connections.
        """
        return pulumi.get(self, "redis")

    @redis.setter
    def redis(self, value: Optional[pulumi.Input['SecretBackendConnectionRedisArgs']]):
        pulumi.set(self, "redis", value)

    @property
    @pulumi.getter(name="redisElasticache")
    def redis_elasticache(self) -> Optional[pulumi.Input['SecretBackendConnectionRedisElasticacheArgs']]:
        """
        A nested block containing configuration options for Redis ElastiCache connections.

        Exactly one of the nested blocks of configuration options must be supplied.
        """
        return pulumi.get(self, "redis_elasticache")

    @redis_elasticache.setter
    def redis_elasticache(self, value: Optional[pulumi.Input['SecretBackendConnectionRedisElasticacheArgs']]):
        pulumi.set(self, "redis_elasticache", value)

    @property
    @pulumi.getter
    def redshift(self) -> Optional[pulumi.Input['SecretBackendConnectionRedshiftArgs']]:
        """
        Connection parameters for the redshift-database-plugin plugin.
        """
        return pulumi.get(self, "redshift")

    @redshift.setter
    def redshift(self, value: Optional[pulumi.Input['SecretBackendConnectionRedshiftArgs']]):
        pulumi.set(self, "redshift", value)

    @property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @root_rotation_statements.setter
    def root_rotation_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "root_rotation_statements", value)

    @property
    @pulumi.getter
    def snowflake(self) -> Optional[pulumi.Input['SecretBackendConnectionSnowflakeArgs']]:
        """
        A nested block containing configuration options for Snowflake connections.
        """
        return pulumi.get(self, "snowflake")

    @snowflake.setter
    def snowflake(self, value: Optional[pulumi.Input['SecretBackendConnectionSnowflakeArgs']]):
        pulumi.set(self, "snowflake", value)

    @property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")

    @verify_connection.setter
    def verify_connection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verify_connection", value)


class SecretBackendConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 cassandra: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionCassandraArgs']]] = None,
                 couchbase: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionCouchbaseArgs']]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 elasticsearch: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionElasticsearchArgs']]] = None,
                 hana: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionHanaArgs']]] = None,
                 influxdb: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionInfluxdbArgs']]] = None,
                 mongodb: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMongodbArgs']]] = None,
                 mongodbatlas: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMongodbatlasArgs']]] = None,
                 mssql: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMssqlArgs']]] = None,
                 mysql: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlArgs']]] = None,
                 mysql_aurora: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlAuroraArgs']]] = None,
                 mysql_legacy: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlLegacyArgs']]] = None,
                 mysql_rds: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlRdsArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 oracle: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionOracleArgs']]] = None,
                 plugin_name: Optional[pulumi.Input[str]] = None,
                 postgresql: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionPostgresqlArgs']]] = None,
                 redis: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionRedisArgs']]] = None,
                 redis_elasticache: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionRedisElasticacheArgs']]] = None,
                 redshift: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionRedshiftArgs']]] = None,
                 root_rotation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snowflake: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionSnowflakeArgs']]] = None,
                 verify_connection: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        db = vault.Mount("db",
            path="postgres",
            type="database")
        postgres = vault.database.SecretBackendConnection("postgres",
            backend=db.path,
            name="postgres",
            allowed_roles=[
                "dev",
                "prod",
            ],
            postgresql=vault.database.SecretBackendConnectionPostgresqlArgs(
                connection_url="postgres://username:password@host:port/database",
            ))
        ```

        ## Import

        Database secret backend connections can be imported using the `backend`, `/config/`, and the `name` e.g.

        ```sh
        $ pulumi import vault:database/secretBackendConnection:SecretBackendConnection example postgres/config/postgres
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param pulumi.Input[str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionCassandraArgs']] cassandra: A nested block containing configuration options for Cassandra connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionCouchbaseArgs']] couchbase: A nested block containing configuration options for Couchbase connections.
        :param pulumi.Input[Mapping[str, Any]] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionElasticsearchArgs']] elasticsearch: A nested block containing configuration options for Elasticsearch connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionHanaArgs']] hana: A nested block containing configuration options for SAP HanaDB connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionInfluxdbArgs']] influxdb: A nested block containing configuration options for InfluxDB connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionMongodbArgs']] mongodb: A nested block containing configuration options for MongoDB connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionMongodbatlasArgs']] mongodbatlas: A nested block containing configuration options for MongoDB Atlas connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionMssqlArgs']] mssql: A nested block containing configuration options for MSSQL connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlArgs']] mysql: A nested block containing configuration options for MySQL connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlAuroraArgs']] mysql_aurora: A nested block containing configuration options for Aurora MySQL connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlLegacyArgs']] mysql_legacy: A nested block containing configuration options for legacy MySQL connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlRdsArgs']] mysql_rds: A nested block containing configuration options for RDS MySQL connections.
        :param pulumi.Input[str] name: A unique name to give the database connection.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionOracleArgs']] oracle: A nested block containing configuration options for Oracle connections.
        :param pulumi.Input[str] plugin_name: Specifies the name of the plugin to use.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionPostgresqlArgs']] postgresql: A nested block containing configuration options for PostgreSQL connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionRedisArgs']] redis: A nested block containing configuration options for Redis connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionRedisElasticacheArgs']] redis_elasticache: A nested block containing configuration options for Redis ElastiCache connections.
               
               Exactly one of the nested blocks of configuration options must be supplied.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionRedshiftArgs']] redshift: Connection parameters for the redshift-database-plugin plugin.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionSnowflakeArgs']] snowflake: A nested block containing configuration options for Snowflake connections.
        :param pulumi.Input[bool] verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        db = vault.Mount("db",
            path="postgres",
            type="database")
        postgres = vault.database.SecretBackendConnection("postgres",
            backend=db.path,
            name="postgres",
            allowed_roles=[
                "dev",
                "prod",
            ],
            postgresql=vault.database.SecretBackendConnectionPostgresqlArgs(
                connection_url="postgres://username:password@host:port/database",
            ))
        ```

        ## Import

        Database secret backend connections can be imported using the `backend`, `/config/`, and the `name` e.g.

        ```sh
        $ pulumi import vault:database/secretBackendConnection:SecretBackendConnection example postgres/config/postgres
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 cassandra: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionCassandraArgs']]] = None,
                 couchbase: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionCouchbaseArgs']]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 elasticsearch: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionElasticsearchArgs']]] = None,
                 hana: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionHanaArgs']]] = None,
                 influxdb: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionInfluxdbArgs']]] = None,
                 mongodb: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMongodbArgs']]] = None,
                 mongodbatlas: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMongodbatlasArgs']]] = None,
                 mssql: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMssqlArgs']]] = None,
                 mysql: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlArgs']]] = None,
                 mysql_aurora: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlAuroraArgs']]] = None,
                 mysql_legacy: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlLegacyArgs']]] = None,
                 mysql_rds: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlRdsArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 oracle: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionOracleArgs']]] = None,
                 plugin_name: Optional[pulumi.Input[str]] = None,
                 postgresql: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionPostgresqlArgs']]] = None,
                 redis: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionRedisArgs']]] = None,
                 redis_elasticache: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionRedisElasticacheArgs']]] = None,
                 redshift: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionRedshiftArgs']]] = None,
                 root_rotation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snowflake: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionSnowflakeArgs']]] = None,
                 verify_connection: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendConnectionArgs.__new__(SecretBackendConnectionArgs)

            __props__.__dict__["allowed_roles"] = allowed_roles
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["cassandra"] = cassandra
            __props__.__dict__["couchbase"] = couchbase
            __props__.__dict__["data"] = data
            __props__.__dict__["elasticsearch"] = elasticsearch
            __props__.__dict__["hana"] = hana
            __props__.__dict__["influxdb"] = influxdb
            __props__.__dict__["mongodb"] = mongodb
            __props__.__dict__["mongodbatlas"] = mongodbatlas
            __props__.__dict__["mssql"] = mssql
            __props__.__dict__["mysql"] = mysql
            __props__.__dict__["mysql_aurora"] = mysql_aurora
            __props__.__dict__["mysql_legacy"] = mysql_legacy
            __props__.__dict__["mysql_rds"] = mysql_rds
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["oracle"] = oracle
            __props__.__dict__["plugin_name"] = plugin_name
            __props__.__dict__["postgresql"] = postgresql
            __props__.__dict__["redis"] = redis
            __props__.__dict__["redis_elasticache"] = redis_elasticache
            __props__.__dict__["redshift"] = redshift
            __props__.__dict__["root_rotation_statements"] = root_rotation_statements
            __props__.__dict__["snowflake"] = snowflake
            __props__.__dict__["verify_connection"] = verify_connection
        super(SecretBackendConnection, __self__).__init__(
            'vault:database/secretBackendConnection:SecretBackendConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            backend: Optional[pulumi.Input[str]] = None,
            cassandra: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionCassandraArgs']]] = None,
            couchbase: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionCouchbaseArgs']]] = None,
            data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            elasticsearch: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionElasticsearchArgs']]] = None,
            hana: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionHanaArgs']]] = None,
            influxdb: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionInfluxdbArgs']]] = None,
            mongodb: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMongodbArgs']]] = None,
            mongodbatlas: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMongodbatlasArgs']]] = None,
            mssql: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMssqlArgs']]] = None,
            mysql: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlArgs']]] = None,
            mysql_aurora: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlAuroraArgs']]] = None,
            mysql_legacy: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlLegacyArgs']]] = None,
            mysql_rds: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlRdsArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            oracle: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionOracleArgs']]] = None,
            plugin_name: Optional[pulumi.Input[str]] = None,
            postgresql: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionPostgresqlArgs']]] = None,
            redis: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionRedisArgs']]] = None,
            redis_elasticache: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionRedisElasticacheArgs']]] = None,
            redshift: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionRedshiftArgs']]] = None,
            root_rotation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            snowflake: Optional[pulumi.Input[pulumi.InputType['SecretBackendConnectionSnowflakeArgs']]] = None,
            verify_connection: Optional[pulumi.Input[bool]] = None) -> 'SecretBackendConnection':
        """
        Get an existing SecretBackendConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param pulumi.Input[str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionCassandraArgs']] cassandra: A nested block containing configuration options for Cassandra connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionCouchbaseArgs']] couchbase: A nested block containing configuration options for Couchbase connections.
        :param pulumi.Input[Mapping[str, Any]] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionElasticsearchArgs']] elasticsearch: A nested block containing configuration options for Elasticsearch connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionHanaArgs']] hana: A nested block containing configuration options for SAP HanaDB connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionInfluxdbArgs']] influxdb: A nested block containing configuration options for InfluxDB connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionMongodbArgs']] mongodb: A nested block containing configuration options for MongoDB connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionMongodbatlasArgs']] mongodbatlas: A nested block containing configuration options for MongoDB Atlas connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionMssqlArgs']] mssql: A nested block containing configuration options for MSSQL connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlArgs']] mysql: A nested block containing configuration options for MySQL connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlAuroraArgs']] mysql_aurora: A nested block containing configuration options for Aurora MySQL connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlLegacyArgs']] mysql_legacy: A nested block containing configuration options for legacy MySQL connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionMysqlRdsArgs']] mysql_rds: A nested block containing configuration options for RDS MySQL connections.
        :param pulumi.Input[str] name: A unique name to give the database connection.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionOracleArgs']] oracle: A nested block containing configuration options for Oracle connections.
        :param pulumi.Input[str] plugin_name: Specifies the name of the plugin to use.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionPostgresqlArgs']] postgresql: A nested block containing configuration options for PostgreSQL connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionRedisArgs']] redis: A nested block containing configuration options for Redis connections.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionRedisElasticacheArgs']] redis_elasticache: A nested block containing configuration options for Redis ElastiCache connections.
               
               Exactly one of the nested blocks of configuration options must be supplied.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionRedshiftArgs']] redshift: Connection parameters for the redshift-database-plugin plugin.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param pulumi.Input[pulumi.InputType['SecretBackendConnectionSnowflakeArgs']] snowflake: A nested block containing configuration options for Snowflake connections.
        :param pulumi.Input[bool] verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendConnectionState.__new__(_SecretBackendConnectionState)

        __props__.__dict__["allowed_roles"] = allowed_roles
        __props__.__dict__["backend"] = backend
        __props__.__dict__["cassandra"] = cassandra
        __props__.__dict__["couchbase"] = couchbase
        __props__.__dict__["data"] = data
        __props__.__dict__["elasticsearch"] = elasticsearch
        __props__.__dict__["hana"] = hana
        __props__.__dict__["influxdb"] = influxdb
        __props__.__dict__["mongodb"] = mongodb
        __props__.__dict__["mongodbatlas"] = mongodbatlas
        __props__.__dict__["mssql"] = mssql
        __props__.__dict__["mysql"] = mysql
        __props__.__dict__["mysql_aurora"] = mysql_aurora
        __props__.__dict__["mysql_legacy"] = mysql_legacy
        __props__.__dict__["mysql_rds"] = mysql_rds
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["oracle"] = oracle
        __props__.__dict__["plugin_name"] = plugin_name
        __props__.__dict__["postgresql"] = postgresql
        __props__.__dict__["redis"] = redis
        __props__.__dict__["redis_elasticache"] = redis_elasticache
        __props__.__dict__["redshift"] = redshift
        __props__.__dict__["root_rotation_statements"] = root_rotation_statements
        __props__.__dict__["snowflake"] = snowflake
        __props__.__dict__["verify_connection"] = verify_connection
        return SecretBackendConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The unique name of the Vault mount to configure.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter
    def cassandra(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionCassandra']]:
        """
        A nested block containing configuration options for Cassandra connections.
        """
        return pulumi.get(self, "cassandra")

    @property
    @pulumi.getter
    def couchbase(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionCouchbase']]:
        """
        A nested block containing configuration options for Couchbase connections.
        """
        return pulumi.get(self, "couchbase")

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def elasticsearch(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionElasticsearch']]:
        """
        A nested block containing configuration options for Elasticsearch connections.
        """
        return pulumi.get(self, "elasticsearch")

    @property
    @pulumi.getter
    def hana(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionHana']]:
        """
        A nested block containing configuration options for SAP HanaDB connections.
        """
        return pulumi.get(self, "hana")

    @property
    @pulumi.getter
    def influxdb(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionInfluxdb']]:
        """
        A nested block containing configuration options for InfluxDB connections.
        """
        return pulumi.get(self, "influxdb")

    @property
    @pulumi.getter
    def mongodb(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionMongodb']]:
        """
        A nested block containing configuration options for MongoDB connections.
        """
        return pulumi.get(self, "mongodb")

    @property
    @pulumi.getter
    def mongodbatlas(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionMongodbatlas']]:
        """
        A nested block containing configuration options for MongoDB Atlas connections.
        """
        return pulumi.get(self, "mongodbatlas")

    @property
    @pulumi.getter
    def mssql(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionMssql']]:
        """
        A nested block containing configuration options for MSSQL connections.
        """
        return pulumi.get(self, "mssql")

    @property
    @pulumi.getter
    def mysql(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionMysql']]:
        """
        A nested block containing configuration options for MySQL connections.
        """
        return pulumi.get(self, "mysql")

    @property
    @pulumi.getter(name="mysqlAurora")
    def mysql_aurora(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionMysqlAurora']]:
        """
        A nested block containing configuration options for Aurora MySQL connections.
        """
        return pulumi.get(self, "mysql_aurora")

    @property
    @pulumi.getter(name="mysqlLegacy")
    def mysql_legacy(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionMysqlLegacy']]:
        """
        A nested block containing configuration options for legacy MySQL connections.
        """
        return pulumi.get(self, "mysql_legacy")

    @property
    @pulumi.getter(name="mysqlRds")
    def mysql_rds(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionMysqlRds']]:
        """
        A nested block containing configuration options for RDS MySQL connections.
        """
        return pulumi.get(self, "mysql_rds")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name to give the database connection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured namespace.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def oracle(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionOracle']]:
        """
        A nested block containing configuration options for Oracle connections.
        """
        return pulumi.get(self, "oracle")

    @property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @property
    @pulumi.getter
    def postgresql(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionPostgresql']]:
        """
        A nested block containing configuration options for PostgreSQL connections.
        """
        return pulumi.get(self, "postgresql")

    @property
    @pulumi.getter
    def redis(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionRedis']]:
        """
        A nested block containing configuration options for Redis connections.
        """
        return pulumi.get(self, "redis")

    @property
    @pulumi.getter(name="redisElasticache")
    def redis_elasticache(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionRedisElasticache']]:
        """
        A nested block containing configuration options for Redis ElastiCache connections.

        Exactly one of the nested blocks of configuration options must be supplied.
        """
        return pulumi.get(self, "redis_elasticache")

    @property
    @pulumi.getter
    def redshift(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionRedshift']]:
        """
        Connection parameters for the redshift-database-plugin plugin.
        """
        return pulumi.get(self, "redshift")

    @property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @property
    @pulumi.getter
    def snowflake(self) -> pulumi.Output[Optional['outputs.SecretBackendConnectionSnowflake']]:
        """
        A nested block containing configuration options for Snowflake connections.
        """
        return pulumi.get(self, "snowflake")

    @property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")

