# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetNamespacesResult',
    'AwaitableGetNamespacesResult',
    'get_namespaces',
    'get_namespaces_output',
]

@pulumi.output_type
class GetNamespacesResult:
    """
    A collection of values returned by getNamespaces.
    """
    def __init__(__self__, id=None, namespace=None, paths=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if paths and not isinstance(paths, list):
            raise TypeError("Expected argument 'paths' to be a list")
        pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def paths(self) -> Sequence[str]:
        """
        Set of the paths of direct child namespaces.
        """
        return pulumi.get(self, "paths")


class AwaitableGetNamespacesResult(GetNamespacesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespacesResult(
            id=self.id,
            namespace=self.namespace,
            paths=self.paths)


def get_namespaces(namespace: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespacesResult:
    """
    ## Example Usage

    ### Child namespaces

    ```python
    import pulumi
    import pulumi_vault as vault

    children = vault.get_namespaces()
    ```

    ### Nested namespace

    To fetch the details of nested namespaces:

    ```python
    import pulumi
    import pulumi_vault as vault

    children = vault.get_namespaces(namespace="parent")
    child = {__key: vault.get_namespace(namespace=children.namespace,
        path=__key) for __key, __value in children.paths}
    ```


    :param str namespace: The namespace to provision the resource in.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vault:index/getNamespaces:getNamespaces', __args__, opts=opts, typ=GetNamespacesResult).value

    return AwaitableGetNamespacesResult(
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        paths=pulumi.get(__ret__, 'paths'))


@_utilities.lift_output_func(get_namespaces)
def get_namespaces_output(namespace: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNamespacesResult]:
    """
    ## Example Usage

    ### Child namespaces

    ```python
    import pulumi
    import pulumi_vault as vault

    children = vault.get_namespaces()
    ```

    ### Nested namespace

    To fetch the details of nested namespaces:

    ```python
    import pulumi
    import pulumi_vault as vault

    children = vault.get_namespaces(namespace="parent")
    child = {__key: vault.get_namespace(namespace=children.namespace,
        path=__key) for __key, __value in children.paths}
    ```


    :param str namespace: The namespace to provision the resource in.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
    """
    ...
