# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['OidcProviderArgs', 'OidcProvider']

@pulumi.input_type
class OidcProviderArgs:
    def __init__(__self__, *,
                 allowed_client_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 https_enabled: Optional[pulumi.Input[bool]] = None,
                 issuer_host: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 scopes_supporteds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a OidcProvider resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_client_ids: The client IDs that are permitted to use the provider. 
               If empty, no clients are allowed. If `*`, all clients are allowed.
        :param pulumi.Input[bool] https_enabled: Set to true if the issuer endpoint uses HTTPS.
        :param pulumi.Input[str] issuer_host: The host for the issuer. Can be either host or host:port.
        :param pulumi.Input[str] name: The name of the provider.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes_supporteds: The scopes available for requesting on the provider.
        """
        if allowed_client_ids is not None:
            pulumi.set(__self__, "allowed_client_ids", allowed_client_ids)
        if https_enabled is not None:
            pulumi.set(__self__, "https_enabled", https_enabled)
        if issuer_host is not None:
            pulumi.set(__self__, "issuer_host", issuer_host)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if scopes_supporteds is not None:
            pulumi.set(__self__, "scopes_supporteds", scopes_supporteds)

    @property
    @pulumi.getter(name="allowedClientIds")
    def allowed_client_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The client IDs that are permitted to use the provider. 
        If empty, no clients are allowed. If `*`, all clients are allowed.
        """
        return pulumi.get(self, "allowed_client_ids")

    @allowed_client_ids.setter
    def allowed_client_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_client_ids", value)

    @property
    @pulumi.getter(name="httpsEnabled")
    def https_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the issuer endpoint uses HTTPS.
        """
        return pulumi.get(self, "https_enabled")

    @https_enabled.setter
    def https_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "https_enabled", value)

    @property
    @pulumi.getter(name="issuerHost")
    def issuer_host(self) -> Optional[pulumi.Input[str]]:
        """
        The host for the issuer. Can be either host or host:port.
        """
        return pulumi.get(self, "issuer_host")

    @issuer_host.setter
    def issuer_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_host", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="scopesSupporteds")
    def scopes_supporteds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The scopes available for requesting on the provider.
        """
        return pulumi.get(self, "scopes_supporteds")

    @scopes_supporteds.setter
    def scopes_supporteds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes_supporteds", value)


@pulumi.input_type
class _OidcProviderState:
    def __init__(__self__, *,
                 allowed_client_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 https_enabled: Optional[pulumi.Input[bool]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 issuer_host: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 scopes_supporteds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering OidcProvider resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_client_ids: The client IDs that are permitted to use the provider. 
               If empty, no clients are allowed. If `*`, all clients are allowed.
        :param pulumi.Input[bool] https_enabled: Set to true if the issuer endpoint uses HTTPS.
        :param pulumi.Input[str] issuer: Specifies what will be used as the `scheme://host:port`
               component for the `iss` claim of ID tokens. This value is computed using the
               `issuer_host` and `https_enabled` fields.
        :param pulumi.Input[str] issuer_host: The host for the issuer. Can be either host or host:port.
        :param pulumi.Input[str] name: The name of the provider.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes_supporteds: The scopes available for requesting on the provider.
        """
        if allowed_client_ids is not None:
            pulumi.set(__self__, "allowed_client_ids", allowed_client_ids)
        if https_enabled is not None:
            pulumi.set(__self__, "https_enabled", https_enabled)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if issuer_host is not None:
            pulumi.set(__self__, "issuer_host", issuer_host)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if scopes_supporteds is not None:
            pulumi.set(__self__, "scopes_supporteds", scopes_supporteds)

    @property
    @pulumi.getter(name="allowedClientIds")
    def allowed_client_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The client IDs that are permitted to use the provider. 
        If empty, no clients are allowed. If `*`, all clients are allowed.
        """
        return pulumi.get(self, "allowed_client_ids")

    @allowed_client_ids.setter
    def allowed_client_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_client_ids", value)

    @property
    @pulumi.getter(name="httpsEnabled")
    def https_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the issuer endpoint uses HTTPS.
        """
        return pulumi.get(self, "https_enabled")

    @https_enabled.setter
    def https_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "https_enabled", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies what will be used as the `scheme://host:port`
        component for the `iss` claim of ID tokens. This value is computed using the
        `issuer_host` and `https_enabled` fields.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="issuerHost")
    def issuer_host(self) -> Optional[pulumi.Input[str]]:
        """
        The host for the issuer. Can be either host or host:port.
        """
        return pulumi.get(self, "issuer_host")

    @issuer_host.setter
    def issuer_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_host", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="scopesSupporteds")
    def scopes_supporteds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The scopes available for requesting on the provider.
        """
        return pulumi.get(self, "scopes_supporteds")

    @scopes_supporteds.setter
    def scopes_supporteds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes_supporteds", value)


class OidcProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_client_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 https_enabled: Optional[pulumi.Input[bool]] = None,
                 issuer_host: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 scopes_supporteds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages OIDC Providers in a Vault server. See the [Vault documentation](https://www.vaultproject.io/api-docs/secret/identity/oidc-provider#create-or-update-an-assignment)
        for more information.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_vault as vault

        test = vault.identity.OidcKey("test",
            name="my-key",
            allowed_client_ids=["*"],
            rotation_period=3600,
            verification_ttl=3600)
        test_oidc_assignment = vault.identity.OidcAssignment("test",
            name="my-assignment",
            entity_ids=["fake-ascbascas-2231a-sdfaa"],
            group_ids=["fake-sajkdsad-32414-sfsada"])
        test_oidc_client = vault.identity.OidcClient("test",
            name="application",
            key=test.name,
            redirect_uris=[
                "http://127.0.0.1:9200/v1/auth-methods/oidc:authenticate:callback",
                "http://127.0.0.1:8251/callback",
                "http://127.0.0.1:8080/callback",
            ],
            assignments=[test_oidc_assignment.name],
            id_token_ttl=2400,
            access_token_ttl=7200)
        test_oidc_scope = vault.identity.OidcScope("test",
            name="groups",
            template=json.dumps({
                "groups": "{{identity.entity.groups.names}}",
            }),
            description="Groups scope.")
        test_oidc_provider = vault.identity.OidcProvider("test",
            name="my-provider",
            https_enabled=False,
            issuer_host="127.0.0.1:8200",
            allowed_client_ids=[test_oidc_client.client_id],
            scopes_supporteds=[test_oidc_scope.name])
        ```

        ## Import

        OIDC Providers can be imported using the `name`, e.g.

        ```sh
        $ pulumi import vault:identity/oidcProvider:OidcProvider test my-provider
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_client_ids: The client IDs that are permitted to use the provider. 
               If empty, no clients are allowed. If `*`, all clients are allowed.
        :param pulumi.Input[bool] https_enabled: Set to true if the issuer endpoint uses HTTPS.
        :param pulumi.Input[str] issuer_host: The host for the issuer. Can be either host or host:port.
        :param pulumi.Input[str] name: The name of the provider.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes_supporteds: The scopes available for requesting on the provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[OidcProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages OIDC Providers in a Vault server. See the [Vault documentation](https://www.vaultproject.io/api-docs/secret/identity/oidc-provider#create-or-update-an-assignment)
        for more information.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_vault as vault

        test = vault.identity.OidcKey("test",
            name="my-key",
            allowed_client_ids=["*"],
            rotation_period=3600,
            verification_ttl=3600)
        test_oidc_assignment = vault.identity.OidcAssignment("test",
            name="my-assignment",
            entity_ids=["fake-ascbascas-2231a-sdfaa"],
            group_ids=["fake-sajkdsad-32414-sfsada"])
        test_oidc_client = vault.identity.OidcClient("test",
            name="application",
            key=test.name,
            redirect_uris=[
                "http://127.0.0.1:9200/v1/auth-methods/oidc:authenticate:callback",
                "http://127.0.0.1:8251/callback",
                "http://127.0.0.1:8080/callback",
            ],
            assignments=[test_oidc_assignment.name],
            id_token_ttl=2400,
            access_token_ttl=7200)
        test_oidc_scope = vault.identity.OidcScope("test",
            name="groups",
            template=json.dumps({
                "groups": "{{identity.entity.groups.names}}",
            }),
            description="Groups scope.")
        test_oidc_provider = vault.identity.OidcProvider("test",
            name="my-provider",
            https_enabled=False,
            issuer_host="127.0.0.1:8200",
            allowed_client_ids=[test_oidc_client.client_id],
            scopes_supporteds=[test_oidc_scope.name])
        ```

        ## Import

        OIDC Providers can be imported using the `name`, e.g.

        ```sh
        $ pulumi import vault:identity/oidcProvider:OidcProvider test my-provider
        ```

        :param str resource_name: The name of the resource.
        :param OidcProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OidcProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_client_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 https_enabled: Optional[pulumi.Input[bool]] = None,
                 issuer_host: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 scopes_supporteds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OidcProviderArgs.__new__(OidcProviderArgs)

            __props__.__dict__["allowed_client_ids"] = allowed_client_ids
            __props__.__dict__["https_enabled"] = https_enabled
            __props__.__dict__["issuer_host"] = issuer_host
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["scopes_supporteds"] = scopes_supporteds
            __props__.__dict__["issuer"] = None
        super(OidcProvider, __self__).__init__(
            'vault:identity/oidcProvider:OidcProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_client_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            https_enabled: Optional[pulumi.Input[bool]] = None,
            issuer: Optional[pulumi.Input[str]] = None,
            issuer_host: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            scopes_supporteds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'OidcProvider':
        """
        Get an existing OidcProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_client_ids: The client IDs that are permitted to use the provider. 
               If empty, no clients are allowed. If `*`, all clients are allowed.
        :param pulumi.Input[bool] https_enabled: Set to true if the issuer endpoint uses HTTPS.
        :param pulumi.Input[str] issuer: Specifies what will be used as the `scheme://host:port`
               component for the `iss` claim of ID tokens. This value is computed using the
               `issuer_host` and `https_enabled` fields.
        :param pulumi.Input[str] issuer_host: The host for the issuer. Can be either host or host:port.
        :param pulumi.Input[str] name: The name of the provider.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes_supporteds: The scopes available for requesting on the provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OidcProviderState.__new__(_OidcProviderState)

        __props__.__dict__["allowed_client_ids"] = allowed_client_ids
        __props__.__dict__["https_enabled"] = https_enabled
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["issuer_host"] = issuer_host
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["scopes_supporteds"] = scopes_supporteds
        return OidcProvider(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedClientIds")
    def allowed_client_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The client IDs that are permitted to use the provider. 
        If empty, no clients are allowed. If `*`, all clients are allowed.
        """
        return pulumi.get(self, "allowed_client_ids")

    @property
    @pulumi.getter(name="httpsEnabled")
    def https_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to true if the issuer endpoint uses HTTPS.
        """
        return pulumi.get(self, "https_enabled")

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[str]:
        """
        Specifies what will be used as the `scheme://host:port`
        component for the `iss` claim of ID tokens. This value is computed using the
        `issuer_host` and `https_enabled` fields.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="issuerHost")
    def issuer_host(self) -> pulumi.Output[Optional[str]]:
        """
        The host for the issuer. Can be either host or host:port.
        """
        return pulumi.get(self, "issuer_host")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the provider.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="scopesSupporteds")
    def scopes_supporteds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The scopes available for requesting on the provider.
        """
        return pulumi.get(self, "scopes_supporteds")

