# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecretBackendRoleArgs', 'SecretBackendRole']

@pulumi.input_type
class SecretBackendRoleArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[str],
                 allowed_kubernetes_namespace_selector: Optional[pulumi.Input[str]] = None,
                 allowed_kubernetes_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extra_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 extra_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 generated_role_rules: Optional[pulumi.Input[str]] = None,
                 kubernetes_role_name: Optional[pulumi.Input[str]] = None,
                 kubernetes_role_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_template: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 service_account_name: Optional[pulumi.Input[str]] = None,
                 token_default_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a SecretBackendRole resource.
        :param pulumi.Input[str] backend: The path of the Kubernetes Secrets Engine backend mount to create
               the role in.
        :param pulumi.Input[str] allowed_kubernetes_namespace_selector: A label selector for Kubernetes namespaces 
               in which credentials can be generated. Accepts either a JSON or YAML object. The value should be
               of type [LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.24/#labelselector-v1-meta).
               If set with `allowed_kubernetes_namespace`, the conditions are `OR`ed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_kubernetes_namespaces: The list of Kubernetes namespaces this role 
               can generate credentials for. If set to `*` all namespaces are allowed. If set with
               `allowed_kubernetes_namespace_selector`, the conditions are `OR`ed.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extra_annotations: Additional annotations to apply to all generated 
               Kubernetes objects.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extra_labels: Additional labels to apply to all generated Kubernetes 
               objects.
               
               This resource also directly accepts all Mount fields.
        :param pulumi.Input[str] generated_role_rules: The Role or ClusterRole rules to use when generating 
               a role. Accepts either JSON or YAML formatted rules. Mutually exclusive with `service_account_name`
               and `kubernetes_role_name`. If set, the entire chain of Kubernetes objects will be generated
               when credentials are requested.
        :param pulumi.Input[str] kubernetes_role_name: The pre-existing Role or ClusterRole to bind a 
               generated service account to. Mutually exclusive with `service_account_name` and
               `generated_role_rules`. If set, Kubernetes token, service account, and role
               binding objects will be created when credentials are requested.
        :param pulumi.Input[str] kubernetes_role_type: Specifies whether the Kubernetes role is a Role or 
               ClusterRole.
        :param pulumi.Input[str] name: The name of the role.
        :param pulumi.Input[str] name_template: The name template to use when generating service accounts, 
               roles and role bindings. If unset, a default template is used.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] service_account_name: The pre-existing service account to generate tokens for.
               Mutually exclusive with `kubernetes_role_name` and `generated_role_rules`. If set, only a
               Kubernetes token will be created when credentials are requested.
        :param pulumi.Input[int] token_default_ttl: The default TTL for generated Kubernetes tokens in seconds.
        :param pulumi.Input[int] token_max_ttl: The maximum TTL for generated Kubernetes tokens in seconds.
        """
        pulumi.set(__self__, "backend", backend)
        if allowed_kubernetes_namespace_selector is not None:
            pulumi.set(__self__, "allowed_kubernetes_namespace_selector", allowed_kubernetes_namespace_selector)
        if allowed_kubernetes_namespaces is not None:
            pulumi.set(__self__, "allowed_kubernetes_namespaces", allowed_kubernetes_namespaces)
        if extra_annotations is not None:
            pulumi.set(__self__, "extra_annotations", extra_annotations)
        if extra_labels is not None:
            pulumi.set(__self__, "extra_labels", extra_labels)
        if generated_role_rules is not None:
            pulumi.set(__self__, "generated_role_rules", generated_role_rules)
        if kubernetes_role_name is not None:
            pulumi.set(__self__, "kubernetes_role_name", kubernetes_role_name)
        if kubernetes_role_type is not None:
            pulumi.set(__self__, "kubernetes_role_type", kubernetes_role_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_template is not None:
            pulumi.set(__self__, "name_template", name_template)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if service_account_name is not None:
            pulumi.set(__self__, "service_account_name", service_account_name)
        if token_default_ttl is not None:
            pulumi.set(__self__, "token_default_ttl", token_default_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[str]:
        """
        The path of the Kubernetes Secrets Engine backend mount to create
        the role in.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="allowedKubernetesNamespaceSelector")
    def allowed_kubernetes_namespace_selector(self) -> Optional[pulumi.Input[str]]:
        """
        A label selector for Kubernetes namespaces 
        in which credentials can be generated. Accepts either a JSON or YAML object. The value should be
        of type [LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.24/#labelselector-v1-meta).
        If set with `allowed_kubernetes_namespace`, the conditions are `OR`ed.
        """
        return pulumi.get(self, "allowed_kubernetes_namespace_selector")

    @allowed_kubernetes_namespace_selector.setter
    def allowed_kubernetes_namespace_selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_kubernetes_namespace_selector", value)

    @property
    @pulumi.getter(name="allowedKubernetesNamespaces")
    def allowed_kubernetes_namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Kubernetes namespaces this role 
        can generate credentials for. If set to `*` all namespaces are allowed. If set with
        `allowed_kubernetes_namespace_selector`, the conditions are `OR`ed.
        """
        return pulumi.get(self, "allowed_kubernetes_namespaces")

    @allowed_kubernetes_namespaces.setter
    def allowed_kubernetes_namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_kubernetes_namespaces", value)

    @property
    @pulumi.getter(name="extraAnnotations")
    def extra_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional annotations to apply to all generated 
        Kubernetes objects.
        """
        return pulumi.get(self, "extra_annotations")

    @extra_annotations.setter
    def extra_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "extra_annotations", value)

    @property
    @pulumi.getter(name="extraLabels")
    def extra_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional labels to apply to all generated Kubernetes 
        objects.

        This resource also directly accepts all Mount fields.
        """
        return pulumi.get(self, "extra_labels")

    @extra_labels.setter
    def extra_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "extra_labels", value)

    @property
    @pulumi.getter(name="generatedRoleRules")
    def generated_role_rules(self) -> Optional[pulumi.Input[str]]:
        """
        The Role or ClusterRole rules to use when generating 
        a role. Accepts either JSON or YAML formatted rules. Mutually exclusive with `service_account_name`
        and `kubernetes_role_name`. If set, the entire chain of Kubernetes objects will be generated
        when credentials are requested.
        """
        return pulumi.get(self, "generated_role_rules")

    @generated_role_rules.setter
    def generated_role_rules(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generated_role_rules", value)

    @property
    @pulumi.getter(name="kubernetesRoleName")
    def kubernetes_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The pre-existing Role or ClusterRole to bind a 
        generated service account to. Mutually exclusive with `service_account_name` and
        `generated_role_rules`. If set, Kubernetes token, service account, and role
        binding objects will be created when credentials are requested.
        """
        return pulumi.get(self, "kubernetes_role_name")

    @kubernetes_role_name.setter
    def kubernetes_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_role_name", value)

    @property
    @pulumi.getter(name="kubernetesRoleType")
    def kubernetes_role_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the Kubernetes role is a Role or 
        ClusterRole.
        """
        return pulumi.get(self, "kubernetes_role_type")

    @kubernetes_role_type.setter
    def kubernetes_role_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_role_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nameTemplate")
    def name_template(self) -> Optional[pulumi.Input[str]]:
        """
        The name template to use when generating service accounts, 
        roles and role bindings. If unset, a default template is used.
        """
        return pulumi.get(self, "name_template")

    @name_template.setter
    def name_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_template", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        The pre-existing service account to generate tokens for.
        Mutually exclusive with `kubernetes_role_name` and `generated_role_rules`. If set, only a
        Kubernetes token will be created when credentials are requested.
        """
        return pulumi.get(self, "service_account_name")

    @service_account_name.setter
    def service_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_name", value)

    @property
    @pulumi.getter(name="tokenDefaultTtl")
    def token_default_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The default TTL for generated Kubernetes tokens in seconds.
        """
        return pulumi.get(self, "token_default_ttl")

    @token_default_ttl.setter
    def token_default_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_default_ttl", value)

    @property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum TTL for generated Kubernetes tokens in seconds.
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_max_ttl", value)


@pulumi.input_type
class _SecretBackendRoleState:
    def __init__(__self__, *,
                 allowed_kubernetes_namespace_selector: Optional[pulumi.Input[str]] = None,
                 allowed_kubernetes_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 extra_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 extra_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 generated_role_rules: Optional[pulumi.Input[str]] = None,
                 kubernetes_role_name: Optional[pulumi.Input[str]] = None,
                 kubernetes_role_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_template: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 service_account_name: Optional[pulumi.Input[str]] = None,
                 token_default_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering SecretBackendRole resources.
        :param pulumi.Input[str] allowed_kubernetes_namespace_selector: A label selector for Kubernetes namespaces 
               in which credentials can be generated. Accepts either a JSON or YAML object. The value should be
               of type [LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.24/#labelselector-v1-meta).
               If set with `allowed_kubernetes_namespace`, the conditions are `OR`ed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_kubernetes_namespaces: The list of Kubernetes namespaces this role 
               can generate credentials for. If set to `*` all namespaces are allowed. If set with
               `allowed_kubernetes_namespace_selector`, the conditions are `OR`ed.
        :param pulumi.Input[str] backend: The path of the Kubernetes Secrets Engine backend mount to create
               the role in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extra_annotations: Additional annotations to apply to all generated 
               Kubernetes objects.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extra_labels: Additional labels to apply to all generated Kubernetes 
               objects.
               
               This resource also directly accepts all Mount fields.
        :param pulumi.Input[str] generated_role_rules: The Role or ClusterRole rules to use when generating 
               a role. Accepts either JSON or YAML formatted rules. Mutually exclusive with `service_account_name`
               and `kubernetes_role_name`. If set, the entire chain of Kubernetes objects will be generated
               when credentials are requested.
        :param pulumi.Input[str] kubernetes_role_name: The pre-existing Role or ClusterRole to bind a 
               generated service account to. Mutually exclusive with `service_account_name` and
               `generated_role_rules`. If set, Kubernetes token, service account, and role
               binding objects will be created when credentials are requested.
        :param pulumi.Input[str] kubernetes_role_type: Specifies whether the Kubernetes role is a Role or 
               ClusterRole.
        :param pulumi.Input[str] name: The name of the role.
        :param pulumi.Input[str] name_template: The name template to use when generating service accounts, 
               roles and role bindings. If unset, a default template is used.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] service_account_name: The pre-existing service account to generate tokens for.
               Mutually exclusive with `kubernetes_role_name` and `generated_role_rules`. If set, only a
               Kubernetes token will be created when credentials are requested.
        :param pulumi.Input[int] token_default_ttl: The default TTL for generated Kubernetes tokens in seconds.
        :param pulumi.Input[int] token_max_ttl: The maximum TTL for generated Kubernetes tokens in seconds.
        """
        if allowed_kubernetes_namespace_selector is not None:
            pulumi.set(__self__, "allowed_kubernetes_namespace_selector", allowed_kubernetes_namespace_selector)
        if allowed_kubernetes_namespaces is not None:
            pulumi.set(__self__, "allowed_kubernetes_namespaces", allowed_kubernetes_namespaces)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if extra_annotations is not None:
            pulumi.set(__self__, "extra_annotations", extra_annotations)
        if extra_labels is not None:
            pulumi.set(__self__, "extra_labels", extra_labels)
        if generated_role_rules is not None:
            pulumi.set(__self__, "generated_role_rules", generated_role_rules)
        if kubernetes_role_name is not None:
            pulumi.set(__self__, "kubernetes_role_name", kubernetes_role_name)
        if kubernetes_role_type is not None:
            pulumi.set(__self__, "kubernetes_role_type", kubernetes_role_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_template is not None:
            pulumi.set(__self__, "name_template", name_template)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if service_account_name is not None:
            pulumi.set(__self__, "service_account_name", service_account_name)
        if token_default_ttl is not None:
            pulumi.set(__self__, "token_default_ttl", token_default_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)

    @property
    @pulumi.getter(name="allowedKubernetesNamespaceSelector")
    def allowed_kubernetes_namespace_selector(self) -> Optional[pulumi.Input[str]]:
        """
        A label selector for Kubernetes namespaces 
        in which credentials can be generated. Accepts either a JSON or YAML object. The value should be
        of type [LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.24/#labelselector-v1-meta).
        If set with `allowed_kubernetes_namespace`, the conditions are `OR`ed.
        """
        return pulumi.get(self, "allowed_kubernetes_namespace_selector")

    @allowed_kubernetes_namespace_selector.setter
    def allowed_kubernetes_namespace_selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_kubernetes_namespace_selector", value)

    @property
    @pulumi.getter(name="allowedKubernetesNamespaces")
    def allowed_kubernetes_namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Kubernetes namespaces this role 
        can generate credentials for. If set to `*` all namespaces are allowed. If set with
        `allowed_kubernetes_namespace_selector`, the conditions are `OR`ed.
        """
        return pulumi.get(self, "allowed_kubernetes_namespaces")

    @allowed_kubernetes_namespaces.setter
    def allowed_kubernetes_namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_kubernetes_namespaces", value)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the Kubernetes Secrets Engine backend mount to create
        the role in.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="extraAnnotations")
    def extra_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional annotations to apply to all generated 
        Kubernetes objects.
        """
        return pulumi.get(self, "extra_annotations")

    @extra_annotations.setter
    def extra_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "extra_annotations", value)

    @property
    @pulumi.getter(name="extraLabels")
    def extra_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional labels to apply to all generated Kubernetes 
        objects.

        This resource also directly accepts all Mount fields.
        """
        return pulumi.get(self, "extra_labels")

    @extra_labels.setter
    def extra_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "extra_labels", value)

    @property
    @pulumi.getter(name="generatedRoleRules")
    def generated_role_rules(self) -> Optional[pulumi.Input[str]]:
        """
        The Role or ClusterRole rules to use when generating 
        a role. Accepts either JSON or YAML formatted rules. Mutually exclusive with `service_account_name`
        and `kubernetes_role_name`. If set, the entire chain of Kubernetes objects will be generated
        when credentials are requested.
        """
        return pulumi.get(self, "generated_role_rules")

    @generated_role_rules.setter
    def generated_role_rules(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generated_role_rules", value)

    @property
    @pulumi.getter(name="kubernetesRoleName")
    def kubernetes_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The pre-existing Role or ClusterRole to bind a 
        generated service account to. Mutually exclusive with `service_account_name` and
        `generated_role_rules`. If set, Kubernetes token, service account, and role
        binding objects will be created when credentials are requested.
        """
        return pulumi.get(self, "kubernetes_role_name")

    @kubernetes_role_name.setter
    def kubernetes_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_role_name", value)

    @property
    @pulumi.getter(name="kubernetesRoleType")
    def kubernetes_role_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the Kubernetes role is a Role or 
        ClusterRole.
        """
        return pulumi.get(self, "kubernetes_role_type")

    @kubernetes_role_type.setter
    def kubernetes_role_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_role_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nameTemplate")
    def name_template(self) -> Optional[pulumi.Input[str]]:
        """
        The name template to use when generating service accounts, 
        roles and role bindings. If unset, a default template is used.
        """
        return pulumi.get(self, "name_template")

    @name_template.setter
    def name_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_template", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        The pre-existing service account to generate tokens for.
        Mutually exclusive with `kubernetes_role_name` and `generated_role_rules`. If set, only a
        Kubernetes token will be created when credentials are requested.
        """
        return pulumi.get(self, "service_account_name")

    @service_account_name.setter
    def service_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_name", value)

    @property
    @pulumi.getter(name="tokenDefaultTtl")
    def token_default_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The default TTL for generated Kubernetes tokens in seconds.
        """
        return pulumi.get(self, "token_default_ttl")

    @token_default_ttl.setter
    def token_default_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_default_ttl", value)

    @property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum TTL for generated Kubernetes tokens in seconds.
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_max_ttl", value)


class SecretBackendRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_kubernetes_namespace_selector: Optional[pulumi.Input[str]] = None,
                 allowed_kubernetes_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 extra_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 extra_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 generated_role_rules: Optional[pulumi.Input[str]] = None,
                 kubernetes_role_name: Optional[pulumi.Input[str]] = None,
                 kubernetes_role_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_template: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 service_account_name: Optional[pulumi.Input[str]] = None,
                 token_default_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        ## Example Usage

        Example using `service_account_name` mode:

        ```python
        import pulumi
        import pulumi_std as std
        import pulumi_vault as vault

        config = vault.kubernetes.SecretBackend("config",
            path="kubernetes",
            description="kubernetes secrets engine description",
            kubernetes_host="https://127.0.0.1:61233",
            kubernetes_ca_cert=std.file(input="/path/to/cert").result,
            service_account_jwt=std.file(input="/path/to/token").result,
            disable_local_ca_jwt=False)
        sa_example = vault.kubernetes.SecretBackendRole("sa-example",
            backend=config.path,
            name="service-account-name-role",
            allowed_kubernetes_namespaces=["*"],
            token_max_ttl=43200,
            token_default_ttl=21600,
            service_account_name="test-service-account-with-generated-token",
            extra_labels={
                "id": "abc123",
                "name": "some_name",
            },
            extra_annotations={
                "env": "development",
                "location": "earth",
            })
        ```

        Example using `kubernetes_role_name` mode:

        ```python
        import pulumi
        import pulumi_std as std
        import pulumi_vault as vault

        config = vault.kubernetes.SecretBackend("config",
            path="kubernetes",
            description="kubernetes secrets engine description",
            kubernetes_host="https://127.0.0.1:61233",
            kubernetes_ca_cert=std.file(input="/path/to/cert").result,
            service_account_jwt=std.file(input="/path/to/token").result,
            disable_local_ca_jwt=False)
        name_example = vault.kubernetes.SecretBackendRole("name-example",
            backend=config.path,
            name="service-account-name-role",
            allowed_kubernetes_namespaces=["*"],
            token_max_ttl=43200,
            token_default_ttl=21600,
            kubernetes_role_name="vault-k8s-secrets-role",
            extra_labels={
                "id": "abc123",
                "name": "some_name",
            },
            extra_annotations={
                "env": "development",
                "location": "earth",
            })
        ```

        Example using `generated_role_rules` mode:

        ```python
        import pulumi
        import pulumi_std as std
        import pulumi_vault as vault

        config = vault.kubernetes.SecretBackend("config",
            path="kubernetes",
            description="kubernetes secrets engine description",
            kubernetes_host="https://127.0.0.1:61233",
            kubernetes_ca_cert=std.file(input="/path/to/cert").result,
            service_account_jwt=std.file(input="/path/to/token").result,
            disable_local_ca_jwt=False)
        rules_example = vault.kubernetes.SecretBackendRole("rules-example",
            backend=config.path,
            name="service-account-name-role",
            allowed_kubernetes_namespaces=["*"],
            token_max_ttl=43200,
            token_default_ttl=21600,
            kubernetes_role_type="Role",
            generated_role_rules=\"\"\"rules:
        - apiGroups: [""]
          resources: ["pods"]
          verbs: ["list"]
        \"\"\",
            extra_labels={
                "id": "abc123",
                "name": "some_name",
            },
            extra_annotations={
                "env": "development",
                "location": "earth",
            })
        ```

        ## Import

        The Kubernetes secret backend role can be imported using the full path to the role

        of the form: `<backend_path>/roles/<role_name>` e.g.

        ```sh
        $ pulumi import vault:kubernetes/secretBackendRole:SecretBackendRole example kubernetes kubernetes/roles/example-role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allowed_kubernetes_namespace_selector: A label selector for Kubernetes namespaces 
               in which credentials can be generated. Accepts either a JSON or YAML object. The value should be
               of type [LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.24/#labelselector-v1-meta).
               If set with `allowed_kubernetes_namespace`, the conditions are `OR`ed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_kubernetes_namespaces: The list of Kubernetes namespaces this role 
               can generate credentials for. If set to `*` all namespaces are allowed. If set with
               `allowed_kubernetes_namespace_selector`, the conditions are `OR`ed.
        :param pulumi.Input[str] backend: The path of the Kubernetes Secrets Engine backend mount to create
               the role in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extra_annotations: Additional annotations to apply to all generated 
               Kubernetes objects.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extra_labels: Additional labels to apply to all generated Kubernetes 
               objects.
               
               This resource also directly accepts all Mount fields.
        :param pulumi.Input[str] generated_role_rules: The Role or ClusterRole rules to use when generating 
               a role. Accepts either JSON or YAML formatted rules. Mutually exclusive with `service_account_name`
               and `kubernetes_role_name`. If set, the entire chain of Kubernetes objects will be generated
               when credentials are requested.
        :param pulumi.Input[str] kubernetes_role_name: The pre-existing Role or ClusterRole to bind a 
               generated service account to. Mutually exclusive with `service_account_name` and
               `generated_role_rules`. If set, Kubernetes token, service account, and role
               binding objects will be created when credentials are requested.
        :param pulumi.Input[str] kubernetes_role_type: Specifies whether the Kubernetes role is a Role or 
               ClusterRole.
        :param pulumi.Input[str] name: The name of the role.
        :param pulumi.Input[str] name_template: The name template to use when generating service accounts, 
               roles and role bindings. If unset, a default template is used.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] service_account_name: The pre-existing service account to generate tokens for.
               Mutually exclusive with `kubernetes_role_name` and `generated_role_rules`. If set, only a
               Kubernetes token will be created when credentials are requested.
        :param pulumi.Input[int] token_default_ttl: The default TTL for generated Kubernetes tokens in seconds.
        :param pulumi.Input[int] token_max_ttl: The maximum TTL for generated Kubernetes tokens in seconds.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        Example using `service_account_name` mode:

        ```python
        import pulumi
        import pulumi_std as std
        import pulumi_vault as vault

        config = vault.kubernetes.SecretBackend("config",
            path="kubernetes",
            description="kubernetes secrets engine description",
            kubernetes_host="https://127.0.0.1:61233",
            kubernetes_ca_cert=std.file(input="/path/to/cert").result,
            service_account_jwt=std.file(input="/path/to/token").result,
            disable_local_ca_jwt=False)
        sa_example = vault.kubernetes.SecretBackendRole("sa-example",
            backend=config.path,
            name="service-account-name-role",
            allowed_kubernetes_namespaces=["*"],
            token_max_ttl=43200,
            token_default_ttl=21600,
            service_account_name="test-service-account-with-generated-token",
            extra_labels={
                "id": "abc123",
                "name": "some_name",
            },
            extra_annotations={
                "env": "development",
                "location": "earth",
            })
        ```

        Example using `kubernetes_role_name` mode:

        ```python
        import pulumi
        import pulumi_std as std
        import pulumi_vault as vault

        config = vault.kubernetes.SecretBackend("config",
            path="kubernetes",
            description="kubernetes secrets engine description",
            kubernetes_host="https://127.0.0.1:61233",
            kubernetes_ca_cert=std.file(input="/path/to/cert").result,
            service_account_jwt=std.file(input="/path/to/token").result,
            disable_local_ca_jwt=False)
        name_example = vault.kubernetes.SecretBackendRole("name-example",
            backend=config.path,
            name="service-account-name-role",
            allowed_kubernetes_namespaces=["*"],
            token_max_ttl=43200,
            token_default_ttl=21600,
            kubernetes_role_name="vault-k8s-secrets-role",
            extra_labels={
                "id": "abc123",
                "name": "some_name",
            },
            extra_annotations={
                "env": "development",
                "location": "earth",
            })
        ```

        Example using `generated_role_rules` mode:

        ```python
        import pulumi
        import pulumi_std as std
        import pulumi_vault as vault

        config = vault.kubernetes.SecretBackend("config",
            path="kubernetes",
            description="kubernetes secrets engine description",
            kubernetes_host="https://127.0.0.1:61233",
            kubernetes_ca_cert=std.file(input="/path/to/cert").result,
            service_account_jwt=std.file(input="/path/to/token").result,
            disable_local_ca_jwt=False)
        rules_example = vault.kubernetes.SecretBackendRole("rules-example",
            backend=config.path,
            name="service-account-name-role",
            allowed_kubernetes_namespaces=["*"],
            token_max_ttl=43200,
            token_default_ttl=21600,
            kubernetes_role_type="Role",
            generated_role_rules=\"\"\"rules:
        - apiGroups: [""]
          resources: ["pods"]
          verbs: ["list"]
        \"\"\",
            extra_labels={
                "id": "abc123",
                "name": "some_name",
            },
            extra_annotations={
                "env": "development",
                "location": "earth",
            })
        ```

        ## Import

        The Kubernetes secret backend role can be imported using the full path to the role

        of the form: `<backend_path>/roles/<role_name>` e.g.

        ```sh
        $ pulumi import vault:kubernetes/secretBackendRole:SecretBackendRole example kubernetes kubernetes/roles/example-role
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_kubernetes_namespace_selector: Optional[pulumi.Input[str]] = None,
                 allowed_kubernetes_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 extra_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 extra_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 generated_role_rules: Optional[pulumi.Input[str]] = None,
                 kubernetes_role_name: Optional[pulumi.Input[str]] = None,
                 kubernetes_role_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_template: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 service_account_name: Optional[pulumi.Input[str]] = None,
                 token_default_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendRoleArgs.__new__(SecretBackendRoleArgs)

            __props__.__dict__["allowed_kubernetes_namespace_selector"] = allowed_kubernetes_namespace_selector
            __props__.__dict__["allowed_kubernetes_namespaces"] = allowed_kubernetes_namespaces
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["extra_annotations"] = extra_annotations
            __props__.__dict__["extra_labels"] = extra_labels
            __props__.__dict__["generated_role_rules"] = generated_role_rules
            __props__.__dict__["kubernetes_role_name"] = kubernetes_role_name
            __props__.__dict__["kubernetes_role_type"] = kubernetes_role_type
            __props__.__dict__["name"] = name
            __props__.__dict__["name_template"] = name_template
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["service_account_name"] = service_account_name
            __props__.__dict__["token_default_ttl"] = token_default_ttl
            __props__.__dict__["token_max_ttl"] = token_max_ttl
        super(SecretBackendRole, __self__).__init__(
            'vault:kubernetes/secretBackendRole:SecretBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_kubernetes_namespace_selector: Optional[pulumi.Input[str]] = None,
            allowed_kubernetes_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            backend: Optional[pulumi.Input[str]] = None,
            extra_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            extra_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            generated_role_rules: Optional[pulumi.Input[str]] = None,
            kubernetes_role_name: Optional[pulumi.Input[str]] = None,
            kubernetes_role_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_template: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            service_account_name: Optional[pulumi.Input[str]] = None,
            token_default_ttl: Optional[pulumi.Input[int]] = None,
            token_max_ttl: Optional[pulumi.Input[int]] = None) -> 'SecretBackendRole':
        """
        Get an existing SecretBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allowed_kubernetes_namespace_selector: A label selector for Kubernetes namespaces 
               in which credentials can be generated. Accepts either a JSON or YAML object. The value should be
               of type [LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.24/#labelselector-v1-meta).
               If set with `allowed_kubernetes_namespace`, the conditions are `OR`ed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_kubernetes_namespaces: The list of Kubernetes namespaces this role 
               can generate credentials for. If set to `*` all namespaces are allowed. If set with
               `allowed_kubernetes_namespace_selector`, the conditions are `OR`ed.
        :param pulumi.Input[str] backend: The path of the Kubernetes Secrets Engine backend mount to create
               the role in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extra_annotations: Additional annotations to apply to all generated 
               Kubernetes objects.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extra_labels: Additional labels to apply to all generated Kubernetes 
               objects.
               
               This resource also directly accepts all Mount fields.
        :param pulumi.Input[str] generated_role_rules: The Role or ClusterRole rules to use when generating 
               a role. Accepts either JSON or YAML formatted rules. Mutually exclusive with `service_account_name`
               and `kubernetes_role_name`. If set, the entire chain of Kubernetes objects will be generated
               when credentials are requested.
        :param pulumi.Input[str] kubernetes_role_name: The pre-existing Role or ClusterRole to bind a 
               generated service account to. Mutually exclusive with `service_account_name` and
               `generated_role_rules`. If set, Kubernetes token, service account, and role
               binding objects will be created when credentials are requested.
        :param pulumi.Input[str] kubernetes_role_type: Specifies whether the Kubernetes role is a Role or 
               ClusterRole.
        :param pulumi.Input[str] name: The name of the role.
        :param pulumi.Input[str] name_template: The name template to use when generating service accounts, 
               roles and role bindings. If unset, a default template is used.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] service_account_name: The pre-existing service account to generate tokens for.
               Mutually exclusive with `kubernetes_role_name` and `generated_role_rules`. If set, only a
               Kubernetes token will be created when credentials are requested.
        :param pulumi.Input[int] token_default_ttl: The default TTL for generated Kubernetes tokens in seconds.
        :param pulumi.Input[int] token_max_ttl: The maximum TTL for generated Kubernetes tokens in seconds.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendRoleState.__new__(_SecretBackendRoleState)

        __props__.__dict__["allowed_kubernetes_namespace_selector"] = allowed_kubernetes_namespace_selector
        __props__.__dict__["allowed_kubernetes_namespaces"] = allowed_kubernetes_namespaces
        __props__.__dict__["backend"] = backend
        __props__.__dict__["extra_annotations"] = extra_annotations
        __props__.__dict__["extra_labels"] = extra_labels
        __props__.__dict__["generated_role_rules"] = generated_role_rules
        __props__.__dict__["kubernetes_role_name"] = kubernetes_role_name
        __props__.__dict__["kubernetes_role_type"] = kubernetes_role_type
        __props__.__dict__["name"] = name
        __props__.__dict__["name_template"] = name_template
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["service_account_name"] = service_account_name
        __props__.__dict__["token_default_ttl"] = token_default_ttl
        __props__.__dict__["token_max_ttl"] = token_max_ttl
        return SecretBackendRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedKubernetesNamespaceSelector")
    def allowed_kubernetes_namespace_selector(self) -> pulumi.Output[Optional[str]]:
        """
        A label selector for Kubernetes namespaces 
        in which credentials can be generated. Accepts either a JSON or YAML object. The value should be
        of type [LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.24/#labelselector-v1-meta).
        If set with `allowed_kubernetes_namespace`, the conditions are `OR`ed.
        """
        return pulumi.get(self, "allowed_kubernetes_namespace_selector")

    @property
    @pulumi.getter(name="allowedKubernetesNamespaces")
    def allowed_kubernetes_namespaces(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of Kubernetes namespaces this role 
        can generate credentials for. If set to `*` all namespaces are allowed. If set with
        `allowed_kubernetes_namespace_selector`, the conditions are `OR`ed.
        """
        return pulumi.get(self, "allowed_kubernetes_namespaces")

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The path of the Kubernetes Secrets Engine backend mount to create
        the role in.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="extraAnnotations")
    def extra_annotations(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Additional annotations to apply to all generated 
        Kubernetes objects.
        """
        return pulumi.get(self, "extra_annotations")

    @property
    @pulumi.getter(name="extraLabels")
    def extra_labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Additional labels to apply to all generated Kubernetes 
        objects.

        This resource also directly accepts all Mount fields.
        """
        return pulumi.get(self, "extra_labels")

    @property
    @pulumi.getter(name="generatedRoleRules")
    def generated_role_rules(self) -> pulumi.Output[Optional[str]]:
        """
        The Role or ClusterRole rules to use when generating 
        a role. Accepts either JSON or YAML formatted rules. Mutually exclusive with `service_account_name`
        and `kubernetes_role_name`. If set, the entire chain of Kubernetes objects will be generated
        when credentials are requested.
        """
        return pulumi.get(self, "generated_role_rules")

    @property
    @pulumi.getter(name="kubernetesRoleName")
    def kubernetes_role_name(self) -> pulumi.Output[Optional[str]]:
        """
        The pre-existing Role or ClusterRole to bind a 
        generated service account to. Mutually exclusive with `service_account_name` and
        `generated_role_rules`. If set, Kubernetes token, service account, and role
        binding objects will be created when credentials are requested.
        """
        return pulumi.get(self, "kubernetes_role_name")

    @property
    @pulumi.getter(name="kubernetesRoleType")
    def kubernetes_role_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether the Kubernetes role is a Role or 
        ClusterRole.
        """
        return pulumi.get(self, "kubernetes_role_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameTemplate")
    def name_template(self) -> pulumi.Output[Optional[str]]:
        """
        The name template to use when generating service accounts, 
        roles and role bindings. If unset, a default template is used.
        """
        return pulumi.get(self, "name_template")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> pulumi.Output[Optional[str]]:
        """
        The pre-existing service account to generate tokens for.
        Mutually exclusive with `kubernetes_role_name` and `generated_role_rules`. If set, only a
        Kubernetes token will be created when credentials are requested.
        """
        return pulumi.get(self, "service_account_name")

    @property
    @pulumi.getter(name="tokenDefaultTtl")
    def token_default_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The default TTL for generated Kubernetes tokens in seconds.
        """
        return pulumi.get(self, "token_default_ttl")

    @property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum TTL for generated Kubernetes tokens in seconds.
        """
        return pulumi.get(self, "token_max_ttl")

