# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecretBackendDynamicRoleArgs', 'SecretBackendDynamicRole']

@pulumi.input_type
class SecretBackendDynamicRoleArgs:
    def __init__(__self__, *,
                 creation_ldif: pulumi.Input[str],
                 deletion_ldif: pulumi.Input[str],
                 role_name: pulumi.Input[str],
                 default_ttl: Optional[pulumi.Input[int]] = None,
                 max_ttl: Optional[pulumi.Input[int]] = None,
                 mount: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 rollback_ldif: Optional[pulumi.Input[str]] = None,
                 username_template: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecretBackendDynamicRole resource.
        :param pulumi.Input[str] creation_ldif: A templatized LDIF string used to create a user
               account. This may contain multiple LDIF entries. The `creation_ldif` can also
               be used to add the user account to an existing group. All LDIF entries are
               performed in order. If Vault encounters an error while executing the
               `creation_ldif` it will stop at the first error and not execute any remaining
               LDIF entries. If an error occurs and `rollback_ldif` is specified, the LDIF
               entries in `rollback_ldif` will be executed. See `rollback_ldif` for more
               details. This field may optionally be provided as a base64 encoded string.
        :param pulumi.Input[str] deletion_ldif: A templatized LDIF string used to delete the
               user account once its TTL has expired. This may contain multiple LDIF
               entries. All LDIF entries are performed in order. If Vault encounters an
               error while executing an entry in the `deletion_ldif` it will attempt to
               continue executing any remaining entries. This field may optionally be
               provided as a base64 encoded string.
        :param pulumi.Input[str] role_name: Name of the role.
        :param pulumi.Input[int] default_ttl: Specifies the TTL for the leases associated with this role.
        :param pulumi.Input[int] max_ttl: Specifies the maximum TTL for the leases associated with this role.
        :param pulumi.Input[str] mount: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `ldap`.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] rollback_ldif: A templatized LDIF string used to attempt to
               rollback any changes in the event that execution of the `creation_ldif` results
               in an error. This may contain multiple LDIF entries. All LDIF entries are
               performed in order. If Vault encounters an error while executing an entry in
               the `rollback_ldif` it will attempt to continue executing any remaining
               entries. This field may optionally be provided as a base64 encoded string.
        :param pulumi.Input[str] username_template: A template used to generate a dynamic
               username. This will be used to fill in the `.Username` field within the
               `creation_ldif` string.
        """
        pulumi.set(__self__, "creation_ldif", creation_ldif)
        pulumi.set(__self__, "deletion_ldif", deletion_ldif)
        pulumi.set(__self__, "role_name", role_name)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if rollback_ldif is not None:
            pulumi.set(__self__, "rollback_ldif", rollback_ldif)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @property
    @pulumi.getter(name="creationLdif")
    def creation_ldif(self) -> pulumi.Input[str]:
        """
        A templatized LDIF string used to create a user
        account. This may contain multiple LDIF entries. The `creation_ldif` can also
        be used to add the user account to an existing group. All LDIF entries are
        performed in order. If Vault encounters an error while executing the
        `creation_ldif` it will stop at the first error and not execute any remaining
        LDIF entries. If an error occurs and `rollback_ldif` is specified, the LDIF
        entries in `rollback_ldif` will be executed. See `rollback_ldif` for more
        details. This field may optionally be provided as a base64 encoded string.
        """
        return pulumi.get(self, "creation_ldif")

    @creation_ldif.setter
    def creation_ldif(self, value: pulumi.Input[str]):
        pulumi.set(self, "creation_ldif", value)

    @property
    @pulumi.getter(name="deletionLdif")
    def deletion_ldif(self) -> pulumi.Input[str]:
        """
        A templatized LDIF string used to delete the
        user account once its TTL has expired. This may contain multiple LDIF
        entries. All LDIF entries are performed in order. If Vault encounters an
        error while executing an entry in the `deletion_ldif` it will attempt to
        continue executing any remaining entries. This field may optionally be
        provided as a base64 encoded string.
        """
        return pulumi.get(self, "deletion_ldif")

    @deletion_ldif.setter
    def deletion_ldif(self, value: pulumi.Input[str]):
        pulumi.set(self, "deletion_ldif", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[str]:
        """
        Name of the role.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the TTL for the leases associated with this role.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_ttl", value)

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum TTL for the leases associated with this role.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ttl", value)

    @property
    @pulumi.getter
    def mount(self) -> Optional[pulumi.Input[str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `ldap`.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="rollbackLdif")
    def rollback_ldif(self) -> Optional[pulumi.Input[str]]:
        """
        A templatized LDIF string used to attempt to
        rollback any changes in the event that execution of the `creation_ldif` results
        in an error. This may contain multiple LDIF entries. All LDIF entries are
        performed in order. If Vault encounters an error while executing an entry in
        the `rollback_ldif` it will attempt to continue executing any remaining
        entries. This field may optionally be provided as a base64 encoded string.
        """
        return pulumi.get(self, "rollback_ldif")

    @rollback_ldif.setter
    def rollback_ldif(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rollback_ldif", value)

    @property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[pulumi.Input[str]]:
        """
        A template used to generate a dynamic
        username. This will be used to fill in the `.Username` field within the
        `creation_ldif` string.
        """
        return pulumi.get(self, "username_template")

    @username_template.setter
    def username_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_template", value)


@pulumi.input_type
class _SecretBackendDynamicRoleState:
    def __init__(__self__, *,
                 creation_ldif: Optional[pulumi.Input[str]] = None,
                 default_ttl: Optional[pulumi.Input[int]] = None,
                 deletion_ldif: Optional[pulumi.Input[str]] = None,
                 max_ttl: Optional[pulumi.Input[int]] = None,
                 mount: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 rollback_ldif: Optional[pulumi.Input[str]] = None,
                 username_template: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecretBackendDynamicRole resources.
        :param pulumi.Input[str] creation_ldif: A templatized LDIF string used to create a user
               account. This may contain multiple LDIF entries. The `creation_ldif` can also
               be used to add the user account to an existing group. All LDIF entries are
               performed in order. If Vault encounters an error while executing the
               `creation_ldif` it will stop at the first error and not execute any remaining
               LDIF entries. If an error occurs and `rollback_ldif` is specified, the LDIF
               entries in `rollback_ldif` will be executed. See `rollback_ldif` for more
               details. This field may optionally be provided as a base64 encoded string.
        :param pulumi.Input[int] default_ttl: Specifies the TTL for the leases associated with this role.
        :param pulumi.Input[str] deletion_ldif: A templatized LDIF string used to delete the
               user account once its TTL has expired. This may contain multiple LDIF
               entries. All LDIF entries are performed in order. If Vault encounters an
               error while executing an entry in the `deletion_ldif` it will attempt to
               continue executing any remaining entries. This field may optionally be
               provided as a base64 encoded string.
        :param pulumi.Input[int] max_ttl: Specifies the maximum TTL for the leases associated with this role.
        :param pulumi.Input[str] mount: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `ldap`.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] role_name: Name of the role.
        :param pulumi.Input[str] rollback_ldif: A templatized LDIF string used to attempt to
               rollback any changes in the event that execution of the `creation_ldif` results
               in an error. This may contain multiple LDIF entries. All LDIF entries are
               performed in order. If Vault encounters an error while executing an entry in
               the `rollback_ldif` it will attempt to continue executing any remaining
               entries. This field may optionally be provided as a base64 encoded string.
        :param pulumi.Input[str] username_template: A template used to generate a dynamic
               username. This will be used to fill in the `.Username` field within the
               `creation_ldif` string.
        """
        if creation_ldif is not None:
            pulumi.set(__self__, "creation_ldif", creation_ldif)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if deletion_ldif is not None:
            pulumi.set(__self__, "deletion_ldif", deletion_ldif)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if rollback_ldif is not None:
            pulumi.set(__self__, "rollback_ldif", rollback_ldif)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @property
    @pulumi.getter(name="creationLdif")
    def creation_ldif(self) -> Optional[pulumi.Input[str]]:
        """
        A templatized LDIF string used to create a user
        account. This may contain multiple LDIF entries. The `creation_ldif` can also
        be used to add the user account to an existing group. All LDIF entries are
        performed in order. If Vault encounters an error while executing the
        `creation_ldif` it will stop at the first error and not execute any remaining
        LDIF entries. If an error occurs and `rollback_ldif` is specified, the LDIF
        entries in `rollback_ldif` will be executed. See `rollback_ldif` for more
        details. This field may optionally be provided as a base64 encoded string.
        """
        return pulumi.get(self, "creation_ldif")

    @creation_ldif.setter
    def creation_ldif(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_ldif", value)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the TTL for the leases associated with this role.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_ttl", value)

    @property
    @pulumi.getter(name="deletionLdif")
    def deletion_ldif(self) -> Optional[pulumi.Input[str]]:
        """
        A templatized LDIF string used to delete the
        user account once its TTL has expired. This may contain multiple LDIF
        entries. All LDIF entries are performed in order. If Vault encounters an
        error while executing an entry in the `deletion_ldif` it will attempt to
        continue executing any remaining entries. This field may optionally be
        provided as a base64 encoded string.
        """
        return pulumi.get(self, "deletion_ldif")

    @deletion_ldif.setter
    def deletion_ldif(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_ldif", value)

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum TTL for the leases associated with this role.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ttl", value)

    @property
    @pulumi.getter
    def mount(self) -> Optional[pulumi.Input[str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `ldap`.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the role.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="rollbackLdif")
    def rollback_ldif(self) -> Optional[pulumi.Input[str]]:
        """
        A templatized LDIF string used to attempt to
        rollback any changes in the event that execution of the `creation_ldif` results
        in an error. This may contain multiple LDIF entries. All LDIF entries are
        performed in order. If Vault encounters an error while executing an entry in
        the `rollback_ldif` it will attempt to continue executing any remaining
        entries. This field may optionally be provided as a base64 encoded string.
        """
        return pulumi.get(self, "rollback_ldif")

    @rollback_ldif.setter
    def rollback_ldif(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rollback_ldif", value)

    @property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[pulumi.Input[str]]:
        """
        A template used to generate a dynamic
        username. This will be used to fill in the `.Username` field within the
        `creation_ldif` string.
        """
        return pulumi.get(self, "username_template")

    @username_template.setter
    def username_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_template", value)


class SecretBackendDynamicRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 creation_ldif: Optional[pulumi.Input[str]] = None,
                 default_ttl: Optional[pulumi.Input[int]] = None,
                 deletion_ldif: Optional[pulumi.Input[str]] = None,
                 max_ttl: Optional[pulumi.Input[int]] = None,
                 mount: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 rollback_ldif: Optional[pulumi.Input[str]] = None,
                 username_template: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        config = vault.ldap.SecretBackend("config",
            path="my-custom-ldap",
            binddn="CN=Administrator,CN=Users,DC=corp,DC=example,DC=net",
            bindpass="SuperSecretPassw0rd",
            url="ldaps://localhost",
            userdn="CN=Users,DC=corp,DC=example,DC=net")
        role = vault.ldap.SecretBackendDynamicRole("role",
            mount=config.path,
            role_name="alice",
            creation_ldif=\"\"\"dn: cn={{.Username}},ou=users,dc=learn,dc=example
        objectClass: person
        objectClass: top
        cn: learn
        sn: {{.Password | utf16le | base64}}
        memberOf: cn=dev,ou=groups,dc=learn,dc=example
        userPassword: {{.Password}}
        \"\"\",
            deletion_ldif=\"\"\"dn: cn={{.Username}},ou=users,dc=learn,dc=example
        changetype: delete
          rollback_ldif = <<EOT
        dn: cn={{.Username}},ou=users,dc=learn,dc=example
        changetype: delete
        \"\"\")
        ```

        ## Import

        LDAP secret backend dynamic role can be imported using the full path to the role
        of the form: `<mount_path>/dynamic-role/<role_name>` e.g.

        ```sh
        $ pulumi import vault:ldap/secretBackendDynamicRole:SecretBackendDynamicRole role ldap/role/dynamic-role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] creation_ldif: A templatized LDIF string used to create a user
               account. This may contain multiple LDIF entries. The `creation_ldif` can also
               be used to add the user account to an existing group. All LDIF entries are
               performed in order. If Vault encounters an error while executing the
               `creation_ldif` it will stop at the first error and not execute any remaining
               LDIF entries. If an error occurs and `rollback_ldif` is specified, the LDIF
               entries in `rollback_ldif` will be executed. See `rollback_ldif` for more
               details. This field may optionally be provided as a base64 encoded string.
        :param pulumi.Input[int] default_ttl: Specifies the TTL for the leases associated with this role.
        :param pulumi.Input[str] deletion_ldif: A templatized LDIF string used to delete the
               user account once its TTL has expired. This may contain multiple LDIF
               entries. All LDIF entries are performed in order. If Vault encounters an
               error while executing an entry in the `deletion_ldif` it will attempt to
               continue executing any remaining entries. This field may optionally be
               provided as a base64 encoded string.
        :param pulumi.Input[int] max_ttl: Specifies the maximum TTL for the leases associated with this role.
        :param pulumi.Input[str] mount: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `ldap`.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] role_name: Name of the role.
        :param pulumi.Input[str] rollback_ldif: A templatized LDIF string used to attempt to
               rollback any changes in the event that execution of the `creation_ldif` results
               in an error. This may contain multiple LDIF entries. All LDIF entries are
               performed in order. If Vault encounters an error while executing an entry in
               the `rollback_ldif` it will attempt to continue executing any remaining
               entries. This field may optionally be provided as a base64 encoded string.
        :param pulumi.Input[str] username_template: A template used to generate a dynamic
               username. This will be used to fill in the `.Username` field within the
               `creation_ldif` string.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendDynamicRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        config = vault.ldap.SecretBackend("config",
            path="my-custom-ldap",
            binddn="CN=Administrator,CN=Users,DC=corp,DC=example,DC=net",
            bindpass="SuperSecretPassw0rd",
            url="ldaps://localhost",
            userdn="CN=Users,DC=corp,DC=example,DC=net")
        role = vault.ldap.SecretBackendDynamicRole("role",
            mount=config.path,
            role_name="alice",
            creation_ldif=\"\"\"dn: cn={{.Username}},ou=users,dc=learn,dc=example
        objectClass: person
        objectClass: top
        cn: learn
        sn: {{.Password | utf16le | base64}}
        memberOf: cn=dev,ou=groups,dc=learn,dc=example
        userPassword: {{.Password}}
        \"\"\",
            deletion_ldif=\"\"\"dn: cn={{.Username}},ou=users,dc=learn,dc=example
        changetype: delete
          rollback_ldif = <<EOT
        dn: cn={{.Username}},ou=users,dc=learn,dc=example
        changetype: delete
        \"\"\")
        ```

        ## Import

        LDAP secret backend dynamic role can be imported using the full path to the role
        of the form: `<mount_path>/dynamic-role/<role_name>` e.g.

        ```sh
        $ pulumi import vault:ldap/secretBackendDynamicRole:SecretBackendDynamicRole role ldap/role/dynamic-role
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendDynamicRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendDynamicRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 creation_ldif: Optional[pulumi.Input[str]] = None,
                 default_ttl: Optional[pulumi.Input[int]] = None,
                 deletion_ldif: Optional[pulumi.Input[str]] = None,
                 max_ttl: Optional[pulumi.Input[int]] = None,
                 mount: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 rollback_ldif: Optional[pulumi.Input[str]] = None,
                 username_template: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendDynamicRoleArgs.__new__(SecretBackendDynamicRoleArgs)

            if creation_ldif is None and not opts.urn:
                raise TypeError("Missing required property 'creation_ldif'")
            __props__.__dict__["creation_ldif"] = creation_ldif
            __props__.__dict__["default_ttl"] = default_ttl
            if deletion_ldif is None and not opts.urn:
                raise TypeError("Missing required property 'deletion_ldif'")
            __props__.__dict__["deletion_ldif"] = deletion_ldif
            __props__.__dict__["max_ttl"] = max_ttl
            __props__.__dict__["mount"] = mount
            __props__.__dict__["namespace"] = namespace
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["rollback_ldif"] = rollback_ldif
            __props__.__dict__["username_template"] = username_template
        super(SecretBackendDynamicRole, __self__).__init__(
            'vault:ldap/secretBackendDynamicRole:SecretBackendDynamicRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_ldif: Optional[pulumi.Input[str]] = None,
            default_ttl: Optional[pulumi.Input[int]] = None,
            deletion_ldif: Optional[pulumi.Input[str]] = None,
            max_ttl: Optional[pulumi.Input[int]] = None,
            mount: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            role_name: Optional[pulumi.Input[str]] = None,
            rollback_ldif: Optional[pulumi.Input[str]] = None,
            username_template: Optional[pulumi.Input[str]] = None) -> 'SecretBackendDynamicRole':
        """
        Get an existing SecretBackendDynamicRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] creation_ldif: A templatized LDIF string used to create a user
               account. This may contain multiple LDIF entries. The `creation_ldif` can also
               be used to add the user account to an existing group. All LDIF entries are
               performed in order. If Vault encounters an error while executing the
               `creation_ldif` it will stop at the first error and not execute any remaining
               LDIF entries. If an error occurs and `rollback_ldif` is specified, the LDIF
               entries in `rollback_ldif` will be executed. See `rollback_ldif` for more
               details. This field may optionally be provided as a base64 encoded string.
        :param pulumi.Input[int] default_ttl: Specifies the TTL for the leases associated with this role.
        :param pulumi.Input[str] deletion_ldif: A templatized LDIF string used to delete the
               user account once its TTL has expired. This may contain multiple LDIF
               entries. All LDIF entries are performed in order. If Vault encounters an
               error while executing an entry in the `deletion_ldif` it will attempt to
               continue executing any remaining entries. This field may optionally be
               provided as a base64 encoded string.
        :param pulumi.Input[int] max_ttl: Specifies the maximum TTL for the leases associated with this role.
        :param pulumi.Input[str] mount: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `ldap`.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] role_name: Name of the role.
        :param pulumi.Input[str] rollback_ldif: A templatized LDIF string used to attempt to
               rollback any changes in the event that execution of the `creation_ldif` results
               in an error. This may contain multiple LDIF entries. All LDIF entries are
               performed in order. If Vault encounters an error while executing an entry in
               the `rollback_ldif` it will attempt to continue executing any remaining
               entries. This field may optionally be provided as a base64 encoded string.
        :param pulumi.Input[str] username_template: A template used to generate a dynamic
               username. This will be used to fill in the `.Username` field within the
               `creation_ldif` string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendDynamicRoleState.__new__(_SecretBackendDynamicRoleState)

        __props__.__dict__["creation_ldif"] = creation_ldif
        __props__.__dict__["default_ttl"] = default_ttl
        __props__.__dict__["deletion_ldif"] = deletion_ldif
        __props__.__dict__["max_ttl"] = max_ttl
        __props__.__dict__["mount"] = mount
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["rollback_ldif"] = rollback_ldif
        __props__.__dict__["username_template"] = username_template
        return SecretBackendDynamicRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationLdif")
    def creation_ldif(self) -> pulumi.Output[str]:
        """
        A templatized LDIF string used to create a user
        account. This may contain multiple LDIF entries. The `creation_ldif` can also
        be used to add the user account to an existing group. All LDIF entries are
        performed in order. If Vault encounters an error while executing the
        `creation_ldif` it will stop at the first error and not execute any remaining
        LDIF entries. If an error occurs and `rollback_ldif` is specified, the LDIF
        entries in `rollback_ldif` will be executed. See `rollback_ldif` for more
        details. This field may optionally be provided as a base64 encoded string.
        """
        return pulumi.get(self, "creation_ldif")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the TTL for the leases associated with this role.
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="deletionLdif")
    def deletion_ldif(self) -> pulumi.Output[str]:
        """
        A templatized LDIF string used to delete the
        user account once its TTL has expired. This may contain multiple LDIF
        entries. All LDIF entries are performed in order. If Vault encounters an
        error while executing an entry in the `deletion_ldif` it will attempt to
        continue executing any remaining entries. This field may optionally be
        provided as a base64 encoded string.
        """
        return pulumi.get(self, "deletion_ldif")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the maximum TTL for the leases associated with this role.
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter
    def mount(self) -> pulumi.Output[Optional[str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `ldap`.
        """
        return pulumi.get(self, "mount")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[str]:
        """
        Name of the role.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="rollbackLdif")
    def rollback_ldif(self) -> pulumi.Output[Optional[str]]:
        """
        A templatized LDIF string used to attempt to
        rollback any changes in the event that execution of the `creation_ldif` results
        in an error. This may contain multiple LDIF entries. All LDIF entries are
        performed in order. If Vault encounters an error while executing an entry in
        the `rollback_ldif` it will attempt to continue executing any remaining
        entries. This field may optionally be provided as a base64 encoded string.
        """
        return pulumi.get(self, "rollback_ldif")

    @property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> pulumi.Output[Optional[str]]:
        """
        A template used to generate a dynamic
        username. This will be used to fill in the `.Username` field within the
        `creation_ldif` string.
        """
        return pulumi.get(self, "username_template")

