# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BackendConfigClusterArgs', 'BackendConfigCluster']

@pulumi.input_type
class BackendConfigClusterArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[str],
                 aia_path: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BackendConfigCluster resource.
        :param pulumi.Input[str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[str] aia_path: Specifies the path to this performance replication cluster's AIA distribution point.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] path: Specifies the path to this performance replication cluster's API mount path.
        """
        pulumi.set(__self__, "backend", backend)
        if aia_path is not None:
            pulumi.set(__self__, "aia_path", aia_path)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[str]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="aiaPath")
    def aia_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path to this performance replication cluster's AIA distribution point.
        """
        return pulumi.get(self, "aia_path")

    @aia_path.setter
    def aia_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aia_path", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path to this performance replication cluster's API mount path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class _BackendConfigClusterState:
    def __init__(__self__, *,
                 aia_path: Optional[pulumi.Input[str]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BackendConfigCluster resources.
        :param pulumi.Input[str] aia_path: Specifies the path to this performance replication cluster's AIA distribution point.
        :param pulumi.Input[str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] path: Specifies the path to this performance replication cluster's API mount path.
        """
        if aia_path is not None:
            pulumi.set(__self__, "aia_path", aia_path)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="aiaPath")
    def aia_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path to this performance replication cluster's AIA distribution point.
        """
        return pulumi.get(self, "aia_path")

    @aia_path.setter
    def aia_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aia_path", value)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path to this performance replication cluster's API mount path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


class BackendConfigCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aia_path: Optional[pulumi.Input[str]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Allows setting the cluster-local's API mount path and AIA distribution point on a particular performance replication cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        root = vault.Mount("root",
            path="pki-root",
            type="pki",
            description="root PKI",
            default_lease_ttl_seconds=8640000,
            max_lease_ttl_seconds=8640000)
        example = vault.pki_secret.BackendConfigCluster("example",
            backend=root.path,
            path="http://127.0.0.1:8200/v1/pki-root",
            aia_path="http://127.0.0.1:8200/v1/pki-root")
        ```

        ## Import

        The PKI config cluster can be imported using the resource's `id`.
        In the case of the example above the `id` would be `pki-root/config/cluster`,
        where the `pki-root` component is the resource's `backend`, e.g.

        ```sh
        $ pulumi import vault:pkiSecret/backendConfigCluster:BackendConfigCluster example pki-root/config/cluster
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aia_path: Specifies the path to this performance replication cluster's AIA distribution point.
        :param pulumi.Input[str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] path: Specifies the path to this performance replication cluster's API mount path.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackendConfigClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows setting the cluster-local's API mount path and AIA distribution point on a particular performance replication cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        root = vault.Mount("root",
            path="pki-root",
            type="pki",
            description="root PKI",
            default_lease_ttl_seconds=8640000,
            max_lease_ttl_seconds=8640000)
        example = vault.pki_secret.BackendConfigCluster("example",
            backend=root.path,
            path="http://127.0.0.1:8200/v1/pki-root",
            aia_path="http://127.0.0.1:8200/v1/pki-root")
        ```

        ## Import

        The PKI config cluster can be imported using the resource's `id`.
        In the case of the example above the `id` would be `pki-root/config/cluster`,
        where the `pki-root` component is the resource's `backend`, e.g.

        ```sh
        $ pulumi import vault:pkiSecret/backendConfigCluster:BackendConfigCluster example pki-root/config/cluster
        ```

        :param str resource_name: The name of the resource.
        :param BackendConfigClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackendConfigClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aia_path: Optional[pulumi.Input[str]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackendConfigClusterArgs.__new__(BackendConfigClusterArgs)

            __props__.__dict__["aia_path"] = aia_path
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["path"] = path
        super(BackendConfigCluster, __self__).__init__(
            'vault:pkiSecret/backendConfigCluster:BackendConfigCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aia_path: Optional[pulumi.Input[str]] = None,
            backend: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None) -> 'BackendConfigCluster':
        """
        Get an existing BackendConfigCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aia_path: Specifies the path to this performance replication cluster's AIA distribution point.
        :param pulumi.Input[str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] path: Specifies the path to this performance replication cluster's API mount path.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackendConfigClusterState.__new__(_BackendConfigClusterState)

        __props__.__dict__["aia_path"] = aia_path
        __props__.__dict__["backend"] = backend
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["path"] = path
        return BackendConfigCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aiaPath")
    def aia_path(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the path to this performance replication cluster's AIA distribution point.
        """
        return pulumi.get(self, "aia_path")

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the path to this performance replication cluster's API mount path.
        """
        return pulumi.get(self, "path")

