# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetBackendIssuerResult',
    'AwaitableGetBackendIssuerResult',
    'get_backend_issuer',
    'get_backend_issuer_output',
]

@pulumi.output_type
class GetBackendIssuerResult:
    """
    A collection of values returned by getBackendIssuer.
    """
    def __init__(__self__, backend=None, ca_chains=None, certificate=None, id=None, issuer_id=None, issuer_name=None, issuer_ref=None, key_id=None, leaf_not_after_behavior=None, manual_chains=None, namespace=None, usage=None):
        if backend and not isinstance(backend, str):
            raise TypeError("Expected argument 'backend' to be a str")
        pulumi.set(__self__, "backend", backend)
        if ca_chains and not isinstance(ca_chains, list):
            raise TypeError("Expected argument 'ca_chains' to be a list")
        pulumi.set(__self__, "ca_chains", ca_chains)
        if certificate and not isinstance(certificate, str):
            raise TypeError("Expected argument 'certificate' to be a str")
        pulumi.set(__self__, "certificate", certificate)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issuer_id and not isinstance(issuer_id, str):
            raise TypeError("Expected argument 'issuer_id' to be a str")
        pulumi.set(__self__, "issuer_id", issuer_id)
        if issuer_name and not isinstance(issuer_name, str):
            raise TypeError("Expected argument 'issuer_name' to be a str")
        pulumi.set(__self__, "issuer_name", issuer_name)
        if issuer_ref and not isinstance(issuer_ref, str):
            raise TypeError("Expected argument 'issuer_ref' to be a str")
        pulumi.set(__self__, "issuer_ref", issuer_ref)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if leaf_not_after_behavior and not isinstance(leaf_not_after_behavior, str):
            raise TypeError("Expected argument 'leaf_not_after_behavior' to be a str")
        pulumi.set(__self__, "leaf_not_after_behavior", leaf_not_after_behavior)
        if manual_chains and not isinstance(manual_chains, list):
            raise TypeError("Expected argument 'manual_chains' to be a list")
        pulumi.set(__self__, "manual_chains", manual_chains)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if usage and not isinstance(usage, str):
            raise TypeError("Expected argument 'usage' to be a str")
        pulumi.set(__self__, "usage", usage)

    @property
    @pulumi.getter
    def backend(self) -> str:
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="caChains")
    def ca_chains(self) -> Sequence[str]:
        """
        The CA chain as a list of format specific certificates.
        """
        return pulumi.get(self, "ca_chains")

    @property
    @pulumi.getter
    def certificate(self) -> str:
        """
        Certificate associated with this issuer.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="issuerId")
    def issuer_id(self) -> str:
        """
        ID of the issuer.
        """
        return pulumi.get(self, "issuer_id")

    @property
    @pulumi.getter(name="issuerName")
    def issuer_name(self) -> str:
        """
        Name of the issuer.
        """
        return pulumi.get(self, "issuer_name")

    @property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> str:
        return pulumi.get(self, "issuer_ref")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        ID of the key used by the issuer.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="leafNotAfterBehavior")
    def leaf_not_after_behavior(self) -> str:
        """
        Behavior of a leaf's NotAfter field during issuance.
        """
        return pulumi.get(self, "leaf_not_after_behavior")

    @property
    @pulumi.getter(name="manualChains")
    def manual_chains(self) -> Sequence[str]:
        """
        Chain of issuer references to build this issuer's computed 
        CAChain field from, when non-empty.
        """
        return pulumi.get(self, "manual_chains")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def usage(self) -> str:
        """
        Allowed usages for this issuer.
        """
        return pulumi.get(self, "usage")


class AwaitableGetBackendIssuerResult(GetBackendIssuerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackendIssuerResult(
            backend=self.backend,
            ca_chains=self.ca_chains,
            certificate=self.certificate,
            id=self.id,
            issuer_id=self.issuer_id,
            issuer_name=self.issuer_name,
            issuer_ref=self.issuer_ref,
            key_id=self.key_id,
            leaf_not_after_behavior=self.leaf_not_after_behavior,
            manual_chains=self.manual_chains,
            namespace=self.namespace,
            usage=self.usage)


def get_backend_issuer(backend: Optional[str] = None,
                       issuer_ref: Optional[str] = None,
                       namespace: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackendIssuerResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    pki = vault.Mount("pki",
        path="pki",
        type="pki",
        description="PKI secret engine mount")
    root = vault.pki_secret.SecretBackendRootCert("root",
        backend=pki.path,
        type="internal",
        common_name="example",
        ttl="86400",
        issuer_name="example")
    example = root.issuer_id.apply(lambda issuer_id: vault.pkiSecret.get_backend_issuer_output(backend=root.path,
        issuer_ref=issuer_id))
    ```


    :param str backend: The path to the PKI secret backend to
           read the issuer from, with no leading or trailing `/`s.
    :param str issuer_ref: Reference to an existing issuer.
    :param str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    """
    __args__ = dict()
    __args__['backend'] = backend
    __args__['issuerRef'] = issuer_ref
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vault:pkiSecret/getBackendIssuer:getBackendIssuer', __args__, opts=opts, typ=GetBackendIssuerResult).value

    return AwaitableGetBackendIssuerResult(
        backend=pulumi.get(__ret__, 'backend'),
        ca_chains=pulumi.get(__ret__, 'ca_chains'),
        certificate=pulumi.get(__ret__, 'certificate'),
        id=pulumi.get(__ret__, 'id'),
        issuer_id=pulumi.get(__ret__, 'issuer_id'),
        issuer_name=pulumi.get(__ret__, 'issuer_name'),
        issuer_ref=pulumi.get(__ret__, 'issuer_ref'),
        key_id=pulumi.get(__ret__, 'key_id'),
        leaf_not_after_behavior=pulumi.get(__ret__, 'leaf_not_after_behavior'),
        manual_chains=pulumi.get(__ret__, 'manual_chains'),
        namespace=pulumi.get(__ret__, 'namespace'),
        usage=pulumi.get(__ret__, 'usage'))


@_utilities.lift_output_func(get_backend_issuer)
def get_backend_issuer_output(backend: Optional[pulumi.Input[str]] = None,
                              issuer_ref: Optional[pulumi.Input[str]] = None,
                              namespace: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBackendIssuerResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    pki = vault.Mount("pki",
        path="pki",
        type="pki",
        description="PKI secret engine mount")
    root = vault.pki_secret.SecretBackendRootCert("root",
        backend=pki.path,
        type="internal",
        common_name="example",
        ttl="86400",
        issuer_name="example")
    example = root.issuer_id.apply(lambda issuer_id: vault.pkiSecret.get_backend_issuer_output(backend=root.path,
        issuer_ref=issuer_id))
    ```


    :param str backend: The path to the PKI secret backend to
           read the issuer from, with no leading or trailing `/`s.
    :param str issuer_ref: Reference to an existing issuer.
    :param str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    """
    ...
