# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecretBackendIssuerArgs', 'SecretBackendIssuer']

@pulumi.input_type
class SecretBackendIssuerArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[str],
                 issuer_ref: pulumi.Input[str],
                 crl_distribution_points: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_aia_url_templating: Optional[pulumi.Input[bool]] = None,
                 issuer_name: Optional[pulumi.Input[str]] = None,
                 issuing_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 leaf_not_after_behavior: Optional[pulumi.Input[str]] = None,
                 manual_chains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 ocsp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 revocation_signature_algorithm: Optional[pulumi.Input[str]] = None,
                 usage: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecretBackendIssuer resource.
        :param pulumi.Input[str] backend: The path the PKI secret backend is mounted at, with no
               leading or trailing `/`s.
        :param pulumi.Input[str] issuer_ref: Reference to an existing issuer.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] crl_distribution_points: Specifies the URL values for the CRL
               Distribution Points field.
        :param pulumi.Input[bool] enable_aia_url_templating: Specifies that the AIA URL values should
               be templated.
        :param pulumi.Input[str] issuer_name: Name of the issuer.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] issuing_certificates: Specifies the URL values for the Issuing
               Certificate field.
        :param pulumi.Input[str] leaf_not_after_behavior: Behavior of a leaf's NotAfter field during
               issuance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manual_chains: Chain of issuer references to build this issuer's
               computed CAChain field from, when non-empty.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ocsp_servers: Specifies the URL values for the OCSP Servers field.
        :param pulumi.Input[str] revocation_signature_algorithm: Which signature algorithm to use
               when building CRLs.
        :param pulumi.Input[str] usage: Allowed usages for this issuer.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "issuer_ref", issuer_ref)
        if crl_distribution_points is not None:
            pulumi.set(__self__, "crl_distribution_points", crl_distribution_points)
        if enable_aia_url_templating is not None:
            pulumi.set(__self__, "enable_aia_url_templating", enable_aia_url_templating)
        if issuer_name is not None:
            pulumi.set(__self__, "issuer_name", issuer_name)
        if issuing_certificates is not None:
            pulumi.set(__self__, "issuing_certificates", issuing_certificates)
        if leaf_not_after_behavior is not None:
            pulumi.set(__self__, "leaf_not_after_behavior", leaf_not_after_behavior)
        if manual_chains is not None:
            pulumi.set(__self__, "manual_chains", manual_chains)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if ocsp_servers is not None:
            pulumi.set(__self__, "ocsp_servers", ocsp_servers)
        if revocation_signature_algorithm is not None:
            pulumi.set(__self__, "revocation_signature_algorithm", revocation_signature_algorithm)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[str]:
        """
        The path the PKI secret backend is mounted at, with no
        leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> pulumi.Input[str]:
        """
        Reference to an existing issuer.
        """
        return pulumi.get(self, "issuer_ref")

    @issuer_ref.setter
    def issuer_ref(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer_ref", value)

    @property
    @pulumi.getter(name="crlDistributionPoints")
    def crl_distribution_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the URL values for the CRL
        Distribution Points field.
        """
        return pulumi.get(self, "crl_distribution_points")

    @crl_distribution_points.setter
    def crl_distribution_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "crl_distribution_points", value)

    @property
    @pulumi.getter(name="enableAiaUrlTemplating")
    def enable_aia_url_templating(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies that the AIA URL values should
        be templated.
        """
        return pulumi.get(self, "enable_aia_url_templating")

    @enable_aia_url_templating.setter
    def enable_aia_url_templating(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_aia_url_templating", value)

    @property
    @pulumi.getter(name="issuerName")
    def issuer_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the issuer.
        """
        return pulumi.get(self, "issuer_name")

    @issuer_name.setter
    def issuer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_name", value)

    @property
    @pulumi.getter(name="issuingCertificates")
    def issuing_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the URL values for the Issuing
        Certificate field.
        """
        return pulumi.get(self, "issuing_certificates")

    @issuing_certificates.setter
    def issuing_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "issuing_certificates", value)

    @property
    @pulumi.getter(name="leafNotAfterBehavior")
    def leaf_not_after_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Behavior of a leaf's NotAfter field during
        issuance.
        """
        return pulumi.get(self, "leaf_not_after_behavior")

    @leaf_not_after_behavior.setter
    def leaf_not_after_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "leaf_not_after_behavior", value)

    @property
    @pulumi.getter(name="manualChains")
    def manual_chains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Chain of issuer references to build this issuer's
        computed CAChain field from, when non-empty.
        """
        return pulumi.get(self, "manual_chains")

    @manual_chains.setter
    def manual_chains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "manual_chains", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="ocspServers")
    def ocsp_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the URL values for the OCSP Servers field.
        """
        return pulumi.get(self, "ocsp_servers")

    @ocsp_servers.setter
    def ocsp_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ocsp_servers", value)

    @property
    @pulumi.getter(name="revocationSignatureAlgorithm")
    def revocation_signature_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Which signature algorithm to use
        when building CRLs.
        """
        return pulumi.get(self, "revocation_signature_algorithm")

    @revocation_signature_algorithm.setter
    def revocation_signature_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revocation_signature_algorithm", value)

    @property
    @pulumi.getter
    def usage(self) -> Optional[pulumi.Input[str]]:
        """
        Allowed usages for this issuer.
        """
        return pulumi.get(self, "usage")

    @usage.setter
    def usage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "usage", value)


@pulumi.input_type
class _SecretBackendIssuerState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[str]] = None,
                 crl_distribution_points: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_aia_url_templating: Optional[pulumi.Input[bool]] = None,
                 issuer_id: Optional[pulumi.Input[str]] = None,
                 issuer_name: Optional[pulumi.Input[str]] = None,
                 issuer_ref: Optional[pulumi.Input[str]] = None,
                 issuing_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 leaf_not_after_behavior: Optional[pulumi.Input[str]] = None,
                 manual_chains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 ocsp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 revocation_signature_algorithm: Optional[pulumi.Input[str]] = None,
                 usage: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecretBackendIssuer resources.
        :param pulumi.Input[str] backend: The path the PKI secret backend is mounted at, with no
               leading or trailing `/`s.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] crl_distribution_points: Specifies the URL values for the CRL
               Distribution Points field.
        :param pulumi.Input[bool] enable_aia_url_templating: Specifies that the AIA URL values should
               be templated.
        :param pulumi.Input[str] issuer_id: ID of the issuer.
        :param pulumi.Input[str] issuer_name: Name of the issuer.
        :param pulumi.Input[str] issuer_ref: Reference to an existing issuer.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] issuing_certificates: Specifies the URL values for the Issuing
               Certificate field.
        :param pulumi.Input[str] leaf_not_after_behavior: Behavior of a leaf's NotAfter field during
               issuance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manual_chains: Chain of issuer references to build this issuer's
               computed CAChain field from, when non-empty.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ocsp_servers: Specifies the URL values for the OCSP Servers field.
        :param pulumi.Input[str] revocation_signature_algorithm: Which signature algorithm to use
               when building CRLs.
        :param pulumi.Input[str] usage: Allowed usages for this issuer.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if crl_distribution_points is not None:
            pulumi.set(__self__, "crl_distribution_points", crl_distribution_points)
        if enable_aia_url_templating is not None:
            pulumi.set(__self__, "enable_aia_url_templating", enable_aia_url_templating)
        if issuer_id is not None:
            pulumi.set(__self__, "issuer_id", issuer_id)
        if issuer_name is not None:
            pulumi.set(__self__, "issuer_name", issuer_name)
        if issuer_ref is not None:
            pulumi.set(__self__, "issuer_ref", issuer_ref)
        if issuing_certificates is not None:
            pulumi.set(__self__, "issuing_certificates", issuing_certificates)
        if leaf_not_after_behavior is not None:
            pulumi.set(__self__, "leaf_not_after_behavior", leaf_not_after_behavior)
        if manual_chains is not None:
            pulumi.set(__self__, "manual_chains", manual_chains)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if ocsp_servers is not None:
            pulumi.set(__self__, "ocsp_servers", ocsp_servers)
        if revocation_signature_algorithm is not None:
            pulumi.set(__self__, "revocation_signature_algorithm", revocation_signature_algorithm)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        The path the PKI secret backend is mounted at, with no
        leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="crlDistributionPoints")
    def crl_distribution_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the URL values for the CRL
        Distribution Points field.
        """
        return pulumi.get(self, "crl_distribution_points")

    @crl_distribution_points.setter
    def crl_distribution_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "crl_distribution_points", value)

    @property
    @pulumi.getter(name="enableAiaUrlTemplating")
    def enable_aia_url_templating(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies that the AIA URL values should
        be templated.
        """
        return pulumi.get(self, "enable_aia_url_templating")

    @enable_aia_url_templating.setter
    def enable_aia_url_templating(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_aia_url_templating", value)

    @property
    @pulumi.getter(name="issuerId")
    def issuer_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the issuer.
        """
        return pulumi.get(self, "issuer_id")

    @issuer_id.setter
    def issuer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_id", value)

    @property
    @pulumi.getter(name="issuerName")
    def issuer_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the issuer.
        """
        return pulumi.get(self, "issuer_name")

    @issuer_name.setter
    def issuer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_name", value)

    @property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> Optional[pulumi.Input[str]]:
        """
        Reference to an existing issuer.
        """
        return pulumi.get(self, "issuer_ref")

    @issuer_ref.setter
    def issuer_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_ref", value)

    @property
    @pulumi.getter(name="issuingCertificates")
    def issuing_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the URL values for the Issuing
        Certificate field.
        """
        return pulumi.get(self, "issuing_certificates")

    @issuing_certificates.setter
    def issuing_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "issuing_certificates", value)

    @property
    @pulumi.getter(name="leafNotAfterBehavior")
    def leaf_not_after_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Behavior of a leaf's NotAfter field during
        issuance.
        """
        return pulumi.get(self, "leaf_not_after_behavior")

    @leaf_not_after_behavior.setter
    def leaf_not_after_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "leaf_not_after_behavior", value)

    @property
    @pulumi.getter(name="manualChains")
    def manual_chains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Chain of issuer references to build this issuer's
        computed CAChain field from, when non-empty.
        """
        return pulumi.get(self, "manual_chains")

    @manual_chains.setter
    def manual_chains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "manual_chains", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="ocspServers")
    def ocsp_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the URL values for the OCSP Servers field.
        """
        return pulumi.get(self, "ocsp_servers")

    @ocsp_servers.setter
    def ocsp_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ocsp_servers", value)

    @property
    @pulumi.getter(name="revocationSignatureAlgorithm")
    def revocation_signature_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Which signature algorithm to use
        when building CRLs.
        """
        return pulumi.get(self, "revocation_signature_algorithm")

    @revocation_signature_algorithm.setter
    def revocation_signature_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revocation_signature_algorithm", value)

    @property
    @pulumi.getter
    def usage(self) -> Optional[pulumi.Input[str]]:
        """
        Allowed usages for this issuer.
        """
        return pulumi.get(self, "usage")

    @usage.setter
    def usage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "usage", value)


class SecretBackendIssuer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 crl_distribution_points: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_aia_url_templating: Optional[pulumi.Input[bool]] = None,
                 issuer_name: Optional[pulumi.Input[str]] = None,
                 issuer_ref: Optional[pulumi.Input[str]] = None,
                 issuing_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 leaf_not_after_behavior: Optional[pulumi.Input[str]] = None,
                 manual_chains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 ocsp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 revocation_signature_algorithm: Optional[pulumi.Input[str]] = None,
                 usage: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            path="pki",
            type="pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400)
        root = vault.pki_secret.SecretBackendRootCert("root",
            backend=pki.path,
            type="internal",
            common_name="test",
            ttl="86400")
        example = vault.pki_secret.SecretBackendIssuer("example",
            backend=root.backend,
            issuer_ref=root.issuer_id,
            issuer_name="example-issuer")
        ```

        ## Import

        PKI secret backend issuer can be imported using the `id`, e.g.

        ```sh
        $ pulumi import vault:pkiSecret/secretBackendIssuer:SecretBackendIssuer example pki/issuer/bf9b0d48-d0dd-652c-30be-77d04fc7e94d
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The path the PKI secret backend is mounted at, with no
               leading or trailing `/`s.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] crl_distribution_points: Specifies the URL values for the CRL
               Distribution Points field.
        :param pulumi.Input[bool] enable_aia_url_templating: Specifies that the AIA URL values should
               be templated.
        :param pulumi.Input[str] issuer_name: Name of the issuer.
        :param pulumi.Input[str] issuer_ref: Reference to an existing issuer.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] issuing_certificates: Specifies the URL values for the Issuing
               Certificate field.
        :param pulumi.Input[str] leaf_not_after_behavior: Behavior of a leaf's NotAfter field during
               issuance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manual_chains: Chain of issuer references to build this issuer's
               computed CAChain field from, when non-empty.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ocsp_servers: Specifies the URL values for the OCSP Servers field.
        :param pulumi.Input[str] revocation_signature_algorithm: Which signature algorithm to use
               when building CRLs.
        :param pulumi.Input[str] usage: Allowed usages for this issuer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendIssuerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            path="pki",
            type="pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400)
        root = vault.pki_secret.SecretBackendRootCert("root",
            backend=pki.path,
            type="internal",
            common_name="test",
            ttl="86400")
        example = vault.pki_secret.SecretBackendIssuer("example",
            backend=root.backend,
            issuer_ref=root.issuer_id,
            issuer_name="example-issuer")
        ```

        ## Import

        PKI secret backend issuer can be imported using the `id`, e.g.

        ```sh
        $ pulumi import vault:pkiSecret/secretBackendIssuer:SecretBackendIssuer example pki/issuer/bf9b0d48-d0dd-652c-30be-77d04fc7e94d
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendIssuerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendIssuerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 crl_distribution_points: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_aia_url_templating: Optional[pulumi.Input[bool]] = None,
                 issuer_name: Optional[pulumi.Input[str]] = None,
                 issuer_ref: Optional[pulumi.Input[str]] = None,
                 issuing_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 leaf_not_after_behavior: Optional[pulumi.Input[str]] = None,
                 manual_chains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 ocsp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 revocation_signature_algorithm: Optional[pulumi.Input[str]] = None,
                 usage: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendIssuerArgs.__new__(SecretBackendIssuerArgs)

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["crl_distribution_points"] = crl_distribution_points
            __props__.__dict__["enable_aia_url_templating"] = enable_aia_url_templating
            __props__.__dict__["issuer_name"] = issuer_name
            if issuer_ref is None and not opts.urn:
                raise TypeError("Missing required property 'issuer_ref'")
            __props__.__dict__["issuer_ref"] = issuer_ref
            __props__.__dict__["issuing_certificates"] = issuing_certificates
            __props__.__dict__["leaf_not_after_behavior"] = leaf_not_after_behavior
            __props__.__dict__["manual_chains"] = manual_chains
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["ocsp_servers"] = ocsp_servers
            __props__.__dict__["revocation_signature_algorithm"] = revocation_signature_algorithm
            __props__.__dict__["usage"] = usage
            __props__.__dict__["issuer_id"] = None
        super(SecretBackendIssuer, __self__).__init__(
            'vault:pkiSecret/secretBackendIssuer:SecretBackendIssuer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[str]] = None,
            crl_distribution_points: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enable_aia_url_templating: Optional[pulumi.Input[bool]] = None,
            issuer_id: Optional[pulumi.Input[str]] = None,
            issuer_name: Optional[pulumi.Input[str]] = None,
            issuer_ref: Optional[pulumi.Input[str]] = None,
            issuing_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            leaf_not_after_behavior: Optional[pulumi.Input[str]] = None,
            manual_chains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            ocsp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            revocation_signature_algorithm: Optional[pulumi.Input[str]] = None,
            usage: Optional[pulumi.Input[str]] = None) -> 'SecretBackendIssuer':
        """
        Get an existing SecretBackendIssuer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The path the PKI secret backend is mounted at, with no
               leading or trailing `/`s.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] crl_distribution_points: Specifies the URL values for the CRL
               Distribution Points field.
        :param pulumi.Input[bool] enable_aia_url_templating: Specifies that the AIA URL values should
               be templated.
        :param pulumi.Input[str] issuer_id: ID of the issuer.
        :param pulumi.Input[str] issuer_name: Name of the issuer.
        :param pulumi.Input[str] issuer_ref: Reference to an existing issuer.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] issuing_certificates: Specifies the URL values for the Issuing
               Certificate field.
        :param pulumi.Input[str] leaf_not_after_behavior: Behavior of a leaf's NotAfter field during
               issuance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manual_chains: Chain of issuer references to build this issuer's
               computed CAChain field from, when non-empty.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ocsp_servers: Specifies the URL values for the OCSP Servers field.
        :param pulumi.Input[str] revocation_signature_algorithm: Which signature algorithm to use
               when building CRLs.
        :param pulumi.Input[str] usage: Allowed usages for this issuer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendIssuerState.__new__(_SecretBackendIssuerState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["crl_distribution_points"] = crl_distribution_points
        __props__.__dict__["enable_aia_url_templating"] = enable_aia_url_templating
        __props__.__dict__["issuer_id"] = issuer_id
        __props__.__dict__["issuer_name"] = issuer_name
        __props__.__dict__["issuer_ref"] = issuer_ref
        __props__.__dict__["issuing_certificates"] = issuing_certificates
        __props__.__dict__["leaf_not_after_behavior"] = leaf_not_after_behavior
        __props__.__dict__["manual_chains"] = manual_chains
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["ocsp_servers"] = ocsp_servers
        __props__.__dict__["revocation_signature_algorithm"] = revocation_signature_algorithm
        __props__.__dict__["usage"] = usage
        return SecretBackendIssuer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The path the PKI secret backend is mounted at, with no
        leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="crlDistributionPoints")
    def crl_distribution_points(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies the URL values for the CRL
        Distribution Points field.
        """
        return pulumi.get(self, "crl_distribution_points")

    @property
    @pulumi.getter(name="enableAiaUrlTemplating")
    def enable_aia_url_templating(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies that the AIA URL values should
        be templated.
        """
        return pulumi.get(self, "enable_aia_url_templating")

    @property
    @pulumi.getter(name="issuerId")
    def issuer_id(self) -> pulumi.Output[str]:
        """
        ID of the issuer.
        """
        return pulumi.get(self, "issuer_id")

    @property
    @pulumi.getter(name="issuerName")
    def issuer_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the issuer.
        """
        return pulumi.get(self, "issuer_name")

    @property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> pulumi.Output[str]:
        """
        Reference to an existing issuer.
        """
        return pulumi.get(self, "issuer_ref")

    @property
    @pulumi.getter(name="issuingCertificates")
    def issuing_certificates(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies the URL values for the Issuing
        Certificate field.
        """
        return pulumi.get(self, "issuing_certificates")

    @property
    @pulumi.getter(name="leafNotAfterBehavior")
    def leaf_not_after_behavior(self) -> pulumi.Output[str]:
        """
        Behavior of a leaf's NotAfter field during
        issuance.
        """
        return pulumi.get(self, "leaf_not_after_behavior")

    @property
    @pulumi.getter(name="manualChains")
    def manual_chains(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Chain of issuer references to build this issuer's
        computed CAChain field from, when non-empty.
        """
        return pulumi.get(self, "manual_chains")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="ocspServers")
    def ocsp_servers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies the URL values for the OCSP Servers field.
        """
        return pulumi.get(self, "ocsp_servers")

    @property
    @pulumi.getter(name="revocationSignatureAlgorithm")
    def revocation_signature_algorithm(self) -> pulumi.Output[str]:
        """
        Which signature algorithm to use
        when building CRLs.
        """
        return pulumi.get(self, "revocation_signature_algorithm")

    @property
    @pulumi.getter
    def usage(self) -> pulumi.Output[str]:
        """
        Allowed usages for this issuer.
        """
        return pulumi.get(self, "usage")

