# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecretBackendRootSignIntermediateArgs', 'SecretBackendRootSignIntermediate']

@pulumi.input_type
class SecretBackendRootSignIntermediateArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[str],
                 common_name: pulumi.Input[str],
                 csr: pulumi.Input[str],
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[bool]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issuer_ref: Optional[pulumi.Input[str]] = None,
                 locality: Optional[pulumi.Input[str]] = None,
                 max_path_length: Optional[pulumi.Input[int]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ou: Optional[pulumi.Input[str]] = None,
                 permitted_dns_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 revoke: Optional[pulumi.Input[bool]] = None,
                 street_address: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_csr_values: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a SecretBackendRootSignIntermediate resource.
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[str] common_name: CN of intermediate to create
        :param pulumi.Input[str] csr: The CSR
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alt_names: List of alternative names
        :param pulumi.Input[str] country: The country
        :param pulumi.Input[bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[str] issuer_ref: Specifies the default issuer of this request. May
               be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
               the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
               overriding the role's `issuer_ref` value.
        :param pulumi.Input[str] locality: The locality
        :param pulumi.Input[int] max_path_length: The maximum path length to encode in the generated certificate
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[str]]] other_sans: List of other SANs
        :param pulumi.Input[str] ou: The organization unit
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permitted_dns_domains: List of domains for which certificates are allowed to be issued
        :param pulumi.Input[str] postal_code: The postal code
        :param pulumi.Input[str] province: The province
        :param pulumi.Input[bool] revoke: If set to `true`, the certificate will be revoked on resource destruction.
        :param pulumi.Input[str] street_address: The street address
        :param pulumi.Input[str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[str]]] uri_sans: List of alternative URIs
        :param pulumi.Input[bool] use_csr_values: Preserve CSR values
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "csr", csr)
        if alt_names is not None:
            pulumi.set(__self__, "alt_names", alt_names)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if exclude_cn_from_sans is not None:
            pulumi.set(__self__, "exclude_cn_from_sans", exclude_cn_from_sans)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if ip_sans is not None:
            pulumi.set(__self__, "ip_sans", ip_sans)
        if issuer_ref is not None:
            pulumi.set(__self__, "issuer_ref", issuer_ref)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if max_path_length is not None:
            pulumi.set(__self__, "max_path_length", max_path_length)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if other_sans is not None:
            pulumi.set(__self__, "other_sans", other_sans)
        if ou is not None:
            pulumi.set(__self__, "ou", ou)
        if permitted_dns_domains is not None:
            pulumi.set(__self__, "permitted_dns_domains", permitted_dns_domains)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if revoke is not None:
            pulumi.set(__self__, "revoke", revoke)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if uri_sans is not None:
            pulumi.set(__self__, "uri_sans", uri_sans)
        if use_csr_values is not None:
            pulumi.set(__self__, "use_csr_values", use_csr_values)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[str]:
        """
        CN of intermediate to create
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter
    def csr(self) -> pulumi.Input[str]:
        """
        The CSR
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: pulumi.Input[str]):
        pulumi.set(self, "csr", value)

    @property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @alt_names.setter
    def alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "alt_names", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        The country
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @exclude_cn_from_sans.setter
    def exclude_cn_from_sans(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_cn_from_sans", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @ip_sans.setter
    def ip_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_sans", value)

    @property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the default issuer of this request. May
        be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
        the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
        overriding the role's `issuer_ref` value.
        """
        return pulumi.get(self, "issuer_ref")

    @issuer_ref.setter
    def issuer_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_ref", value)

    @property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[str]]:
        """
        The locality
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locality", value)

    @property
    @pulumi.getter(name="maxPathLength")
    def max_path_length(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum path length to encode in the generated certificate
        """
        return pulumi.get(self, "max_path_length")

    @max_path_length.setter
    def max_path_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_path_length", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        The organization
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @other_sans.setter
    def other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "other_sans", value)

    @property
    @pulumi.getter
    def ou(self) -> Optional[pulumi.Input[str]]:
        """
        The organization unit
        """
        return pulumi.get(self, "ou")

    @ou.setter
    def ou(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ou", value)

    @property
    @pulumi.getter(name="permittedDnsDomains")
    def permitted_dns_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of domains for which certificates are allowed to be issued
        """
        return pulumi.get(self, "permitted_dns_domains")

    @permitted_dns_domains.setter
    def permitted_dns_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permitted_dns_domains", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[str]]:
        """
        The postal code
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter
    def province(self) -> Optional[pulumi.Input[str]]:
        """
        The province
        """
        return pulumi.get(self, "province")

    @province.setter
    def province(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "province", value)

    @property
    @pulumi.getter
    def revoke(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, the certificate will be revoked on resource destruction.
        """
        return pulumi.get(self, "revoke")

    @revoke.setter
    def revoke(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "revoke", value)

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[pulumi.Input[str]]:
        """
        The street address
        """
        return pulumi.get(self, "street_address")

    @street_address.setter
    def street_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "street_address", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Time to live
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @uri_sans.setter
    def uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "uri_sans", value)

    @property
    @pulumi.getter(name="useCsrValues")
    def use_csr_values(self) -> Optional[pulumi.Input[bool]]:
        """
        Preserve CSR values
        """
        return pulumi.get(self, "use_csr_values")

    @use_csr_values.setter
    def use_csr_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_csr_values", value)


@pulumi.input_type
class _SecretBackendRootSignIntermediateState:
    def __init__(__self__, *,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 ca_chains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 certificate_bundle: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 csr: Optional[pulumi.Input[str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[bool]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issuer_ref: Optional[pulumi.Input[str]] = None,
                 issuing_ca: Optional[pulumi.Input[str]] = None,
                 locality: Optional[pulumi.Input[str]] = None,
                 max_path_length: Optional[pulumi.Input[int]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ou: Optional[pulumi.Input[str]] = None,
                 permitted_dns_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 revoke: Optional[pulumi.Input[bool]] = None,
                 serial_number: Optional[pulumi.Input[str]] = None,
                 street_address: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_csr_values: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering SecretBackendRootSignIntermediate resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alt_names: List of alternative names
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ca_chains: A list of the issuing and intermediate CA certificates in the `format` specified.
        :param pulumi.Input[str] certificate: The intermediate CA certificate in the `format` specified.
        :param pulumi.Input[str] certificate_bundle: The concatenation of the intermediate CA and the issuing CA certificates (PEM encoded). 
               Requires the `format` to be set to any of: pem, pem_bundle. The value will be empty for all other formats.
        :param pulumi.Input[str] common_name: CN of intermediate to create
        :param pulumi.Input[str] country: The country
        :param pulumi.Input[str] csr: The CSR
        :param pulumi.Input[bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[str] issuer_ref: Specifies the default issuer of this request. May
               be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
               the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
               overriding the role's `issuer_ref` value.
        :param pulumi.Input[str] issuing_ca: The issuing CA certificate in the `format` specified.
        :param pulumi.Input[str] locality: The locality
        :param pulumi.Input[int] max_path_length: The maximum path length to encode in the generated certificate
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[str]]] other_sans: List of other SANs
        :param pulumi.Input[str] ou: The organization unit
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permitted_dns_domains: List of domains for which certificates are allowed to be issued
        :param pulumi.Input[str] postal_code: The postal code
        :param pulumi.Input[str] province: The province
        :param pulumi.Input[bool] revoke: If set to `true`, the certificate will be revoked on resource destruction.
        :param pulumi.Input[str] serial_number: The certificate's serial number, hex formatted.
        :param pulumi.Input[str] street_address: The street address
        :param pulumi.Input[str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[str]]] uri_sans: List of alternative URIs
        :param pulumi.Input[bool] use_csr_values: Preserve CSR values
        """
        if alt_names is not None:
            pulumi.set(__self__, "alt_names", alt_names)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if ca_chains is not None:
            pulumi.set(__self__, "ca_chains", ca_chains)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_bundle is not None:
            pulumi.set(__self__, "certificate_bundle", certificate_bundle)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if csr is not None:
            pulumi.set(__self__, "csr", csr)
        if exclude_cn_from_sans is not None:
            pulumi.set(__self__, "exclude_cn_from_sans", exclude_cn_from_sans)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if ip_sans is not None:
            pulumi.set(__self__, "ip_sans", ip_sans)
        if issuer_ref is not None:
            pulumi.set(__self__, "issuer_ref", issuer_ref)
        if issuing_ca is not None:
            pulumi.set(__self__, "issuing_ca", issuing_ca)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if max_path_length is not None:
            pulumi.set(__self__, "max_path_length", max_path_length)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if other_sans is not None:
            pulumi.set(__self__, "other_sans", other_sans)
        if ou is not None:
            pulumi.set(__self__, "ou", ou)
        if permitted_dns_domains is not None:
            pulumi.set(__self__, "permitted_dns_domains", permitted_dns_domains)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if revoke is not None:
            pulumi.set(__self__, "revoke", revoke)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if uri_sans is not None:
            pulumi.set(__self__, "uri_sans", uri_sans)
        if use_csr_values is not None:
            pulumi.set(__self__, "use_csr_values", use_csr_values)

    @property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @alt_names.setter
    def alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "alt_names", value)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="caChains")
    def ca_chains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the issuing and intermediate CA certificates in the `format` specified.
        """
        return pulumi.get(self, "ca_chains")

    @ca_chains.setter
    def ca_chains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ca_chains", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The intermediate CA certificate in the `format` specified.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="certificateBundle")
    def certificate_bundle(self) -> Optional[pulumi.Input[str]]:
        """
        The concatenation of the intermediate CA and the issuing CA certificates (PEM encoded). 
        Requires the `format` to be set to any of: pem, pem_bundle. The value will be empty for all other formats.
        """
        return pulumi.get(self, "certificate_bundle")

    @certificate_bundle.setter
    def certificate_bundle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_bundle", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        """
        CN of intermediate to create
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        The country
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input[str]]:
        """
        The CSR
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csr", value)

    @property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @exclude_cn_from_sans.setter
    def exclude_cn_from_sans(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_cn_from_sans", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @ip_sans.setter
    def ip_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_sans", value)

    @property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the default issuer of this request. May
        be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
        the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
        overriding the role's `issuer_ref` value.
        """
        return pulumi.get(self, "issuer_ref")

    @issuer_ref.setter
    def issuer_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_ref", value)

    @property
    @pulumi.getter(name="issuingCa")
    def issuing_ca(self) -> Optional[pulumi.Input[str]]:
        """
        The issuing CA certificate in the `format` specified.
        """
        return pulumi.get(self, "issuing_ca")

    @issuing_ca.setter
    def issuing_ca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuing_ca", value)

    @property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[str]]:
        """
        The locality
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locality", value)

    @property
    @pulumi.getter(name="maxPathLength")
    def max_path_length(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum path length to encode in the generated certificate
        """
        return pulumi.get(self, "max_path_length")

    @max_path_length.setter
    def max_path_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_path_length", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        The organization
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @other_sans.setter
    def other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "other_sans", value)

    @property
    @pulumi.getter
    def ou(self) -> Optional[pulumi.Input[str]]:
        """
        The organization unit
        """
        return pulumi.get(self, "ou")

    @ou.setter
    def ou(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ou", value)

    @property
    @pulumi.getter(name="permittedDnsDomains")
    def permitted_dns_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of domains for which certificates are allowed to be issued
        """
        return pulumi.get(self, "permitted_dns_domains")

    @permitted_dns_domains.setter
    def permitted_dns_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permitted_dns_domains", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[str]]:
        """
        The postal code
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter
    def province(self) -> Optional[pulumi.Input[str]]:
        """
        The province
        """
        return pulumi.get(self, "province")

    @province.setter
    def province(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "province", value)

    @property
    @pulumi.getter
    def revoke(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, the certificate will be revoked on resource destruction.
        """
        return pulumi.get(self, "revoke")

    @revoke.setter
    def revoke(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "revoke", value)

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate's serial number, hex formatted.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial_number", value)

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[pulumi.Input[str]]:
        """
        The street address
        """
        return pulumi.get(self, "street_address")

    @street_address.setter
    def street_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "street_address", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Time to live
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @uri_sans.setter
    def uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "uri_sans", value)

    @property
    @pulumi.getter(name="useCsrValues")
    def use_csr_values(self) -> Optional[pulumi.Input[bool]]:
        """
        Preserve CSR values
        """
        return pulumi.get(self, "use_csr_values")

    @use_csr_values.setter
    def use_csr_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_csr_values", value)


class SecretBackendRootSignIntermediate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 csr: Optional[pulumi.Input[str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[bool]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issuer_ref: Optional[pulumi.Input[str]] = None,
                 locality: Optional[pulumi.Input[str]] = None,
                 max_path_length: Optional[pulumi.Input[int]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ou: Optional[pulumi.Input[str]] = None,
                 permitted_dns_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 revoke: Optional[pulumi.Input[bool]] = None,
                 street_address: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_csr_values: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Creates PKI certificate.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        root = vault.pki_secret.SecretBackendRootSignIntermediate("root",
            backend=root_vault_mount["path"],
            csr=intermediate["csr"],
            common_name="Intermediate CA",
            exclude_cn_from_sans=True,
            ou="My OU",
            organization="My organization",
            opts=pulumi.ResourceOptions(depends_on=[intermediate]))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alt_names: List of alternative names
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[str] common_name: CN of intermediate to create
        :param pulumi.Input[str] country: The country
        :param pulumi.Input[str] csr: The CSR
        :param pulumi.Input[bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[str] issuer_ref: Specifies the default issuer of this request. May
               be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
               the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
               overriding the role's `issuer_ref` value.
        :param pulumi.Input[str] locality: The locality
        :param pulumi.Input[int] max_path_length: The maximum path length to encode in the generated certificate
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[str]]] other_sans: List of other SANs
        :param pulumi.Input[str] ou: The organization unit
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permitted_dns_domains: List of domains for which certificates are allowed to be issued
        :param pulumi.Input[str] postal_code: The postal code
        :param pulumi.Input[str] province: The province
        :param pulumi.Input[bool] revoke: If set to `true`, the certificate will be revoked on resource destruction.
        :param pulumi.Input[str] street_address: The street address
        :param pulumi.Input[str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[str]]] uri_sans: List of alternative URIs
        :param pulumi.Input[bool] use_csr_values: Preserve CSR values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendRootSignIntermediateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates PKI certificate.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        root = vault.pki_secret.SecretBackendRootSignIntermediate("root",
            backend=root_vault_mount["path"],
            csr=intermediate["csr"],
            common_name="Intermediate CA",
            exclude_cn_from_sans=True,
            ou="My OU",
            organization="My organization",
            opts=pulumi.ResourceOptions(depends_on=[intermediate]))
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendRootSignIntermediateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendRootSignIntermediateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 csr: Optional[pulumi.Input[str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[bool]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issuer_ref: Optional[pulumi.Input[str]] = None,
                 locality: Optional[pulumi.Input[str]] = None,
                 max_path_length: Optional[pulumi.Input[int]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ou: Optional[pulumi.Input[str]] = None,
                 permitted_dns_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 revoke: Optional[pulumi.Input[bool]] = None,
                 street_address: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_csr_values: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendRootSignIntermediateArgs.__new__(SecretBackendRootSignIntermediateArgs)

            __props__.__dict__["alt_names"] = alt_names
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            if common_name is None and not opts.urn:
                raise TypeError("Missing required property 'common_name'")
            __props__.__dict__["common_name"] = common_name
            __props__.__dict__["country"] = country
            if csr is None and not opts.urn:
                raise TypeError("Missing required property 'csr'")
            __props__.__dict__["csr"] = csr
            __props__.__dict__["exclude_cn_from_sans"] = exclude_cn_from_sans
            __props__.__dict__["format"] = format
            __props__.__dict__["ip_sans"] = ip_sans
            __props__.__dict__["issuer_ref"] = issuer_ref
            __props__.__dict__["locality"] = locality
            __props__.__dict__["max_path_length"] = max_path_length
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["organization"] = organization
            __props__.__dict__["other_sans"] = other_sans
            __props__.__dict__["ou"] = ou
            __props__.__dict__["permitted_dns_domains"] = permitted_dns_domains
            __props__.__dict__["postal_code"] = postal_code
            __props__.__dict__["province"] = province
            __props__.__dict__["revoke"] = revoke
            __props__.__dict__["street_address"] = street_address
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["uri_sans"] = uri_sans
            __props__.__dict__["use_csr_values"] = use_csr_values
            __props__.__dict__["ca_chains"] = None
            __props__.__dict__["certificate"] = None
            __props__.__dict__["certificate_bundle"] = None
            __props__.__dict__["issuing_ca"] = None
            __props__.__dict__["serial_number"] = None
        super(SecretBackendRootSignIntermediate, __self__).__init__(
            'vault:pkiSecret/secretBackendRootSignIntermediate:SecretBackendRootSignIntermediate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            backend: Optional[pulumi.Input[str]] = None,
            ca_chains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            certificate_bundle: Optional[pulumi.Input[str]] = None,
            common_name: Optional[pulumi.Input[str]] = None,
            country: Optional[pulumi.Input[str]] = None,
            csr: Optional[pulumi.Input[str]] = None,
            exclude_cn_from_sans: Optional[pulumi.Input[bool]] = None,
            format: Optional[pulumi.Input[str]] = None,
            ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            issuer_ref: Optional[pulumi.Input[str]] = None,
            issuing_ca: Optional[pulumi.Input[str]] = None,
            locality: Optional[pulumi.Input[str]] = None,
            max_path_length: Optional[pulumi.Input[int]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            organization: Optional[pulumi.Input[str]] = None,
            other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ou: Optional[pulumi.Input[str]] = None,
            permitted_dns_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            postal_code: Optional[pulumi.Input[str]] = None,
            province: Optional[pulumi.Input[str]] = None,
            revoke: Optional[pulumi.Input[bool]] = None,
            serial_number: Optional[pulumi.Input[str]] = None,
            street_address: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[str]] = None,
            uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            use_csr_values: Optional[pulumi.Input[bool]] = None) -> 'SecretBackendRootSignIntermediate':
        """
        Get an existing SecretBackendRootSignIntermediate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alt_names: List of alternative names
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ca_chains: A list of the issuing and intermediate CA certificates in the `format` specified.
        :param pulumi.Input[str] certificate: The intermediate CA certificate in the `format` specified.
        :param pulumi.Input[str] certificate_bundle: The concatenation of the intermediate CA and the issuing CA certificates (PEM encoded). 
               Requires the `format` to be set to any of: pem, pem_bundle. The value will be empty for all other formats.
        :param pulumi.Input[str] common_name: CN of intermediate to create
        :param pulumi.Input[str] country: The country
        :param pulumi.Input[str] csr: The CSR
        :param pulumi.Input[bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[str] issuer_ref: Specifies the default issuer of this request. May
               be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
               the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
               overriding the role's `issuer_ref` value.
        :param pulumi.Input[str] issuing_ca: The issuing CA certificate in the `format` specified.
        :param pulumi.Input[str] locality: The locality
        :param pulumi.Input[int] max_path_length: The maximum path length to encode in the generated certificate
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[str]]] other_sans: List of other SANs
        :param pulumi.Input[str] ou: The organization unit
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permitted_dns_domains: List of domains for which certificates are allowed to be issued
        :param pulumi.Input[str] postal_code: The postal code
        :param pulumi.Input[str] province: The province
        :param pulumi.Input[bool] revoke: If set to `true`, the certificate will be revoked on resource destruction.
        :param pulumi.Input[str] serial_number: The certificate's serial number, hex formatted.
        :param pulumi.Input[str] street_address: The street address
        :param pulumi.Input[str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[str]]] uri_sans: List of alternative URIs
        :param pulumi.Input[bool] use_csr_values: Preserve CSR values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendRootSignIntermediateState.__new__(_SecretBackendRootSignIntermediateState)

        __props__.__dict__["alt_names"] = alt_names
        __props__.__dict__["backend"] = backend
        __props__.__dict__["ca_chains"] = ca_chains
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["certificate_bundle"] = certificate_bundle
        __props__.__dict__["common_name"] = common_name
        __props__.__dict__["country"] = country
        __props__.__dict__["csr"] = csr
        __props__.__dict__["exclude_cn_from_sans"] = exclude_cn_from_sans
        __props__.__dict__["format"] = format
        __props__.__dict__["ip_sans"] = ip_sans
        __props__.__dict__["issuer_ref"] = issuer_ref
        __props__.__dict__["issuing_ca"] = issuing_ca
        __props__.__dict__["locality"] = locality
        __props__.__dict__["max_path_length"] = max_path_length
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["organization"] = organization
        __props__.__dict__["other_sans"] = other_sans
        __props__.__dict__["ou"] = ou
        __props__.__dict__["permitted_dns_domains"] = permitted_dns_domains
        __props__.__dict__["postal_code"] = postal_code
        __props__.__dict__["province"] = province
        __props__.__dict__["revoke"] = revoke
        __props__.__dict__["serial_number"] = serial_number
        __props__.__dict__["street_address"] = street_address
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["uri_sans"] = uri_sans
        __props__.__dict__["use_csr_values"] = use_csr_values
        return SecretBackendRootSignIntermediate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="caChains")
    def ca_chains(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of the issuing and intermediate CA certificates in the `format` specified.
        """
        return pulumi.get(self, "ca_chains")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        The intermediate CA certificate in the `format` specified.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificateBundle")
    def certificate_bundle(self) -> pulumi.Output[str]:
        """
        The concatenation of the intermediate CA and the issuing CA certificates (PEM encoded). 
        Requires the `format` to be set to any of: pem, pem_bundle. The value will be empty for all other formats.
        """
        return pulumi.get(self, "certificate_bundle")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Output[str]:
        """
        CN of intermediate to create
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def country(self) -> pulumi.Output[Optional[str]]:
        """
        The country
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def csr(self) -> pulumi.Output[str]:
        """
        The CSR
        """
        return pulumi.get(self, "csr")

    @property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> pulumi.Output[Optional[bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output[Optional[str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the default issuer of this request. May
        be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
        the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
        overriding the role's `issuer_ref` value.
        """
        return pulumi.get(self, "issuer_ref")

    @property
    @pulumi.getter(name="issuingCa")
    def issuing_ca(self) -> pulumi.Output[str]:
        """
        The issuing CA certificate in the `format` specified.
        """
        return pulumi.get(self, "issuing_ca")

    @property
    @pulumi.getter
    def locality(self) -> pulumi.Output[Optional[str]]:
        """
        The locality
        """
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter(name="maxPathLength")
    def max_path_length(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum path length to encode in the generated certificate
        """
        return pulumi.get(self, "max_path_length")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[Optional[str]]:
        """
        The organization
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @property
    @pulumi.getter
    def ou(self) -> pulumi.Output[Optional[str]]:
        """
        The organization unit
        """
        return pulumi.get(self, "ou")

    @property
    @pulumi.getter(name="permittedDnsDomains")
    def permitted_dns_domains(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of domains for which certificates are allowed to be issued
        """
        return pulumi.get(self, "permitted_dns_domains")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> pulumi.Output[Optional[str]]:
        """
        The postal code
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> pulumi.Output[Optional[str]]:
        """
        The province
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def revoke(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to `true`, the certificate will be revoked on resource destruction.
        """
        return pulumi.get(self, "revoke")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Output[str]:
        """
        The certificate's serial number, hex formatted.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> pulumi.Output[Optional[str]]:
        """
        The street address
        """
        return pulumi.get(self, "street_address")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[str]]:
        """
        Time to live
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @property
    @pulumi.getter(name="useCsrValues")
    def use_csr_values(self) -> pulumi.Output[Optional[bool]]:
        """
        Preserve CSR values
        """
        return pulumi.get(self, "use_csr_values")

