# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 token: pulumi.Input[str],
                 add_address_to_env: Optional[pulumi.Input[str]] = None,
                 auth_login: Optional[pulumi.Input['ProviderAuthLoginArgs']] = None,
                 auth_login_aws: Optional[pulumi.Input['ProviderAuthLoginAwsArgs']] = None,
                 auth_login_azure: Optional[pulumi.Input['ProviderAuthLoginAzureArgs']] = None,
                 auth_login_cert: Optional[pulumi.Input['ProviderAuthLoginCertArgs']] = None,
                 auth_login_gcp: Optional[pulumi.Input['ProviderAuthLoginGcpArgs']] = None,
                 auth_login_jwt: Optional[pulumi.Input['ProviderAuthLoginJwtArgs']] = None,
                 auth_login_kerberos: Optional[pulumi.Input['ProviderAuthLoginKerberosArgs']] = None,
                 auth_login_oci: Optional[pulumi.Input['ProviderAuthLoginOciArgs']] = None,
                 auth_login_oidc: Optional[pulumi.Input['ProviderAuthLoginOidcArgs']] = None,
                 auth_login_radius: Optional[pulumi.Input['ProviderAuthLoginRadiusArgs']] = None,
                 auth_login_token_file: Optional[pulumi.Input['ProviderAuthLoginTokenFileArgs']] = None,
                 auth_login_userpass: Optional[pulumi.Input['ProviderAuthLoginUserpassArgs']] = None,
                 ca_cert_dir: Optional[pulumi.Input[str]] = None,
                 ca_cert_file: Optional[pulumi.Input[str]] = None,
                 client_auth: Optional[pulumi.Input['ProviderClientAuthArgs']] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 max_retries_ccc: Optional[pulumi.Input[int]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 set_namespace_from_token: Optional[pulumi.Input[bool]] = None,
                 skip_child_token: Optional[pulumi.Input[bool]] = None,
                 skip_get_vault_version: Optional[pulumi.Input[bool]] = None,
                 skip_tls_verify: Optional[pulumi.Input[bool]] = None,
                 tls_server_name: Optional[pulumi.Input[str]] = None,
                 token_name: Optional[pulumi.Input[str]] = None,
                 vault_version_override: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] address: URL of the root of the target Vault server.
        :param pulumi.Input[str] token: Token to use to authenticate to Vault.
        :param pulumi.Input['ProviderAuthLoginArgs'] auth_login: Login to vault with an existing auth method using auth/<mount>/login
        :param pulumi.Input['ProviderAuthLoginAwsArgs'] auth_login_aws: Login to vault using the AWS method
        :param pulumi.Input['ProviderAuthLoginAzureArgs'] auth_login_azure: Login to vault using the azure method
        :param pulumi.Input['ProviderAuthLoginCertArgs'] auth_login_cert: Login to vault using the cert method
        :param pulumi.Input['ProviderAuthLoginGcpArgs'] auth_login_gcp: Login to vault using the gcp method
        :param pulumi.Input['ProviderAuthLoginJwtArgs'] auth_login_jwt: Login to vault using the jwt method
        :param pulumi.Input['ProviderAuthLoginKerberosArgs'] auth_login_kerberos: Login to vault using the kerberos method
        :param pulumi.Input['ProviderAuthLoginOciArgs'] auth_login_oci: Login to vault using the OCI method
        :param pulumi.Input['ProviderAuthLoginOidcArgs'] auth_login_oidc: Login to vault using the oidc method
        :param pulumi.Input['ProviderAuthLoginRadiusArgs'] auth_login_radius: Login to vault using the radius method
        :param pulumi.Input['ProviderAuthLoginTokenFileArgs'] auth_login_token_file: Login to vault using
        :param pulumi.Input['ProviderAuthLoginUserpassArgs'] auth_login_userpass: Login to vault using the userpass method
        :param pulumi.Input[str] ca_cert_dir: Path to directory containing CA certificate files to validate the server's certificate.
        :param pulumi.Input[str] ca_cert_file: Path to a CA certificate file to validate the server's certificate.
        :param pulumi.Input['ProviderClientAuthArgs'] client_auth: Client authentication credentials.
        :param pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]] headers: The headers to send with each Vault request.
        :param pulumi.Input[int] max_lease_ttl_seconds: Maximum TTL for secret leases requested by this provider.
        :param pulumi.Input[int] max_retries: Maximum number of retries when a 5xx error code is encountered.
        :param pulumi.Input[int] max_retries_ccc: Maximum number of retries for Client Controlled Consistency related operations
        :param pulumi.Input[str] namespace: The namespace to use. Available only for Vault Enterprise.
        :param pulumi.Input[bool] set_namespace_from_token: In the case where the Vault token is for a specific namespace and the provider namespace is not configured, use the
               token namespace as the root namespace for all resources.
        :param pulumi.Input[bool] skip_child_token: Set this to true to prevent the creation of ephemeral child token used by this provider.
        :param pulumi.Input[bool] skip_get_vault_version: Skip the dynamic fetching of the Vault server version.
        :param pulumi.Input[bool] skip_tls_verify: Set this to true only if the target Vault server is an insecure development instance.
        :param pulumi.Input[str] tls_server_name: Name to use as the SNI host when connecting via TLS.
        :param pulumi.Input[str] token_name: Token name to use for creating the Vault child token.
        :param pulumi.Input[str] vault_version_override: Override the Vault server version, which is normally determined dynamically from the target Vault server
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "token", token)
        if add_address_to_env is not None:
            pulumi.set(__self__, "add_address_to_env", add_address_to_env)
        if auth_login is not None:
            pulumi.set(__self__, "auth_login", auth_login)
        if auth_login_aws is not None:
            pulumi.set(__self__, "auth_login_aws", auth_login_aws)
        if auth_login_azure is not None:
            pulumi.set(__self__, "auth_login_azure", auth_login_azure)
        if auth_login_cert is not None:
            pulumi.set(__self__, "auth_login_cert", auth_login_cert)
        if auth_login_gcp is not None:
            pulumi.set(__self__, "auth_login_gcp", auth_login_gcp)
        if auth_login_jwt is not None:
            pulumi.set(__self__, "auth_login_jwt", auth_login_jwt)
        if auth_login_kerberos is not None:
            pulumi.set(__self__, "auth_login_kerberos", auth_login_kerberos)
        if auth_login_oci is not None:
            pulumi.set(__self__, "auth_login_oci", auth_login_oci)
        if auth_login_oidc is not None:
            pulumi.set(__self__, "auth_login_oidc", auth_login_oidc)
        if auth_login_radius is not None:
            pulumi.set(__self__, "auth_login_radius", auth_login_radius)
        if auth_login_token_file is not None:
            pulumi.set(__self__, "auth_login_token_file", auth_login_token_file)
        if auth_login_userpass is not None:
            pulumi.set(__self__, "auth_login_userpass", auth_login_userpass)
        if ca_cert_dir is not None:
            pulumi.set(__self__, "ca_cert_dir", ca_cert_dir)
        if ca_cert_file is not None:
            pulumi.set(__self__, "ca_cert_file", ca_cert_file)
        if client_auth is not None:
            warnings.warn("""Use auth_login_cert instead""", DeprecationWarning)
            pulumi.log.warn("""client_auth is deprecated: Use auth_login_cert instead""")
        if client_auth is not None:
            pulumi.set(__self__, "client_auth", client_auth)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if max_lease_ttl_seconds is None:
            max_lease_ttl_seconds = (_utilities.get_env_int('TERRAFORM_VAULT_MAX_TTL') or 1200)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if max_retries is None:
            max_retries = (_utilities.get_env_int('VAULT_MAX_RETRIES') or 2)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if max_retries_ccc is not None:
            pulumi.set(__self__, "max_retries_ccc", max_retries_ccc)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if set_namespace_from_token is not None:
            pulumi.set(__self__, "set_namespace_from_token", set_namespace_from_token)
        if skip_child_token is not None:
            pulumi.set(__self__, "skip_child_token", skip_child_token)
        if skip_get_vault_version is not None:
            pulumi.set(__self__, "skip_get_vault_version", skip_get_vault_version)
        if skip_tls_verify is None:
            skip_tls_verify = _utilities.get_env_bool('VAULT_SKIP_VERIFY')
        if skip_tls_verify is not None:
            pulumi.set(__self__, "skip_tls_verify", skip_tls_verify)
        if tls_server_name is not None:
            pulumi.set(__self__, "tls_server_name", tls_server_name)
        if token_name is not None:
            pulumi.set(__self__, "token_name", token_name)
        if vault_version_override is not None:
            pulumi.set(__self__, "vault_version_override", vault_version_override)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        URL of the root of the target Vault server.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        Token to use to authenticate to Vault.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="addAddressToEnv")
    def add_address_to_env(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "add_address_to_env")

    @add_address_to_env.setter
    def add_address_to_env(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "add_address_to_env", value)

    @property
    @pulumi.getter(name="authLogin")
    def auth_login(self) -> Optional[pulumi.Input['ProviderAuthLoginArgs']]:
        """
        Login to vault with an existing auth method using auth/<mount>/login
        """
        return pulumi.get(self, "auth_login")

    @auth_login.setter
    def auth_login(self, value: Optional[pulumi.Input['ProviderAuthLoginArgs']]):
        pulumi.set(self, "auth_login", value)

    @property
    @pulumi.getter(name="authLoginAws")
    def auth_login_aws(self) -> Optional[pulumi.Input['ProviderAuthLoginAwsArgs']]:
        """
        Login to vault using the AWS method
        """
        return pulumi.get(self, "auth_login_aws")

    @auth_login_aws.setter
    def auth_login_aws(self, value: Optional[pulumi.Input['ProviderAuthLoginAwsArgs']]):
        pulumi.set(self, "auth_login_aws", value)

    @property
    @pulumi.getter(name="authLoginAzure")
    def auth_login_azure(self) -> Optional[pulumi.Input['ProviderAuthLoginAzureArgs']]:
        """
        Login to vault using the azure method
        """
        return pulumi.get(self, "auth_login_azure")

    @auth_login_azure.setter
    def auth_login_azure(self, value: Optional[pulumi.Input['ProviderAuthLoginAzureArgs']]):
        pulumi.set(self, "auth_login_azure", value)

    @property
    @pulumi.getter(name="authLoginCert")
    def auth_login_cert(self) -> Optional[pulumi.Input['ProviderAuthLoginCertArgs']]:
        """
        Login to vault using the cert method
        """
        return pulumi.get(self, "auth_login_cert")

    @auth_login_cert.setter
    def auth_login_cert(self, value: Optional[pulumi.Input['ProviderAuthLoginCertArgs']]):
        pulumi.set(self, "auth_login_cert", value)

    @property
    @pulumi.getter(name="authLoginGcp")
    def auth_login_gcp(self) -> Optional[pulumi.Input['ProviderAuthLoginGcpArgs']]:
        """
        Login to vault using the gcp method
        """
        return pulumi.get(self, "auth_login_gcp")

    @auth_login_gcp.setter
    def auth_login_gcp(self, value: Optional[pulumi.Input['ProviderAuthLoginGcpArgs']]):
        pulumi.set(self, "auth_login_gcp", value)

    @property
    @pulumi.getter(name="authLoginJwt")
    def auth_login_jwt(self) -> Optional[pulumi.Input['ProviderAuthLoginJwtArgs']]:
        """
        Login to vault using the jwt method
        """
        return pulumi.get(self, "auth_login_jwt")

    @auth_login_jwt.setter
    def auth_login_jwt(self, value: Optional[pulumi.Input['ProviderAuthLoginJwtArgs']]):
        pulumi.set(self, "auth_login_jwt", value)

    @property
    @pulumi.getter(name="authLoginKerberos")
    def auth_login_kerberos(self) -> Optional[pulumi.Input['ProviderAuthLoginKerberosArgs']]:
        """
        Login to vault using the kerberos method
        """
        return pulumi.get(self, "auth_login_kerberos")

    @auth_login_kerberos.setter
    def auth_login_kerberos(self, value: Optional[pulumi.Input['ProviderAuthLoginKerberosArgs']]):
        pulumi.set(self, "auth_login_kerberos", value)

    @property
    @pulumi.getter(name="authLoginOci")
    def auth_login_oci(self) -> Optional[pulumi.Input['ProviderAuthLoginOciArgs']]:
        """
        Login to vault using the OCI method
        """
        return pulumi.get(self, "auth_login_oci")

    @auth_login_oci.setter
    def auth_login_oci(self, value: Optional[pulumi.Input['ProviderAuthLoginOciArgs']]):
        pulumi.set(self, "auth_login_oci", value)

    @property
    @pulumi.getter(name="authLoginOidc")
    def auth_login_oidc(self) -> Optional[pulumi.Input['ProviderAuthLoginOidcArgs']]:
        """
        Login to vault using the oidc method
        """
        return pulumi.get(self, "auth_login_oidc")

    @auth_login_oidc.setter
    def auth_login_oidc(self, value: Optional[pulumi.Input['ProviderAuthLoginOidcArgs']]):
        pulumi.set(self, "auth_login_oidc", value)

    @property
    @pulumi.getter(name="authLoginRadius")
    def auth_login_radius(self) -> Optional[pulumi.Input['ProviderAuthLoginRadiusArgs']]:
        """
        Login to vault using the radius method
        """
        return pulumi.get(self, "auth_login_radius")

    @auth_login_radius.setter
    def auth_login_radius(self, value: Optional[pulumi.Input['ProviderAuthLoginRadiusArgs']]):
        pulumi.set(self, "auth_login_radius", value)

    @property
    @pulumi.getter(name="authLoginTokenFile")
    def auth_login_token_file(self) -> Optional[pulumi.Input['ProviderAuthLoginTokenFileArgs']]:
        """
        Login to vault using
        """
        return pulumi.get(self, "auth_login_token_file")

    @auth_login_token_file.setter
    def auth_login_token_file(self, value: Optional[pulumi.Input['ProviderAuthLoginTokenFileArgs']]):
        pulumi.set(self, "auth_login_token_file", value)

    @property
    @pulumi.getter(name="authLoginUserpass")
    def auth_login_userpass(self) -> Optional[pulumi.Input['ProviderAuthLoginUserpassArgs']]:
        """
        Login to vault using the userpass method
        """
        return pulumi.get(self, "auth_login_userpass")

    @auth_login_userpass.setter
    def auth_login_userpass(self, value: Optional[pulumi.Input['ProviderAuthLoginUserpassArgs']]):
        pulumi.set(self, "auth_login_userpass", value)

    @property
    @pulumi.getter(name="caCertDir")
    def ca_cert_dir(self) -> Optional[pulumi.Input[str]]:
        """
        Path to directory containing CA certificate files to validate the server's certificate.
        """
        return pulumi.get(self, "ca_cert_dir")

    @ca_cert_dir.setter
    def ca_cert_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_cert_dir", value)

    @property
    @pulumi.getter(name="caCertFile")
    def ca_cert_file(self) -> Optional[pulumi.Input[str]]:
        """
        Path to a CA certificate file to validate the server's certificate.
        """
        return pulumi.get(self, "ca_cert_file")

    @ca_cert_file.setter
    def ca_cert_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_cert_file", value)

    @property
    @pulumi.getter(name="clientAuth")
    def client_auth(self) -> Optional[pulumi.Input['ProviderClientAuthArgs']]:
        """
        Client authentication credentials.
        """
        warnings.warn("""Use auth_login_cert instead""", DeprecationWarning)
        pulumi.log.warn("""client_auth is deprecated: Use auth_login_cert instead""")

        return pulumi.get(self, "client_auth")

    @client_auth.setter
    def client_auth(self, value: Optional[pulumi.Input['ProviderClientAuthArgs']]):
        pulumi.set(self, "client_auth", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]]]:
        """
        The headers to send with each Vault request.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum TTL for secret leases requested by this provider.
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of retries when a 5xx error code is encountered.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter(name="maxRetriesCcc")
    def max_retries_ccc(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of retries for Client Controlled Consistency related operations
        """
        return pulumi.get(self, "max_retries_ccc")

    @max_retries_ccc.setter
    def max_retries_ccc(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries_ccc", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to use. Available only for Vault Enterprise.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="setNamespaceFromToken")
    def set_namespace_from_token(self) -> Optional[pulumi.Input[bool]]:
        """
        In the case where the Vault token is for a specific namespace and the provider namespace is not configured, use the
        token namespace as the root namespace for all resources.
        """
        return pulumi.get(self, "set_namespace_from_token")

    @set_namespace_from_token.setter
    def set_namespace_from_token(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "set_namespace_from_token", value)

    @property
    @pulumi.getter(name="skipChildToken")
    def skip_child_token(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this to true to prevent the creation of ephemeral child token used by this provider.
        """
        return pulumi.get(self, "skip_child_token")

    @skip_child_token.setter
    def skip_child_token(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_child_token", value)

    @property
    @pulumi.getter(name="skipGetVaultVersion")
    def skip_get_vault_version(self) -> Optional[pulumi.Input[bool]]:
        """
        Skip the dynamic fetching of the Vault server version.
        """
        return pulumi.get(self, "skip_get_vault_version")

    @skip_get_vault_version.setter
    def skip_get_vault_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_get_vault_version", value)

    @property
    @pulumi.getter(name="skipTlsVerify")
    def skip_tls_verify(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this to true only if the target Vault server is an insecure development instance.
        """
        return pulumi.get(self, "skip_tls_verify")

    @skip_tls_verify.setter
    def skip_tls_verify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_tls_verify", value)

    @property
    @pulumi.getter(name="tlsServerName")
    def tls_server_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name to use as the SNI host when connecting via TLS.
        """
        return pulumi.get(self, "tls_server_name")

    @tls_server_name.setter
    def tls_server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_server_name", value)

    @property
    @pulumi.getter(name="tokenName")
    def token_name(self) -> Optional[pulumi.Input[str]]:
        """
        Token name to use for creating the Vault child token.
        """
        return pulumi.get(self, "token_name")

    @token_name.setter
    def token_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_name", value)

    @property
    @pulumi.getter(name="vaultVersionOverride")
    def vault_version_override(self) -> Optional[pulumi.Input[str]]:
        """
        Override the Vault server version, which is normally determined dynamically from the target Vault server
        """
        return pulumi.get(self, "vault_version_override")

    @vault_version_override.setter
    def vault_version_override(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_version_override", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_address_to_env: Optional[pulumi.Input[str]] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 auth_login: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginArgs']]] = None,
                 auth_login_aws: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginAwsArgs']]] = None,
                 auth_login_azure: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginAzureArgs']]] = None,
                 auth_login_cert: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginCertArgs']]] = None,
                 auth_login_gcp: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginGcpArgs']]] = None,
                 auth_login_jwt: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginJwtArgs']]] = None,
                 auth_login_kerberos: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginKerberosArgs']]] = None,
                 auth_login_oci: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginOciArgs']]] = None,
                 auth_login_oidc: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginOidcArgs']]] = None,
                 auth_login_radius: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginRadiusArgs']]] = None,
                 auth_login_token_file: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginTokenFileArgs']]] = None,
                 auth_login_userpass: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginUserpassArgs']]] = None,
                 ca_cert_dir: Optional[pulumi.Input[str]] = None,
                 ca_cert_file: Optional[pulumi.Input[str]] = None,
                 client_auth: Optional[pulumi.Input[pulumi.InputType['ProviderClientAuthArgs']]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProviderHeaderArgs']]]]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 max_retries_ccc: Optional[pulumi.Input[int]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 set_namespace_from_token: Optional[pulumi.Input[bool]] = None,
                 skip_child_token: Optional[pulumi.Input[bool]] = None,
                 skip_get_vault_version: Optional[pulumi.Input[bool]] = None,
                 skip_tls_verify: Optional[pulumi.Input[bool]] = None,
                 tls_server_name: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 token_name: Optional[pulumi.Input[str]] = None,
                 vault_version_override: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the vault package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: URL of the root of the target Vault server.
        :param pulumi.Input[pulumi.InputType['ProviderAuthLoginArgs']] auth_login: Login to vault with an existing auth method using auth/<mount>/login
        :param pulumi.Input[pulumi.InputType['ProviderAuthLoginAwsArgs']] auth_login_aws: Login to vault using the AWS method
        :param pulumi.Input[pulumi.InputType['ProviderAuthLoginAzureArgs']] auth_login_azure: Login to vault using the azure method
        :param pulumi.Input[pulumi.InputType['ProviderAuthLoginCertArgs']] auth_login_cert: Login to vault using the cert method
        :param pulumi.Input[pulumi.InputType['ProviderAuthLoginGcpArgs']] auth_login_gcp: Login to vault using the gcp method
        :param pulumi.Input[pulumi.InputType['ProviderAuthLoginJwtArgs']] auth_login_jwt: Login to vault using the jwt method
        :param pulumi.Input[pulumi.InputType['ProviderAuthLoginKerberosArgs']] auth_login_kerberos: Login to vault using the kerberos method
        :param pulumi.Input[pulumi.InputType['ProviderAuthLoginOciArgs']] auth_login_oci: Login to vault using the OCI method
        :param pulumi.Input[pulumi.InputType['ProviderAuthLoginOidcArgs']] auth_login_oidc: Login to vault using the oidc method
        :param pulumi.Input[pulumi.InputType['ProviderAuthLoginRadiusArgs']] auth_login_radius: Login to vault using the radius method
        :param pulumi.Input[pulumi.InputType['ProviderAuthLoginTokenFileArgs']] auth_login_token_file: Login to vault using
        :param pulumi.Input[pulumi.InputType['ProviderAuthLoginUserpassArgs']] auth_login_userpass: Login to vault using the userpass method
        :param pulumi.Input[str] ca_cert_dir: Path to directory containing CA certificate files to validate the server's certificate.
        :param pulumi.Input[str] ca_cert_file: Path to a CA certificate file to validate the server's certificate.
        :param pulumi.Input[pulumi.InputType['ProviderClientAuthArgs']] client_auth: Client authentication credentials.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProviderHeaderArgs']]]] headers: The headers to send with each Vault request.
        :param pulumi.Input[int] max_lease_ttl_seconds: Maximum TTL for secret leases requested by this provider.
        :param pulumi.Input[int] max_retries: Maximum number of retries when a 5xx error code is encountered.
        :param pulumi.Input[int] max_retries_ccc: Maximum number of retries for Client Controlled Consistency related operations
        :param pulumi.Input[str] namespace: The namespace to use. Available only for Vault Enterprise.
        :param pulumi.Input[bool] set_namespace_from_token: In the case where the Vault token is for a specific namespace and the provider namespace is not configured, use the
               token namespace as the root namespace for all resources.
        :param pulumi.Input[bool] skip_child_token: Set this to true to prevent the creation of ephemeral child token used by this provider.
        :param pulumi.Input[bool] skip_get_vault_version: Skip the dynamic fetching of the Vault server version.
        :param pulumi.Input[bool] skip_tls_verify: Set this to true only if the target Vault server is an insecure development instance.
        :param pulumi.Input[str] tls_server_name: Name to use as the SNI host when connecting via TLS.
        :param pulumi.Input[str] token: Token to use to authenticate to Vault.
        :param pulumi.Input[str] token_name: Token name to use for creating the Vault child token.
        :param pulumi.Input[str] vault_version_override: Override the Vault server version, which is normally determined dynamically from the target Vault server
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the vault package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_address_to_env: Optional[pulumi.Input[str]] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 auth_login: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginArgs']]] = None,
                 auth_login_aws: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginAwsArgs']]] = None,
                 auth_login_azure: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginAzureArgs']]] = None,
                 auth_login_cert: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginCertArgs']]] = None,
                 auth_login_gcp: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginGcpArgs']]] = None,
                 auth_login_jwt: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginJwtArgs']]] = None,
                 auth_login_kerberos: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginKerberosArgs']]] = None,
                 auth_login_oci: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginOciArgs']]] = None,
                 auth_login_oidc: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginOidcArgs']]] = None,
                 auth_login_radius: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginRadiusArgs']]] = None,
                 auth_login_token_file: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginTokenFileArgs']]] = None,
                 auth_login_userpass: Optional[pulumi.Input[pulumi.InputType['ProviderAuthLoginUserpassArgs']]] = None,
                 ca_cert_dir: Optional[pulumi.Input[str]] = None,
                 ca_cert_file: Optional[pulumi.Input[str]] = None,
                 client_auth: Optional[pulumi.Input[pulumi.InputType['ProviderClientAuthArgs']]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProviderHeaderArgs']]]]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 max_retries_ccc: Optional[pulumi.Input[int]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 set_namespace_from_token: Optional[pulumi.Input[bool]] = None,
                 skip_child_token: Optional[pulumi.Input[bool]] = None,
                 skip_get_vault_version: Optional[pulumi.Input[bool]] = None,
                 skip_tls_verify: Optional[pulumi.Input[bool]] = None,
                 tls_server_name: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 token_name: Optional[pulumi.Input[str]] = None,
                 vault_version_override: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["add_address_to_env"] = add_address_to_env
            if address is None and not opts.urn:
                raise TypeError("Missing required property 'address'")
            __props__.__dict__["address"] = address
            __props__.__dict__["auth_login"] = pulumi.Output.from_input(auth_login).apply(pulumi.runtime.to_json) if auth_login is not None else None
            __props__.__dict__["auth_login_aws"] = pulumi.Output.from_input(auth_login_aws).apply(pulumi.runtime.to_json) if auth_login_aws is not None else None
            __props__.__dict__["auth_login_azure"] = pulumi.Output.from_input(auth_login_azure).apply(pulumi.runtime.to_json) if auth_login_azure is not None else None
            __props__.__dict__["auth_login_cert"] = pulumi.Output.from_input(auth_login_cert).apply(pulumi.runtime.to_json) if auth_login_cert is not None else None
            __props__.__dict__["auth_login_gcp"] = pulumi.Output.from_input(auth_login_gcp).apply(pulumi.runtime.to_json) if auth_login_gcp is not None else None
            __props__.__dict__["auth_login_jwt"] = pulumi.Output.from_input(auth_login_jwt).apply(pulumi.runtime.to_json) if auth_login_jwt is not None else None
            __props__.__dict__["auth_login_kerberos"] = pulumi.Output.from_input(auth_login_kerberos).apply(pulumi.runtime.to_json) if auth_login_kerberos is not None else None
            __props__.__dict__["auth_login_oci"] = pulumi.Output.from_input(auth_login_oci).apply(pulumi.runtime.to_json) if auth_login_oci is not None else None
            __props__.__dict__["auth_login_oidc"] = pulumi.Output.from_input(auth_login_oidc).apply(pulumi.runtime.to_json) if auth_login_oidc is not None else None
            __props__.__dict__["auth_login_radius"] = pulumi.Output.from_input(auth_login_radius).apply(pulumi.runtime.to_json) if auth_login_radius is not None else None
            __props__.__dict__["auth_login_token_file"] = pulumi.Output.from_input(auth_login_token_file).apply(pulumi.runtime.to_json) if auth_login_token_file is not None else None
            __props__.__dict__["auth_login_userpass"] = pulumi.Output.from_input(auth_login_userpass).apply(pulumi.runtime.to_json) if auth_login_userpass is not None else None
            __props__.__dict__["ca_cert_dir"] = ca_cert_dir
            __props__.__dict__["ca_cert_file"] = ca_cert_file
            __props__.__dict__["client_auth"] = pulumi.Output.from_input(client_auth).apply(pulumi.runtime.to_json) if client_auth is not None else None
            __props__.__dict__["headers"] = pulumi.Output.secret(headers).apply(pulumi.runtime.to_json) if headers is not None else None
            if max_lease_ttl_seconds is None:
                max_lease_ttl_seconds = (_utilities.get_env_int('TERRAFORM_VAULT_MAX_TTL') or 1200)
            __props__.__dict__["max_lease_ttl_seconds"] = pulumi.Output.from_input(max_lease_ttl_seconds).apply(pulumi.runtime.to_json) if max_lease_ttl_seconds is not None else None
            if max_retries is None:
                max_retries = (_utilities.get_env_int('VAULT_MAX_RETRIES') or 2)
            __props__.__dict__["max_retries"] = pulumi.Output.from_input(max_retries).apply(pulumi.runtime.to_json) if max_retries is not None else None
            __props__.__dict__["max_retries_ccc"] = pulumi.Output.from_input(max_retries_ccc).apply(pulumi.runtime.to_json) if max_retries_ccc is not None else None
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["set_namespace_from_token"] = pulumi.Output.from_input(set_namespace_from_token).apply(pulumi.runtime.to_json) if set_namespace_from_token is not None else None
            __props__.__dict__["skip_child_token"] = pulumi.Output.from_input(skip_child_token).apply(pulumi.runtime.to_json) if skip_child_token is not None else None
            __props__.__dict__["skip_get_vault_version"] = pulumi.Output.from_input(skip_get_vault_version).apply(pulumi.runtime.to_json) if skip_get_vault_version is not None else None
            if skip_tls_verify is None:
                skip_tls_verify = _utilities.get_env_bool('VAULT_SKIP_VERIFY')
            __props__.__dict__["skip_tls_verify"] = pulumi.Output.from_input(skip_tls_verify).apply(pulumi.runtime.to_json) if skip_tls_verify is not None else None
            __props__.__dict__["tls_server_name"] = tls_server_name
            if token is None and not opts.urn:
                raise TypeError("Missing required property 'token'")
            __props__.__dict__["token"] = token
            __props__.__dict__["token_name"] = token_name
            __props__.__dict__["vault_version_override"] = vault_version_override
        super(Provider, __self__).__init__(
            'vault',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="addAddressToEnv")
    def add_address_to_env(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "add_address_to_env")

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[str]:
        """
        URL of the root of the target Vault server.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="caCertDir")
    def ca_cert_dir(self) -> pulumi.Output[Optional[str]]:
        """
        Path to directory containing CA certificate files to validate the server's certificate.
        """
        return pulumi.get(self, "ca_cert_dir")

    @property
    @pulumi.getter(name="caCertFile")
    def ca_cert_file(self) -> pulumi.Output[Optional[str]]:
        """
        Path to a CA certificate file to validate the server's certificate.
        """
        return pulumi.get(self, "ca_cert_file")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to use. Available only for Vault Enterprise.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="tlsServerName")
    def tls_server_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name to use as the SNI host when connecting via TLS.
        """
        return pulumi.get(self, "tls_server_name")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        """
        Token to use to authenticate to Vault.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="tokenName")
    def token_name(self) -> pulumi.Output[Optional[str]]:
        """
        Token name to use for creating the Vault child token.
        """
        return pulumi.get(self, "token_name")

    @property
    @pulumi.getter(name="vaultVersionOverride")
    def vault_version_override(self) -> pulumi.Output[Optional[str]]:
        """
        Override the Vault server version, which is normally determined dynamically from the target Vault server
        """
        return pulumi.get(self, "vault_version_override")

