# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['RaftSnapshotAgentConfigArgs', 'RaftSnapshotAgentConfig']

@pulumi.input_type
class RaftSnapshotAgentConfigArgs:
    def __init__(__self__, *,
                 interval_seconds: pulumi.Input[int],
                 path_prefix: pulumi.Input[str],
                 storage_type: pulumi.Input[str],
                 aws_access_key_id: Optional[pulumi.Input[str]] = None,
                 aws_s3_bucket: Optional[pulumi.Input[str]] = None,
                 aws_s3_disable_tls: Optional[pulumi.Input[bool]] = None,
                 aws_s3_enable_kms: Optional[pulumi.Input[bool]] = None,
                 aws_s3_endpoint: Optional[pulumi.Input[str]] = None,
                 aws_s3_force_path_style: Optional[pulumi.Input[bool]] = None,
                 aws_s3_kms_key: Optional[pulumi.Input[str]] = None,
                 aws_s3_region: Optional[pulumi.Input[str]] = None,
                 aws_s3_server_side_encryption: Optional[pulumi.Input[bool]] = None,
                 aws_secret_access_key: Optional[pulumi.Input[str]] = None,
                 aws_session_token: Optional[pulumi.Input[str]] = None,
                 azure_account_key: Optional[pulumi.Input[str]] = None,
                 azure_account_name: Optional[pulumi.Input[str]] = None,
                 azure_blob_environment: Optional[pulumi.Input[str]] = None,
                 azure_container_name: Optional[pulumi.Input[str]] = None,
                 azure_endpoint: Optional[pulumi.Input[str]] = None,
                 file_prefix: Optional[pulumi.Input[str]] = None,
                 google_disable_tls: Optional[pulumi.Input[bool]] = None,
                 google_endpoint: Optional[pulumi.Input[str]] = None,
                 google_gcs_bucket: Optional[pulumi.Input[str]] = None,
                 google_service_account_key: Optional[pulumi.Input[str]] = None,
                 local_max_space: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 retain: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a RaftSnapshotAgentConfig resource.
        :param pulumi.Input[int] interval_seconds: `<required>` - Time (in seconds) between snapshots.
        :param pulumi.Input[str] path_prefix: `<required>` - For `storage_type = "local"`, the directory to
               write the snapshots in. For cloud storage types, the bucket prefix to use.
               Types `azure-s3` and `google-gcs` require a trailing `/` (slash).
               Types `local` and `aws-s3` the trailing `/` is optional.
        :param pulumi.Input[str] storage_type: `<required>` - One of "local", "azure-blob", "aws-s3",
               or "google-gcs". The remaining parameters described below are all specific to
               the selected `storage_type` and prefixed accordingly.
        :param pulumi.Input[str] aws_access_key_id: AWS access key ID.
        :param pulumi.Input[str] aws_s3_bucket: S3 bucket to write snapshots to.
        :param pulumi.Input[bool] aws_s3_disable_tls: Disable TLS for the S3 endpoint. This should only be used for testing purposes.
        :param pulumi.Input[bool] aws_s3_enable_kms: Use KMS to encrypt bucket contents.
        :param pulumi.Input[str] aws_s3_endpoint: AWS endpoint. This is typically only set when using a non-AWS S3 implementation like Minio.
        :param pulumi.Input[bool] aws_s3_force_path_style: Use the endpoint/bucket URL style instead of bucket.endpoint.
        :param pulumi.Input[str] aws_s3_kms_key: Use named KMS key, when aws_s3_enable_kms=true
        :param pulumi.Input[str] aws_s3_region: AWS region bucket is in.
        :param pulumi.Input[bool] aws_s3_server_side_encryption: Use AES256 to encrypt bucket contents.
        :param pulumi.Input[str] aws_secret_access_key: AWS secret access key.
        :param pulumi.Input[str] aws_session_token: AWS session token.
        :param pulumi.Input[str] azure_account_key: Azure account key.
        :param pulumi.Input[str] azure_account_name: Azure account name.
        :param pulumi.Input[str] azure_blob_environment: Azure blob environment.
        :param pulumi.Input[str] azure_container_name: Azure container name to write snapshots to.
        :param pulumi.Input[str] azure_endpoint: Azure blob storage endpoint. This is typically only set when using a non-Azure implementation like Azurite.
        :param pulumi.Input[str] file_prefix: Within the directory or bucket
               prefix given by `path_prefix`, the file or object name of snapshot files
               will start with this string.
        :param pulumi.Input[bool] google_disable_tls: Disable TLS for the GCS endpoint.
        :param pulumi.Input[str] google_endpoint: GCS endpoint. This is typically only set when using a non-Google GCS implementation like fake-gcs-server.
        :param pulumi.Input[str] google_gcs_bucket: GCS bucket to write snapshots to.
        :param pulumi.Input[str] google_service_account_key: Google service account key in JSON format.
        :param pulumi.Input[int] local_max_space: The maximum space, in bytes, to use for snapshots.
        :param pulumi.Input[str] name: `<required>` – Name of the configuration to modify.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[int] retain: How many snapshots are to be kept; when writing a
               snapshot, if there are more snapshots already stored than this number, the
               oldest ones will be deleted.
        """
        pulumi.set(__self__, "interval_seconds", interval_seconds)
        pulumi.set(__self__, "path_prefix", path_prefix)
        pulumi.set(__self__, "storage_type", storage_type)
        if aws_access_key_id is not None:
            pulumi.set(__self__, "aws_access_key_id", aws_access_key_id)
        if aws_s3_bucket is not None:
            pulumi.set(__self__, "aws_s3_bucket", aws_s3_bucket)
        if aws_s3_disable_tls is not None:
            pulumi.set(__self__, "aws_s3_disable_tls", aws_s3_disable_tls)
        if aws_s3_enable_kms is not None:
            pulumi.set(__self__, "aws_s3_enable_kms", aws_s3_enable_kms)
        if aws_s3_endpoint is not None:
            pulumi.set(__self__, "aws_s3_endpoint", aws_s3_endpoint)
        if aws_s3_force_path_style is not None:
            pulumi.set(__self__, "aws_s3_force_path_style", aws_s3_force_path_style)
        if aws_s3_kms_key is not None:
            pulumi.set(__self__, "aws_s3_kms_key", aws_s3_kms_key)
        if aws_s3_region is not None:
            pulumi.set(__self__, "aws_s3_region", aws_s3_region)
        if aws_s3_server_side_encryption is not None:
            pulumi.set(__self__, "aws_s3_server_side_encryption", aws_s3_server_side_encryption)
        if aws_secret_access_key is not None:
            pulumi.set(__self__, "aws_secret_access_key", aws_secret_access_key)
        if aws_session_token is not None:
            pulumi.set(__self__, "aws_session_token", aws_session_token)
        if azure_account_key is not None:
            pulumi.set(__self__, "azure_account_key", azure_account_key)
        if azure_account_name is not None:
            pulumi.set(__self__, "azure_account_name", azure_account_name)
        if azure_blob_environment is not None:
            pulumi.set(__self__, "azure_blob_environment", azure_blob_environment)
        if azure_container_name is not None:
            pulumi.set(__self__, "azure_container_name", azure_container_name)
        if azure_endpoint is not None:
            pulumi.set(__self__, "azure_endpoint", azure_endpoint)
        if file_prefix is not None:
            pulumi.set(__self__, "file_prefix", file_prefix)
        if google_disable_tls is not None:
            pulumi.set(__self__, "google_disable_tls", google_disable_tls)
        if google_endpoint is not None:
            pulumi.set(__self__, "google_endpoint", google_endpoint)
        if google_gcs_bucket is not None:
            pulumi.set(__self__, "google_gcs_bucket", google_gcs_bucket)
        if google_service_account_key is not None:
            pulumi.set(__self__, "google_service_account_key", google_service_account_key)
        if local_max_space is not None:
            pulumi.set(__self__, "local_max_space", local_max_space)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if retain is not None:
            pulumi.set(__self__, "retain", retain)

    @property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> pulumi.Input[int]:
        """
        `<required>` - Time (in seconds) between snapshots.
        """
        return pulumi.get(self, "interval_seconds")

    @interval_seconds.setter
    def interval_seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "interval_seconds", value)

    @property
    @pulumi.getter(name="pathPrefix")
    def path_prefix(self) -> pulumi.Input[str]:
        """
        `<required>` - For `storage_type = "local"`, the directory to
        write the snapshots in. For cloud storage types, the bucket prefix to use.
        Types `azure-s3` and `google-gcs` require a trailing `/` (slash).
        Types `local` and `aws-s3` the trailing `/` is optional.
        """
        return pulumi.get(self, "path_prefix")

    @path_prefix.setter
    def path_prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "path_prefix", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input[str]:
        """
        `<required>` - One of "local", "azure-blob", "aws-s3",
        or "google-gcs". The remaining parameters described below are all specific to
        the selected `storage_type` and prefixed accordingly.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="awsAccessKeyId")
    def aws_access_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS access key ID.
        """
        return pulumi.get(self, "aws_access_key_id")

    @aws_access_key_id.setter
    def aws_access_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_access_key_id", value)

    @property
    @pulumi.getter(name="awsS3Bucket")
    def aws_s3_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        S3 bucket to write snapshots to.
        """
        return pulumi.get(self, "aws_s3_bucket")

    @aws_s3_bucket.setter
    def aws_s3_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_s3_bucket", value)

    @property
    @pulumi.getter(name="awsS3DisableTls")
    def aws_s3_disable_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable TLS for the S3 endpoint. This should only be used for testing purposes.
        """
        return pulumi.get(self, "aws_s3_disable_tls")

    @aws_s3_disable_tls.setter
    def aws_s3_disable_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aws_s3_disable_tls", value)

    @property
    @pulumi.getter(name="awsS3EnableKms")
    def aws_s3_enable_kms(self) -> Optional[pulumi.Input[bool]]:
        """
        Use KMS to encrypt bucket contents.
        """
        return pulumi.get(self, "aws_s3_enable_kms")

    @aws_s3_enable_kms.setter
    def aws_s3_enable_kms(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aws_s3_enable_kms", value)

    @property
    @pulumi.getter(name="awsS3Endpoint")
    def aws_s3_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        AWS endpoint. This is typically only set when using a non-AWS S3 implementation like Minio.
        """
        return pulumi.get(self, "aws_s3_endpoint")

    @aws_s3_endpoint.setter
    def aws_s3_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_s3_endpoint", value)

    @property
    @pulumi.getter(name="awsS3ForcePathStyle")
    def aws_s3_force_path_style(self) -> Optional[pulumi.Input[bool]]:
        """
        Use the endpoint/bucket URL style instead of bucket.endpoint.
        """
        return pulumi.get(self, "aws_s3_force_path_style")

    @aws_s3_force_path_style.setter
    def aws_s3_force_path_style(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aws_s3_force_path_style", value)

    @property
    @pulumi.getter(name="awsS3KmsKey")
    def aws_s3_kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        Use named KMS key, when aws_s3_enable_kms=true
        """
        return pulumi.get(self, "aws_s3_kms_key")

    @aws_s3_kms_key.setter
    def aws_s3_kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_s3_kms_key", value)

    @property
    @pulumi.getter(name="awsS3Region")
    def aws_s3_region(self) -> Optional[pulumi.Input[str]]:
        """
        AWS region bucket is in.
        """
        return pulumi.get(self, "aws_s3_region")

    @aws_s3_region.setter
    def aws_s3_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_s3_region", value)

    @property
    @pulumi.getter(name="awsS3ServerSideEncryption")
    def aws_s3_server_side_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        Use AES256 to encrypt bucket contents.
        """
        return pulumi.get(self, "aws_s3_server_side_encryption")

    @aws_s3_server_side_encryption.setter
    def aws_s3_server_side_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aws_s3_server_side_encryption", value)

    @property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        AWS secret access key.
        """
        return pulumi.get(self, "aws_secret_access_key")

    @aws_secret_access_key.setter
    def aws_secret_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_secret_access_key", value)

    @property
    @pulumi.getter(name="awsSessionToken")
    def aws_session_token(self) -> Optional[pulumi.Input[str]]:
        """
        AWS session token.
        """
        return pulumi.get(self, "aws_session_token")

    @aws_session_token.setter
    def aws_session_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_session_token", value)

    @property
    @pulumi.getter(name="azureAccountKey")
    def azure_account_key(self) -> Optional[pulumi.Input[str]]:
        """
        Azure account key.
        """
        return pulumi.get(self, "azure_account_key")

    @azure_account_key.setter
    def azure_account_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_account_key", value)

    @property
    @pulumi.getter(name="azureAccountName")
    def azure_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Azure account name.
        """
        return pulumi.get(self, "azure_account_name")

    @azure_account_name.setter
    def azure_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_account_name", value)

    @property
    @pulumi.getter(name="azureBlobEnvironment")
    def azure_blob_environment(self) -> Optional[pulumi.Input[str]]:
        """
        Azure blob environment.
        """
        return pulumi.get(self, "azure_blob_environment")

    @azure_blob_environment.setter
    def azure_blob_environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_blob_environment", value)

    @property
    @pulumi.getter(name="azureContainerName")
    def azure_container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Azure container name to write snapshots to.
        """
        return pulumi.get(self, "azure_container_name")

    @azure_container_name.setter
    def azure_container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_container_name", value)

    @property
    @pulumi.getter(name="azureEndpoint")
    def azure_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Azure blob storage endpoint. This is typically only set when using a non-Azure implementation like Azurite.
        """
        return pulumi.get(self, "azure_endpoint")

    @azure_endpoint.setter
    def azure_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_endpoint", value)

    @property
    @pulumi.getter(name="filePrefix")
    def file_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Within the directory or bucket
        prefix given by `path_prefix`, the file or object name of snapshot files
        will start with this string.
        """
        return pulumi.get(self, "file_prefix")

    @file_prefix.setter
    def file_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_prefix", value)

    @property
    @pulumi.getter(name="googleDisableTls")
    def google_disable_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable TLS for the GCS endpoint.
        """
        return pulumi.get(self, "google_disable_tls")

    @google_disable_tls.setter
    def google_disable_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "google_disable_tls", value)

    @property
    @pulumi.getter(name="googleEndpoint")
    def google_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        GCS endpoint. This is typically only set when using a non-Google GCS implementation like fake-gcs-server.
        """
        return pulumi.get(self, "google_endpoint")

    @google_endpoint.setter
    def google_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "google_endpoint", value)

    @property
    @pulumi.getter(name="googleGcsBucket")
    def google_gcs_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        GCS bucket to write snapshots to.
        """
        return pulumi.get(self, "google_gcs_bucket")

    @google_gcs_bucket.setter
    def google_gcs_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "google_gcs_bucket", value)

    @property
    @pulumi.getter(name="googleServiceAccountKey")
    def google_service_account_key(self) -> Optional[pulumi.Input[str]]:
        """
        Google service account key in JSON format.
        """
        return pulumi.get(self, "google_service_account_key")

    @google_service_account_key.setter
    def google_service_account_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "google_service_account_key", value)

    @property
    @pulumi.getter(name="localMaxSpace")
    def local_max_space(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum space, in bytes, to use for snapshots.
        """
        return pulumi.get(self, "local_max_space")

    @local_max_space.setter
    def local_max_space(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "local_max_space", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        `<required>` – Name of the configuration to modify.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def retain(self) -> Optional[pulumi.Input[int]]:
        """
        How many snapshots are to be kept; when writing a
        snapshot, if there are more snapshots already stored than this number, the
        oldest ones will be deleted.
        """
        return pulumi.get(self, "retain")

    @retain.setter
    def retain(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retain", value)


@pulumi.input_type
class _RaftSnapshotAgentConfigState:
    def __init__(__self__, *,
                 aws_access_key_id: Optional[pulumi.Input[str]] = None,
                 aws_s3_bucket: Optional[pulumi.Input[str]] = None,
                 aws_s3_disable_tls: Optional[pulumi.Input[bool]] = None,
                 aws_s3_enable_kms: Optional[pulumi.Input[bool]] = None,
                 aws_s3_endpoint: Optional[pulumi.Input[str]] = None,
                 aws_s3_force_path_style: Optional[pulumi.Input[bool]] = None,
                 aws_s3_kms_key: Optional[pulumi.Input[str]] = None,
                 aws_s3_region: Optional[pulumi.Input[str]] = None,
                 aws_s3_server_side_encryption: Optional[pulumi.Input[bool]] = None,
                 aws_secret_access_key: Optional[pulumi.Input[str]] = None,
                 aws_session_token: Optional[pulumi.Input[str]] = None,
                 azure_account_key: Optional[pulumi.Input[str]] = None,
                 azure_account_name: Optional[pulumi.Input[str]] = None,
                 azure_blob_environment: Optional[pulumi.Input[str]] = None,
                 azure_container_name: Optional[pulumi.Input[str]] = None,
                 azure_endpoint: Optional[pulumi.Input[str]] = None,
                 file_prefix: Optional[pulumi.Input[str]] = None,
                 google_disable_tls: Optional[pulumi.Input[bool]] = None,
                 google_endpoint: Optional[pulumi.Input[str]] = None,
                 google_gcs_bucket: Optional[pulumi.Input[str]] = None,
                 google_service_account_key: Optional[pulumi.Input[str]] = None,
                 interval_seconds: Optional[pulumi.Input[int]] = None,
                 local_max_space: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 path_prefix: Optional[pulumi.Input[str]] = None,
                 retain: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RaftSnapshotAgentConfig resources.
        :param pulumi.Input[str] aws_access_key_id: AWS access key ID.
        :param pulumi.Input[str] aws_s3_bucket: S3 bucket to write snapshots to.
        :param pulumi.Input[bool] aws_s3_disable_tls: Disable TLS for the S3 endpoint. This should only be used for testing purposes.
        :param pulumi.Input[bool] aws_s3_enable_kms: Use KMS to encrypt bucket contents.
        :param pulumi.Input[str] aws_s3_endpoint: AWS endpoint. This is typically only set when using a non-AWS S3 implementation like Minio.
        :param pulumi.Input[bool] aws_s3_force_path_style: Use the endpoint/bucket URL style instead of bucket.endpoint.
        :param pulumi.Input[str] aws_s3_kms_key: Use named KMS key, when aws_s3_enable_kms=true
        :param pulumi.Input[str] aws_s3_region: AWS region bucket is in.
        :param pulumi.Input[bool] aws_s3_server_side_encryption: Use AES256 to encrypt bucket contents.
        :param pulumi.Input[str] aws_secret_access_key: AWS secret access key.
        :param pulumi.Input[str] aws_session_token: AWS session token.
        :param pulumi.Input[str] azure_account_key: Azure account key.
        :param pulumi.Input[str] azure_account_name: Azure account name.
        :param pulumi.Input[str] azure_blob_environment: Azure blob environment.
        :param pulumi.Input[str] azure_container_name: Azure container name to write snapshots to.
        :param pulumi.Input[str] azure_endpoint: Azure blob storage endpoint. This is typically only set when using a non-Azure implementation like Azurite.
        :param pulumi.Input[str] file_prefix: Within the directory or bucket
               prefix given by `path_prefix`, the file or object name of snapshot files
               will start with this string.
        :param pulumi.Input[bool] google_disable_tls: Disable TLS for the GCS endpoint.
        :param pulumi.Input[str] google_endpoint: GCS endpoint. This is typically only set when using a non-Google GCS implementation like fake-gcs-server.
        :param pulumi.Input[str] google_gcs_bucket: GCS bucket to write snapshots to.
        :param pulumi.Input[str] google_service_account_key: Google service account key in JSON format.
        :param pulumi.Input[int] interval_seconds: `<required>` - Time (in seconds) between snapshots.
        :param pulumi.Input[int] local_max_space: The maximum space, in bytes, to use for snapshots.
        :param pulumi.Input[str] name: `<required>` – Name of the configuration to modify.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] path_prefix: `<required>` - For `storage_type = "local"`, the directory to
               write the snapshots in. For cloud storage types, the bucket prefix to use.
               Types `azure-s3` and `google-gcs` require a trailing `/` (slash).
               Types `local` and `aws-s3` the trailing `/` is optional.
        :param pulumi.Input[int] retain: How many snapshots are to be kept; when writing a
               snapshot, if there are more snapshots already stored than this number, the
               oldest ones will be deleted.
        :param pulumi.Input[str] storage_type: `<required>` - One of "local", "azure-blob", "aws-s3",
               or "google-gcs". The remaining parameters described below are all specific to
               the selected `storage_type` and prefixed accordingly.
        """
        if aws_access_key_id is not None:
            pulumi.set(__self__, "aws_access_key_id", aws_access_key_id)
        if aws_s3_bucket is not None:
            pulumi.set(__self__, "aws_s3_bucket", aws_s3_bucket)
        if aws_s3_disable_tls is not None:
            pulumi.set(__self__, "aws_s3_disable_tls", aws_s3_disable_tls)
        if aws_s3_enable_kms is not None:
            pulumi.set(__self__, "aws_s3_enable_kms", aws_s3_enable_kms)
        if aws_s3_endpoint is not None:
            pulumi.set(__self__, "aws_s3_endpoint", aws_s3_endpoint)
        if aws_s3_force_path_style is not None:
            pulumi.set(__self__, "aws_s3_force_path_style", aws_s3_force_path_style)
        if aws_s3_kms_key is not None:
            pulumi.set(__self__, "aws_s3_kms_key", aws_s3_kms_key)
        if aws_s3_region is not None:
            pulumi.set(__self__, "aws_s3_region", aws_s3_region)
        if aws_s3_server_side_encryption is not None:
            pulumi.set(__self__, "aws_s3_server_side_encryption", aws_s3_server_side_encryption)
        if aws_secret_access_key is not None:
            pulumi.set(__self__, "aws_secret_access_key", aws_secret_access_key)
        if aws_session_token is not None:
            pulumi.set(__self__, "aws_session_token", aws_session_token)
        if azure_account_key is not None:
            pulumi.set(__self__, "azure_account_key", azure_account_key)
        if azure_account_name is not None:
            pulumi.set(__self__, "azure_account_name", azure_account_name)
        if azure_blob_environment is not None:
            pulumi.set(__self__, "azure_blob_environment", azure_blob_environment)
        if azure_container_name is not None:
            pulumi.set(__self__, "azure_container_name", azure_container_name)
        if azure_endpoint is not None:
            pulumi.set(__self__, "azure_endpoint", azure_endpoint)
        if file_prefix is not None:
            pulumi.set(__self__, "file_prefix", file_prefix)
        if google_disable_tls is not None:
            pulumi.set(__self__, "google_disable_tls", google_disable_tls)
        if google_endpoint is not None:
            pulumi.set(__self__, "google_endpoint", google_endpoint)
        if google_gcs_bucket is not None:
            pulumi.set(__self__, "google_gcs_bucket", google_gcs_bucket)
        if google_service_account_key is not None:
            pulumi.set(__self__, "google_service_account_key", google_service_account_key)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if local_max_space is not None:
            pulumi.set(__self__, "local_max_space", local_max_space)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path_prefix is not None:
            pulumi.set(__self__, "path_prefix", path_prefix)
        if retain is not None:
            pulumi.set(__self__, "retain", retain)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter(name="awsAccessKeyId")
    def aws_access_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS access key ID.
        """
        return pulumi.get(self, "aws_access_key_id")

    @aws_access_key_id.setter
    def aws_access_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_access_key_id", value)

    @property
    @pulumi.getter(name="awsS3Bucket")
    def aws_s3_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        S3 bucket to write snapshots to.
        """
        return pulumi.get(self, "aws_s3_bucket")

    @aws_s3_bucket.setter
    def aws_s3_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_s3_bucket", value)

    @property
    @pulumi.getter(name="awsS3DisableTls")
    def aws_s3_disable_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable TLS for the S3 endpoint. This should only be used for testing purposes.
        """
        return pulumi.get(self, "aws_s3_disable_tls")

    @aws_s3_disable_tls.setter
    def aws_s3_disable_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aws_s3_disable_tls", value)

    @property
    @pulumi.getter(name="awsS3EnableKms")
    def aws_s3_enable_kms(self) -> Optional[pulumi.Input[bool]]:
        """
        Use KMS to encrypt bucket contents.
        """
        return pulumi.get(self, "aws_s3_enable_kms")

    @aws_s3_enable_kms.setter
    def aws_s3_enable_kms(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aws_s3_enable_kms", value)

    @property
    @pulumi.getter(name="awsS3Endpoint")
    def aws_s3_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        AWS endpoint. This is typically only set when using a non-AWS S3 implementation like Minio.
        """
        return pulumi.get(self, "aws_s3_endpoint")

    @aws_s3_endpoint.setter
    def aws_s3_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_s3_endpoint", value)

    @property
    @pulumi.getter(name="awsS3ForcePathStyle")
    def aws_s3_force_path_style(self) -> Optional[pulumi.Input[bool]]:
        """
        Use the endpoint/bucket URL style instead of bucket.endpoint.
        """
        return pulumi.get(self, "aws_s3_force_path_style")

    @aws_s3_force_path_style.setter
    def aws_s3_force_path_style(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aws_s3_force_path_style", value)

    @property
    @pulumi.getter(name="awsS3KmsKey")
    def aws_s3_kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        Use named KMS key, when aws_s3_enable_kms=true
        """
        return pulumi.get(self, "aws_s3_kms_key")

    @aws_s3_kms_key.setter
    def aws_s3_kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_s3_kms_key", value)

    @property
    @pulumi.getter(name="awsS3Region")
    def aws_s3_region(self) -> Optional[pulumi.Input[str]]:
        """
        AWS region bucket is in.
        """
        return pulumi.get(self, "aws_s3_region")

    @aws_s3_region.setter
    def aws_s3_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_s3_region", value)

    @property
    @pulumi.getter(name="awsS3ServerSideEncryption")
    def aws_s3_server_side_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        Use AES256 to encrypt bucket contents.
        """
        return pulumi.get(self, "aws_s3_server_side_encryption")

    @aws_s3_server_side_encryption.setter
    def aws_s3_server_side_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aws_s3_server_side_encryption", value)

    @property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        AWS secret access key.
        """
        return pulumi.get(self, "aws_secret_access_key")

    @aws_secret_access_key.setter
    def aws_secret_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_secret_access_key", value)

    @property
    @pulumi.getter(name="awsSessionToken")
    def aws_session_token(self) -> Optional[pulumi.Input[str]]:
        """
        AWS session token.
        """
        return pulumi.get(self, "aws_session_token")

    @aws_session_token.setter
    def aws_session_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_session_token", value)

    @property
    @pulumi.getter(name="azureAccountKey")
    def azure_account_key(self) -> Optional[pulumi.Input[str]]:
        """
        Azure account key.
        """
        return pulumi.get(self, "azure_account_key")

    @azure_account_key.setter
    def azure_account_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_account_key", value)

    @property
    @pulumi.getter(name="azureAccountName")
    def azure_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Azure account name.
        """
        return pulumi.get(self, "azure_account_name")

    @azure_account_name.setter
    def azure_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_account_name", value)

    @property
    @pulumi.getter(name="azureBlobEnvironment")
    def azure_blob_environment(self) -> Optional[pulumi.Input[str]]:
        """
        Azure blob environment.
        """
        return pulumi.get(self, "azure_blob_environment")

    @azure_blob_environment.setter
    def azure_blob_environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_blob_environment", value)

    @property
    @pulumi.getter(name="azureContainerName")
    def azure_container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Azure container name to write snapshots to.
        """
        return pulumi.get(self, "azure_container_name")

    @azure_container_name.setter
    def azure_container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_container_name", value)

    @property
    @pulumi.getter(name="azureEndpoint")
    def azure_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Azure blob storage endpoint. This is typically only set when using a non-Azure implementation like Azurite.
        """
        return pulumi.get(self, "azure_endpoint")

    @azure_endpoint.setter
    def azure_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_endpoint", value)

    @property
    @pulumi.getter(name="filePrefix")
    def file_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Within the directory or bucket
        prefix given by `path_prefix`, the file or object name of snapshot files
        will start with this string.
        """
        return pulumi.get(self, "file_prefix")

    @file_prefix.setter
    def file_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_prefix", value)

    @property
    @pulumi.getter(name="googleDisableTls")
    def google_disable_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable TLS for the GCS endpoint.
        """
        return pulumi.get(self, "google_disable_tls")

    @google_disable_tls.setter
    def google_disable_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "google_disable_tls", value)

    @property
    @pulumi.getter(name="googleEndpoint")
    def google_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        GCS endpoint. This is typically only set when using a non-Google GCS implementation like fake-gcs-server.
        """
        return pulumi.get(self, "google_endpoint")

    @google_endpoint.setter
    def google_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "google_endpoint", value)

    @property
    @pulumi.getter(name="googleGcsBucket")
    def google_gcs_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        GCS bucket to write snapshots to.
        """
        return pulumi.get(self, "google_gcs_bucket")

    @google_gcs_bucket.setter
    def google_gcs_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "google_gcs_bucket", value)

    @property
    @pulumi.getter(name="googleServiceAccountKey")
    def google_service_account_key(self) -> Optional[pulumi.Input[str]]:
        """
        Google service account key in JSON format.
        """
        return pulumi.get(self, "google_service_account_key")

    @google_service_account_key.setter
    def google_service_account_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "google_service_account_key", value)

    @property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        `<required>` - Time (in seconds) between snapshots.
        """
        return pulumi.get(self, "interval_seconds")

    @interval_seconds.setter
    def interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval_seconds", value)

    @property
    @pulumi.getter(name="localMaxSpace")
    def local_max_space(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum space, in bytes, to use for snapshots.
        """
        return pulumi.get(self, "local_max_space")

    @local_max_space.setter
    def local_max_space(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "local_max_space", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        `<required>` – Name of the configuration to modify.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="pathPrefix")
    def path_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        `<required>` - For `storage_type = "local"`, the directory to
        write the snapshots in. For cloud storage types, the bucket prefix to use.
        Types `azure-s3` and `google-gcs` require a trailing `/` (slash).
        Types `local` and `aws-s3` the trailing `/` is optional.
        """
        return pulumi.get(self, "path_prefix")

    @path_prefix.setter
    def path_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_prefix", value)

    @property
    @pulumi.getter
    def retain(self) -> Optional[pulumi.Input[int]]:
        """
        How many snapshots are to be kept; when writing a
        snapshot, if there are more snapshots already stored than this number, the
        oldest ones will be deleted.
        """
        return pulumi.get(self, "retain")

    @retain.setter
    def retain(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retain", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        `<required>` - One of "local", "azure-blob", "aws-s3",
        or "google-gcs". The remaining parameters described below are all specific to
        the selected `storage_type` and prefixed accordingly.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)


class RaftSnapshotAgentConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_access_key_id: Optional[pulumi.Input[str]] = None,
                 aws_s3_bucket: Optional[pulumi.Input[str]] = None,
                 aws_s3_disable_tls: Optional[pulumi.Input[bool]] = None,
                 aws_s3_enable_kms: Optional[pulumi.Input[bool]] = None,
                 aws_s3_endpoint: Optional[pulumi.Input[str]] = None,
                 aws_s3_force_path_style: Optional[pulumi.Input[bool]] = None,
                 aws_s3_kms_key: Optional[pulumi.Input[str]] = None,
                 aws_s3_region: Optional[pulumi.Input[str]] = None,
                 aws_s3_server_side_encryption: Optional[pulumi.Input[bool]] = None,
                 aws_secret_access_key: Optional[pulumi.Input[str]] = None,
                 aws_session_token: Optional[pulumi.Input[str]] = None,
                 azure_account_key: Optional[pulumi.Input[str]] = None,
                 azure_account_name: Optional[pulumi.Input[str]] = None,
                 azure_blob_environment: Optional[pulumi.Input[str]] = None,
                 azure_container_name: Optional[pulumi.Input[str]] = None,
                 azure_endpoint: Optional[pulumi.Input[str]] = None,
                 file_prefix: Optional[pulumi.Input[str]] = None,
                 google_disable_tls: Optional[pulumi.Input[bool]] = None,
                 google_endpoint: Optional[pulumi.Input[str]] = None,
                 google_gcs_bucket: Optional[pulumi.Input[str]] = None,
                 google_service_account_key: Optional[pulumi.Input[str]] = None,
                 interval_seconds: Optional[pulumi.Input[int]] = None,
                 local_max_space: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 path_prefix: Optional[pulumi.Input[str]] = None,
                 retain: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Local Storage
        ```python
        import pulumi
        import pulumi_vault as vault

        local_backups = vault.RaftSnapshotAgentConfig("local_backups",
            name="local",
            interval_seconds=86400,
            retain=7,
            path_prefix="/opt/vault/snapshots/",
            storage_type="local",
            local_max_space=10000000)
        ```

        ### AWS S3
        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_vault as vault

        config = pulumi.Config()
        aws_access_key_id = config.require_object("awsAccessKeyId")
        aws_secret_access_key = config.require_object("awsSecretAccessKey")
        current = aws.get_region()
        s3_backups = vault.RaftSnapshotAgentConfig("s3_backups",
            name="s3",
            interval_seconds=86400,
            retain=7,
            path_prefix="/path/in/bucket",
            storage_type="aws-s3",
            aws_s3_bucket="my-bucket",
            aws_s3_region=current.name,
            aws_access_key_id=aws_access_key_id,
            aws_secret_access_key=aws_secret_access_key,
            aws_s3_enable_kms=True)
        ```

        ### Azure BLOB

        ```python
        import pulumi
        import pulumi_vault as vault

        config = pulumi.Config()
        azure_account_name = config.require_object("azureAccountName")
        azure_account_key = config.require_object("azureAccountKey")
        azure_backups = vault.RaftSnapshotAgentConfig("azure_backups",
            name="azure_backup",
            interval_seconds=86400,
            retain=7,
            path_prefix="/",
            storage_type="azure-blob",
            azure_container_name="vault-blob",
            azure_account_name=azure_account_name,
            azure_account_key=azure_account_key)
        ```

        ## Import

        Raft Snapshot Agent Configurations can be imported using the `name`, e.g.

        ```sh
        $ pulumi import vault:index/raftSnapshotAgentConfig:RaftSnapshotAgentConfig local local
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aws_access_key_id: AWS access key ID.
        :param pulumi.Input[str] aws_s3_bucket: S3 bucket to write snapshots to.
        :param pulumi.Input[bool] aws_s3_disable_tls: Disable TLS for the S3 endpoint. This should only be used for testing purposes.
        :param pulumi.Input[bool] aws_s3_enable_kms: Use KMS to encrypt bucket contents.
        :param pulumi.Input[str] aws_s3_endpoint: AWS endpoint. This is typically only set when using a non-AWS S3 implementation like Minio.
        :param pulumi.Input[bool] aws_s3_force_path_style: Use the endpoint/bucket URL style instead of bucket.endpoint.
        :param pulumi.Input[str] aws_s3_kms_key: Use named KMS key, when aws_s3_enable_kms=true
        :param pulumi.Input[str] aws_s3_region: AWS region bucket is in.
        :param pulumi.Input[bool] aws_s3_server_side_encryption: Use AES256 to encrypt bucket contents.
        :param pulumi.Input[str] aws_secret_access_key: AWS secret access key.
        :param pulumi.Input[str] aws_session_token: AWS session token.
        :param pulumi.Input[str] azure_account_key: Azure account key.
        :param pulumi.Input[str] azure_account_name: Azure account name.
        :param pulumi.Input[str] azure_blob_environment: Azure blob environment.
        :param pulumi.Input[str] azure_container_name: Azure container name to write snapshots to.
        :param pulumi.Input[str] azure_endpoint: Azure blob storage endpoint. This is typically only set when using a non-Azure implementation like Azurite.
        :param pulumi.Input[str] file_prefix: Within the directory or bucket
               prefix given by `path_prefix`, the file or object name of snapshot files
               will start with this string.
        :param pulumi.Input[bool] google_disable_tls: Disable TLS for the GCS endpoint.
        :param pulumi.Input[str] google_endpoint: GCS endpoint. This is typically only set when using a non-Google GCS implementation like fake-gcs-server.
        :param pulumi.Input[str] google_gcs_bucket: GCS bucket to write snapshots to.
        :param pulumi.Input[str] google_service_account_key: Google service account key in JSON format.
        :param pulumi.Input[int] interval_seconds: `<required>` - Time (in seconds) between snapshots.
        :param pulumi.Input[int] local_max_space: The maximum space, in bytes, to use for snapshots.
        :param pulumi.Input[str] name: `<required>` – Name of the configuration to modify.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] path_prefix: `<required>` - For `storage_type = "local"`, the directory to
               write the snapshots in. For cloud storage types, the bucket prefix to use.
               Types `azure-s3` and `google-gcs` require a trailing `/` (slash).
               Types `local` and `aws-s3` the trailing `/` is optional.
        :param pulumi.Input[int] retain: How many snapshots are to be kept; when writing a
               snapshot, if there are more snapshots already stored than this number, the
               oldest ones will be deleted.
        :param pulumi.Input[str] storage_type: `<required>` - One of "local", "azure-blob", "aws-s3",
               or "google-gcs". The remaining parameters described below are all specific to
               the selected `storage_type` and prefixed accordingly.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RaftSnapshotAgentConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Local Storage
        ```python
        import pulumi
        import pulumi_vault as vault

        local_backups = vault.RaftSnapshotAgentConfig("local_backups",
            name="local",
            interval_seconds=86400,
            retain=7,
            path_prefix="/opt/vault/snapshots/",
            storage_type="local",
            local_max_space=10000000)
        ```

        ### AWS S3
        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_vault as vault

        config = pulumi.Config()
        aws_access_key_id = config.require_object("awsAccessKeyId")
        aws_secret_access_key = config.require_object("awsSecretAccessKey")
        current = aws.get_region()
        s3_backups = vault.RaftSnapshotAgentConfig("s3_backups",
            name="s3",
            interval_seconds=86400,
            retain=7,
            path_prefix="/path/in/bucket",
            storage_type="aws-s3",
            aws_s3_bucket="my-bucket",
            aws_s3_region=current.name,
            aws_access_key_id=aws_access_key_id,
            aws_secret_access_key=aws_secret_access_key,
            aws_s3_enable_kms=True)
        ```

        ### Azure BLOB

        ```python
        import pulumi
        import pulumi_vault as vault

        config = pulumi.Config()
        azure_account_name = config.require_object("azureAccountName")
        azure_account_key = config.require_object("azureAccountKey")
        azure_backups = vault.RaftSnapshotAgentConfig("azure_backups",
            name="azure_backup",
            interval_seconds=86400,
            retain=7,
            path_prefix="/",
            storage_type="azure-blob",
            azure_container_name="vault-blob",
            azure_account_name=azure_account_name,
            azure_account_key=azure_account_key)
        ```

        ## Import

        Raft Snapshot Agent Configurations can be imported using the `name`, e.g.

        ```sh
        $ pulumi import vault:index/raftSnapshotAgentConfig:RaftSnapshotAgentConfig local local
        ```

        :param str resource_name: The name of the resource.
        :param RaftSnapshotAgentConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RaftSnapshotAgentConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_access_key_id: Optional[pulumi.Input[str]] = None,
                 aws_s3_bucket: Optional[pulumi.Input[str]] = None,
                 aws_s3_disable_tls: Optional[pulumi.Input[bool]] = None,
                 aws_s3_enable_kms: Optional[pulumi.Input[bool]] = None,
                 aws_s3_endpoint: Optional[pulumi.Input[str]] = None,
                 aws_s3_force_path_style: Optional[pulumi.Input[bool]] = None,
                 aws_s3_kms_key: Optional[pulumi.Input[str]] = None,
                 aws_s3_region: Optional[pulumi.Input[str]] = None,
                 aws_s3_server_side_encryption: Optional[pulumi.Input[bool]] = None,
                 aws_secret_access_key: Optional[pulumi.Input[str]] = None,
                 aws_session_token: Optional[pulumi.Input[str]] = None,
                 azure_account_key: Optional[pulumi.Input[str]] = None,
                 azure_account_name: Optional[pulumi.Input[str]] = None,
                 azure_blob_environment: Optional[pulumi.Input[str]] = None,
                 azure_container_name: Optional[pulumi.Input[str]] = None,
                 azure_endpoint: Optional[pulumi.Input[str]] = None,
                 file_prefix: Optional[pulumi.Input[str]] = None,
                 google_disable_tls: Optional[pulumi.Input[bool]] = None,
                 google_endpoint: Optional[pulumi.Input[str]] = None,
                 google_gcs_bucket: Optional[pulumi.Input[str]] = None,
                 google_service_account_key: Optional[pulumi.Input[str]] = None,
                 interval_seconds: Optional[pulumi.Input[int]] = None,
                 local_max_space: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 path_prefix: Optional[pulumi.Input[str]] = None,
                 retain: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RaftSnapshotAgentConfigArgs.__new__(RaftSnapshotAgentConfigArgs)

            __props__.__dict__["aws_access_key_id"] = aws_access_key_id
            __props__.__dict__["aws_s3_bucket"] = aws_s3_bucket
            __props__.__dict__["aws_s3_disable_tls"] = aws_s3_disable_tls
            __props__.__dict__["aws_s3_enable_kms"] = aws_s3_enable_kms
            __props__.__dict__["aws_s3_endpoint"] = aws_s3_endpoint
            __props__.__dict__["aws_s3_force_path_style"] = aws_s3_force_path_style
            __props__.__dict__["aws_s3_kms_key"] = aws_s3_kms_key
            __props__.__dict__["aws_s3_region"] = aws_s3_region
            __props__.__dict__["aws_s3_server_side_encryption"] = aws_s3_server_side_encryption
            __props__.__dict__["aws_secret_access_key"] = aws_secret_access_key
            __props__.__dict__["aws_session_token"] = aws_session_token
            __props__.__dict__["azure_account_key"] = azure_account_key
            __props__.__dict__["azure_account_name"] = azure_account_name
            __props__.__dict__["azure_blob_environment"] = azure_blob_environment
            __props__.__dict__["azure_container_name"] = azure_container_name
            __props__.__dict__["azure_endpoint"] = azure_endpoint
            __props__.__dict__["file_prefix"] = file_prefix
            __props__.__dict__["google_disable_tls"] = google_disable_tls
            __props__.__dict__["google_endpoint"] = google_endpoint
            __props__.__dict__["google_gcs_bucket"] = google_gcs_bucket
            __props__.__dict__["google_service_account_key"] = google_service_account_key
            if interval_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'interval_seconds'")
            __props__.__dict__["interval_seconds"] = interval_seconds
            __props__.__dict__["local_max_space"] = local_max_space
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            if path_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'path_prefix'")
            __props__.__dict__["path_prefix"] = path_prefix
            __props__.__dict__["retain"] = retain
            if storage_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_type'")
            __props__.__dict__["storage_type"] = storage_type
        super(RaftSnapshotAgentConfig, __self__).__init__(
            'vault:index/raftSnapshotAgentConfig:RaftSnapshotAgentConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_access_key_id: Optional[pulumi.Input[str]] = None,
            aws_s3_bucket: Optional[pulumi.Input[str]] = None,
            aws_s3_disable_tls: Optional[pulumi.Input[bool]] = None,
            aws_s3_enable_kms: Optional[pulumi.Input[bool]] = None,
            aws_s3_endpoint: Optional[pulumi.Input[str]] = None,
            aws_s3_force_path_style: Optional[pulumi.Input[bool]] = None,
            aws_s3_kms_key: Optional[pulumi.Input[str]] = None,
            aws_s3_region: Optional[pulumi.Input[str]] = None,
            aws_s3_server_side_encryption: Optional[pulumi.Input[bool]] = None,
            aws_secret_access_key: Optional[pulumi.Input[str]] = None,
            aws_session_token: Optional[pulumi.Input[str]] = None,
            azure_account_key: Optional[pulumi.Input[str]] = None,
            azure_account_name: Optional[pulumi.Input[str]] = None,
            azure_blob_environment: Optional[pulumi.Input[str]] = None,
            azure_container_name: Optional[pulumi.Input[str]] = None,
            azure_endpoint: Optional[pulumi.Input[str]] = None,
            file_prefix: Optional[pulumi.Input[str]] = None,
            google_disable_tls: Optional[pulumi.Input[bool]] = None,
            google_endpoint: Optional[pulumi.Input[str]] = None,
            google_gcs_bucket: Optional[pulumi.Input[str]] = None,
            google_service_account_key: Optional[pulumi.Input[str]] = None,
            interval_seconds: Optional[pulumi.Input[int]] = None,
            local_max_space: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            path_prefix: Optional[pulumi.Input[str]] = None,
            retain: Optional[pulumi.Input[int]] = None,
            storage_type: Optional[pulumi.Input[str]] = None) -> 'RaftSnapshotAgentConfig':
        """
        Get an existing RaftSnapshotAgentConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aws_access_key_id: AWS access key ID.
        :param pulumi.Input[str] aws_s3_bucket: S3 bucket to write snapshots to.
        :param pulumi.Input[bool] aws_s3_disable_tls: Disable TLS for the S3 endpoint. This should only be used for testing purposes.
        :param pulumi.Input[bool] aws_s3_enable_kms: Use KMS to encrypt bucket contents.
        :param pulumi.Input[str] aws_s3_endpoint: AWS endpoint. This is typically only set when using a non-AWS S3 implementation like Minio.
        :param pulumi.Input[bool] aws_s3_force_path_style: Use the endpoint/bucket URL style instead of bucket.endpoint.
        :param pulumi.Input[str] aws_s3_kms_key: Use named KMS key, when aws_s3_enable_kms=true
        :param pulumi.Input[str] aws_s3_region: AWS region bucket is in.
        :param pulumi.Input[bool] aws_s3_server_side_encryption: Use AES256 to encrypt bucket contents.
        :param pulumi.Input[str] aws_secret_access_key: AWS secret access key.
        :param pulumi.Input[str] aws_session_token: AWS session token.
        :param pulumi.Input[str] azure_account_key: Azure account key.
        :param pulumi.Input[str] azure_account_name: Azure account name.
        :param pulumi.Input[str] azure_blob_environment: Azure blob environment.
        :param pulumi.Input[str] azure_container_name: Azure container name to write snapshots to.
        :param pulumi.Input[str] azure_endpoint: Azure blob storage endpoint. This is typically only set when using a non-Azure implementation like Azurite.
        :param pulumi.Input[str] file_prefix: Within the directory or bucket
               prefix given by `path_prefix`, the file or object name of snapshot files
               will start with this string.
        :param pulumi.Input[bool] google_disable_tls: Disable TLS for the GCS endpoint.
        :param pulumi.Input[str] google_endpoint: GCS endpoint. This is typically only set when using a non-Google GCS implementation like fake-gcs-server.
        :param pulumi.Input[str] google_gcs_bucket: GCS bucket to write snapshots to.
        :param pulumi.Input[str] google_service_account_key: Google service account key in JSON format.
        :param pulumi.Input[int] interval_seconds: `<required>` - Time (in seconds) between snapshots.
        :param pulumi.Input[int] local_max_space: The maximum space, in bytes, to use for snapshots.
        :param pulumi.Input[str] name: `<required>` – Name of the configuration to modify.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] path_prefix: `<required>` - For `storage_type = "local"`, the directory to
               write the snapshots in. For cloud storage types, the bucket prefix to use.
               Types `azure-s3` and `google-gcs` require a trailing `/` (slash).
               Types `local` and `aws-s3` the trailing `/` is optional.
        :param pulumi.Input[int] retain: How many snapshots are to be kept; when writing a
               snapshot, if there are more snapshots already stored than this number, the
               oldest ones will be deleted.
        :param pulumi.Input[str] storage_type: `<required>` - One of "local", "azure-blob", "aws-s3",
               or "google-gcs". The remaining parameters described below are all specific to
               the selected `storage_type` and prefixed accordingly.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RaftSnapshotAgentConfigState.__new__(_RaftSnapshotAgentConfigState)

        __props__.__dict__["aws_access_key_id"] = aws_access_key_id
        __props__.__dict__["aws_s3_bucket"] = aws_s3_bucket
        __props__.__dict__["aws_s3_disable_tls"] = aws_s3_disable_tls
        __props__.__dict__["aws_s3_enable_kms"] = aws_s3_enable_kms
        __props__.__dict__["aws_s3_endpoint"] = aws_s3_endpoint
        __props__.__dict__["aws_s3_force_path_style"] = aws_s3_force_path_style
        __props__.__dict__["aws_s3_kms_key"] = aws_s3_kms_key
        __props__.__dict__["aws_s3_region"] = aws_s3_region
        __props__.__dict__["aws_s3_server_side_encryption"] = aws_s3_server_side_encryption
        __props__.__dict__["aws_secret_access_key"] = aws_secret_access_key
        __props__.__dict__["aws_session_token"] = aws_session_token
        __props__.__dict__["azure_account_key"] = azure_account_key
        __props__.__dict__["azure_account_name"] = azure_account_name
        __props__.__dict__["azure_blob_environment"] = azure_blob_environment
        __props__.__dict__["azure_container_name"] = azure_container_name
        __props__.__dict__["azure_endpoint"] = azure_endpoint
        __props__.__dict__["file_prefix"] = file_prefix
        __props__.__dict__["google_disable_tls"] = google_disable_tls
        __props__.__dict__["google_endpoint"] = google_endpoint
        __props__.__dict__["google_gcs_bucket"] = google_gcs_bucket
        __props__.__dict__["google_service_account_key"] = google_service_account_key
        __props__.__dict__["interval_seconds"] = interval_seconds
        __props__.__dict__["local_max_space"] = local_max_space
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["path_prefix"] = path_prefix
        __props__.__dict__["retain"] = retain
        __props__.__dict__["storage_type"] = storage_type
        return RaftSnapshotAgentConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsAccessKeyId")
    def aws_access_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        AWS access key ID.
        """
        return pulumi.get(self, "aws_access_key_id")

    @property
    @pulumi.getter(name="awsS3Bucket")
    def aws_s3_bucket(self) -> pulumi.Output[Optional[str]]:
        """
        S3 bucket to write snapshots to.
        """
        return pulumi.get(self, "aws_s3_bucket")

    @property
    @pulumi.getter(name="awsS3DisableTls")
    def aws_s3_disable_tls(self) -> pulumi.Output[Optional[bool]]:
        """
        Disable TLS for the S3 endpoint. This should only be used for testing purposes.
        """
        return pulumi.get(self, "aws_s3_disable_tls")

    @property
    @pulumi.getter(name="awsS3EnableKms")
    def aws_s3_enable_kms(self) -> pulumi.Output[Optional[bool]]:
        """
        Use KMS to encrypt bucket contents.
        """
        return pulumi.get(self, "aws_s3_enable_kms")

    @property
    @pulumi.getter(name="awsS3Endpoint")
    def aws_s3_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        AWS endpoint. This is typically only set when using a non-AWS S3 implementation like Minio.
        """
        return pulumi.get(self, "aws_s3_endpoint")

    @property
    @pulumi.getter(name="awsS3ForcePathStyle")
    def aws_s3_force_path_style(self) -> pulumi.Output[Optional[bool]]:
        """
        Use the endpoint/bucket URL style instead of bucket.endpoint.
        """
        return pulumi.get(self, "aws_s3_force_path_style")

    @property
    @pulumi.getter(name="awsS3KmsKey")
    def aws_s3_kms_key(self) -> pulumi.Output[Optional[str]]:
        """
        Use named KMS key, when aws_s3_enable_kms=true
        """
        return pulumi.get(self, "aws_s3_kms_key")

    @property
    @pulumi.getter(name="awsS3Region")
    def aws_s3_region(self) -> pulumi.Output[Optional[str]]:
        """
        AWS region bucket is in.
        """
        return pulumi.get(self, "aws_s3_region")

    @property
    @pulumi.getter(name="awsS3ServerSideEncryption")
    def aws_s3_server_side_encryption(self) -> pulumi.Output[Optional[bool]]:
        """
        Use AES256 to encrypt bucket contents.
        """
        return pulumi.get(self, "aws_s3_server_side_encryption")

    @property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> pulumi.Output[Optional[str]]:
        """
        AWS secret access key.
        """
        return pulumi.get(self, "aws_secret_access_key")

    @property
    @pulumi.getter(name="awsSessionToken")
    def aws_session_token(self) -> pulumi.Output[Optional[str]]:
        """
        AWS session token.
        """
        return pulumi.get(self, "aws_session_token")

    @property
    @pulumi.getter(name="azureAccountKey")
    def azure_account_key(self) -> pulumi.Output[Optional[str]]:
        """
        Azure account key.
        """
        return pulumi.get(self, "azure_account_key")

    @property
    @pulumi.getter(name="azureAccountName")
    def azure_account_name(self) -> pulumi.Output[Optional[str]]:
        """
        Azure account name.
        """
        return pulumi.get(self, "azure_account_name")

    @property
    @pulumi.getter(name="azureBlobEnvironment")
    def azure_blob_environment(self) -> pulumi.Output[Optional[str]]:
        """
        Azure blob environment.
        """
        return pulumi.get(self, "azure_blob_environment")

    @property
    @pulumi.getter(name="azureContainerName")
    def azure_container_name(self) -> pulumi.Output[Optional[str]]:
        """
        Azure container name to write snapshots to.
        """
        return pulumi.get(self, "azure_container_name")

    @property
    @pulumi.getter(name="azureEndpoint")
    def azure_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        Azure blob storage endpoint. This is typically only set when using a non-Azure implementation like Azurite.
        """
        return pulumi.get(self, "azure_endpoint")

    @property
    @pulumi.getter(name="filePrefix")
    def file_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        Within the directory or bucket
        prefix given by `path_prefix`, the file or object name of snapshot files
        will start with this string.
        """
        return pulumi.get(self, "file_prefix")

    @property
    @pulumi.getter(name="googleDisableTls")
    def google_disable_tls(self) -> pulumi.Output[Optional[bool]]:
        """
        Disable TLS for the GCS endpoint.
        """
        return pulumi.get(self, "google_disable_tls")

    @property
    @pulumi.getter(name="googleEndpoint")
    def google_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        GCS endpoint. This is typically only set when using a non-Google GCS implementation like fake-gcs-server.
        """
        return pulumi.get(self, "google_endpoint")

    @property
    @pulumi.getter(name="googleGcsBucket")
    def google_gcs_bucket(self) -> pulumi.Output[Optional[str]]:
        """
        GCS bucket to write snapshots to.
        """
        return pulumi.get(self, "google_gcs_bucket")

    @property
    @pulumi.getter(name="googleServiceAccountKey")
    def google_service_account_key(self) -> pulumi.Output[Optional[str]]:
        """
        Google service account key in JSON format.
        """
        return pulumi.get(self, "google_service_account_key")

    @property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> pulumi.Output[int]:
        """
        `<required>` - Time (in seconds) between snapshots.
        """
        return pulumi.get(self, "interval_seconds")

    @property
    @pulumi.getter(name="localMaxSpace")
    def local_max_space(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum space, in bytes, to use for snapshots.
        """
        return pulumi.get(self, "local_max_space")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        `<required>` – Name of the configuration to modify.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="pathPrefix")
    def path_prefix(self) -> pulumi.Output[str]:
        """
        `<required>` - For `storage_type = "local"`, the directory to
        write the snapshots in. For cloud storage types, the bucket prefix to use.
        Types `azure-s3` and `google-gcs` require a trailing `/` (slash).
        Types `local` and `aws-s3` the trailing `/` is optional.
        """
        return pulumi.get(self, "path_prefix")

    @property
    @pulumi.getter
    def retain(self) -> pulumi.Output[Optional[int]]:
        """
        How many snapshots are to be kept; when writing a
        snapshot, if there are more snapshots already stored than this number, the
        oldest ones will be deleted.
        """
        return pulumi.get(self, "retain")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[str]:
        """
        `<required>` - One of "local", "azure-blob", "aws-s3",
        or "google-gcs". The remaining parameters described below are all specific to
        the selected `storage_type` and prefixed accordingly.
        """
        return pulumi.get(self, "storage_type")

