# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AuthBackendRoleArgs', 'AuthBackendRole']

@pulumi.input_type
class AuthBackendRoleArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 bound_attributes: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 bound_attributes_type: Optional[pulumi.Input[str]] = None,
                 bound_subjects: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bound_subjects_type: Optional[pulumi.Input[str]] = None,
                 groups_attribute: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[bool]] = None,
                 token_num_uses: Optional[pulumi.Input[int]] = None,
                 token_period: Optional[pulumi.Input[int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_ttl: Optional[pulumi.Input[int]] = None,
                 token_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AuthBackendRole resource.
        :param pulumi.Input[str] path: Path where the auth backend is mounted.
        :param pulumi.Input[Mapping[str, Any]] bound_attributes: Mapping of attribute names to values that are expected to
               exist in the SAML assertion.
        :param pulumi.Input[str] bound_attributes_type: The type of matching assertion to perform on
               `bound_attributes_type`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_subjects: List of subjects being asserted for SAML authentication.
        :param pulumi.Input[str] bound_subjects_type: The type of matching assertion to perform on `bound_subjects`.
        :param pulumi.Input[str] groups_attribute: The attribute to use to identify the set of groups to which the
               user belongs.
        :param pulumi.Input[str] name: Unique name of the role.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[str] token_type: The type of token to generate, service or batch
        """
        pulumi.set(__self__, "path", path)
        if bound_attributes is not None:
            pulumi.set(__self__, "bound_attributes", bound_attributes)
        if bound_attributes_type is not None:
            pulumi.set(__self__, "bound_attributes_type", bound_attributes_type)
        if bound_subjects is not None:
            pulumi.set(__self__, "bound_subjects", bound_subjects)
        if bound_subjects_type is not None:
            pulumi.set(__self__, "bound_subjects_type", bound_subjects_type)
        if groups_attribute is not None:
            pulumi.set(__self__, "groups_attribute", groups_attribute)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Path where the auth backend is mounted.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="boundAttributes")
    def bound_attributes(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Mapping of attribute names to values that are expected to
        exist in the SAML assertion.
        """
        return pulumi.get(self, "bound_attributes")

    @bound_attributes.setter
    def bound_attributes(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "bound_attributes", value)

    @property
    @pulumi.getter(name="boundAttributesType")
    def bound_attributes_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of matching assertion to perform on
        `bound_attributes_type`.
        """
        return pulumi.get(self, "bound_attributes_type")

    @bound_attributes_type.setter
    def bound_attributes_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bound_attributes_type", value)

    @property
    @pulumi.getter(name="boundSubjects")
    def bound_subjects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of subjects being asserted for SAML authentication.
        """
        return pulumi.get(self, "bound_subjects")

    @bound_subjects.setter
    def bound_subjects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "bound_subjects", value)

    @property
    @pulumi.getter(name="boundSubjectsType")
    def bound_subjects_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of matching assertion to perform on `bound_subjects`.
        """
        return pulumi.get(self, "bound_subjects_type")

    @bound_subjects_type.setter
    def bound_subjects_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bound_subjects_type", value)

    @property
    @pulumi.getter(name="groupsAttribute")
    def groups_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        The attribute to use to identify the set of groups to which the
        user belongs.
        """
        return pulumi.get(self, "groups_attribute")

    @groups_attribute.setter
    def groups_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_attribute", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_max_ttl", value)

    @property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_num_uses", value)

    @property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_period", value)

    @property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "token_policies", value)

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_ttl", value)

    @property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_type", value)


@pulumi.input_type
class _AuthBackendRoleState:
    def __init__(__self__, *,
                 bound_attributes: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 bound_attributes_type: Optional[pulumi.Input[str]] = None,
                 bound_subjects: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bound_subjects_type: Optional[pulumi.Input[str]] = None,
                 groups_attribute: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[bool]] = None,
                 token_num_uses: Optional[pulumi.Input[int]] = None,
                 token_period: Optional[pulumi.Input[int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_ttl: Optional[pulumi.Input[int]] = None,
                 token_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AuthBackendRole resources.
        :param pulumi.Input[Mapping[str, Any]] bound_attributes: Mapping of attribute names to values that are expected to
               exist in the SAML assertion.
        :param pulumi.Input[str] bound_attributes_type: The type of matching assertion to perform on
               `bound_attributes_type`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_subjects: List of subjects being asserted for SAML authentication.
        :param pulumi.Input[str] bound_subjects_type: The type of matching assertion to perform on `bound_subjects`.
        :param pulumi.Input[str] groups_attribute: The attribute to use to identify the set of groups to which the
               user belongs.
        :param pulumi.Input[str] name: Unique name of the role.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] path: Path where the auth backend is mounted.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[str] token_type: The type of token to generate, service or batch
        """
        if bound_attributes is not None:
            pulumi.set(__self__, "bound_attributes", bound_attributes)
        if bound_attributes_type is not None:
            pulumi.set(__self__, "bound_attributes_type", bound_attributes_type)
        if bound_subjects is not None:
            pulumi.set(__self__, "bound_subjects", bound_subjects)
        if bound_subjects_type is not None:
            pulumi.set(__self__, "bound_subjects_type", bound_subjects_type)
        if groups_attribute is not None:
            pulumi.set(__self__, "groups_attribute", groups_attribute)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)

    @property
    @pulumi.getter(name="boundAttributes")
    def bound_attributes(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Mapping of attribute names to values that are expected to
        exist in the SAML assertion.
        """
        return pulumi.get(self, "bound_attributes")

    @bound_attributes.setter
    def bound_attributes(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "bound_attributes", value)

    @property
    @pulumi.getter(name="boundAttributesType")
    def bound_attributes_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of matching assertion to perform on
        `bound_attributes_type`.
        """
        return pulumi.get(self, "bound_attributes_type")

    @bound_attributes_type.setter
    def bound_attributes_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bound_attributes_type", value)

    @property
    @pulumi.getter(name="boundSubjects")
    def bound_subjects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of subjects being asserted for SAML authentication.
        """
        return pulumi.get(self, "bound_subjects")

    @bound_subjects.setter
    def bound_subjects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "bound_subjects", value)

    @property
    @pulumi.getter(name="boundSubjectsType")
    def bound_subjects_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of matching assertion to perform on `bound_subjects`.
        """
        return pulumi.get(self, "bound_subjects_type")

    @bound_subjects_type.setter
    def bound_subjects_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bound_subjects_type", value)

    @property
    @pulumi.getter(name="groupsAttribute")
    def groups_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        The attribute to use to identify the set of groups to which the
        user belongs.
        """
        return pulumi.get(self, "groups_attribute")

    @groups_attribute.setter
    def groups_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_attribute", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path where the auth backend is mounted.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_max_ttl", value)

    @property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_num_uses", value)

    @property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_period", value)

    @property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "token_policies", value)

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_ttl", value)

    @property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_type", value)


class AuthBackendRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bound_attributes: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 bound_attributes_type: Optional[pulumi.Input[str]] = None,
                 bound_subjects: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bound_subjects_type: Optional[pulumi.Input[str]] = None,
                 groups_attribute: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[bool]] = None,
                 token_num_uses: Optional[pulumi.Input[int]] = None,
                 token_period: Optional[pulumi.Input[int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_ttl: Optional[pulumi.Input[int]] = None,
                 token_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an SAML auth backend role in a Vault server. See the [Vault
        documentation](https://www.vaultproject.io/docs/auth/saml.html) for more
        information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.saml.AuthBackend("example",
            path="saml",
            idp_metadata_url="https://company.okta.com/app/abc123eb9xnIfzlaf697/sso/saml/metadata",
            entity_id="https://my.vault/v1/auth/saml",
            acs_urls=["https://my.vault.primary/v1/auth/saml/callback"],
            default_role="default-role")
        example_auth_backend_role = vault.saml.AuthBackendRole("example",
            path=example.path,
            name="my-role",
            groups_attribute="groups",
            bound_attributes={
                "group": "admin",
            },
            bound_subjects=["*example.com"],
            token_policies=["writer"],
            token_ttl=86400)
        ```

        ## Import

        SAML authentication backend roles can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:saml/authBackendRole:AuthBackendRole example auth/saml/role/my-role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] bound_attributes: Mapping of attribute names to values that are expected to
               exist in the SAML assertion.
        :param pulumi.Input[str] bound_attributes_type: The type of matching assertion to perform on
               `bound_attributes_type`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_subjects: List of subjects being asserted for SAML authentication.
        :param pulumi.Input[str] bound_subjects_type: The type of matching assertion to perform on `bound_subjects`.
        :param pulumi.Input[str] groups_attribute: The attribute to use to identify the set of groups to which the
               user belongs.
        :param pulumi.Input[str] name: Unique name of the role.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] path: Path where the auth backend is mounted.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[str] token_type: The type of token to generate, service or batch
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthBackendRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an SAML auth backend role in a Vault server. See the [Vault
        documentation](https://www.vaultproject.io/docs/auth/saml.html) for more
        information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.saml.AuthBackend("example",
            path="saml",
            idp_metadata_url="https://company.okta.com/app/abc123eb9xnIfzlaf697/sso/saml/metadata",
            entity_id="https://my.vault/v1/auth/saml",
            acs_urls=["https://my.vault.primary/v1/auth/saml/callback"],
            default_role="default-role")
        example_auth_backend_role = vault.saml.AuthBackendRole("example",
            path=example.path,
            name="my-role",
            groups_attribute="groups",
            bound_attributes={
                "group": "admin",
            },
            bound_subjects=["*example.com"],
            token_policies=["writer"],
            token_ttl=86400)
        ```

        ## Import

        SAML authentication backend roles can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:saml/authBackendRole:AuthBackendRole example auth/saml/role/my-role
        ```

        :param str resource_name: The name of the resource.
        :param AuthBackendRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bound_attributes: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 bound_attributes_type: Optional[pulumi.Input[str]] = None,
                 bound_subjects: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bound_subjects_type: Optional[pulumi.Input[str]] = None,
                 groups_attribute: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[bool]] = None,
                 token_num_uses: Optional[pulumi.Input[int]] = None,
                 token_period: Optional[pulumi.Input[int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_ttl: Optional[pulumi.Input[int]] = None,
                 token_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthBackendRoleArgs.__new__(AuthBackendRoleArgs)

            __props__.__dict__["bound_attributes"] = bound_attributes
            __props__.__dict__["bound_attributes_type"] = bound_attributes_type
            __props__.__dict__["bound_subjects"] = bound_subjects
            __props__.__dict__["bound_subjects_type"] = bound_subjects_type
            __props__.__dict__["groups_attribute"] = groups_attribute
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
            __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
            __props__.__dict__["token_max_ttl"] = token_max_ttl
            __props__.__dict__["token_no_default_policy"] = token_no_default_policy
            __props__.__dict__["token_num_uses"] = token_num_uses
            __props__.__dict__["token_period"] = token_period
            __props__.__dict__["token_policies"] = token_policies
            __props__.__dict__["token_ttl"] = token_ttl
            __props__.__dict__["token_type"] = token_type
        super(AuthBackendRole, __self__).__init__(
            'vault:saml/authBackendRole:AuthBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bound_attributes: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            bound_attributes_type: Optional[pulumi.Input[str]] = None,
            bound_subjects: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            bound_subjects_type: Optional[pulumi.Input[str]] = None,
            groups_attribute: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
            token_max_ttl: Optional[pulumi.Input[int]] = None,
            token_no_default_policy: Optional[pulumi.Input[bool]] = None,
            token_num_uses: Optional[pulumi.Input[int]] = None,
            token_period: Optional[pulumi.Input[int]] = None,
            token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            token_ttl: Optional[pulumi.Input[int]] = None,
            token_type: Optional[pulumi.Input[str]] = None) -> 'AuthBackendRole':
        """
        Get an existing AuthBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] bound_attributes: Mapping of attribute names to values that are expected to
               exist in the SAML assertion.
        :param pulumi.Input[str] bound_attributes_type: The type of matching assertion to perform on
               `bound_attributes_type`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_subjects: List of subjects being asserted for SAML authentication.
        :param pulumi.Input[str] bound_subjects_type: The type of matching assertion to perform on `bound_subjects`.
        :param pulumi.Input[str] groups_attribute: The attribute to use to identify the set of groups to which the
               user belongs.
        :param pulumi.Input[str] name: Unique name of the role.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] path: Path where the auth backend is mounted.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[str] token_type: The type of token to generate, service or batch
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthBackendRoleState.__new__(_AuthBackendRoleState)

        __props__.__dict__["bound_attributes"] = bound_attributes
        __props__.__dict__["bound_attributes_type"] = bound_attributes_type
        __props__.__dict__["bound_subjects"] = bound_subjects
        __props__.__dict__["bound_subjects_type"] = bound_subjects_type
        __props__.__dict__["groups_attribute"] = groups_attribute
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["path"] = path
        __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
        __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
        __props__.__dict__["token_max_ttl"] = token_max_ttl
        __props__.__dict__["token_no_default_policy"] = token_no_default_policy
        __props__.__dict__["token_num_uses"] = token_num_uses
        __props__.__dict__["token_period"] = token_period
        __props__.__dict__["token_policies"] = token_policies
        __props__.__dict__["token_ttl"] = token_ttl
        __props__.__dict__["token_type"] = token_type
        return AuthBackendRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="boundAttributes")
    def bound_attributes(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Mapping of attribute names to values that are expected to
        exist in the SAML assertion.
        """
        return pulumi.get(self, "bound_attributes")

    @property
    @pulumi.getter(name="boundAttributesType")
    def bound_attributes_type(self) -> pulumi.Output[str]:
        """
        The type of matching assertion to perform on
        `bound_attributes_type`.
        """
        return pulumi.get(self, "bound_attributes_type")

    @property
    @pulumi.getter(name="boundSubjects")
    def bound_subjects(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of subjects being asserted for SAML authentication.
        """
        return pulumi.get(self, "bound_subjects")

    @property
    @pulumi.getter(name="boundSubjectsType")
    def bound_subjects_type(self) -> pulumi.Output[str]:
        """
        The type of matching assertion to perform on `bound_subjects`.
        """
        return pulumi.get(self, "bound_subjects_type")

    @property
    @pulumi.getter(name="groupsAttribute")
    def groups_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        The attribute to use to identify the set of groups to which the
        user belongs.
        """
        return pulumi.get(self, "groups_attribute")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Unique name of the role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        Path where the auth backend is mounted.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> pulumi.Output[Optional[int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

