<p align="center">
<img src="https://main-sequence.app/static/media/logos/MS_logo_long_black.png" alt="Main Sequence Logo" width="500"/>
</p>

# Main Sequence Python SDK



The **Main Sequence Python SDK** is a powerful set of client libraries designed to facilitate interaction with Main Sequence systems using Python. 

1. **TDAG:** A Time Series Data Orchestration and Scheduling Tool.
2. **Client:** The Main Sequence client for interacting with the Main Sequence API.
3. **VirtualFundBuilder:** A collection of classes and methods to quickly build portfolios and interact with our AI agents.
4. **Examples:** A comprehensive collection of examples demonstrating how to build portfolios and interact with our AI agents.

**We strongly** encourage you to go through our examples. 
We have built the examples as individual Jupyter notebooks that explain the SDK through use cases. 
Since most platform usage involves a combination of operations, this is the most intuitive way to learn about Main Sequence.



---

## How the Documentation is Organized

The documentation follows the same structure as the SDK. Within each topic, we delve deeper into the logic and usage.

Additionally, we provide an extensive set of examples within the repository here:  
[Example Repository](https://github.com/mainsequence-sdk/mainsequence-sdk/tree/main/mainsequence).

The examples section is organized by use-case rather than by individual libraries.

Recordings of our previous bootcamps will be available in our youtube channel:  
[Example Repository](https://www.youtube.com/channel/UCHevDrKbbsoWuV4OjTHOrpA).

