import os
from rich.console import Console
from rich.syntax import Syntax
from rich.panel import Panel
from rich.prompt import Prompt

def display_and_confirm_script(script: str, os_family: str) -> str:
    """
    Displays the generated script to the user with syntax highlighting
    and prompts for confirmation.

    Args:
        script: The shell script generated by the AI.
        os_family: The name of the operating system (e.g., "Windows", "Linux").

    Returns:
        The user's choice: "execute", "copy", or "abort".
    """
    console = Console()
    
    # Determine the lexer for syntax highlighting
    lexer = "powershell" if os_family == "Windows" else "bash"

    # --- THIS IS THE FIX ---
    # Clear the console for a clean presentation before showing the script.
    os.system('cls' if os.name == 'nt' else 'clear')

    console.print(Panel(
        Syntax(script, lexer, theme="monokai", line_numbers=True),
        title="[bold yellow]Generated Script[/bold yellow]",
        border_style="green",
        expand=True
    ))

    choice = Prompt.ask(
        "\n[bold]What would you like to do?[/bold]",
        choices=["execute", "copy", "abort"],
        default="abort"
    ).lower()

    return choice
