#!/usr/bin/env python3
"""
This sample contains example code of how encryption can be used.
It requires a room to be already created.
"""
import sys

from samples_common import get_user_details, get_input
from matrix_client.client import MatrixClient
from matrix_client.errors import E2EUnknownDevices


host, user_id, password = get_user_details(sys.argv)
try:
    room_id = sys.argv[4]
except:
    room_id = get_input("Room ID: ")

## Basic usage

client = MatrixClient(host, encryption=True, restore_device_id=True)
client.login(username=user_id, password=password)
device_id = client.device_id
room = client.join_room(room_id)

if not room.encrypted:
    room.send_text("Unencrypted!")
    encrypted = room.enable_encryption()
    if encrypted:
        room.send_text("Encrypted!")
    else:
        room.send_text("Still unencrypted, insufficient power levels?")

room.send_text("My autogenerated device ID is {}.".format(device_id))

client.logout()

client = MatrixClient(host, encryption=True, restore_device_id=True)
client.login(username=user_id, password=password)
assert client.device_id == device_id

room = client.join_room(room_id)
room.send_text("My device ID is still {}!".format(device_id))

## Advanced usage

# Device verification

room.verify_devices = True

try:
    room.send_text("Do I know everyone?")
except E2EUnknownDevices as e:
    # We don't know anyone, but send anyway
    for user_id, devices in e.user_devices.items():
        for device in devices:
            device.ignored = True
            # Out-of-band verification should allow to do device.verified = True instead

room.send_text("Now I know everyone, kind of.")


# Key sharing

# Print every keys which arrive to us
client.add_key_forward_listener(lambda x: print(x))

# Share keys everytime we receive a request from another of our devices (do not do this)
client.add_key_request_listener(lambda x, f: f(x))
