<?xml version='1.0'?> <!-- As XML file -->

<!-- Contains an xsl list of symbols provided by the Material Symbols font -->
<!-- Used by the insert-symbol template in pretext-html                    -->

<!-- http://pimpmyxslt.com/articles/entity-tricks-part2/ -->
<!DOCTYPE xsl:stylesheet [
    <!ENTITY % entities SYSTEM "entities.ent">
    %entities;
]>

<!-- Identify as a stylesheet -->
<!-- We choose to not include a default namespace       -->
<!-- (in particular  http://www.w3.org/1999/xhtml),     -->
<!-- even if this complicates adding namespaces onto    -->
<!-- derivatives, such as HTML destined for EPUB output -->
<!-- xmlns="http://www.w3.org/1999/xhtml"               -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- From Material Symbols: https://github.com/google/material-design-icons/blob/master -->
<!-- License: Apache 2.0 https://github.com/google/material-design-icons/blob/master/LICENSE -->

<xsl:variable name="available-symbols-list">
    <symbolinfo name="10k" entity="e951"/>
    <symbolinfo name="10mp" entity="e952"/>
    <symbolinfo name="11mp" entity="e953"/>
    <symbolinfo name="123" entity="eb8d"/>
    <symbolinfo name="12mp" entity="e954"/>
    <symbolinfo name="13mp" entity="e955"/>
    <symbolinfo name="14mp" entity="e956"/>
    <symbolinfo name="15mp" entity="e957"/>
    <symbolinfo name="16mp" entity="e958"/>
    <symbolinfo name="17mp" entity="e959"/>
    <symbolinfo name="18_up_rating" entity="f8fd"/>
    <symbolinfo name="18mp" entity="e95a"/>
    <symbolinfo name="19mp" entity="e95b"/>
    <symbolinfo name="1k" entity="e95c"/>
    <symbolinfo name="1k_plus" entity="e95d"/>
    <symbolinfo name="1x_mobiledata" entity="efcd"/>
    <symbolinfo name="1x_mobiledata_badge" entity="f7f1"/>
    <symbolinfo name="20mp" entity="e95e"/>
    <symbolinfo name="21mp" entity="e95f"/>
    <symbolinfo name="22mp" entity="e960"/>
    <symbolinfo name="23mp" entity="e961"/>
    <symbolinfo name="24mp" entity="e962"/>
    <symbolinfo name="2d" entity="ef37"/>
    <symbolinfo name="2k" entity="e963"/>
    <symbolinfo name="2k_plus" entity="e964"/>
    <symbolinfo name="2mp" entity="e965"/>
    <symbolinfo name="30fps" entity="efce"/>
    <symbolinfo name="30fps_select" entity="efcf"/>
    <symbolinfo name="360" entity="e577"/>
    <symbolinfo name="3d_rotation" entity="e84d"/>
    <symbolinfo name="3g_mobiledata" entity="efd0"/>
    <symbolinfo name="3g_mobiledata_badge" entity="f7f0"/>
    <symbolinfo name="3k" entity="e966"/>
    <symbolinfo name="3k_plus" entity="e967"/>
    <symbolinfo name="3mp" entity="e968"/>
    <symbolinfo name="3p" entity="efd1"/>
    <symbolinfo name="4g_mobiledata" entity="efd2"/>
    <symbolinfo name="4g_mobiledata_badge" entity="f7ef"/>
    <symbolinfo name="4g_plus_mobiledata" entity="efd3"/>
    <symbolinfo name="4k" entity="e072"/>
    <symbolinfo name="4k_plus" entity="e969"/>
    <symbolinfo name="4mp" entity="e96a"/>
    <symbolinfo name="50mp" entity="f6f3"/>
    <symbolinfo name="5g" entity="ef38"/>
    <symbolinfo name="5g_mobiledata_badge" entity="f7ee"/>
    <symbolinfo name="5k" entity="e96b"/>
    <symbolinfo name="5k_plus" entity="e96c"/>
    <symbolinfo name="5mp" entity="e96d"/>
    <symbolinfo name="60fps" entity="efd4"/>
    <symbolinfo name="60fps_select" entity="efd5"/>
    <symbolinfo name="6_ft_apart" entity="f21e"/>
    <symbolinfo name="6k" entity="e96e"/>
    <symbolinfo name="6k_plus" entity="e96f"/>
    <symbolinfo name="6mp" entity="e970"/>
    <symbolinfo name="7k" entity="e971"/>
    <symbolinfo name="7k_plus" entity="e972"/>
    <symbolinfo name="7mp" entity="e973"/>
    <symbolinfo name="8k" entity="e974"/>
    <symbolinfo name="8k_plus" entity="e975"/>
    <symbolinfo name="8mp" entity="e976"/>
    <symbolinfo name="9k" entity="e977"/>
    <symbolinfo name="9k_plus" entity="e978"/>
    <symbolinfo name="9mp" entity="e979"/>
    <symbolinfo name="abc" entity="eb94"/>
    <symbolinfo name="ac_unit" entity="eb3b"/>
    <symbolinfo name="access_alarm" entity="e855"/>
    <symbolinfo name="access_alarms" entity="e855"/>
    <symbolinfo name="access_time" entity="efd6"/>
    <symbolinfo name="access_time_filled" entity="efd6"/>
    <symbolinfo name="accessibility" entity="e84e"/>
    <symbolinfo name="accessibility_new" entity="e92c"/>
    <symbolinfo name="accessible" entity="e914"/>
    <symbolinfo name="accessible_forward" entity="e934"/>
    <symbolinfo name="account_balance" entity="e84f"/>
    <symbolinfo name="account_balance_wallet" entity="e850"/>
    <symbolinfo name="account_box" entity="e851"/>
    <symbolinfo name="account_circle" entity="f20b"/>
    <symbolinfo name="account_circle_filled" entity="f20b"/>
    <symbolinfo name="account_circle_off" entity="f7b3"/>
    <symbolinfo name="account_tree" entity="e97a"/>
    <symbolinfo name="activity_zone" entity="e1e6"/>
    <symbolinfo name="acute" entity="e4cb"/>
    <symbolinfo name="ad" entity="e65a"/>
    <symbolinfo name="ad_group" entity="e65b"/>
    <symbolinfo name="ad_group_off" entity="eae5"/>
    <symbolinfo name="ad_off" entity="f7b2"/>
    <symbolinfo name="ad_units" entity="ef39"/>
    <symbolinfo name="adb" entity="e60e"/>
    <symbolinfo name="add" entity="e145"/>
    <symbolinfo name="add_a_photo" entity="e439"/>
    <symbolinfo name="add_ad" entity="e72a"/>
    <symbolinfo name="add_alarm" entity="e856"/>
    <symbolinfo name="add_alert" entity="e003"/>
    <symbolinfo name="add_box" entity="e146"/>
    <symbolinfo name="add_business" entity="e729"/>
    <symbolinfo name="add_call" entity="f0b7"/>
    <symbolinfo name="add_card" entity="eb86"/>
    <symbolinfo name="add_chart" entity="ef3c"/>
    <symbolinfo name="add_circle" entity="e3ba"/>
    <symbolinfo name="add_circle_outline" entity="e3ba"/>
    <symbolinfo name="add_comment" entity="e266"/>
    <symbolinfo name="add_home" entity="f8eb"/>
    <symbolinfo name="add_home_work" entity="f8ed"/>
    <symbolinfo name="add_ic_call" entity="f0b7"/>
    <symbolinfo name="add_link" entity="e178"/>
    <symbolinfo name="add_location" entity="e567"/>
    <symbolinfo name="add_location_alt" entity="ef3a"/>
    <symbolinfo name="add_moderator" entity="e97d"/>
    <symbolinfo name="add_notes" entity="e091"/>
    <symbolinfo name="add_photo_alternate" entity="e43e"/>
    <symbolinfo name="add_reaction" entity="e1d3"/>
    <symbolinfo name="add_road" entity="ef3b"/>
    <symbolinfo name="add_shopping_cart" entity="e854"/>
    <symbolinfo name="add_task" entity="f23a"/>
    <symbolinfo name="add_to_drive" entity="e65c"/>
    <symbolinfo name="add_to_home_screen" entity="e1fe"/>
    <symbolinfo name="add_to_photos" entity="e39d"/>
    <symbolinfo name="add_to_queue" entity="e05c"/>
    <symbolinfo name="addchart" entity="ef3c"/>
    <symbolinfo name="adf_scanner" entity="eada"/>
    <symbolinfo name="adjust" entity="e39e"/>
    <symbolinfo name="admin_meds" entity="e48d"/>
    <symbolinfo name="admin_panel_settings" entity="ef3d"/>
    <symbolinfo name="ads_click" entity="e762"/>
    <symbolinfo name="agender" entity="f888"/>
    <symbolinfo name="agriculture" entity="ea79"/>
    <symbolinfo name="air" entity="efd8"/>
    <symbolinfo name="air_freshener" entity="e2ca"/>
    <symbolinfo name="air_purifier_gen" entity="e829"/>
    <symbolinfo name="airline_seat_flat" entity="e630"/>
    <symbolinfo name="airline_seat_flat_angled" entity="e631"/>
    <symbolinfo name="airline_seat_individual_suite" entity="e632"/>
    <symbolinfo name="airline_seat_legroom_extra" entity="e633"/>
    <symbolinfo name="airline_seat_legroom_normal" entity="e634"/>
    <symbolinfo name="airline_seat_legroom_reduced" entity="e635"/>
    <symbolinfo name="airline_seat_recline_extra" entity="e636"/>
    <symbolinfo name="airline_seat_recline_normal" entity="e637"/>
    <symbolinfo name="airline_stops" entity="e7d0"/>
    <symbolinfo name="airlines" entity="e7ca"/>
    <symbolinfo name="airplane_ticket" entity="efd9"/>
    <symbolinfo name="airplanemode_active" entity="e53d"/>
    <symbolinfo name="airplanemode_inactive" entity="e194"/>
    <symbolinfo name="airplay" entity="e055"/>
    <symbolinfo name="airport_shuttle" entity="eb3c"/>
    <symbolinfo name="airware" entity="f154"/>
    <symbolinfo name="airwave" entity="f154"/>
    <symbolinfo name="alarm" entity="e855"/>
    <symbolinfo name="alarm_add" entity="e856"/>
    <symbolinfo name="alarm_off" entity="e857"/>
    <symbolinfo name="alarm_on" entity="e858"/>
    <symbolinfo name="alarm_smart_wake" entity="f6b0"/>
    <symbolinfo name="album" entity="e019"/>
    <symbolinfo name="align_center" entity="e356"/>
    <symbolinfo name="align_end" entity="f797"/>
    <symbolinfo name="align_flex_center" entity="f796"/>
    <symbolinfo name="align_flex_end" entity="f795"/>
    <symbolinfo name="align_flex_start" entity="f794"/>
    <symbolinfo name="align_horizontal_center" entity="e00f"/>
    <symbolinfo name="align_horizontal_left" entity="e00d"/>
    <symbolinfo name="align_horizontal_right" entity="e010"/>
    <symbolinfo name="align_items_stretch" entity="f793"/>
    <symbolinfo name="align_justify_center" entity="f792"/>
    <symbolinfo name="align_justify_flex_end" entity="f791"/>
    <symbolinfo name="align_justify_flex_start" entity="f790"/>
    <symbolinfo name="align_justify_space_around" entity="f78f"/>
    <symbolinfo name="align_justify_space_between" entity="f78e"/>
    <symbolinfo name="align_justify_space_even" entity="f78d"/>
    <symbolinfo name="align_justify_stretch" entity="f78c"/>
    <symbolinfo name="align_self_stretch" entity="f78b"/>
    <symbolinfo name="align_space_around" entity="f78a"/>
    <symbolinfo name="align_space_between" entity="f789"/>
    <symbolinfo name="align_space_even" entity="f788"/>
    <symbolinfo name="align_start" entity="f787"/>
    <symbolinfo name="align_stretch" entity="f786"/>
    <symbolinfo name="align_vertical_bottom" entity="e015"/>
    <symbolinfo name="align_vertical_center" entity="e011"/>
    <symbolinfo name="align_vertical_top" entity="e00c"/>
    <symbolinfo name="all_inbox" entity="e97f"/>
    <symbolinfo name="all_inclusive" entity="eb3d"/>
    <symbolinfo name="all_match" entity="e093"/>
    <symbolinfo name="all_out" entity="e90b"/>
    <symbolinfo name="allergies" entity="e094"/>
    <symbolinfo name="allergy" entity="e64e"/>
    <symbolinfo name="alt_route" entity="f184"/>
    <symbolinfo name="alternate_email" entity="e0e6"/>
    <symbolinfo name="altitude" entity="f873"/>
    <symbolinfo name="ambient_screen" entity="f6c4"/>
    <symbolinfo name="ambulance" entity="f803"/>
    <symbolinfo name="amend" entity="f802"/>
    <symbolinfo name="amp_stories" entity="ea13"/>
    <symbolinfo name="analytics" entity="ef3e"/>
    <symbolinfo name="anchor" entity="f1cd"/>
    <symbolinfo name="android" entity="e859"/>
    <symbolinfo name="animation" entity="e71c"/>
    <symbolinfo name="announcement" entity="e87f"/>
    <symbolinfo name="aod" entity="efda"/>
    <symbolinfo name="aod_tablet" entity="f89f"/>
    <symbolinfo name="aod_watch" entity="f6ac"/>
    <symbolinfo name="apartment" entity="ea40"/>
    <symbolinfo name="api" entity="f1b7"/>
    <symbolinfo name="apk_document" entity="f88e"/>
    <symbolinfo name="apk_install" entity="f88f"/>
    <symbolinfo name="app_badging" entity="f72f"/>
    <symbolinfo name="app_blocking" entity="ef3f"/>
    <symbolinfo name="app_promo" entity="e981"/>
    <symbolinfo name="app_registration" entity="ef40"/>
    <symbolinfo name="app_settings_alt" entity="ef41"/>
    <symbolinfo name="app_shortcut" entity="eae4"/>
    <symbolinfo name="approval" entity="e982"/>
    <symbolinfo name="approval_delegation" entity="f84a"/>
    <symbolinfo name="apps" entity="e5c3"/>
    <symbolinfo name="apps_outage" entity="e7cc"/>
    <symbolinfo name="aq" entity="f55a"/>
    <symbolinfo name="aq_indoor" entity="f55b"/>
    <symbolinfo name="ar_on_you" entity="ef7c"/>
    <symbolinfo name="architecture" entity="ea3b"/>
    <symbolinfo name="archive" entity="e149"/>
    <symbolinfo name="area_chart" entity="e770"/>
    <symbolinfo name="arming_countdown" entity="e78a"/>
    <symbolinfo name="arrow_and_edge" entity="f5d7"/>
    <symbolinfo name="arrow_back" entity="e5c4"/>
    <symbolinfo name="arrow_back_ios" entity="e5e0"/>
    <symbolinfo name="arrow_back_ios_new" entity="e2ea"/>
    <symbolinfo name="arrow_circle_down" entity="f181"/>
    <symbolinfo name="arrow_circle_left" entity="eaa7"/>
    <symbolinfo name="arrow_circle_right" entity="eaaa"/>
    <symbolinfo name="arrow_circle_up" entity="f182"/>
    <symbolinfo name="arrow_downward" entity="e5db"/>
    <symbolinfo name="arrow_downward_alt" entity="e984"/>
    <symbolinfo name="arrow_drop_down" entity="e5c5"/>
    <symbolinfo name="arrow_drop_down_circle" entity="e5c6"/>
    <symbolinfo name="arrow_drop_up" entity="e5c7"/>
    <symbolinfo name="arrow_forward" entity="e5c8"/>
    <symbolinfo name="arrow_forward_ios" entity="e5e1"/>
    <symbolinfo name="arrow_insert" entity="f837"/>
    <symbolinfo name="arrow_left" entity="e5de"/>
    <symbolinfo name="arrow_left_alt" entity="ef7d"/>
    <symbolinfo name="arrow_or_edge" entity="f5d6"/>
    <symbolinfo name="arrow_outward" entity="f8ce"/>
    <symbolinfo name="arrow_range" entity="f69b"/>
    <symbolinfo name="arrow_right" entity="e5df"/>
    <symbolinfo name="arrow_right_alt" entity="e941"/>
    <symbolinfo name="arrow_selector_tool" entity="f82f"/>
    <symbolinfo name="arrow_split" entity="ea04"/>
    <symbolinfo name="arrow_top_left" entity="f72e"/>
    <symbolinfo name="arrow_top_right" entity="f72d"/>
    <symbolinfo name="arrow_upward" entity="e5d8"/>
    <symbolinfo name="arrow_upward_alt" entity="e986"/>
    <symbolinfo name="arrows_more_down" entity="f8ab"/>
    <symbolinfo name="arrows_more_up" entity="f8ac"/>
    <symbolinfo name="arrows_outward" entity="f72c"/>
    <symbolinfo name="art_track" entity="e060"/>
    <symbolinfo name="article" entity="ef42"/>
    <symbolinfo name="article_shortcut" entity="f587"/>
    <symbolinfo name="aspect_ratio" entity="e85b"/>
    <symbolinfo name="assessment" entity="f0cc"/>
    <symbolinfo name="assignment" entity="e85d"/>
    <symbolinfo name="assignment_add" entity="f848"/>
    <symbolinfo name="assignment_ind" entity="e85e"/>
    <symbolinfo name="assignment_late" entity="e85f"/>
    <symbolinfo name="assignment_return" entity="e860"/>
    <symbolinfo name="assignment_returned" entity="e861"/>
    <symbolinfo name="assignment_turned_in" entity="e862"/>
    <symbolinfo name="assist_walker" entity="f8d5"/>
    <symbolinfo name="assistant" entity="e39f"/>
    <symbolinfo name="assistant_direction" entity="e988"/>
    <symbolinfo name="assistant_navigation" entity="e989"/>
    <symbolinfo name="assistant_on_hub" entity="f6c1"/>
    <symbolinfo name="assistant_photo" entity="f0c6"/>
    <symbolinfo name="assured_workload" entity="eb6f"/>
    <symbolinfo name="astrophotography_auto" entity="f1d9"/>
    <symbolinfo name="astrophotography_off" entity="f1da"/>
    <symbolinfo name="atm" entity="e573"/>
    <symbolinfo name="atr" entity="ebc7"/>
    <symbolinfo name="attach_email" entity="ea5e"/>
    <symbolinfo name="attach_file" entity="e226"/>
    <symbolinfo name="attach_file_add" entity="f841"/>
    <symbolinfo name="attach_money" entity="e227"/>
    <symbolinfo name="attachment" entity="e2bc"/>
    <symbolinfo name="attractions" entity="ea52"/>
    <symbolinfo name="attribution" entity="efdb"/>
    <symbolinfo name="audio_description" entity="f58c"/>
    <symbolinfo name="audio_file" entity="eb82"/>
    <symbolinfo name="audio_video_receiver" entity="f5d3"/>
    <symbolinfo name="audiotrack" entity="e405"/>
    <symbolinfo name="auto_activity_zone" entity="f8ad"/>
    <symbolinfo name="auto_awesome" entity="e65f"/>
    <symbolinfo name="auto_awesome_mosaic" entity="e660"/>
    <symbolinfo name="auto_awesome_motion" entity="e661"/>
    <symbolinfo name="auto_delete" entity="ea4c"/>
    <symbolinfo name="auto_detect_voice" entity="f83e"/>
    <symbolinfo name="auto_fix" entity="e663"/>
    <symbolinfo name="auto_fix_high" entity="e663"/>
    <symbolinfo name="auto_fix_normal" entity="e664"/>
    <symbolinfo name="auto_fix_off" entity="e665"/>
    <symbolinfo name="auto_graph" entity="e4fb"/>
    <symbolinfo name="auto_label" entity="f6be"/>
    <symbolinfo name="auto_meeting_room" entity="f6bf"/>
    <symbolinfo name="auto_mode" entity="ec20"/>
    <symbolinfo name="auto_read_pause" entity="f219"/>
    <symbolinfo name="auto_read_play" entity="f216"/>
    <symbolinfo name="auto_schedule" entity="e214"/>
    <symbolinfo name="auto_stories" entity="e666"/>
    <symbolinfo name="auto_timer" entity="ef7f"/>
    <symbolinfo name="auto_videocam" entity="f6c0"/>
    <symbolinfo name="autofps_select" entity="efdc"/>
    <symbolinfo name="autopause" entity="f6b6"/>
    <symbolinfo name="autopay" entity="f84b"/>
    <symbolinfo name="autoplay" entity="f6b5"/>
    <symbolinfo name="autorenew" entity="e863"/>
    <symbolinfo name="autostop" entity="f682"/>
    <symbolinfo name="av_timer" entity="e01b"/>
    <symbolinfo name="avg_pace" entity="f6bb"/>
    <symbolinfo name="avg_time" entity="f813"/>
    <symbolinfo name="award_star" entity="f612"/>
    <symbolinfo name="azm" entity="f6ec"/>
    <symbolinfo name="baby_changing_station" entity="f19b"/>
    <symbolinfo name="back_hand" entity="e764"/>
    <symbolinfo name="back_to_tab" entity="f72b"/>
    <symbolinfo name="background_dot_large" entity="f79e"/>
    <symbolinfo name="background_grid_small" entity="f79d"/>
    <symbolinfo name="background_replace" entity="f20a"/>
    <symbolinfo name="backlight_high" entity="f7ed"/>
    <symbolinfo name="backlight_low" entity="f7ec"/>
    <symbolinfo name="backpack" entity="f19c"/>
    <symbolinfo name="backspace" entity="e14a"/>
    <symbolinfo name="backup" entity="e864"/>
    <symbolinfo name="backup_table" entity="ef43"/>
    <symbolinfo name="badge" entity="ea67"/>
    <symbolinfo name="badge_critical_battery" entity="f156"/>
    <symbolinfo name="bakery_dining" entity="ea53"/>
    <symbolinfo name="balance" entity="eaf6"/>
    <symbolinfo name="balcony" entity="e58f"/>
    <symbolinfo name="ballot" entity="e172"/>
    <symbolinfo name="bar_chart" entity="e26b"/>
    <symbolinfo name="bar_chart_4_bars" entity="f681"/>
    <symbolinfo name="barcode" entity="e70b"/>
    <symbolinfo name="barcode_reader" entity="f85c"/>
    <symbolinfo name="barcode_scanner" entity="e70c"/>
    <symbolinfo name="barefoot" entity="f871"/>
    <symbolinfo name="batch_prediction" entity="f0f5"/>
    <symbolinfo name="bath_outdoor" entity="f6fb"/>
    <symbolinfo name="bath_private" entity="f6fa"/>
    <symbolinfo name="bath_public_large" entity="f6f9"/>
    <symbolinfo name="bathroom" entity="efdd"/>
    <symbolinfo name="bathtub" entity="ea41"/>
    <symbolinfo name="battery_0_bar" entity="ebdc"/>
    <symbolinfo name="battery_1_bar" entity="f09c"/>
    <symbolinfo name="battery_20" entity="f09c"/>
    <symbolinfo name="battery_2_bar" entity="f09d"/>
    <symbolinfo name="battery_30" entity="f09d"/>
    <symbolinfo name="battery_3_bar" entity="f09e"/>
    <symbolinfo name="battery_4_bar" entity="f09f"/>
    <symbolinfo name="battery_50" entity="f09e"/>
    <symbolinfo name="battery_5_bar" entity="f0a0"/>
    <symbolinfo name="battery_60" entity="f09f"/>
    <symbolinfo name="battery_6_bar" entity="f0a1"/>
    <symbolinfo name="battery_80" entity="f0a0"/>
    <symbolinfo name="battery_90" entity="f0a1"/>
    <symbolinfo name="battery_alert" entity="e19c"/>
    <symbolinfo name="battery_change" entity="f7eb"/>
    <symbolinfo name="battery_charging_20" entity="f0a2"/>
    <symbolinfo name="battery_charging_30" entity="f0a3"/>
    <symbolinfo name="battery_charging_50" entity="f0a4"/>
    <symbolinfo name="battery_charging_60" entity="f0a5"/>
    <symbolinfo name="battery_charging_80" entity="f0a6"/>
    <symbolinfo name="battery_charging_90" entity="f0a7"/>
    <symbolinfo name="battery_charging_full" entity="e1a3"/>
    <symbolinfo name="battery_error" entity="f7ea"/>
    <symbolinfo name="battery_full" entity="e1a5"/>
    <symbolinfo name="battery_full_alt" entity="f13b"/>
    <symbolinfo name="battery_horiz_000" entity="f8ae"/>
    <symbolinfo name="battery_horiz_050" entity="f8af"/>
    <symbolinfo name="battery_horiz_075" entity="f8b0"/>
    <symbolinfo name="battery_low" entity="f155"/>
    <symbolinfo name="battery_plus" entity="f7e9"/>
    <symbolinfo name="battery_profile" entity="e206"/>
    <symbolinfo name="battery_saver" entity="efde"/>
    <symbolinfo name="battery_share" entity="f67e"/>
    <symbolinfo name="battery_status_good" entity="f67d"/>
    <symbolinfo name="battery_std" entity="e1a5"/>
    <symbolinfo name="battery_unknown" entity="e1a6"/>
    <symbolinfo name="battery_vert_005" entity="f8b1"/>
    <symbolinfo name="battery_vert_020" entity="f8b2"/>
    <symbolinfo name="battery_vert_050" entity="f8b3"/>
    <symbolinfo name="battery_very_low" entity="f156"/>
    <symbolinfo name="beach_access" entity="eb3e"/>
    <symbolinfo name="bed" entity="efdf"/>
    <symbolinfo name="bedroom_baby" entity="efe0"/>
    <symbolinfo name="bedroom_child" entity="efe1"/>
    <symbolinfo name="bedroom_parent" entity="efe2"/>
    <symbolinfo name="bedtime" entity="ef44"/>
    <symbolinfo name="bedtime_off" entity="eb76"/>
    <symbolinfo name="beenhere" entity="e52d"/>
    <symbolinfo name="bento" entity="f1f4"/>
    <symbolinfo name="bia" entity="f6eb"/>
    <symbolinfo name="bid_landscape" entity="e678"/>
    <symbolinfo name="bid_landscape_disabled" entity="ef81"/>
    <symbolinfo name="bike_scooter" entity="ef45"/>
    <symbolinfo name="biotech" entity="ea3a"/>
    <symbolinfo name="blanket" entity="e828"/>
    <symbolinfo name="blender" entity="efe3"/>
    <symbolinfo name="blind" entity="f8d6"/>
    <symbolinfo name="blinds" entity="e286"/>
    <symbolinfo name="blinds_closed" entity="ec1f"/>
    <symbolinfo name="block" entity="f08c"/>
    <symbolinfo name="blood_pressure" entity="e097"/>
    <symbolinfo name="bloodtype" entity="efe4"/>
    <symbolinfo name="bluetooth" entity="e1a7"/>
    <symbolinfo name="bluetooth_audio" entity="e60f"/>
    <symbolinfo name="bluetooth_connected" entity="e1a8"/>
    <symbolinfo name="bluetooth_disabled" entity="e1a9"/>
    <symbolinfo name="bluetooth_drive" entity="efe5"/>
    <symbolinfo name="bluetooth_searching" entity="e60f"/>
    <symbolinfo name="blur_circular" entity="e3a2"/>
    <symbolinfo name="blur_linear" entity="e3a3"/>
    <symbolinfo name="blur_medium" entity="e84c"/>
    <symbolinfo name="blur_off" entity="e3a4"/>
    <symbolinfo name="blur_on" entity="e3a5"/>
    <symbolinfo name="blur_short" entity="e8cf"/>
    <symbolinfo name="body_fat" entity="e098"/>
    <symbolinfo name="body_system" entity="e099"/>
    <symbolinfo name="bolt" entity="ea0b"/>
    <symbolinfo name="bomb" entity="f568"/>
    <symbolinfo name="book" entity="e86e"/>
    <symbolinfo name="book_online" entity="f217"/>
    <symbolinfo name="bookmark" entity="e8e7"/>
    <symbolinfo name="bookmark_add" entity="e598"/>
    <symbolinfo name="bookmark_added" entity="e599"/>
    <symbolinfo name="bookmark_border" entity="e8e7"/>
    <symbolinfo name="bookmark_manager" entity="f7b1"/>
    <symbolinfo name="bookmark_remove" entity="e59a"/>
    <symbolinfo name="bookmarks" entity="e98b"/>
    <symbolinfo name="border_all" entity="e228"/>
    <symbolinfo name="border_bottom" entity="e229"/>
    <symbolinfo name="border_clear" entity="e22a"/>
    <symbolinfo name="border_color" entity="e22b"/>
    <symbolinfo name="border_horizontal" entity="e22c"/>
    <symbolinfo name="border_inner" entity="e22d"/>
    <symbolinfo name="border_left" entity="e22e"/>
    <symbolinfo name="border_outer" entity="e22f"/>
    <symbolinfo name="border_right" entity="e230"/>
    <symbolinfo name="border_style" entity="e231"/>
    <symbolinfo name="border_top" entity="e232"/>
    <symbolinfo name="border_vertical" entity="e233"/>
    <symbolinfo name="bottom_app_bar" entity="e730"/>
    <symbolinfo name="bottom_drawer" entity="e72d"/>
    <symbolinfo name="bottom_navigation" entity="e98c"/>
    <symbolinfo name="bottom_panel_close" entity="f72a"/>
    <symbolinfo name="bottom_panel_open" entity="f729"/>
    <symbolinfo name="bottom_right_click" entity="f684"/>
    <symbolinfo name="bottom_sheets" entity="e98d"/>
    <symbolinfo name="box" entity="f5a4"/>
    <symbolinfo name="box_add" entity="f5a5"/>
    <symbolinfo name="box_edit" entity="f5a6"/>
    <symbolinfo name="boy" entity="eb67"/>
    <symbolinfo name="brand_awareness" entity="e98e"/>
    <symbolinfo name="branding_watermark" entity="e06b"/>
    <symbolinfo name="breakfast_dining" entity="ea54"/>
    <symbolinfo name="breaking_news" entity="ea08"/>
    <symbolinfo name="breaking_news_alt_1" entity="f0ba"/>
    <symbolinfo name="breastfeeding" entity="f856"/>
    <symbolinfo name="brightness_1" entity="e3fa"/>
    <symbolinfo name="brightness_2" entity="f036"/>
    <symbolinfo name="brightness_3" entity="e3a8"/>
    <symbolinfo name="brightness_4" entity="e3a9"/>
    <symbolinfo name="brightness_5" entity="e3aa"/>
    <symbolinfo name="brightness_6" entity="e3ab"/>
    <symbolinfo name="brightness_7" entity="e3ac"/>
    <symbolinfo name="brightness_alert" entity="f5cf"/>
    <symbolinfo name="brightness_auto" entity="e1ab"/>
    <symbolinfo name="brightness_empty" entity="f7e8"/>
    <symbolinfo name="brightness_high" entity="e1ac"/>
    <symbolinfo name="brightness_low" entity="e1ad"/>
    <symbolinfo name="brightness_medium" entity="e1ae"/>
    <symbolinfo name="bring_your_own_ip" entity="e016"/>
    <symbolinfo name="broadcast_on_home" entity="f8f8"/>
    <symbolinfo name="broadcast_on_personal" entity="f8f9"/>
    <symbolinfo name="broken_image" entity="e3ad"/>
    <symbolinfo name="browse" entity="eb13"/>
    <symbolinfo name="browse_activity" entity="f8a5"/>
    <symbolinfo name="browse_gallery" entity="ebd1"/>
    <symbolinfo name="browser_not_supported" entity="ef47"/>
    <symbolinfo name="browser_updated" entity="e7cf"/>
    <symbolinfo name="brunch_dining" entity="ea73"/>
    <symbolinfo name="brush" entity="e3ae"/>
    <symbolinfo name="bubble" entity="ef83"/>
    <symbolinfo name="bubble_chart" entity="e6dd"/>
    <symbolinfo name="bubbles" entity="f64e"/>
    <symbolinfo name="bug_report" entity="e868"/>
    <symbolinfo name="build" entity="f8cd"/>
    <symbolinfo name="build_circle" entity="ef48"/>
    <symbolinfo name="bungalow" entity="e591"/>
    <symbolinfo name="burst_mode" entity="e43c"/>
    <symbolinfo name="bus_alert" entity="e98f"/>
    <symbolinfo name="business" entity="e7ee"/>
    <symbolinfo name="business_center" entity="eb3f"/>
    <symbolinfo name="business_chip" entity="f84c"/>
    <symbolinfo name="business_messages" entity="ef84"/>
    <symbolinfo name="buttons_alt" entity="e72f"/>
    <symbolinfo name="cabin" entity="e589"/>
    <symbolinfo name="cable" entity="efe6"/>
    <symbolinfo name="cached" entity="e86a"/>
    <symbolinfo name="cake" entity="e7e9"/>
    <symbolinfo name="cake_add" entity="f85b"/>
    <symbolinfo name="calculate" entity="ea5f"/>
    <symbolinfo name="calendar_add_on" entity="ef85"/>
    <symbolinfo name="calendar_apps_script" entity="f0bb"/>
    <symbolinfo name="calendar_month" entity="ebcc"/>
    <symbolinfo name="calendar_today" entity="e935"/>
    <symbolinfo name="calendar_view_day" entity="e936"/>
    <symbolinfo name="calendar_view_month" entity="efe7"/>
    <symbolinfo name="calendar_view_week" entity="efe8"/>
    <symbolinfo name="call" entity="f0d4"/>
    <symbolinfo name="call_end" entity="f0bc"/>
    <symbolinfo name="call_end_alt" entity="f0bc"/>
    <symbolinfo name="call_log" entity="e08e"/>
    <symbolinfo name="call_made" entity="e0b2"/>
    <symbolinfo name="call_merge" entity="e0b3"/>
    <symbolinfo name="call_missed" entity="e0b4"/>
    <symbolinfo name="call_missed_outgoing" entity="e0e4"/>
    <symbolinfo name="call_quality" entity="f652"/>
    <symbolinfo name="call_received" entity="e0b5"/>
    <symbolinfo name="call_split" entity="e0b6"/>
    <symbolinfo name="call_to_action" entity="e06c"/>
    <symbolinfo name="camera" entity="e3af"/>
    <symbolinfo name="camera_alt" entity="e412"/>
    <symbolinfo name="camera_enhance" entity="e8fc"/>
    <symbolinfo name="camera_front" entity="e3b1"/>
    <symbolinfo name="camera_indoor" entity="efe9"/>
    <symbolinfo name="camera_outdoor" entity="efea"/>
    <symbolinfo name="camera_rear" entity="e3b2"/>
    <symbolinfo name="camera_roll" entity="e3b3"/>
    <symbolinfo name="camera_video" entity="f7a6"/>
    <symbolinfo name="cameraswitch" entity="efeb"/>
    <symbolinfo name="campaign" entity="ef49"/>
    <symbolinfo name="camping" entity="f8a2"/>
    <symbolinfo name="cancel" entity="e888"/>
    <symbolinfo name="cancel_presentation" entity="e0e9"/>
    <symbolinfo name="cancel_schedule_send" entity="ea39"/>
    <symbolinfo name="candle" entity="f588"/>
    <symbolinfo name="candlestick_chart" entity="ead4"/>
    <symbolinfo name="captive_portal" entity="f728"/>
    <symbolinfo name="capture" entity="f727"/>
    <symbolinfo name="car_crash" entity="ebf2"/>
    <symbolinfo name="car_rental" entity="ea55"/>
    <symbolinfo name="car_repair" entity="ea56"/>
    <symbolinfo name="card_giftcard" entity="e8f6"/>
    <symbolinfo name="card_membership" entity="e8f7"/>
    <symbolinfo name="card_travel" entity="e8f8"/>
    <symbolinfo name="cardiology" entity="e09c"/>
    <symbolinfo name="cards" entity="e991"/>
    <symbolinfo name="carpenter" entity="f1f8"/>
    <symbolinfo name="cases" entity="e992"/>
    <symbolinfo name="casino" entity="eb40"/>
    <symbolinfo name="cast" entity="e307"/>
    <symbolinfo name="cast_connected" entity="e308"/>
    <symbolinfo name="cast_for_education" entity="efec"/>
    <symbolinfo name="cast_pause" entity="f5f0"/>
    <symbolinfo name="cast_warning" entity="f5ef"/>
    <symbolinfo name="castle" entity="eab1"/>
    <symbolinfo name="category" entity="e574"/>
    <symbolinfo name="celebration" entity="ea65"/>
    <symbolinfo name="cell_merge" entity="f82e"/>
    <symbolinfo name="cell_tower" entity="ebba"/>
    <symbolinfo name="cell_wifi" entity="e0ec"/>
    <symbolinfo name="center_focus_strong" entity="e3b4"/>
    <symbolinfo name="center_focus_weak" entity="e3b5"/>
    <symbolinfo name="chair" entity="efed"/>
    <symbolinfo name="chair_alt" entity="efee"/>
    <symbolinfo name="chalet" entity="e585"/>
    <symbolinfo name="change_circle" entity="e2e7"/>
    <symbolinfo name="change_history" entity="e86b"/>
    <symbolinfo name="charger" entity="e2ae"/>
    <symbolinfo name="charging_station" entity="f19d"/>
    <symbolinfo name="chart_data" entity="e473"/>
    <symbolinfo name="chat" entity="e0c9"/>
    <symbolinfo name="chat_add_on" entity="f0f3"/>
    <symbolinfo name="chat_apps_script" entity="f0bd"/>
    <symbolinfo name="chat_bubble" entity="e0cb"/>
    <symbolinfo name="chat_bubble_outline" entity="e0cb"/>
    <symbolinfo name="chat_error" entity="f7ac"/>
    <symbolinfo name="chat_paste_go" entity="f6bd"/>
    <symbolinfo name="check" entity="e5ca"/>
    <symbolinfo name="check_box" entity="e834"/>
    <symbolinfo name="check_box_outline_blank" entity="e835"/>
    <symbolinfo name="check_circle" entity="f0be"/>
    <symbolinfo name="check_circle_filled" entity="f0be"/>
    <symbolinfo name="check_circle_outline" entity="f0be"/>
    <symbolinfo name="check_in_out" entity="f6f6"/>
    <symbolinfo name="check_indeterminate_small" entity="f88a"/>
    <symbolinfo name="check_small" entity="f88b"/>
    <symbolinfo name="checklist" entity="e6b1"/>
    <symbolinfo name="checklist_rtl" entity="e6b3"/>
    <symbolinfo name="checkroom" entity="f19e"/>
    <symbolinfo name="cheer" entity="f6a8"/>
    <symbolinfo name="chess" entity="f5e7"/>
    <symbolinfo name="chevron_left" entity="e5cb"/>
    <symbolinfo name="chevron_right" entity="e5cc"/>
    <symbolinfo name="child_care" entity="eb41"/>
    <symbolinfo name="child_friendly" entity="eb42"/>
    <symbolinfo name="chip_extraction" entity="f821"/>
    <symbolinfo name="chips" entity="e993"/>
    <symbolinfo name="chrome_reader_mode" entity="e86d"/>
    <symbolinfo name="chromecast_2" entity="f17b"/>
    <symbolinfo name="chromecast_device" entity="e83c"/>
    <symbolinfo name="chronic" entity="ebb2"/>
    <symbolinfo name="church" entity="eaae"/>
    <symbolinfo name="cinematic_blur" entity="f853"/>
    <symbolinfo name="circle" entity="ef4a"/>
    <symbolinfo name="circle_notifications" entity="e994"/>
    <symbolinfo name="circles" entity="e7ea"/>
    <symbolinfo name="circles_ext" entity="e7ec"/>
    <symbolinfo name="clarify" entity="f0bf"/>
    <symbolinfo name="class" entity="e86e"/>
    <symbolinfo name="clean_hands" entity="f21f"/>
    <symbolinfo name="cleaning_bucket" entity="f8b4"/>
    <symbolinfo name="cleaning_services" entity="f0ff"/>
    <symbolinfo name="clear" entity="e5cd"/>
    <symbolinfo name="clear_all" entity="e0b8"/>
    <symbolinfo name="clear_day" entity="f157"/>
    <symbolinfo name="clear_night" entity="f159"/>
    <symbolinfo name="climate_mini_split" entity="f8b5"/>
    <symbolinfo name="clinical_notes" entity="e09e"/>
    <symbolinfo name="clock_loader_10" entity="f726"/>
    <symbolinfo name="clock_loader_20" entity="f725"/>
    <symbolinfo name="clock_loader_40" entity="f724"/>
    <symbolinfo name="clock_loader_60" entity="f723"/>
    <symbolinfo name="clock_loader_80" entity="f722"/>
    <symbolinfo name="clock_loader_90" entity="f721"/>
    <symbolinfo name="close" entity="e5cd"/>
    <symbolinfo name="close_fullscreen" entity="f1cf"/>
    <symbolinfo name="closed_caption" entity="e996"/>
    <symbolinfo name="closed_caption_disabled" entity="f1dc"/>
    <symbolinfo name="closed_caption_off" entity="e996"/>
    <symbolinfo name="cloud" entity="f15c"/>
    <symbolinfo name="cloud_circle" entity="e2be"/>
    <symbolinfo name="cloud_done" entity="e2bf"/>
    <symbolinfo name="cloud_download" entity="e2c0"/>
    <symbolinfo name="cloud_off" entity="e2c1"/>
    <symbolinfo name="cloud_queue" entity="f15c"/>
    <symbolinfo name="cloud_sync" entity="eb5a"/>
    <symbolinfo name="cloud_upload" entity="e2c3"/>
    <symbolinfo name="cloudy" entity="f15c"/>
    <symbolinfo name="cloudy_filled" entity="f15c"/>
    <symbolinfo name="cloudy_snowing" entity="e810"/>
    <symbolinfo name="co2" entity="e7b0"/>
    <symbolinfo name="co_present" entity="eaf0"/>
    <symbolinfo name="code" entity="e86f"/>
    <symbolinfo name="code_blocks" entity="f84d"/>
    <symbolinfo name="code_off" entity="e4f3"/>
    <symbolinfo name="coffee" entity="efef"/>
    <symbolinfo name="coffee_maker" entity="eff0"/>
    <symbolinfo name="cognition" entity="e09f"/>
    <symbolinfo name="collapse_all" entity="e944"/>
    <symbolinfo name="collections" entity="e3d3"/>
    <symbolinfo name="collections_bookmark" entity="e431"/>
    <symbolinfo name="color_lens" entity="e40a"/>
    <symbolinfo name="colorize" entity="e3b8"/>
    <symbolinfo name="colors" entity="e997"/>
    <symbolinfo name="comic_bubble" entity="f5dd"/>
    <symbolinfo name="comment" entity="e24c"/>
    <symbolinfo name="comment_bank" entity="ea4e"/>
    <symbolinfo name="comments_disabled" entity="e7a2"/>
    <symbolinfo name="commit" entity="eaf5"/>
    <symbolinfo name="communication" entity="e27c"/>
    <symbolinfo name="communities" entity="eb16"/>
    <symbolinfo name="communities_filled" entity="eb16"/>
    <symbolinfo name="commute" entity="e940"/>
    <symbolinfo name="compare" entity="e3b9"/>
    <symbolinfo name="compare_arrows" entity="e915"/>
    <symbolinfo name="compass_calibration" entity="e57c"/>
    <symbolinfo name="component_exchange" entity="f1e7"/>
    <symbolinfo name="compost" entity="e761"/>
    <symbolinfo name="compress" entity="e94d"/>
    <symbolinfo name="computer" entity="e31e"/>
    <symbolinfo name="concierge" entity="f561"/>
    <symbolinfo name="conditions" entity="e0a0"/>
    <symbolinfo name="confirmation_number" entity="e638"/>
    <symbolinfo name="congenital" entity="e0a1"/>
    <symbolinfo name="connect_without_contact" entity="f223"/>
    <symbolinfo name="connected_tv" entity="e998"/>
    <symbolinfo name="connecting_airports" entity="e7c9"/>
    <symbolinfo name="construction" entity="ea3c"/>
    <symbolinfo name="contact_emergency" entity="f8d1"/>
    <symbolinfo name="contact_mail" entity="e0d0"/>
    <symbolinfo name="contact_page" entity="f22e"/>
    <symbolinfo name="contact_phone" entity="f0c0"/>
    <symbolinfo name="contact_phone_filled" entity="f0c0"/>
    <symbolinfo name="contact_support" entity="e94c"/>
    <symbolinfo name="contactless" entity="ea71"/>
    <symbolinfo name="contactless_off" entity="f858"/>
    <symbolinfo name="contacts" entity="e0ba"/>
    <symbolinfo name="content_copy" entity="e14d"/>
    <symbolinfo name="content_cut" entity="e14e"/>
    <symbolinfo name="content_paste" entity="e14f"/>
    <symbolinfo name="content_paste_go" entity="ea8e"/>
    <symbolinfo name="content_paste_off" entity="e4f8"/>
    <symbolinfo name="content_paste_search" entity="ea9b"/>
    <symbolinfo name="contract" entity="f5a0"/>
    <symbolinfo name="contract_delete" entity="f5a2"/>
    <symbolinfo name="contract_edit" entity="f5a1"/>
    <symbolinfo name="contrast" entity="eb37"/>
    <symbolinfo name="contrast_rtl_off" entity="ec72"/>
    <symbolinfo name="control_camera" entity="e074"/>
    <symbolinfo name="control_point" entity="e3ba"/>
    <symbolinfo name="control_point_duplicate" entity="e3bb"/>
    <symbolinfo name="controller_gen" entity="e83d"/>
    <symbolinfo name="conversion_path" entity="f0c1"/>
    <symbolinfo name="conversion_path_off" entity="f7b4"/>
    <symbolinfo name="conveyor_belt" entity="f867"/>
    <symbolinfo name="cookie" entity="eaac"/>
    <symbolinfo name="cookie_off" entity="f79a"/>
    <symbolinfo name="cooking" entity="e2b6"/>
    <symbolinfo name="cool_to_dry" entity="e276"/>
    <symbolinfo name="copy_all" entity="e2ec"/>
    <symbolinfo name="copyright" entity="e90c"/>
    <symbolinfo name="coronavirus" entity="f221"/>
    <symbolinfo name="corporate_fare" entity="f1d0"/>
    <symbolinfo name="cottage" entity="e587"/>
    <symbolinfo name="counter_0" entity="f785"/>
    <symbolinfo name="counter_1" entity="f784"/>
    <symbolinfo name="counter_2" entity="f783"/>
    <symbolinfo name="counter_3" entity="f782"/>
    <symbolinfo name="counter_4" entity="f781"/>
    <symbolinfo name="counter_5" entity="f780"/>
    <symbolinfo name="counter_6" entity="f77f"/>
    <symbolinfo name="counter_7" entity="f77e"/>
    <symbolinfo name="counter_8" entity="f77d"/>
    <symbolinfo name="counter_9" entity="f77c"/>
    <symbolinfo name="countertops" entity="f1f7"/>
    <symbolinfo name="create" entity="f097"/>
    <symbolinfo name="create_new_folder" entity="e2cc"/>
    <symbolinfo name="credit_card" entity="e8a1"/>
    <symbolinfo name="credit_card_off" entity="e4f4"/>
    <symbolinfo name="credit_score" entity="eff1"/>
    <symbolinfo name="crib" entity="e588"/>
    <symbolinfo name="crisis_alert" entity="ebe9"/>
    <symbolinfo name="crop" entity="e3be"/>
    <symbolinfo name="crop_16_9" entity="e3bc"/>
    <symbolinfo name="crop_3_2" entity="e3bd"/>
    <symbolinfo name="crop_5_4" entity="e3bf"/>
    <symbolinfo name="crop_7_5" entity="e3c0"/>
    <symbolinfo name="crop_9_16" entity="f549"/>
    <symbolinfo name="crop_din" entity="e3c6"/>
    <symbolinfo name="crop_free" entity="e3c2"/>
    <symbolinfo name="crop_landscape" entity="e3c3"/>
    <symbolinfo name="crop_original" entity="e3f4"/>
    <symbolinfo name="crop_portrait" entity="e3c5"/>
    <symbolinfo name="crop_rotate" entity="e437"/>
    <symbolinfo name="crop_square" entity="e3c6"/>
    <symbolinfo name="crossword" entity="f5e5"/>
    <symbolinfo name="crowdsource" entity="eb18"/>
    <symbolinfo name="cruelty_free" entity="e799"/>
    <symbolinfo name="css" entity="eb93"/>
    <symbolinfo name="csv" entity="e6cf"/>
    <symbolinfo name="currency_bitcoin" entity="ebc5"/>
    <symbolinfo name="currency_exchange" entity="eb70"/>
    <symbolinfo name="currency_franc" entity="eafa"/>
    <symbolinfo name="currency_lira" entity="eaef"/>
    <symbolinfo name="currency_pound" entity="eaf1"/>
    <symbolinfo name="currency_ruble" entity="eaec"/>
    <symbolinfo name="currency_rupee" entity="eaf7"/>
    <symbolinfo name="currency_yen" entity="eafb"/>
    <symbolinfo name="currency_yuan" entity="eaf9"/>
    <symbolinfo name="curtains" entity="ec1e"/>
    <symbolinfo name="curtains_closed" entity="ec1d"/>
    <symbolinfo name="custom_typography" entity="e732"/>
    <symbolinfo name="cut" entity="f08b"/>
    <symbolinfo name="cycle" entity="f854"/>
    <symbolinfo name="cyclone" entity="ebd5"/>
    <symbolinfo name="dangerous" entity="e99a"/>
    <symbolinfo name="dark_mode" entity="e51c"/>
    <symbolinfo name="dashboard" entity="e871"/>
    <symbolinfo name="dashboard_customize" entity="e99b"/>
    <symbolinfo name="data_alert" entity="f7f6"/>
    <symbolinfo name="data_array" entity="ead1"/>
    <symbolinfo name="data_check" entity="f7f2"/>
    <symbolinfo name="data_exploration" entity="e76f"/>
    <symbolinfo name="data_info_alert" entity="f7f5"/>
    <symbolinfo name="data_loss_prevention" entity="e2dc"/>
    <symbolinfo name="data_object" entity="ead3"/>
    <symbolinfo name="data_saver_off" entity="eff2"/>
    <symbolinfo name="data_saver_on" entity="eff3"/>
    <symbolinfo name="data_table" entity="e99c"/>
    <symbolinfo name="data_thresholding" entity="eb9f"/>
    <symbolinfo name="data_usage" entity="eff2"/>
    <symbolinfo name="database" entity="f20e"/>
    <symbolinfo name="dataset" entity="f8ee"/>
    <symbolinfo name="dataset_linked" entity="f8ef"/>
    <symbolinfo name="date_range" entity="e916"/>
    <symbolinfo name="deblur" entity="eb77"/>
    <symbolinfo name="deceased" entity="e0a5"/>
    <symbolinfo name="decimal_decrease" entity="f82d"/>
    <symbolinfo name="decimal_increase" entity="f82c"/>
    <symbolinfo name="deck" entity="ea42"/>
    <symbolinfo name="dehaze" entity="e3c7"/>
    <symbolinfo name="delete" entity="e92e"/>
    <symbolinfo name="delete_forever" entity="e92b"/>
    <symbolinfo name="delete_outline" entity="e92e"/>
    <symbolinfo name="delete_sweep" entity="e16c"/>
    <symbolinfo name="demography" entity="e489"/>
    <symbolinfo name="density_large" entity="eba9"/>
    <symbolinfo name="density_medium" entity="eb9e"/>
    <symbolinfo name="density_small" entity="eba8"/>
    <symbolinfo name="dentistry" entity="e0a6"/>
    <symbolinfo name="departure_board" entity="e576"/>
    <symbolinfo name="deployed_code" entity="f720"/>
    <symbolinfo name="deployed_code_alert" entity="f5f2"/>
    <symbolinfo name="deployed_code_history" entity="f5f3"/>
    <symbolinfo name="deployed_code_update" entity="f5f4"/>
    <symbolinfo name="dermatology" entity="e0a7"/>
    <symbolinfo name="description" entity="e873"/>
    <symbolinfo name="deselect" entity="ebb6"/>
    <symbolinfo name="design_services" entity="f10a"/>
    <symbolinfo name="desk" entity="f8f4"/>
    <symbolinfo name="deskphone" entity="f7fa"/>
    <symbolinfo name="desktop_access_disabled" entity="e99d"/>
    <symbolinfo name="desktop_mac" entity="e30b"/>
    <symbolinfo name="desktop_windows" entity="e30c"/>
    <symbolinfo name="destruction" entity="f585"/>
    <symbolinfo name="details" entity="e3c8"/>
    <symbolinfo name="detection_and_zone" entity="e29f"/>
    <symbolinfo name="detector" entity="e282"/>
    <symbolinfo name="detector_alarm" entity="e1f7"/>
    <symbolinfo name="detector_battery" entity="e204"/>
    <symbolinfo name="detector_co" entity="e2af"/>
    <symbolinfo name="detector_offline" entity="e223"/>
    <symbolinfo name="detector_smoke" entity="e285"/>
    <symbolinfo name="detector_status" entity="e1e8"/>
    <symbolinfo name="developer_board" entity="e30d"/>
    <symbolinfo name="developer_board_off" entity="e4ff"/>
    <symbolinfo name="developer_guide" entity="e99e"/>
    <symbolinfo name="developer_mode" entity="e1b0"/>
    <symbolinfo name="developer_mode_tv" entity="e874"/>
    <symbolinfo name="device_hub" entity="e335"/>
    <symbolinfo name="device_reset" entity="e8b3"/>
    <symbolinfo name="device_thermostat" entity="e1ff"/>
    <symbolinfo name="device_unknown" entity="e339"/>
    <symbolinfo name="devices" entity="e326"/>
    <symbolinfo name="devices_fold" entity="ebde"/>
    <symbolinfo name="devices_off" entity="f7a5"/>
    <symbolinfo name="devices_other" entity="e337"/>
    <symbolinfo name="devices_wearables" entity="f6ab"/>
    <symbolinfo name="dew_point" entity="f879"/>
    <symbolinfo name="diagnosis" entity="e0a8"/>
    <symbolinfo name="dialer_sip" entity="e0bb"/>
    <symbolinfo name="dialogs" entity="e99f"/>
    <symbolinfo name="dialpad" entity="e0bc"/>
    <symbolinfo name="diamond" entity="ead5"/>
    <symbolinfo name="difference" entity="eb7d"/>
    <symbolinfo name="digital_out_of_home" entity="f1de"/>
    <symbolinfo name="dining" entity="eff4"/>
    <symbolinfo name="dinner_dining" entity="ea57"/>
    <symbolinfo name="directions" entity="e52e"/>
    <symbolinfo name="directions_alt" entity="f880"/>
    <symbolinfo name="directions_alt_off" entity="f881"/>
    <symbolinfo name="directions_bike" entity="e52f"/>
    <symbolinfo name="directions_boat" entity="eff5"/>
    <symbolinfo name="directions_boat_filled" entity="eff5"/>
    <symbolinfo name="directions_bus" entity="eff6"/>
    <symbolinfo name="directions_bus_filled" entity="eff6"/>
    <symbolinfo name="directions_car" entity="eff7"/>
    <symbolinfo name="directions_car_filled" entity="eff7"/>
    <symbolinfo name="directions_off" entity="f10f"/>
    <symbolinfo name="directions_railway" entity="eff8"/>
    <symbolinfo name="directions_railway_filled" entity="eff8"/>
    <symbolinfo name="directions_run" entity="e566"/>
    <symbolinfo name="directions_subway" entity="effa"/>
    <symbolinfo name="directions_subway_filled" entity="effa"/>
    <symbolinfo name="directions_transit" entity="effa"/>
    <symbolinfo name="directions_transit_filled" entity="effa"/>
    <symbolinfo name="directions_walk" entity="e536"/>
    <symbolinfo name="directory_sync" entity="e394"/>
    <symbolinfo name="dirty_lens" entity="ef4b"/>
    <symbolinfo name="disabled_by_default" entity="f230"/>
    <symbolinfo name="disabled_visible" entity="e76e"/>
    <symbolinfo name="disc_full" entity="e610"/>
    <symbolinfo name="discover_tune" entity="e018"/>
    <symbolinfo name="dishwasher_gen" entity="e832"/>
    <symbolinfo name="display_external_input" entity="f7e7"/>
    <symbolinfo name="display_settings" entity="eb97"/>
    <symbolinfo name="distance" entity="f6ea"/>
    <symbolinfo name="diversity_1" entity="f8d7"/>
    <symbolinfo name="diversity_2" entity="f8d8"/>
    <symbolinfo name="diversity_3" entity="f8d9"/>
    <symbolinfo name="diversity_4" entity="f857"/>
    <symbolinfo name="dns" entity="e875"/>
    <symbolinfo name="do_disturb" entity="f08c"/>
    <symbolinfo name="do_disturb_alt" entity="f08d"/>
    <symbolinfo name="do_disturb_off" entity="f08e"/>
    <symbolinfo name="do_disturb_on" entity="f08f"/>
    <symbolinfo name="do_not_disturb" entity="f08d"/>
    <symbolinfo name="do_not_disturb_alt" entity="f08c"/>
    <symbolinfo name="do_not_disturb_off" entity="f08e"/>
    <symbolinfo name="do_not_disturb_on" entity="f08f"/>
    <symbolinfo name="do_not_disturb_on_total_silence" entity="effb"/>
    <symbolinfo name="do_not_step" entity="f19f"/>
    <symbolinfo name="do_not_touch" entity="f1b0"/>
    <symbolinfo name="dock" entity="e30e"/>
    <symbolinfo name="dock_to_bottom" entity="f7e6"/>
    <symbolinfo name="dock_to_left" entity="f7e5"/>
    <symbolinfo name="dock_to_right" entity="f7e4"/>
    <symbolinfo name="docs_add_on" entity="f0c2"/>
    <symbolinfo name="docs_apps_script" entity="f0c3"/>
    <symbolinfo name="document_scanner" entity="e5fa"/>
    <symbolinfo name="domain" entity="e7ee"/>
    <symbolinfo name="domain_add" entity="eb62"/>
    <symbolinfo name="domain_disabled" entity="e0ef"/>
    <symbolinfo name="domain_verification" entity="ef4c"/>
    <symbolinfo name="domain_verification_off" entity="f7b0"/>
    <symbolinfo name="domino_mask" entity="f5e4"/>
    <symbolinfo name="done" entity="e876"/>
    <symbolinfo name="done_all" entity="e877"/>
    <symbolinfo name="done_outline" entity="e92f"/>
    <symbolinfo name="donut_large" entity="e917"/>
    <symbolinfo name="donut_small" entity="e918"/>
    <symbolinfo name="door_back" entity="effc"/>
    <symbolinfo name="door_front" entity="effd"/>
    <symbolinfo name="door_open" entity="e77c"/>
    <symbolinfo name="door_sensor" entity="e28a"/>
    <symbolinfo name="door_sliding" entity="effe"/>
    <symbolinfo name="doorbell" entity="efff"/>
    <symbolinfo name="doorbell_3p" entity="e1e7"/>
    <symbolinfo name="doorbell_chime" entity="e1f3"/>
    <symbolinfo name="double_arrow" entity="ea50"/>
    <symbolinfo name="downhill_skiing" entity="e509"/>
    <symbolinfo name="download" entity="f090"/>
    <symbolinfo name="download_done" entity="f091"/>
    <symbolinfo name="download_for_offline" entity="f000"/>
    <symbolinfo name="downloading" entity="f001"/>
    <symbolinfo name="draft" entity="e66d"/>
    <symbolinfo name="draft_orders" entity="e7b3"/>
    <symbolinfo name="drafts" entity="e151"/>
    <symbolinfo name="drag_click" entity="f71f"/>
    <symbolinfo name="drag_handle" entity="e25d"/>
    <symbolinfo name="drag_indicator" entity="e945"/>
    <symbolinfo name="drag_pan" entity="f71e"/>
    <symbolinfo name="draw" entity="e746"/>
    <symbolinfo name="draw_abstract" entity="f7f8"/>
    <symbolinfo name="draw_collage" entity="f7f7"/>
    <symbolinfo name="dresser" entity="e210"/>
    <symbolinfo name="drive_eta" entity="eff7"/>
    <symbolinfo name="drive_file_move" entity="e9a1"/>
    <symbolinfo name="drive_file_move_outline" entity="e9a1"/>
    <symbolinfo name="drive_file_move_rtl" entity="e9a1"/>
    <symbolinfo name="drive_file_rename_outline" entity="e9a2"/>
    <symbolinfo name="drive_folder_upload" entity="e9a3"/>
    <symbolinfo name="drive_fusiontable" entity="e678"/>
    <symbolinfo name="dropdown" entity="e9a4"/>
    <symbolinfo name="dry" entity="f1b3"/>
    <symbolinfo name="dry_cleaning" entity="ea58"/>
    <symbolinfo name="dual_screen" entity="f6cf"/>
    <symbolinfo name="duo" entity="e9a5"/>
    <symbolinfo name="dvr" entity="e1b2"/>
    <symbolinfo name="dynamic_feed" entity="ea14"/>
    <symbolinfo name="dynamic_form" entity="f1bf"/>
    <symbolinfo name="e911_avatar" entity="f11a"/>
    <symbolinfo name="e911_emergency" entity="f119"/>
    <symbolinfo name="e_mobiledata" entity="f002"/>
    <symbolinfo name="e_mobiledata_badge" entity="f7e3"/>
    <symbolinfo name="earbuds" entity="f003"/>
    <symbolinfo name="earbuds_battery" entity="f004"/>
    <symbolinfo name="early_on" entity="e2ba"/>
    <symbolinfo name="earthquake" entity="f64f"/>
    <symbolinfo name="east" entity="f1df"/>
    <symbolinfo name="ecg" entity="f80f"/>
    <symbolinfo name="ecg_heart" entity="f6e9"/>
    <symbolinfo name="eco" entity="ea35"/>
    <symbolinfo name="eda" entity="f6e8"/>
    <symbolinfo name="edgesensor_high" entity="f005"/>
    <symbolinfo name="edgesensor_low" entity="f006"/>
    <symbolinfo name="edit" entity="f097"/>
    <symbolinfo name="edit_attributes" entity="e578"/>
    <symbolinfo name="edit_calendar" entity="e742"/>
    <symbolinfo name="edit_document" entity="f88c"/>
    <symbolinfo name="edit_location" entity="e568"/>
    <symbolinfo name="edit_location_alt" entity="e1c5"/>
    <symbolinfo name="edit_note" entity="e745"/>
    <symbolinfo name="edit_notifications" entity="e525"/>
    <symbolinfo name="edit_off" entity="e950"/>
    <symbolinfo name="edit_road" entity="ef4d"/>
    <symbolinfo name="edit_square" entity="f88d"/>
    <symbolinfo name="egg" entity="eacc"/>
    <symbolinfo name="egg_alt" entity="eac8"/>
    <symbolinfo name="eject" entity="e8fb"/>
    <symbolinfo name="elderly" entity="f21a"/>
    <symbolinfo name="elderly_woman" entity="eb69"/>
    <symbolinfo name="electric_bike" entity="eb1b"/>
    <symbolinfo name="electric_bolt" entity="ec1c"/>
    <symbolinfo name="electric_car" entity="eb1c"/>
    <symbolinfo name="electric_meter" entity="ec1b"/>
    <symbolinfo name="electric_moped" entity="eb1d"/>
    <symbolinfo name="electric_rickshaw" entity="eb1e"/>
    <symbolinfo name="electric_scooter" entity="eb1f"/>
    <symbolinfo name="electrical_services" entity="f102"/>
    <symbolinfo name="elevation" entity="f6e7"/>
    <symbolinfo name="elevator" entity="f1a0"/>
    <symbolinfo name="email" entity="e159"/>
    <symbolinfo name="emergency" entity="e1eb"/>
    <symbolinfo name="emergency_heat" entity="f15d"/>
    <symbolinfo name="emergency_home" entity="e82a"/>
    <symbolinfo name="emergency_recording" entity="ebf4"/>
    <symbolinfo name="emergency_share" entity="ebf6"/>
    <symbolinfo name="emergency_share_off" entity="f59e"/>
    <symbolinfo name="emoji_emotions" entity="ea22"/>
    <symbolinfo name="emoji_events" entity="ea23"/>
    <symbolinfo name="emoji_flags" entity="f0c6"/>
    <symbolinfo name="emoji_food_beverage" entity="ea1b"/>
    <symbolinfo name="emoji_nature" entity="ea1c"/>
    <symbolinfo name="emoji_objects" entity="ea24"/>
    <symbolinfo name="emoji_people" entity="ea1d"/>
    <symbolinfo name="emoji_symbols" entity="ea1e"/>
    <symbolinfo name="emoji_transportation" entity="ea1f"/>
    <symbolinfo name="emoticon" entity="e5f3"/>
    <symbolinfo name="empty_dashboard" entity="f844"/>
    <symbolinfo name="enable" entity="f188"/>
    <symbolinfo name="encrypted" entity="e593"/>
    <symbolinfo name="endocrinology" entity="e0a9"/>
    <symbolinfo name="energy_program_saving" entity="f15f"/>
    <symbolinfo name="energy_program_time_used" entity="f161"/>
    <symbolinfo name="energy_savings_leaf" entity="ec1a"/>
    <symbolinfo name="engineering" entity="ea3d"/>
    <symbolinfo name="enhanced_encryption" entity="e63f"/>
    <symbolinfo name="ent" entity="e0aa"/>
    <symbolinfo name="equal" entity="f77b"/>
    <symbolinfo name="equalizer" entity="e01d"/>
    <symbolinfo name="error" entity="f8b6"/>
    <symbolinfo name="error_circle_rounded" entity="f8b6"/>
    <symbolinfo name="error_med" entity="e49b"/>
    <symbolinfo name="error_outline" entity="f8b6"/>
    <symbolinfo name="escalator" entity="f1a1"/>
    <symbolinfo name="escalator_warning" entity="f1ac"/>
    <symbolinfo name="euro" entity="ea15"/>
    <symbolinfo name="euro_symbol" entity="e926"/>
    <symbolinfo name="ev_charger" entity="e56d"/>
    <symbolinfo name="ev_mobiledata_badge" entity="f7e2"/>
    <symbolinfo name="ev_shadow" entity="ef8f"/>
    <symbolinfo name="ev_shadow_add" entity="f580"/>
    <symbolinfo name="ev_shadow_minus" entity="f57f"/>
    <symbolinfo name="ev_station" entity="e56d"/>
    <symbolinfo name="event" entity="e878"/>
    <symbolinfo name="event_available" entity="e614"/>
    <symbolinfo name="event_busy" entity="e615"/>
    <symbolinfo name="event_list" entity="f683"/>
    <symbolinfo name="event_note" entity="e616"/>
    <symbolinfo name="event_repeat" entity="eb7b"/>
    <symbolinfo name="event_seat" entity="e903"/>
    <symbolinfo name="event_upcoming" entity="f238"/>
    <symbolinfo name="exclamation" entity="f22f"/>
    <symbolinfo name="exercise" entity="f6e6"/>
    <symbolinfo name="exit_to_app" entity="e879"/>
    <symbolinfo name="expand" entity="e94f"/>
    <symbolinfo name="expand_all" entity="e946"/>
    <symbolinfo name="expand_circle_down" entity="e7cd"/>
    <symbolinfo name="expand_circle_right" entity="f591"/>
    <symbolinfo name="expand_circle_up" entity="f5d2"/>
    <symbolinfo name="expand_content" entity="f830"/>
    <symbolinfo name="expand_less" entity="e5ce"/>
    <symbolinfo name="expand_more" entity="e5cf"/>
    <symbolinfo name="explicit" entity="e01e"/>
    <symbolinfo name="explore" entity="e87a"/>
    <symbolinfo name="explore_off" entity="e9a8"/>
    <symbolinfo name="explosion" entity="f685"/>
    <symbolinfo name="export_notes" entity="e0ac"/>
    <symbolinfo name="exposure" entity="e3f6"/>
    <symbolinfo name="exposure_neg_1" entity="e3cb"/>
    <symbolinfo name="exposure_neg_2" entity="e3cc"/>
    <symbolinfo name="exposure_plus_1" entity="e800"/>
    <symbolinfo name="exposure_plus_2" entity="e3ce"/>
    <symbolinfo name="exposure_zero" entity="e3cf"/>
    <symbolinfo name="extension" entity="e87b"/>
    <symbolinfo name="extension_off" entity="e4f5"/>
    <symbolinfo name="eyeglasses" entity="f6ee"/>
    <symbolinfo name="face" entity="f008"/>
    <symbolinfo name="face_2" entity="f8da"/>
    <symbolinfo name="face_3" entity="f8db"/>
    <symbolinfo name="face_4" entity="f8dc"/>
    <symbolinfo name="face_5" entity="f8dd"/>
    <symbolinfo name="face_6" entity="f8de"/>
    <symbolinfo name="face_retouching_natural" entity="ef4e"/>
    <symbolinfo name="face_retouching_off" entity="f007"/>
    <symbolinfo name="face_unlock" entity="f008"/>
    <symbolinfo name="fact_check" entity="f0c5"/>
    <symbolinfo name="factory" entity="ebbc"/>
    <symbolinfo name="falling" entity="f60d"/>
    <symbolinfo name="familiar_face_and_zone" entity="e21c"/>
    <symbolinfo name="family_history" entity="e0ad"/>
    <symbolinfo name="family_link" entity="eb19"/>
    <symbolinfo name="family_restroom" entity="f1a2"/>
    <symbolinfo name="farsight_digital" entity="f559"/>
    <symbolinfo name="fast_forward" entity="e01f"/>
    <symbolinfo name="fast_rewind" entity="e020"/>
    <symbolinfo name="fastfood" entity="e57a"/>
    <symbolinfo name="faucet" entity="e278"/>
    <symbolinfo name="favorite" entity="e87e"/>
    <symbolinfo name="favorite_border" entity="e87e"/>
    <symbolinfo name="fax" entity="ead8"/>
    <symbolinfo name="feature_search" entity="e9a9"/>
    <symbolinfo name="featured_play_list" entity="e06d"/>
    <symbolinfo name="featured_video" entity="e06e"/>
    <symbolinfo name="feed" entity="f009"/>
    <symbolinfo name="feedback" entity="e87f"/>
    <symbolinfo name="female" entity="e590"/>
    <symbolinfo name="femur" entity="f891"/>
    <symbolinfo name="femur_alt" entity="f892"/>
    <symbolinfo name="fence" entity="f1f6"/>
    <symbolinfo name="fertile" entity="f6e5"/>
    <symbolinfo name="festival" entity="ea68"/>
    <symbolinfo name="fiber_dvr" entity="e05d"/>
    <symbolinfo name="fiber_manual_record" entity="e061"/>
    <symbolinfo name="fiber_new" entity="e05e"/>
    <symbolinfo name="fiber_pin" entity="e06a"/>
    <symbolinfo name="fiber_smart_record" entity="e062"/>
    <symbolinfo name="file_copy" entity="e173"/>
    <symbolinfo name="file_download" entity="f090"/>
    <symbolinfo name="file_download_done" entity="f091"/>
    <symbolinfo name="file_download_off" entity="e4fe"/>
    <symbolinfo name="file_open" entity="eaf3"/>
    <symbolinfo name="file_present" entity="ea0e"/>
    <symbolinfo name="file_upload" entity="f09b"/>
    <symbolinfo name="file_upload_off" entity="f886"/>
    <symbolinfo name="filter" entity="e3d3"/>
    <symbolinfo name="filter_1" entity="e3d0"/>
    <symbolinfo name="filter_2" entity="e3d1"/>
    <symbolinfo name="filter_3" entity="e3d2"/>
    <symbolinfo name="filter_4" entity="e3d4"/>
    <symbolinfo name="filter_5" entity="e3d5"/>
    <symbolinfo name="filter_6" entity="e3d6"/>
    <symbolinfo name="filter_7" entity="e3d7"/>
    <symbolinfo name="filter_8" entity="e3d8"/>
    <symbolinfo name="filter_9" entity="e3d9"/>
    <symbolinfo name="filter_9_plus" entity="e3da"/>
    <symbolinfo name="filter_alt" entity="ef4f"/>
    <symbolinfo name="filter_alt_off" entity="eb32"/>
    <symbolinfo name="filter_b_and_w" entity="e3db"/>
    <symbolinfo name="filter_center_focus" entity="e3dc"/>
    <symbolinfo name="filter_drama" entity="e3dd"/>
    <symbolinfo name="filter_frames" entity="e3de"/>
    <symbolinfo name="filter_hdr" entity="e3df"/>
    <symbolinfo name="filter_list" entity="e152"/>
    <symbolinfo name="filter_list_alt" entity="e94e"/>
    <symbolinfo name="filter_list_off" entity="eb57"/>
    <symbolinfo name="filter_none" entity="e3e0"/>
    <symbolinfo name="filter_tilt_shift" entity="e3e2"/>
    <symbolinfo name="filter_vintage" entity="e3e3"/>
    <symbolinfo name="finance" entity="e6bf"/>
    <symbolinfo name="finance_chip" entity="f84e"/>
    <symbolinfo name="find_in_page" entity="e880"/>
    <symbolinfo name="find_replace" entity="e881"/>
    <symbolinfo name="fingerprint" entity="e90d"/>
    <symbolinfo name="fire_extinguisher" entity="f1d8"/>
    <symbolinfo name="fire_hydrant" entity="f1a3"/>
    <symbolinfo name="fire_truck" entity="f8f2"/>
    <symbolinfo name="fireplace" entity="ea43"/>
    <symbolinfo name="first_page" entity="e5dc"/>
    <symbolinfo name="fit_page" entity="f77a"/>
    <symbolinfo name="fit_screen" entity="ea10"/>
    <symbolinfo name="fit_width" entity="f779"/>
    <symbolinfo name="fitness_center" entity="eb43"/>
    <symbolinfo name="flag" entity="f0c6"/>
    <symbolinfo name="flag_circle" entity="eaf8"/>
    <symbolinfo name="flag_filled" entity="f0c6"/>
    <symbolinfo name="flaky" entity="ef50"/>
    <symbolinfo name="flare" entity="e3e4"/>
    <symbolinfo name="flash_auto" entity="e3e5"/>
    <symbolinfo name="flash_off" entity="e3e6"/>
    <symbolinfo name="flash_on" entity="e3e7"/>
    <symbolinfo name="flashlight_off" entity="f00a"/>
    <symbolinfo name="flashlight_on" entity="f00b"/>
    <symbolinfo name="flatware" entity="f00c"/>
    <symbolinfo name="flex_direction" entity="f778"/>
    <symbolinfo name="flex_no_wrap" entity="f777"/>
    <symbolinfo name="flex_wrap" entity="f776"/>
    <symbolinfo name="flight" entity="e539"/>
    <symbolinfo name="flight_class" entity="e7cb"/>
    <symbolinfo name="flight_land" entity="e904"/>
    <symbolinfo name="flight_takeoff" entity="e905"/>
    <symbolinfo name="flightsmode" entity="ef93"/>
    <symbolinfo name="flip" entity="e3e8"/>
    <symbolinfo name="flip_camera_android" entity="ea37"/>
    <symbolinfo name="flip_camera_ios" entity="ea38"/>
    <symbolinfo name="flip_to_back" entity="e882"/>
    <symbolinfo name="flip_to_front" entity="e883"/>
    <symbolinfo name="flood" entity="ebe6"/>
    <symbolinfo name="floor" entity="f6e4"/>
    <symbolinfo name="floor_lamp" entity="e21e"/>
    <symbolinfo name="flourescent" entity="f07d"/>
    <symbolinfo name="flowsheet" entity="e0ae"/>
    <symbolinfo name="fluid" entity="e483"/>
    <symbolinfo name="fluid_balance" entity="f80d"/>
    <symbolinfo name="fluid_med" entity="f80c"/>
    <symbolinfo name="fluorescent" entity="f07d"/>
    <symbolinfo name="flutter" entity="f1dd"/>
    <symbolinfo name="flutter_dash" entity="e00b"/>
    <symbolinfo name="fmd_bad" entity="f00e"/>
    <symbolinfo name="fmd_good" entity="f1db"/>
    <symbolinfo name="foggy" entity="e818"/>
    <symbolinfo name="folded_hands" entity="f5ed"/>
    <symbolinfo name="folder" entity="e2c7"/>
    <symbolinfo name="folder_copy" entity="ebbd"/>
    <symbolinfo name="folder_data" entity="f586"/>
    <symbolinfo name="folder_delete" entity="eb34"/>
    <symbolinfo name="folder_managed" entity="f775"/>
    <symbolinfo name="folder_off" entity="eb83"/>
    <symbolinfo name="folder_open" entity="e2c8"/>
    <symbolinfo name="folder_shared" entity="e2c9"/>
    <symbolinfo name="folder_special" entity="e617"/>
    <symbolinfo name="folder_supervised" entity="f774"/>
    <symbolinfo name="folder_zip" entity="eb2c"/>
    <symbolinfo name="follow_the_signs" entity="f222"/>
    <symbolinfo name="font_download" entity="e167"/>
    <symbolinfo name="font_download_off" entity="e4f9"/>
    <symbolinfo name="food_bank" entity="f1f2"/>
    <symbolinfo name="foot_bones" entity="f893"/>
    <symbolinfo name="footprint" entity="f87d"/>
    <symbolinfo name="forest" entity="ea99"/>
    <symbolinfo name="fork_left" entity="eba0"/>
    <symbolinfo name="fork_right" entity="ebac"/>
    <symbolinfo name="forklift" entity="f868"/>
    <symbolinfo name="format_align_center" entity="e234"/>
    <symbolinfo name="format_align_justify" entity="e235"/>
    <symbolinfo name="format_align_left" entity="e236"/>
    <symbolinfo name="format_align_right" entity="e237"/>
    <symbolinfo name="format_bold" entity="e238"/>
    <symbolinfo name="format_clear" entity="e239"/>
    <symbolinfo name="format_color_fill" entity="e23a"/>
    <symbolinfo name="format_color_reset" entity="e23b"/>
    <symbolinfo name="format_color_text" entity="e23c"/>
    <symbolinfo name="format_h1" entity="f85d"/>
    <symbolinfo name="format_h2" entity="f85e"/>
    <symbolinfo name="format_h3" entity="f85f"/>
    <symbolinfo name="format_h4" entity="f860"/>
    <symbolinfo name="format_h5" entity="f861"/>
    <symbolinfo name="format_h6" entity="f862"/>
    <symbolinfo name="format_image_left" entity="f863"/>
    <symbolinfo name="format_image_right" entity="f864"/>
    <symbolinfo name="format_indent_decrease" entity="e23d"/>
    <symbolinfo name="format_indent_increase" entity="e23e"/>
    <symbolinfo name="format_ink_highlighter" entity="f82b"/>
    <symbolinfo name="format_italic" entity="e23f"/>
    <symbolinfo name="format_letter_spacing" entity="f773"/>
    <symbolinfo name="format_letter_spacing_2" entity="f618"/>
    <symbolinfo name="format_letter_spacing_standard" entity="f617"/>
    <symbolinfo name="format_letter_spacing_wide" entity="f616"/>
    <symbolinfo name="format_letter_spacing_wider" entity="f615"/>
    <symbolinfo name="format_line_spacing" entity="e240"/>
    <symbolinfo name="format_list_bulleted" entity="e241"/>
    <symbolinfo name="format_list_bulleted_add" entity="f849"/>
    <symbolinfo name="format_list_numbered" entity="e242"/>
    <symbolinfo name="format_list_numbered_rtl" entity="e267"/>
    <symbolinfo name="format_overline" entity="eb65"/>
    <symbolinfo name="format_paint" entity="e243"/>
    <symbolinfo name="format_paragraph" entity="f865"/>
    <symbolinfo name="format_quote" entity="e244"/>
    <symbolinfo name="format_shapes" entity="e25e"/>
    <symbolinfo name="format_size" entity="e245"/>
    <symbolinfo name="format_strikethrough" entity="e246"/>
    <symbolinfo name="format_text_clip" entity="f82a"/>
    <symbolinfo name="format_text_overflow" entity="f829"/>
    <symbolinfo name="format_text_wrap" entity="f828"/>
    <symbolinfo name="format_textdirection_l_to_r" entity="e247"/>
    <symbolinfo name="format_textdirection_r_to_l" entity="e248"/>
    <symbolinfo name="format_underlined" entity="e249"/>
    <symbolinfo name="format_underlined_squiggle" entity="f885"/>
    <symbolinfo name="forms_add_on" entity="f0c7"/>
    <symbolinfo name="forms_apps_script" entity="f0c8"/>
    <symbolinfo name="fort" entity="eaad"/>
    <symbolinfo name="forum" entity="e8af"/>
    <symbolinfo name="forward" entity="f57a"/>
    <symbolinfo name="forward_10" entity="e056"/>
    <symbolinfo name="forward_30" entity="e057"/>
    <symbolinfo name="forward_5" entity="e058"/>
    <symbolinfo name="forward_circle" entity="f6f5"/>
    <symbolinfo name="forward_media" entity="f6f4"/>
    <symbolinfo name="forward_to_inbox" entity="f187"/>
    <symbolinfo name="foundation" entity="f200"/>
    <symbolinfo name="frame_inspect" entity="f772"/>
    <symbolinfo name="frame_person" entity="f8a6"/>
    <symbolinfo name="frame_person_off" entity="f7d1"/>
    <symbolinfo name="frame_reload" entity="f771"/>
    <symbolinfo name="frame_source" entity="f770"/>
    <symbolinfo name="free_breakfast" entity="eb44"/>
    <symbolinfo name="free_cancellation" entity="e748"/>
    <symbolinfo name="front_hand" entity="e769"/>
    <symbolinfo name="front_loader" entity="f869"/>
    <symbolinfo name="full_coverage" entity="eb12"/>
    <symbolinfo name="full_hd" entity="f58b"/>
    <symbolinfo name="full_stacked_bar_chart" entity="f212"/>
    <symbolinfo name="fullscreen" entity="e5d0"/>
    <symbolinfo name="fullscreen_exit" entity="e5d1"/>
    <symbolinfo name="function" entity="f866"/>
    <symbolinfo name="functions" entity="e24a"/>
    <symbolinfo name="g_mobiledata" entity="f010"/>
    <symbolinfo name="g_mobiledata_badge" entity="f7e1"/>
    <symbolinfo name="g_translate" entity="e927"/>
    <symbolinfo name="gallery_thumbnail" entity="f86f"/>
    <symbolinfo name="gamepad" entity="e30f"/>
    <symbolinfo name="games" entity="e30f"/>
    <symbolinfo name="garage" entity="f011"/>
    <symbolinfo name="garage_home" entity="e82d"/>
    <symbolinfo name="garden_cart" entity="f8a9"/>
    <symbolinfo name="gas_meter" entity="ec19"/>
    <symbolinfo name="gastroenterology" entity="e0f1"/>
    <symbolinfo name="gate" entity="e277"/>
    <symbolinfo name="gavel" entity="e90e"/>
    <symbolinfo name="generating_tokens" entity="e749"/>
    <symbolinfo name="genetics" entity="e0f3"/>
    <symbolinfo name="genres" entity="e6ee"/>
    <symbolinfo name="gesture" entity="e155"/>
    <symbolinfo name="gesture_select" entity="f657"/>
    <symbolinfo name="get_app" entity="f090"/>
    <symbolinfo name="gif" entity="e908"/>
    <symbolinfo name="gif_box" entity="e7a3"/>
    <symbolinfo name="girl" entity="eb68"/>
    <symbolinfo name="gite" entity="e58b"/>
    <symbolinfo name="glass_cup" entity="f6e3"/>
    <symbolinfo name="globe" entity="e64c"/>
    <symbolinfo name="globe_asia" entity="f799"/>
    <symbolinfo name="globe_uk" entity="f798"/>
    <symbolinfo name="glucose" entity="e4a0"/>
    <symbolinfo name="glyphs" entity="f8a3"/>
    <symbolinfo name="go_to_line" entity="f71d"/>
    <symbolinfo name="golf_course" entity="eb45"/>
    <symbolinfo name="google_plus_reshare" entity="f57a"/>
    <symbolinfo name="google_tv_remote" entity="f5db"/>
    <symbolinfo name="google_wifi" entity="f579"/>
    <symbolinfo name="gpp_bad" entity="f012"/>
    <symbolinfo name="gpp_good" entity="f013"/>
    <symbolinfo name="gpp_maybe" entity="f014"/>
    <symbolinfo name="gps_fixed" entity="e55c"/>
    <symbolinfo name="gps_not_fixed" entity="e1b7"/>
    <symbolinfo name="gps_off" entity="e1b6"/>
    <symbolinfo name="grade" entity="e885"/>
    <symbolinfo name="gradient" entity="e3e9"/>
    <symbolinfo name="grading" entity="ea4f"/>
    <symbolinfo name="grain" entity="e3ea"/>
    <symbolinfo name="graphic_eq" entity="e1b8"/>
    <symbolinfo name="grass" entity="f205"/>
    <symbolinfo name="grid_3x3" entity="f015"/>
    <symbolinfo name="grid_3x3_off" entity="f67c"/>
    <symbolinfo name="grid_4x4" entity="f016"/>
    <symbolinfo name="grid_goldenratio" entity="f017"/>
    <symbolinfo name="grid_guides" entity="f76f"/>
    <symbolinfo name="grid_off" entity="e3eb"/>
    <symbolinfo name="grid_on" entity="e3ec"/>
    <symbolinfo name="grid_view" entity="e9b0"/>
    <symbolinfo name="group" entity="ea21"/>
    <symbolinfo name="group_add" entity="e7f0"/>
    <symbolinfo name="group_auto" entity="f551"/>
    <symbolinfo name="group_off" entity="e747"/>
    <symbolinfo name="group_remove" entity="e7ad"/>
    <symbolinfo name="group_work" entity="e886"/>
    <symbolinfo name="grouped_bar_chart" entity="f211"/>
    <symbolinfo name="groups" entity="f233"/>
    <symbolinfo name="groups_2" entity="f8df"/>
    <symbolinfo name="groups_3" entity="f8e0"/>
    <symbolinfo name="gynecology" entity="e0f4"/>
    <symbolinfo name="h_mobiledata" entity="f018"/>
    <symbolinfo name="h_mobiledata_badge" entity="f7e0"/>
    <symbolinfo name="h_plus_mobiledata" entity="f019"/>
    <symbolinfo name="h_plus_mobiledata_badge" entity="f7df"/>
    <symbolinfo name="hail" entity="e9b1"/>
    <symbolinfo name="hallway" entity="e6f8"/>
    <symbolinfo name="hand_bones" entity="f894"/>
    <symbolinfo name="hand_gesture" entity="ef9c"/>
    <symbolinfo name="handshake" entity="ebcb"/>
    <symbolinfo name="handyman" entity="f10b"/>
    <symbolinfo name="hangout_video" entity="e0c1"/>
    <symbolinfo name="hangout_video_off" entity="e0c2"/>
    <symbolinfo name="hard_drive" entity="f80e"/>
    <symbolinfo name="hard_drive_2" entity="f7a4"/>
    <symbolinfo name="hardware" entity="ea59"/>
    <symbolinfo name="hd" entity="e052"/>
    <symbolinfo name="hdr_auto" entity="f01a"/>
    <symbolinfo name="hdr_auto_select" entity="f01b"/>
    <symbolinfo name="hdr_enhanced_select" entity="ef51"/>
    <symbolinfo name="hdr_off" entity="e3ed"/>
    <symbolinfo name="hdr_off_select" entity="f01c"/>
    <symbolinfo name="hdr_on" entity="e3ee"/>
    <symbolinfo name="hdr_on_select" entity="f01d"/>
    <symbolinfo name="hdr_plus" entity="f01e"/>
    <symbolinfo name="hdr_strong" entity="e3f1"/>
    <symbolinfo name="hdr_weak" entity="e3f2"/>
    <symbolinfo name="headphones" entity="f01f"/>
    <symbolinfo name="headphones_battery" entity="f020"/>
    <symbolinfo name="headset" entity="f01f"/>
    <symbolinfo name="headset_mic" entity="e311"/>
    <symbolinfo name="headset_off" entity="e33a"/>
    <symbolinfo name="healing" entity="e3f3"/>
    <symbolinfo name="health_and_safety" entity="e1d5"/>
    <symbolinfo name="health_metrics" entity="f6e2"/>
    <symbolinfo name="heap_snapshot_large" entity="f76e"/>
    <symbolinfo name="heap_snapshot_multiple" entity="f76d"/>
    <symbolinfo name="heap_snapshot_thumbnail" entity="f76c"/>
    <symbolinfo name="hearing" entity="e023"/>
    <symbolinfo name="hearing_disabled" entity="f104"/>
    <symbolinfo name="heart_broken" entity="eac2"/>
    <symbolinfo name="heart_check" entity="f60a"/>
    <symbolinfo name="heart_minus" entity="f883"/>
    <symbolinfo name="heart_plus" entity="f884"/>
    <symbolinfo name="heat_pump" entity="ec18"/>
    <symbolinfo name="heat_pump_balance" entity="e27e"/>
    <symbolinfo name="height" entity="ea16"/>
    <symbolinfo name="helicopter" entity="f60c"/>
    <symbolinfo name="help" entity="e8fd"/>
    <symbolinfo name="help_center" entity="f1c0"/>
    <symbolinfo name="help_clinic" entity="f810"/>
    <symbolinfo name="help_outline" entity="e8fd"/>
    <symbolinfo name="hematology" entity="e0f6"/>
    <symbolinfo name="hevc" entity="f021"/>
    <symbolinfo name="hexagon" entity="eb39"/>
    <symbolinfo name="hide" entity="ef9e"/>
    <symbolinfo name="hide_image" entity="f022"/>
    <symbolinfo name="hide_source" entity="f023"/>
    <symbolinfo name="high_density" entity="f79c"/>
    <symbolinfo name="high_quality" entity="e024"/>
    <symbolinfo name="high_res" entity="f54b"/>
    <symbolinfo name="highlight" entity="e25f"/>
    <symbolinfo name="highlight_off" entity="e888"/>
    <symbolinfo name="highlighter_size_1" entity="f76b"/>
    <symbolinfo name="highlighter_size_2" entity="f76a"/>
    <symbolinfo name="highlighter_size_3" entity="f769"/>
    <symbolinfo name="highlighter_size_4" entity="f768"/>
    <symbolinfo name="highlighter_size_5" entity="f767"/>
    <symbolinfo name="hiking" entity="e50a"/>
    <symbolinfo name="history" entity="e8b3"/>
    <symbolinfo name="history_edu" entity="ea3e"/>
    <symbolinfo name="history_toggle_off" entity="f17d"/>
    <symbolinfo name="hive" entity="eaa6"/>
    <symbolinfo name="hls" entity="eb8a"/>
    <symbolinfo name="hls_off" entity="eb8c"/>
    <symbolinfo name="holiday_village" entity="e58a"/>
    <symbolinfo name="home" entity="e9b2"/>
    <symbolinfo name="home_app_logo" entity="e295"/>
    <symbolinfo name="home_filled" entity="e9b2"/>
    <symbolinfo name="home_health" entity="e4b9"/>
    <symbolinfo name="home_iot_device" entity="e283"/>
    <symbolinfo name="home_max" entity="f024"/>
    <symbolinfo name="home_max_dots" entity="e849"/>
    <symbolinfo name="home_mini" entity="f025"/>
    <symbolinfo name="home_pin" entity="f14d"/>
    <symbolinfo name="home_repair_service" entity="f100"/>
    <symbolinfo name="home_speaker" entity="f11c"/>
    <symbolinfo name="home_storage" entity="f86c"/>
    <symbolinfo name="home_work" entity="f030"/>
    <symbolinfo name="horizontal_distribute" entity="e014"/>
    <symbolinfo name="horizontal_rule" entity="f108"/>
    <symbolinfo name="horizontal_split" entity="e947"/>
    <symbolinfo name="hot_tub" entity="eb46"/>
    <symbolinfo name="hotel" entity="e549"/>
    <symbolinfo name="hotel_class" entity="e743"/>
    <symbolinfo name="hourglass" entity="ebff"/>
    <symbolinfo name="hourglass_bottom" entity="ea5c"/>
    <symbolinfo name="hourglass_disabled" entity="ef53"/>
    <symbolinfo name="hourglass_empty" entity="e88b"/>
    <symbolinfo name="hourglass_full" entity="e88c"/>
    <symbolinfo name="hourglass_top" entity="ea5b"/>
    <symbolinfo name="house" entity="ea44"/>
    <symbolinfo name="house_siding" entity="f202"/>
    <symbolinfo name="house_with_shield" entity="e786"/>
    <symbolinfo name="houseboat" entity="e584"/>
    <symbolinfo name="how_to_reg" entity="e174"/>
    <symbolinfo name="how_to_vote" entity="e175"/>
    <symbolinfo name="hr_resting" entity="f6ba"/>
    <symbolinfo name="html" entity="eb7e"/>
    <symbolinfo name="http" entity="e902"/>
    <symbolinfo name="https" entity="e899"/>
    <symbolinfo name="hub" entity="e9f4"/>
    <symbolinfo name="humerus" entity="f895"/>
    <symbolinfo name="humerus_alt" entity="f896"/>
    <symbolinfo name="humidity_helper" entity="f55f"/>
    <symbolinfo name="humidity_high" entity="f163"/>
    <symbolinfo name="humidity_indoor" entity="f558"/>
    <symbolinfo name="humidity_low" entity="f164"/>
    <symbolinfo name="humidity_mid" entity="f165"/>
    <symbolinfo name="humidity_percentage" entity="f87e"/>
    <symbolinfo name="hvac" entity="f10e"/>
    <symbolinfo name="ice_skating" entity="e50b"/>
    <symbolinfo name="icecream" entity="ea69"/>
    <symbolinfo name="ifl" entity="e025"/>
    <symbolinfo name="iframe" entity="f71b"/>
    <symbolinfo name="iframe_off" entity="f71c"/>
    <symbolinfo name="image" entity="e3f4"/>
    <symbolinfo name="image_aspect_ratio" entity="e3f5"/>
    <symbolinfo name="image_not_supported" entity="f116"/>
    <symbolinfo name="image_search" entity="e43f"/>
    <symbolinfo name="imagesearch_roller" entity="e9b4"/>
    <symbolinfo name="imagesmode" entity="efa2"/>
    <symbolinfo name="immunology" entity="e0fb"/>
    <symbolinfo name="import_contacts" entity="e0e0"/>
    <symbolinfo name="import_export" entity="e8d5"/>
    <symbolinfo name="important_devices" entity="e912"/>
    <symbolinfo name="in_home_mode" entity="e833"/>
    <symbolinfo name="inactive_order" entity="e0fc"/>
    <symbolinfo name="inbox" entity="e156"/>
    <symbolinfo name="inbox_customize" entity="f859"/>
    <symbolinfo name="incomplete_circle" entity="e79b"/>
    <symbolinfo name="indeterminate_check_box" entity="e909"/>
    <symbolinfo name="indeterminate_question_box" entity="f56d"/>
    <symbolinfo name="info" entity="e88e"/>
    <symbolinfo name="info_i" entity="f59b"/>
    <symbolinfo name="infrared" entity="f87c"/>
    <symbolinfo name="ink_eraser" entity="e6d0"/>
    <symbolinfo name="ink_eraser_off" entity="e7e3"/>
    <symbolinfo name="ink_highlighter" entity="e6d1"/>
    <symbolinfo name="ink_marker" entity="e6d2"/>
    <symbolinfo name="ink_pen" entity="e6d3"/>
    <symbolinfo name="inpatient" entity="e0fe"/>
    <symbolinfo name="input" entity="e890"/>
    <symbolinfo name="input_circle" entity="f71a"/>
    <symbolinfo name="insert_chart" entity="f0cc"/>
    <symbolinfo name="insert_chart_filled" entity="f0cc"/>
    <symbolinfo name="insert_chart_outlined" entity="f0cc"/>
    <symbolinfo name="insert_comment" entity="e24c"/>
    <symbolinfo name="insert_drive_file" entity="e66d"/>
    <symbolinfo name="insert_emoticon" entity="ea22"/>
    <symbolinfo name="insert_invitation" entity="e878"/>
    <symbolinfo name="insert_link" entity="e250"/>
    <symbolinfo name="insert_page_break" entity="eaca"/>
    <symbolinfo name="insert_photo" entity="e3f4"/>
    <symbolinfo name="insert_text" entity="f827"/>
    <symbolinfo name="insights" entity="f092"/>
    <symbolinfo name="install_desktop" entity="eb71"/>
    <symbolinfo name="install_mobile" entity="eb72"/>
    <symbolinfo name="instant_mix" entity="e026"/>
    <symbolinfo name="integration_instructions" entity="ef54"/>
    <symbolinfo name="interactive_space" entity="f7ff"/>
    <symbolinfo name="interests" entity="e7c8"/>
    <symbolinfo name="interpreter_mode" entity="e83b"/>
    <symbolinfo name="inventory" entity="e179"/>
    <symbolinfo name="inventory_2" entity="e1a1"/>
    <symbolinfo name="invert_colors" entity="e891"/>
    <symbolinfo name="invert_colors_off" entity="e0c4"/>
    <symbolinfo name="ios_share" entity="e6b8"/>
    <symbolinfo name="iron" entity="e583"/>
    <symbolinfo name="iso" entity="e3f6"/>
    <symbolinfo name="jamboard_kiosk" entity="e9b5"/>
    <symbolinfo name="javascript" entity="eb7c"/>
    <symbolinfo name="join" entity="f84f"/>
    <symbolinfo name="join_full" entity="f84f"/>
    <symbolinfo name="join_inner" entity="eaf4"/>
    <symbolinfo name="join_left" entity="eaf2"/>
    <symbolinfo name="join_right" entity="eaea"/>
    <symbolinfo name="joystick" entity="f5ee"/>
    <symbolinfo name="jump_to_element" entity="f719"/>
    <symbolinfo name="kayaking" entity="e50c"/>
    <symbolinfo name="kebab_dining" entity="e842"/>
    <symbolinfo name="keep_public" entity="f56f"/>
    <symbolinfo name="kettle" entity="e2b9"/>
    <symbolinfo name="key" entity="e73c"/>
    <symbolinfo name="key_off" entity="eb84"/>
    <symbolinfo name="key_visualizer" entity="f199"/>
    <symbolinfo name="keyboard" entity="e312"/>
    <symbolinfo name="keyboard_alt" entity="f028"/>
    <symbolinfo name="keyboard_arrow_down" entity="e313"/>
    <symbolinfo name="keyboard_arrow_left" entity="e314"/>
    <symbolinfo name="keyboard_arrow_right" entity="e315"/>
    <symbolinfo name="keyboard_arrow_up" entity="e316"/>
    <symbolinfo name="keyboard_backspace" entity="e317"/>
    <symbolinfo name="keyboard_capslock" entity="e318"/>
    <symbolinfo name="keyboard_capslock_badge" entity="f7de"/>
    <symbolinfo name="keyboard_command_key" entity="eae7"/>
    <symbolinfo name="keyboard_control_key" entity="eae6"/>
    <symbolinfo name="keyboard_double_arrow_down" entity="ead0"/>
    <symbolinfo name="keyboard_double_arrow_left" entity="eac3"/>
    <symbolinfo name="keyboard_double_arrow_right" entity="eac9"/>
    <symbolinfo name="keyboard_double_arrow_up" entity="eacf"/>
    <symbolinfo name="keyboard_external_input" entity="f7dd"/>
    <symbolinfo name="keyboard_full" entity="f7dc"/>
    <symbolinfo name="keyboard_hide" entity="e31a"/>
    <symbolinfo name="keyboard_keys" entity="f67b"/>
    <symbolinfo name="keyboard_off" entity="f67a"/>
    <symbolinfo name="keyboard_onscreen" entity="f7db"/>
    <symbolinfo name="keyboard_option_key" entity="eae8"/>
    <symbolinfo name="keyboard_previous_language" entity="f7da"/>
    <symbolinfo name="keyboard_return" entity="e31b"/>
    <symbolinfo name="keyboard_tab" entity="e31c"/>
    <symbolinfo name="keyboard_tab_rtl" entity="ec73"/>
    <symbolinfo name="keyboard_voice" entity="e31d"/>
    <symbolinfo name="king_bed" entity="ea45"/>
    <symbolinfo name="kitchen" entity="eb47"/>
    <symbolinfo name="kitesurfing" entity="e50d"/>
    <symbolinfo name="lab_panel" entity="e103"/>
    <symbolinfo name="lab_profile" entity="e104"/>
    <symbolinfo name="lab_research" entity="f80b"/>
    <symbolinfo name="label" entity="e893"/>
    <symbolinfo name="label_important" entity="e948"/>
    <symbolinfo name="label_important_outline" entity="e948"/>
    <symbolinfo name="label_off" entity="e9b6"/>
    <symbolinfo name="label_outline" entity="e893"/>
    <symbolinfo name="labs" entity="e105"/>
    <symbolinfo name="lan" entity="eb2f"/>
    <symbolinfo name="landscape" entity="e564"/>
    <symbolinfo name="landslide" entity="ebd7"/>
    <symbolinfo name="language" entity="e894"/>
    <symbolinfo name="language_chinese_array" entity="f766"/>
    <symbolinfo name="language_chinese_cangjie" entity="f765"/>
    <symbolinfo name="language_chinese_dayi" entity="f764"/>
    <symbolinfo name="language_chinese_pinyin" entity="f763"/>
    <symbolinfo name="language_chinese_quick" entity="f762"/>
    <symbolinfo name="language_chinese_wubi" entity="f761"/>
    <symbolinfo name="language_french" entity="f760"/>
    <symbolinfo name="language_gb_english" entity="f75f"/>
    <symbolinfo name="language_international" entity="f75e"/>
    <symbolinfo name="language_korean_latin" entity="f75d"/>
    <symbolinfo name="language_pinyin" entity="f75c"/>
    <symbolinfo name="language_spanish" entity="f5e9"/>
    <symbolinfo name="language_us" entity="f759"/>
    <symbolinfo name="language_us_colemak" entity="f75b"/>
    <symbolinfo name="language_us_dvorak" entity="f75a"/>
    <symbolinfo name="laps" entity="f6b9"/>
    <symbolinfo name="laptop" entity="e31e"/>
    <symbolinfo name="laptop_chromebook" entity="e31f"/>
    <symbolinfo name="laptop_mac" entity="e320"/>
    <symbolinfo name="laptop_windows" entity="e321"/>
    <symbolinfo name="lasso_select" entity="eb03"/>
    <symbolinfo name="last_page" entity="e5dd"/>
    <symbolinfo name="launch" entity="e89e"/>
    <symbolinfo name="laundry" entity="e2a8"/>
    <symbolinfo name="layers" entity="e53b"/>
    <symbolinfo name="layers_clear" entity="e53c"/>
    <symbolinfo name="lda" entity="e106"/>
    <symbolinfo name="leaderboard" entity="f20c"/>
    <symbolinfo name="leaf_spark" entity="f55e"/>
    <symbolinfo name="leak_add" entity="e3f8"/>
    <symbolinfo name="leak_remove" entity="e3f9"/>
    <symbolinfo name="left_click" entity="f718"/>
    <symbolinfo name="left_panel_close" entity="f717"/>
    <symbolinfo name="left_panel_open" entity="f716"/>
    <symbolinfo name="legend_toggle" entity="f11b"/>
    <symbolinfo name="lens" entity="e3fa"/>
    <symbolinfo name="lens_blur" entity="f029"/>
    <symbolinfo name="letter_switch" entity="f758"/>
    <symbolinfo name="library_add" entity="e03c"/>
    <symbolinfo name="library_add_check" entity="e9b7"/>
    <symbolinfo name="library_books" entity="e02f"/>
    <symbolinfo name="library_music" entity="e030"/>
    <symbolinfo name="lift_to_talk" entity="efa3"/>
    <symbolinfo name="light" entity="f02a"/>
    <symbolinfo name="light_group" entity="e28b"/>
    <symbolinfo name="light_mode" entity="e518"/>
    <symbolinfo name="lightbulb" entity="e90f"/>
    <symbolinfo name="lightbulb_circle" entity="ebfe"/>
    <symbolinfo name="lightbulb_outline" entity="e90f"/>
    <symbolinfo name="line_axis" entity="ea9a"/>
    <symbolinfo name="line_curve" entity="f757"/>
    <symbolinfo name="line_end" entity="f826"/>
    <symbolinfo name="line_end_arrow" entity="f81d"/>
    <symbolinfo name="line_end_arrow_notch" entity="f81c"/>
    <symbolinfo name="line_end_circle" entity="f81b"/>
    <symbolinfo name="line_end_diamond" entity="f81a"/>
    <symbolinfo name="line_end_square" entity="f819"/>
    <symbolinfo name="line_start" entity="f825"/>
    <symbolinfo name="line_start_arrow" entity="f818"/>
    <symbolinfo name="line_start_arrow_notch" entity="f817"/>
    <symbolinfo name="line_start_circle" entity="f816"/>
    <symbolinfo name="line_start_diamond" entity="f815"/>
    <symbolinfo name="line_start_square" entity="f814"/>
    <symbolinfo name="line_style" entity="e919"/>
    <symbolinfo name="line_weight" entity="e91a"/>
    <symbolinfo name="linear_scale" entity="e260"/>
    <symbolinfo name="link" entity="e250"/>
    <symbolinfo name="link_off" entity="e16f"/>
    <symbolinfo name="linked_camera" entity="e438"/>
    <symbolinfo name="liquor" entity="ea60"/>
    <symbolinfo name="list" entity="e896"/>
    <symbolinfo name="list_alt" entity="e0ee"/>
    <symbolinfo name="list_alt_add" entity="f756"/>
    <symbolinfo name="lists" entity="e9b9"/>
    <symbolinfo name="live_help" entity="e0c6"/>
    <symbolinfo name="live_tv" entity="e63a"/>
    <symbolinfo name="living" entity="f02b"/>
    <symbolinfo name="local_activity" entity="e553"/>
    <symbolinfo name="local_airport" entity="e53d"/>
    <symbolinfo name="local_atm" entity="e53e"/>
    <symbolinfo name="local_bar" entity="e540"/>
    <symbolinfo name="local_cafe" entity="eb44"/>
    <symbolinfo name="local_car_wash" entity="e542"/>
    <symbolinfo name="local_convenience_store" entity="e543"/>
    <symbolinfo name="local_dining" entity="e561"/>
    <symbolinfo name="local_drink" entity="e544"/>
    <symbolinfo name="local_fire_department" entity="ef55"/>
    <symbolinfo name="local_florist" entity="e545"/>
    <symbolinfo name="local_gas_station" entity="e546"/>
    <symbolinfo name="local_grocery_store" entity="e8cc"/>
    <symbolinfo name="local_hospital" entity="e548"/>
    <symbolinfo name="local_hotel" entity="e549"/>
    <symbolinfo name="local_laundry_service" entity="e54a"/>
    <symbolinfo name="local_library" entity="e54b"/>
    <symbolinfo name="local_mall" entity="e54c"/>
    <symbolinfo name="local_movies" entity="e8da"/>
    <symbolinfo name="local_offer" entity="f05b"/>
    <symbolinfo name="local_parking" entity="e54f"/>
    <symbolinfo name="local_pharmacy" entity="e550"/>
    <symbolinfo name="local_phone" entity="f0d4"/>
    <symbolinfo name="local_pizza" entity="e552"/>
    <symbolinfo name="local_play" entity="e553"/>
    <symbolinfo name="local_police" entity="ef56"/>
    <symbolinfo name="local_post_office" entity="e554"/>
    <symbolinfo name="local_printshop" entity="e8ad"/>
    <symbolinfo name="local_see" entity="e557"/>
    <symbolinfo name="local_shipping" entity="e558"/>
    <symbolinfo name="local_taxi" entity="e559"/>
    <symbolinfo name="location_automation" entity="f14f"/>
    <symbolinfo name="location_away" entity="f150"/>
    <symbolinfo name="location_chip" entity="f850"/>
    <symbolinfo name="location_city" entity="e7f1"/>
    <symbolinfo name="location_disabled" entity="e1b6"/>
    <symbolinfo name="location_home" entity="f152"/>
    <symbolinfo name="location_off" entity="e0c7"/>
    <symbolinfo name="location_on" entity="f1db"/>
    <symbolinfo name="location_pin" entity="f1db"/>
    <symbolinfo name="location_searching" entity="e1b7"/>
    <symbolinfo name="locator_tag" entity="f8c1"/>
    <symbolinfo name="lock" entity="e899"/>
    <symbolinfo name="lock_clock" entity="ef57"/>
    <symbolinfo name="lock_open" entity="e898"/>
    <symbolinfo name="lock_open_right" entity="f656"/>
    <symbolinfo name="lock_outline" entity="e899"/>
    <symbolinfo name="lock_person" entity="f8f3"/>
    <symbolinfo name="lock_reset" entity="eade"/>
    <symbolinfo name="login" entity="ea77"/>
    <symbolinfo name="logo_dev" entity="ead6"/>
    <symbolinfo name="logout" entity="e9ba"/>
    <symbolinfo name="looks" entity="e3fc"/>
    <symbolinfo name="looks_3" entity="e3fb"/>
    <symbolinfo name="looks_4" entity="e3fd"/>
    <symbolinfo name="looks_5" entity="e3fe"/>
    <symbolinfo name="looks_6" entity="e3ff"/>
    <symbolinfo name="looks_one" entity="e400"/>
    <symbolinfo name="looks_two" entity="e401"/>
    <symbolinfo name="loop" entity="e863"/>
    <symbolinfo name="loupe" entity="e402"/>
    <symbolinfo name="low_density" entity="f79b"/>
    <symbolinfo name="low_priority" entity="e16d"/>
    <symbolinfo name="loyalty" entity="e89a"/>
    <symbolinfo name="lte_mobiledata" entity="f02c"/>
    <symbolinfo name="lte_mobiledata_badge" entity="f7d9"/>
    <symbolinfo name="lte_plus_mobiledata" entity="f02d"/>
    <symbolinfo name="lte_plus_mobiledata_badge" entity="f7d8"/>
    <symbolinfo name="luggage" entity="f235"/>
    <symbolinfo name="lunch_dining" entity="ea61"/>
    <symbolinfo name="lyrics" entity="ec0b"/>
    <symbolinfo name="macro_auto" entity="f6f2"/>
    <symbolinfo name="macro_off" entity="f8d2"/>
    <symbolinfo name="magic_button" entity="f136"/>
    <symbolinfo name="magic_exchange" entity="f7f4"/>
    <symbolinfo name="magic_tether" entity="f7d7"/>
    <symbolinfo name="magnification_large" entity="f83d"/>
    <symbolinfo name="magnification_small" entity="f83c"/>
    <symbolinfo name="magnify_docked" entity="f7d6"/>
    <symbolinfo name="magnify_fullscreen" entity="f7d5"/>
    <symbolinfo name="mail" entity="e159"/>
    <symbolinfo name="mail_lock" entity="ec0a"/>
    <symbolinfo name="mail_outline" entity="e159"/>
    <symbolinfo name="male" entity="e58e"/>
    <symbolinfo name="man" entity="e4eb"/>
    <symbolinfo name="man_2" entity="f8e1"/>
    <symbolinfo name="man_3" entity="f8e2"/>
    <symbolinfo name="man_4" entity="f8e3"/>
    <symbolinfo name="manage_accounts" entity="f02e"/>
    <symbolinfo name="manage_history" entity="ebe7"/>
    <symbolinfo name="manage_search" entity="f02f"/>
    <symbolinfo name="manga" entity="f5e3"/>
    <symbolinfo name="map" entity="e55b"/>
    <symbolinfo name="maps_home_work" entity="f030"/>
    <symbolinfo name="maps_ugc" entity="ef58"/>
    <symbolinfo name="margin" entity="e9bb"/>
    <symbolinfo name="mark_as_unread" entity="e9bc"/>
    <symbolinfo name="mark_chat_read" entity="f18b"/>
    <symbolinfo name="mark_chat_unread" entity="f189"/>
    <symbolinfo name="mark_email_read" entity="f18c"/>
    <symbolinfo name="mark_email_unread" entity="f18a"/>
    <symbolinfo name="mark_unread_chat_alt" entity="eb9d"/>
    <symbolinfo name="markdown" entity="f552"/>
    <symbolinfo name="markdown_copy" entity="f553"/>
    <symbolinfo name="markdown_paste" entity="f554"/>
    <symbolinfo name="markunread" entity="e159"/>
    <symbolinfo name="markunread_mailbox" entity="e89b"/>
    <symbolinfo name="masked_transitions" entity="e72e"/>
    <symbolinfo name="masks" entity="f218"/>
    <symbolinfo name="match_case" entity="f6f1"/>
    <symbolinfo name="match_word" entity="f6f0"/>
    <symbolinfo name="matter" entity="e907"/>
    <symbolinfo name="maximize" entity="e930"/>
    <symbolinfo name="measuring_tape" entity="f6af"/>
    <symbolinfo name="media_bluetooth_off" entity="f031"/>
    <symbolinfo name="media_bluetooth_on" entity="f032"/>
    <symbolinfo name="media_link" entity="f83f"/>
    <symbolinfo name="mediation" entity="efa7"/>
    <symbolinfo name="medical_information" entity="ebed"/>
    <symbolinfo name="medical_mask" entity="f80a"/>
    <symbolinfo name="medical_services" entity="f109"/>
    <symbolinfo name="medication" entity="f033"/>
    <symbolinfo name="medication_liquid" entity="ea87"/>
    <symbolinfo name="meeting_room" entity="eb4f"/>
    <symbolinfo name="memory" entity="e322"/>
    <symbolinfo name="memory_alt" entity="f7a3"/>
    <symbolinfo name="menstrual_health" entity="f6e1"/>
    <symbolinfo name="menu" entity="e5d2"/>
    <symbolinfo name="menu_book" entity="ea19"/>
    <symbolinfo name="menu_open" entity="e9bd"/>
    <symbolinfo name="merge" entity="eb98"/>
    <symbolinfo name="merge_type" entity="e252"/>
    <symbolinfo name="message" entity="e0c9"/>
    <symbolinfo name="metabolism" entity="e10b"/>
    <symbolinfo name="mfg_nest_yale_lock" entity="f11d"/>
    <symbolinfo name="mic" entity="e31d"/>
    <symbolinfo name="mic_double" entity="f5d1"/>
    <symbolinfo name="mic_external_off" entity="ef59"/>
    <symbolinfo name="mic_external_on" entity="ef5a"/>
    <symbolinfo name="mic_none" entity="e31d"/>
    <symbolinfo name="mic_off" entity="e02b"/>
    <symbolinfo name="microbiology" entity="e10c"/>
    <symbolinfo name="microwave" entity="f204"/>
    <symbolinfo name="microwave_gen" entity="e847"/>
    <symbolinfo name="military_tech" entity="ea3f"/>
    <symbolinfo name="mimo" entity="e9be"/>
    <symbolinfo name="mimo_disconnect" entity="e9bf"/>
    <symbolinfo name="mindfulness" entity="f6e0"/>
    <symbolinfo name="minimize" entity="e931"/>
    <symbolinfo name="minor_crash" entity="ebf1"/>
    <symbolinfo name="missed_video_call" entity="f0ce"/>
    <symbolinfo name="missed_video_call_filled" entity="f0ce"/>
    <symbolinfo name="mist" entity="e188"/>
    <symbolinfo name="mixture_med" entity="e4c8"/>
    <symbolinfo name="mms" entity="e618"/>
    <symbolinfo name="mobile_friendly" entity="e200"/>
    <symbolinfo name="mobile_off" entity="e201"/>
    <symbolinfo name="mobile_screen_share" entity="e0e7"/>
    <symbolinfo name="mobiledata_off" entity="f034"/>
    <symbolinfo name="mode" entity="f097"/>
    <symbolinfo name="mode_comment" entity="e253"/>
    <symbolinfo name="mode_cool" entity="f166"/>
    <symbolinfo name="mode_cool_off" entity="f167"/>
    <symbolinfo name="mode_dual" entity="f557"/>
    <symbolinfo name="mode_edit" entity="f097"/>
    <symbolinfo name="mode_edit_outline" entity="f097"/>
    <symbolinfo name="mode_fan" entity="f168"/>
    <symbolinfo name="mode_fan_off" entity="ec17"/>
    <symbolinfo name="mode_heat" entity="f16a"/>
    <symbolinfo name="mode_heat_cool" entity="f16b"/>
    <symbolinfo name="mode_heat_off" entity="f16d"/>
    <symbolinfo name="mode_night" entity="f036"/>
    <symbolinfo name="mode_of_travel" entity="e7ce"/>
    <symbolinfo name="mode_off_on" entity="f16f"/>
    <symbolinfo name="mode_standby" entity="f037"/>
    <symbolinfo name="model_training" entity="f0cf"/>
    <symbolinfo name="monetization_on" entity="e263"/>
    <symbolinfo name="money" entity="e57d"/>
    <symbolinfo name="money_off" entity="f038"/>
    <symbolinfo name="money_off_csred" entity="f038"/>
    <symbolinfo name="monitor" entity="ef5b"/>
    <symbolinfo name="monitor_heart" entity="eaa2"/>
    <symbolinfo name="monitor_weight" entity="f039"/>
    <symbolinfo name="monitor_weight_gain" entity="f6df"/>
    <symbolinfo name="monitor_weight_loss" entity="f6de"/>
    <symbolinfo name="monitoring" entity="f190"/>
    <symbolinfo name="monochrome_photos" entity="e403"/>
    <symbolinfo name="mood" entity="ea22"/>
    <symbolinfo name="mood_bad" entity="e7f3"/>
    <symbolinfo name="mop" entity="e28d"/>
    <symbolinfo name="more" entity="e619"/>
    <symbolinfo name="more_down" entity="f196"/>
    <symbolinfo name="more_horiz" entity="e5d3"/>
    <symbolinfo name="more_time" entity="ea5d"/>
    <symbolinfo name="more_up" entity="f197"/>
    <symbolinfo name="more_vert" entity="e5d4"/>
    <symbolinfo name="mosque" entity="eab2"/>
    <symbolinfo name="motion_blur" entity="f0d0"/>
    <symbolinfo name="motion_mode" entity="f842"/>
    <symbolinfo name="motion_photos_auto" entity="f03a"/>
    <symbolinfo name="motion_photos_off" entity="e9c0"/>
    <symbolinfo name="motion_photos_on" entity="e9c1"/>
    <symbolinfo name="motion_photos_pause" entity="f227"/>
    <symbolinfo name="motion_photos_paused" entity="f227"/>
    <symbolinfo name="motion_sensor_active" entity="e792"/>
    <symbolinfo name="motion_sensor_alert" entity="e784"/>
    <symbolinfo name="motion_sensor_idle" entity="e783"/>
    <symbolinfo name="motion_sensor_urgent" entity="e78e"/>
    <symbolinfo name="motorcycle" entity="e91b"/>
    <symbolinfo name="mountain_flag" entity="f5e2"/>
    <symbolinfo name="mouse" entity="e323"/>
    <symbolinfo name="move" entity="e740"/>
    <symbolinfo name="move_down" entity="eb61"/>
    <symbolinfo name="move_group" entity="f715"/>
    <symbolinfo name="move_item" entity="f1ff"/>
    <symbolinfo name="move_location" entity="e741"/>
    <symbolinfo name="move_selection_down" entity="f714"/>
    <symbolinfo name="move_selection_left" entity="f713"/>
    <symbolinfo name="move_selection_right" entity="f712"/>
    <symbolinfo name="move_selection_up" entity="f711"/>
    <symbolinfo name="move_to_inbox" entity="e168"/>
    <symbolinfo name="move_up" entity="eb64"/>
    <symbolinfo name="moved_location" entity="e594"/>
    <symbolinfo name="movie" entity="e404"/>
    <symbolinfo name="movie_creation" entity="e404"/>
    <symbolinfo name="movie_edit" entity="f840"/>
    <symbolinfo name="movie_filter" entity="e43a"/>
    <symbolinfo name="movie_info" entity="e02d"/>
    <symbolinfo name="moving" entity="e501"/>
    <symbolinfo name="moving_beds" entity="e73d"/>
    <symbolinfo name="moving_ministry" entity="e73e"/>
    <symbolinfo name="mp" entity="e9c3"/>
    <symbolinfo name="multicooker" entity="e293"/>
    <symbolinfo name="multiline_chart" entity="e6df"/>
    <symbolinfo name="multiple_stop" entity="f1b9"/>
    <symbolinfo name="museum" entity="ea36"/>
    <symbolinfo name="music_note" entity="e405"/>
    <symbolinfo name="music_off" entity="e440"/>
    <symbolinfo name="music_video" entity="e063"/>
    <symbolinfo name="my_location" entity="e55c"/>
    <symbolinfo name="mystery" entity="f5e1"/>
    <symbolinfo name="nat" entity="ef5c"/>
    <symbolinfo name="nature" entity="e406"/>
    <symbolinfo name="nature_people" entity="e407"/>
    <symbolinfo name="navigate_before" entity="e408"/>
    <symbolinfo name="navigate_next" entity="e409"/>
    <symbolinfo name="navigation" entity="e55d"/>
    <symbolinfo name="near_me" entity="e569"/>
    <symbolinfo name="near_me_disabled" entity="f1ef"/>
    <symbolinfo name="nearby" entity="e6b7"/>
    <symbolinfo name="nearby_error" entity="f03b"/>
    <symbolinfo name="nearby_off" entity="f03c"/>
    <symbolinfo name="nephrology" entity="e10d"/>
    <symbolinfo name="nest_audio" entity="ebbf"/>
    <symbolinfo name="nest_cam_floodlight" entity="f8b7"/>
    <symbolinfo name="nest_cam_indoor" entity="f11e"/>
    <symbolinfo name="nest_cam_iq" entity="f11f"/>
    <symbolinfo name="nest_cam_iq_outdoor" entity="f120"/>
    <symbolinfo name="nest_cam_magnet_mount" entity="f8b8"/>
    <symbolinfo name="nest_cam_outdoor" entity="f121"/>
    <symbolinfo name="nest_cam_stand" entity="f8b9"/>
    <symbolinfo name="nest_cam_wall_mount" entity="f8ba"/>
    <symbolinfo name="nest_cam_wired_stand" entity="ec16"/>
    <symbolinfo name="nest_clock_farsight_analog" entity="f8bb"/>
    <symbolinfo name="nest_clock_farsight_digital" entity="f8bc"/>
    <symbolinfo name="nest_connect" entity="f122"/>
    <symbolinfo name="nest_detect" entity="f123"/>
    <symbolinfo name="nest_display" entity="f124"/>
    <symbolinfo name="nest_display_max" entity="f125"/>
    <symbolinfo name="nest_doorbell_visitor" entity="f8bd"/>
    <symbolinfo name="nest_eco_leaf" entity="f8be"/>
    <symbolinfo name="nest_farsight_weather" entity="f8bf"/>
    <symbolinfo name="nest_found_savings" entity="f8c0"/>
    <symbolinfo name="nest_gale_wifi" entity="f579"/>
    <symbolinfo name="nest_heat_link_e" entity="f126"/>
    <symbolinfo name="nest_heat_link_gen_3" entity="f127"/>
    <symbolinfo name="nest_hello_doorbell" entity="e82c"/>
    <symbolinfo name="nest_locator_tag" entity="f8c1"/>
    <symbolinfo name="nest_mini" entity="e789"/>
    <symbolinfo name="nest_multi_room" entity="f8c2"/>
    <symbolinfo name="nest_protect" entity="e68e"/>
    <symbolinfo name="nest_remote" entity="f5db"/>
    <symbolinfo name="nest_remote_comfort_sensor" entity="f12a"/>
    <symbolinfo name="nest_secure_alarm" entity="f12b"/>
    <symbolinfo name="nest_sunblock" entity="f8c3"/>
    <symbolinfo name="nest_tag" entity="f8c1"/>
    <symbolinfo name="nest_thermostat" entity="e68f"/>
    <symbolinfo name="nest_thermostat_e_eu" entity="f12d"/>
    <symbolinfo name="nest_thermostat_gen_3" entity="f12e"/>
    <symbolinfo name="nest_thermostat_sensor" entity="f12f"/>
    <symbolinfo name="nest_thermostat_sensor_eu" entity="f130"/>
    <symbolinfo name="nest_thermostat_zirconium_eu" entity="f131"/>
    <symbolinfo name="nest_true_radiant" entity="f8c4"/>
    <symbolinfo name="nest_wake_on_approach" entity="f8c5"/>
    <symbolinfo name="nest_wake_on_press" entity="f8c6"/>
    <symbolinfo name="nest_wifi_gale" entity="f132"/>
    <symbolinfo name="nest_wifi_mistral" entity="f133"/>
    <symbolinfo name="nest_wifi_point" entity="f134"/>
    <symbolinfo name="nest_wifi_point_vento" entity="f134"/>
    <symbolinfo name="nest_wifi_pro" entity="f56b"/>
    <symbolinfo name="nest_wifi_pro_2" entity="f56a"/>
    <symbolinfo name="nest_wifi_router" entity="f133"/>
    <symbolinfo name="network_cell" entity="e1b9"/>
    <symbolinfo name="network_check" entity="e640"/>
    <symbolinfo name="network_intelligence_history" entity="f5f6"/>
    <symbolinfo name="network_intelligence_update" entity="f5f5"/>
    <symbolinfo name="network_locked" entity="e61a"/>
    <symbolinfo name="network_manage" entity="f7ab"/>
    <symbolinfo name="network_node" entity="f56e"/>
    <symbolinfo name="network_ping" entity="ebca"/>
    <symbolinfo name="network_wifi" entity="e1ba"/>
    <symbolinfo name="network_wifi_1_bar" entity="ebe4"/>
    <symbolinfo name="network_wifi_1_bar_locked" entity="f58f"/>
    <symbolinfo name="network_wifi_2_bar" entity="ebd6"/>
    <symbolinfo name="network_wifi_2_bar_locked" entity="f58e"/>
    <symbolinfo name="network_wifi_3_bar" entity="ebe1"/>
    <symbolinfo name="network_wifi_3_bar_locked" entity="f58d"/>
    <symbolinfo name="neurology" entity="e10e"/>
    <symbolinfo name="new_label" entity="e609"/>
    <symbolinfo name="new_releases" entity="ef76"/>
    <symbolinfo name="new_window" entity="f710"/>
    <symbolinfo name="news" entity="e032"/>
    <symbolinfo name="newsmode" entity="efad"/>
    <symbolinfo name="newspaper" entity="eb81"/>
    <symbolinfo name="next_plan" entity="ef5d"/>
    <symbolinfo name="next_week" entity="e16a"/>
    <symbolinfo name="nfc" entity="e1bb"/>
    <symbolinfo name="night_shelter" entity="f1f1"/>
    <symbolinfo name="night_sight_auto" entity="f1d7"/>
    <symbolinfo name="night_sight_auto_off" entity="f1f9"/>
    <symbolinfo name="night_sight_max" entity="f6c3"/>
    <symbolinfo name="nightlife" entity="ea62"/>
    <symbolinfo name="nightlight" entity="f03d"/>
    <symbolinfo name="nightlight_round" entity="f03d"/>
    <symbolinfo name="nights_stay" entity="ea46"/>
    <symbolinfo name="no_accounts" entity="f03e"/>
    <symbolinfo name="no_adult_content" entity="f8fe"/>
    <symbolinfo name="no_backpack" entity="f237"/>
    <symbolinfo name="no_crash" entity="ebf0"/>
    <symbolinfo name="no_drinks" entity="f1a5"/>
    <symbolinfo name="no_encryption" entity="f03f"/>
    <symbolinfo name="no_encryption_gmailerrorred" entity="f03f"/>
    <symbolinfo name="no_flash" entity="f1a6"/>
    <symbolinfo name="no_food" entity="f1a7"/>
    <symbolinfo name="no_luggage" entity="f23b"/>
    <symbolinfo name="no_meals" entity="f1d6"/>
    <symbolinfo name="no_meeting_room" entity="eb4e"/>
    <symbolinfo name="no_photography" entity="f1a8"/>
    <symbolinfo name="no_sim" entity="e1ce"/>
    <symbolinfo name="no_sound" entity="e710"/>
    <symbolinfo name="no_stroller" entity="f1af"/>
    <symbolinfo name="no_transfer" entity="f1d5"/>
    <symbolinfo name="noise_aware" entity="ebec"/>
    <symbolinfo name="noise_control_off" entity="ebf3"/>
    <symbolinfo name="noise_control_on" entity="f8a8"/>
    <symbolinfo name="nordic_walking" entity="e50e"/>
    <symbolinfo name="north" entity="f1e0"/>
    <symbolinfo name="north_east" entity="f1e1"/>
    <symbolinfo name="north_west" entity="f1e2"/>
    <symbolinfo name="not_accessible" entity="f0fe"/>
    <symbolinfo name="not_accessible_forward" entity="f54a"/>
    <symbolinfo name="not_interested" entity="f08c"/>
    <symbolinfo name="not_listed_location" entity="e575"/>
    <symbolinfo name="not_started" entity="f0d1"/>
    <symbolinfo name="note" entity="e66d"/>
    <symbolinfo name="note_add" entity="e89c"/>
    <symbolinfo name="note_alt" entity="f040"/>
    <symbolinfo name="note_stack" entity="f562"/>
    <symbolinfo name="note_stack_add" entity="f563"/>
    <symbolinfo name="notes" entity="e26c"/>
    <symbolinfo name="notification_add" entity="e399"/>
    <symbolinfo name="notification_important" entity="e004"/>
    <symbolinfo name="notification_multiple" entity="e6c2"/>
    <symbolinfo name="notifications" entity="e7f5"/>
    <symbolinfo name="notifications_active" entity="e7f7"/>
    <symbolinfo name="notifications_none" entity="e7f5"/>
    <symbolinfo name="notifications_off" entity="e7f6"/>
    <symbolinfo name="notifications_paused" entity="e7f8"/>
    <symbolinfo name="numbers" entity="eac7"/>
    <symbolinfo name="nutrition" entity="e110"/>
    <symbolinfo name="ods" entity="e6e8"/>
    <symbolinfo name="odt" entity="e6e9"/>
    <symbolinfo name="offline_bolt" entity="e932"/>
    <symbolinfo name="offline_pin" entity="e90a"/>
    <symbolinfo name="offline_share" entity="e9c5"/>
    <symbolinfo name="oil_barrel" entity="ec15"/>
    <symbolinfo name="on_device_training" entity="ebfd"/>
    <symbolinfo name="oncology" entity="e114"/>
    <symbolinfo name="ondemand_video" entity="e63a"/>
    <symbolinfo name="online_prediction" entity="f0eb"/>
    <symbolinfo name="onsen" entity="f6f8"/>
    <symbolinfo name="opacity" entity="e91c"/>
    <symbolinfo name="open_in_browser" entity="e89d"/>
    <symbolinfo name="open_in_full" entity="f1ce"/>
    <symbolinfo name="open_in_new" entity="e89e"/>
    <symbolinfo name="open_in_new_down" entity="f70f"/>
    <symbolinfo name="open_in_new_off" entity="e4f6"/>
    <symbolinfo name="open_in_phone" entity="e702"/>
    <symbolinfo name="open_jam" entity="efae"/>
    <symbolinfo name="open_with" entity="e89f"/>
    <symbolinfo name="ophthalmology" entity="e115"/>
    <symbolinfo name="oral_disease" entity="e116"/>
    <symbolinfo name="order_approve" entity="f812"/>
    <symbolinfo name="order_play" entity="f811"/>
    <symbolinfo name="orthopedics" entity="f897"/>
    <symbolinfo name="other_admission" entity="e47b"/>
    <symbolinfo name="other_houses" entity="e58c"/>
    <symbolinfo name="outbound" entity="e1ca"/>
    <symbolinfo name="outbox" entity="ef5f"/>
    <symbolinfo name="outbox_alt" entity="eb17"/>
    <symbolinfo name="outdoor_garden" entity="e205"/>
    <symbolinfo name="outdoor_grill" entity="ea47"/>
    <symbolinfo name="outgoing_mail" entity="f0d2"/>
    <symbolinfo name="outlet" entity="f1d4"/>
    <symbolinfo name="outlined_flag" entity="f0c6"/>
    <symbolinfo name="outpatient" entity="e118"/>
    <symbolinfo name="outpatient_med" entity="e119"/>
    <symbolinfo name="output" entity="ebbe"/>
    <symbolinfo name="output_circle" entity="f70e"/>
    <symbolinfo name="oven_gen" entity="e843"/>
    <symbolinfo name="overview" entity="e4a7"/>
    <symbolinfo name="overview_key" entity="f7d4"/>
    <symbolinfo name="oxygen_saturation" entity="e4de"/>
    <symbolinfo name="pace" entity="f6b8"/>
    <symbolinfo name="pacemaker" entity="e656"/>
    <symbolinfo name="package" entity="e48f"/>
    <symbolinfo name="package_2" entity="f569"/>
    <symbolinfo name="padding" entity="e9c8"/>
    <symbolinfo name="page_control" entity="e731"/>
    <symbolinfo name="page_info" entity="f614"/>
    <symbolinfo name="pages" entity="e7f9"/>
    <symbolinfo name="pageview" entity="e8a0"/>
    <symbolinfo name="paid" entity="f041"/>
    <symbolinfo name="palette" entity="e40a"/>
    <symbolinfo name="pallet" entity="f86a"/>
    <symbolinfo name="pan_tool" entity="e925"/>
    <symbolinfo name="pan_tool_alt" entity="ebb9"/>
    <symbolinfo name="pan_zoom" entity="f655"/>
    <symbolinfo name="panorama" entity="e40b"/>
    <symbolinfo name="panorama_fish_eye" entity="e40c"/>
    <symbolinfo name="panorama_horizontal" entity="e40d"/>
    <symbolinfo name="panorama_photosphere" entity="e9c9"/>
    <symbolinfo name="panorama_vertical" entity="e40e"/>
    <symbolinfo name="panorama_wide_angle" entity="e40f"/>
    <symbolinfo name="paragliding" entity="e50f"/>
    <symbolinfo name="park" entity="ea63"/>
    <symbolinfo name="partly_cloudy_day" entity="f172"/>
    <symbolinfo name="partly_cloudy_night" entity="f174"/>
    <symbolinfo name="partner_exchange" entity="f7f9"/>
    <symbolinfo name="partner_reports" entity="efaf"/>
    <symbolinfo name="party_mode" entity="e7fa"/>
    <symbolinfo name="passkey" entity="f87f"/>
    <symbolinfo name="password" entity="f042"/>
    <symbolinfo name="patient_list" entity="e653"/>
    <symbolinfo name="pattern" entity="f043"/>
    <symbolinfo name="pause" entity="e034"/>
    <symbolinfo name="pause_circle" entity="e1a2"/>
    <symbolinfo name="pause_circle_filled" entity="e1a2"/>
    <symbolinfo name="pause_circle_outline" entity="e1a2"/>
    <symbolinfo name="pause_presentation" entity="e0ea"/>
    <symbolinfo name="payment" entity="e8a1"/>
    <symbolinfo name="payments" entity="ef63"/>
    <symbolinfo name="pedal_bike" entity="eb29"/>
    <symbolinfo name="pediatrics" entity="e11d"/>
    <symbolinfo name="pen_size_1" entity="f755"/>
    <symbolinfo name="pen_size_2" entity="f754"/>
    <symbolinfo name="pen_size_3" entity="f753"/>
    <symbolinfo name="pen_size_4" entity="f752"/>
    <symbolinfo name="pen_size_5" entity="f751"/>
    <symbolinfo name="pending" entity="ef64"/>
    <symbolinfo name="pending_actions" entity="f1bb"/>
    <symbolinfo name="pentagon" entity="eb50"/>
    <symbolinfo name="people" entity="ea21"/>
    <symbolinfo name="people_alt" entity="ea21"/>
    <symbolinfo name="people_outline" entity="ea21"/>
    <symbolinfo name="percent" entity="eb58"/>
    <symbolinfo name="performance_max" entity="e51a"/>
    <symbolinfo name="pergola" entity="e203"/>
    <symbolinfo name="perm_camera_mic" entity="e8a2"/>
    <symbolinfo name="perm_contact_calendar" entity="e8a3"/>
    <symbolinfo name="perm_data_setting" entity="e8a4"/>
    <symbolinfo name="perm_device_information" entity="e8a5"/>
    <symbolinfo name="perm_identity" entity="f0d3"/>
    <symbolinfo name="perm_media" entity="e8a7"/>
    <symbolinfo name="perm_phone_msg" entity="e8a8"/>
    <symbolinfo name="perm_scan_wifi" entity="e8a9"/>
    <symbolinfo name="person" entity="f0d3"/>
    <symbolinfo name="person_2" entity="f8e4"/>
    <symbolinfo name="person_3" entity="f8e5"/>
    <symbolinfo name="person_4" entity="f8e6"/>
    <symbolinfo name="person_add" entity="ea4d"/>
    <symbolinfo name="person_add_alt" entity="ea4d"/>
    <symbolinfo name="person_add_disabled" entity="e9cb"/>
    <symbolinfo name="person_alert" entity="f567"/>
    <symbolinfo name="person_apron" entity="f5a3"/>
    <symbolinfo name="person_book" entity="f5e8"/>
    <symbolinfo name="person_cancel" entity="f566"/>
    <symbolinfo name="person_celebrate" entity="f7fe"/>
    <symbolinfo name="person_check" entity="f565"/>
    <symbolinfo name="person_filled" entity="f0d3"/>
    <symbolinfo name="person_off" entity="e510"/>
    <symbolinfo name="person_outline" entity="f0d3"/>
    <symbolinfo name="person_pin" entity="e55a"/>
    <symbolinfo name="person_pin_circle" entity="e56a"/>
    <symbolinfo name="person_play" entity="f7fd"/>
    <symbolinfo name="person_raised_hand" entity="f59a"/>
    <symbolinfo name="person_remove" entity="ef66"/>
    <symbolinfo name="person_search" entity="f106"/>
    <symbolinfo name="personal_injury" entity="e6da"/>
    <symbolinfo name="personal_video" entity="e63b"/>
    <symbolinfo name="pest_control" entity="f0fa"/>
    <symbolinfo name="pest_control_rodent" entity="f0fd"/>
    <symbolinfo name="pet_supplies" entity="efb1"/>
    <symbolinfo name="pets" entity="e91d"/>
    <symbolinfo name="phishing" entity="ead7"/>
    <symbolinfo name="phone" entity="f0d4"/>
    <symbolinfo name="phone_alt" entity="f0d4"/>
    <symbolinfo name="phone_android" entity="e324"/>
    <symbolinfo name="phone_bluetooth_speaker" entity="e61b"/>
    <symbolinfo name="phone_callback" entity="e649"/>
    <symbolinfo name="phone_disabled" entity="e9cc"/>
    <symbolinfo name="phone_enabled" entity="e9cd"/>
    <symbolinfo name="phone_forwarded" entity="e61c"/>
    <symbolinfo name="phone_in_talk" entity="e61d"/>
    <symbolinfo name="phone_iphone" entity="e325"/>
    <symbolinfo name="phone_locked" entity="e61e"/>
    <symbolinfo name="phone_missed" entity="e61f"/>
    <symbolinfo name="phone_paused" entity="e620"/>
    <symbolinfo name="phonelink" entity="e326"/>
    <symbolinfo name="phonelink_erase" entity="e0db"/>
    <symbolinfo name="phonelink_lock" entity="e0dc"/>
    <symbolinfo name="phonelink_off" entity="e327"/>
    <symbolinfo name="phonelink_ring" entity="e0dd"/>
    <symbolinfo name="phonelink_ring_off" entity="f7aa"/>
    <symbolinfo name="phonelink_setup" entity="ef41"/>
    <symbolinfo name="photo" entity="e432"/>
    <symbolinfo name="photo_album" entity="e411"/>
    <symbolinfo name="photo_camera" entity="e412"/>
    <symbolinfo name="photo_camera_back" entity="ef68"/>
    <symbolinfo name="photo_camera_front" entity="ef69"/>
    <symbolinfo name="photo_filter" entity="e43b"/>
    <symbolinfo name="photo_frame" entity="f0d9"/>
    <symbolinfo name="photo_library" entity="e413"/>
    <symbolinfo name="photo_prints" entity="efb2"/>
    <symbolinfo name="photo_size_select_actual" entity="e432"/>
    <symbolinfo name="photo_size_select_large" entity="e433"/>
    <symbolinfo name="photo_size_select_small" entity="e434"/>
    <symbolinfo name="php" entity="eb8f"/>
    <symbolinfo name="physical_therapy" entity="e11e"/>
    <symbolinfo name="piano" entity="e521"/>
    <symbolinfo name="piano_off" entity="e520"/>
    <symbolinfo name="picture_as_pdf" entity="e415"/>
    <symbolinfo name="picture_in_picture" entity="e8aa"/>
    <symbolinfo name="picture_in_picture_alt" entity="e911"/>
    <symbolinfo name="picture_in_picture_center" entity="f550"/>
    <symbolinfo name="picture_in_picture_large" entity="f54f"/>
    <symbolinfo name="picture_in_picture_medium" entity="f54e"/>
    <symbolinfo name="picture_in_picture_small" entity="f54d"/>
    <symbolinfo name="pie_chart" entity="f0da"/>
    <symbolinfo name="pie_chart_filled" entity="f0da"/>
    <symbolinfo name="pie_chart_outline" entity="f0da"/>
    <symbolinfo name="pie_chart_outlined" entity="f0da"/>
    <symbolinfo name="pill" entity="e11f"/>
    <symbolinfo name="pill_off" entity="f809"/>
    <symbolinfo name="pin" entity="f045"/>
    <symbolinfo name="pin_drop" entity="e55e"/>
    <symbolinfo name="pin_end" entity="e767"/>
    <symbolinfo name="pin_invoke" entity="e763"/>
    <symbolinfo name="pinch" entity="eb38"/>
    <symbolinfo name="pinch_zoom_in" entity="f1fa"/>
    <symbolinfo name="pinch_zoom_out" entity="f1fb"/>
    <symbolinfo name="pip" entity="f64d"/>
    <symbolinfo name="pip_exit" entity="f70d"/>
    <symbolinfo name="pivot_table_chart" entity="e9ce"/>
    <symbolinfo name="place" entity="f1db"/>
    <symbolinfo name="place_item" entity="f1f0"/>
    <symbolinfo name="plagiarism" entity="ea5a"/>
    <symbolinfo name="planner_banner_ad_pt" entity="e692"/>
    <symbolinfo name="play_arrow" entity="e037"/>
    <symbolinfo name="play_circle" entity="e1c4"/>
    <symbolinfo name="play_disabled" entity="ef6a"/>
    <symbolinfo name="play_for_work" entity="e906"/>
    <symbolinfo name="play_lesson" entity="f047"/>
    <symbolinfo name="play_music" entity="e6ee"/>
    <symbolinfo name="play_pause" entity="f137"/>
    <symbolinfo name="play_shapes" entity="f7fc"/>
    <symbolinfo name="playing_cards" entity="f5dc"/>
    <symbolinfo name="playlist_add" entity="e03b"/>
    <symbolinfo name="playlist_add_check" entity="e065"/>
    <symbolinfo name="playlist_add_check_circle" entity="e7e6"/>
    <symbolinfo name="playlist_add_circle" entity="e7e5"/>
    <symbolinfo name="playlist_play" entity="e05f"/>
    <symbolinfo name="playlist_remove" entity="eb80"/>
    <symbolinfo name="plumbing" entity="f107"/>
    <symbolinfo name="plus_one" entity="e800"/>
    <symbolinfo name="podcasts" entity="f048"/>
    <symbolinfo name="podiatry" entity="e120"/>
    <symbolinfo name="podium" entity="f7fb"/>
    <symbolinfo name="point_of_sale" entity="f17e"/>
    <symbolinfo name="point_scan" entity="f70c"/>
    <symbolinfo name="policy" entity="ea17"/>
    <symbolinfo name="poll" entity="f0cc"/>
    <symbolinfo name="polyline" entity="ebbb"/>
    <symbolinfo name="polymer" entity="e8ab"/>
    <symbolinfo name="pool" entity="eb48"/>
    <symbolinfo name="portable_wifi_off" entity="f087"/>
    <symbolinfo name="portrait" entity="e851"/>
    <symbolinfo name="position_bottom_left" entity="f70b"/>
    <symbolinfo name="position_bottom_right" entity="f70a"/>
    <symbolinfo name="position_top_right" entity="f709"/>
    <symbolinfo name="post" entity="e705"/>
    <symbolinfo name="post_add" entity="ea20"/>
    <symbolinfo name="potted_plant" entity="f8aa"/>
    <symbolinfo name="power" entity="e63c"/>
    <symbolinfo name="power_input" entity="e336"/>
    <symbolinfo name="power_off" entity="e646"/>
    <symbolinfo name="power_rounded" entity="f8c7"/>
    <symbolinfo name="power_settings_new" entity="f8c7"/>
    <symbolinfo name="prayer_times" entity="f838"/>
    <symbolinfo name="precision_manufacturing" entity="f049"/>
    <symbolinfo name="pregnancy" entity="f5f1"/>
    <symbolinfo name="pregnant_woman" entity="f5f1"/>
    <symbolinfo name="preliminary" entity="e7d8"/>
    <symbolinfo name="prescriptions" entity="e121"/>
    <symbolinfo name="present_to_all" entity="e0df"/>
    <symbolinfo name="preview" entity="f1c5"/>
    <symbolinfo name="preview_off" entity="f7af"/>
    <symbolinfo name="price_change" entity="f04a"/>
    <symbolinfo name="price_check" entity="f04b"/>
    <symbolinfo name="print" entity="e8ad"/>
    <symbolinfo name="print_add" entity="f7a2"/>
    <symbolinfo name="print_connect" entity="f7a1"/>
    <symbolinfo name="print_disabled" entity="e9cf"/>
    <symbolinfo name="print_error" entity="f7a0"/>
    <symbolinfo name="print_lock" entity="f651"/>
    <symbolinfo name="priority" entity="e19f"/>
    <symbolinfo name="priority_high" entity="e645"/>
    <symbolinfo name="privacy" entity="f148"/>
    <symbolinfo name="privacy_tip" entity="f0dc"/>
    <symbolinfo name="private_connectivity" entity="e744"/>
    <symbolinfo name="problem" entity="e122"/>
    <symbolinfo name="procedure" entity="e651"/>
    <symbolinfo name="process_chart" entity="f855"/>
    <symbolinfo name="production_quantity_limits" entity="e1d1"/>
    <symbolinfo name="productivity" entity="e296"/>
    <symbolinfo name="progress_activity" entity="e9d0"/>
    <symbolinfo name="propane" entity="ec14"/>
    <symbolinfo name="propane_tank" entity="ec13"/>
    <symbolinfo name="psychiatry" entity="e123"/>
    <symbolinfo name="psychology" entity="ea4a"/>
    <symbolinfo name="psychology_alt" entity="f8ea"/>
    <symbolinfo name="public" entity="e80b"/>
    <symbolinfo name="public_off" entity="f1ca"/>
    <symbolinfo name="publish" entity="e255"/>
    <symbolinfo name="published_with_changes" entity="f232"/>
    <symbolinfo name="pulmonology" entity="e124"/>
    <symbolinfo name="punch_clock" entity="eaa8"/>
    <symbolinfo name="push_pin" entity="f10d"/>
    <symbolinfo name="qr_code" entity="ef6b"/>
    <symbolinfo name="qr_code_2" entity="e00a"/>
    <symbolinfo name="qr_code_2_add" entity="f658"/>
    <symbolinfo name="qr_code_scanner" entity="f206"/>
    <symbolinfo name="query_builder" entity="efd6"/>
    <symbolinfo name="query_stats" entity="e4fc"/>
    <symbolinfo name="question_answer" entity="e8af"/>
    <symbolinfo name="question_exchange" entity="f7f3"/>
    <symbolinfo name="question_mark" entity="eb8b"/>
    <symbolinfo name="queue" entity="e03c"/>
    <symbolinfo name="queue_music" entity="e03d"/>
    <symbolinfo name="queue_play_next" entity="e066"/>
    <symbolinfo name="quick_phrases" entity="e7d1"/>
    <symbolinfo name="quick_reference" entity="e46e"/>
    <symbolinfo name="quick_reference_all" entity="f801"/>
    <symbolinfo name="quickreply" entity="ef6c"/>
    <symbolinfo name="quiet_time" entity="e1f9"/>
    <symbolinfo name="quiet_time_active" entity="e291"/>
    <symbolinfo name="quiz" entity="f04c"/>
    <symbolinfo name="r_mobiledata" entity="f04d"/>
    <symbolinfo name="radar" entity="f04e"/>
    <symbolinfo name="radio" entity="e03e"/>
    <symbolinfo name="radio_button_checked" entity="e837"/>
    <symbolinfo name="radio_button_partial" entity="f560"/>
    <symbolinfo name="radio_button_unchecked" entity="e836"/>
    <symbolinfo name="radiology" entity="e125"/>
    <symbolinfo name="railway_alert" entity="e9d1"/>
    <symbolinfo name="rainy" entity="f176"/>
    <symbolinfo name="rainy_heavy" entity="f61f"/>
    <symbolinfo name="rainy_light" entity="f61e"/>
    <symbolinfo name="rainy_snow" entity="f61d"/>
    <symbolinfo name="ramen_dining" entity="ea64"/>
    <symbolinfo name="ramp_left" entity="eb9c"/>
    <symbolinfo name="ramp_right" entity="eb96"/>
    <symbolinfo name="range_hood" entity="e1ea"/>
    <symbolinfo name="rate_review" entity="e560"/>
    <symbolinfo name="raven" entity="f555"/>
    <symbolinfo name="raw_off" entity="f04f"/>
    <symbolinfo name="raw_on" entity="f050"/>
    <symbolinfo name="read_more" entity="ef6d"/>
    <symbolinfo name="readiness_score" entity="f6dd"/>
    <symbolinfo name="real_estate_agent" entity="e73a"/>
    <symbolinfo name="rear_camera" entity="f6c2"/>
    <symbolinfo name="rebase" entity="f845"/>
    <symbolinfo name="rebase_edit" entity="f846"/>
    <symbolinfo name="receipt" entity="e8b0"/>
    <symbolinfo name="receipt_long" entity="ef6e"/>
    <symbolinfo name="recent_actors" entity="e03f"/>
    <symbolinfo name="recent_patient" entity="f808"/>
    <symbolinfo name="recommend" entity="e9d2"/>
    <symbolinfo name="record_voice_over" entity="e91f"/>
    <symbolinfo name="rectangle" entity="eb54"/>
    <symbolinfo name="recycling" entity="e760"/>
    <symbolinfo name="redeem" entity="e8f6"/>
    <symbolinfo name="redo" entity="e15a"/>
    <symbolinfo name="reduce_capacity" entity="f21c"/>
    <symbolinfo name="refresh" entity="e5d5"/>
    <symbolinfo name="regular_expression" entity="f750"/>
    <symbolinfo name="relax" entity="f6dc"/>
    <symbolinfo name="release_alert" entity="f654"/>
    <symbolinfo name="remember_me" entity="f051"/>
    <symbolinfo name="reminder" entity="e6c6"/>
    <symbolinfo name="reminders_alt" entity="e6c6"/>
    <symbolinfo name="remote_gen" entity="e83e"/>
    <symbolinfo name="remove" entity="e15b"/>
    <symbolinfo name="remove_circle" entity="f08f"/>
    <symbolinfo name="remove_circle_outline" entity="f08f"/>
    <symbolinfo name="remove_done" entity="e9d3"/>
    <symbolinfo name="remove_from_queue" entity="e067"/>
    <symbolinfo name="remove_moderator" entity="e9d4"/>
    <symbolinfo name="remove_red_eye" entity="e8f4"/>
    <symbolinfo name="remove_road" entity="ebfc"/>
    <symbolinfo name="remove_selection" entity="e9d5"/>
    <symbolinfo name="remove_shopping_cart" entity="e928"/>
    <symbolinfo name="reopen_window" entity="f708"/>
    <symbolinfo name="reorder" entity="e8fe"/>
    <symbolinfo name="repartition" entity="f8e8"/>
    <symbolinfo name="repeat" entity="e040"/>
    <symbolinfo name="repeat_on" entity="e9d6"/>
    <symbolinfo name="repeat_one" entity="e041"/>
    <symbolinfo name="repeat_one_on" entity="e9d7"/>
    <symbolinfo name="replay" entity="e042"/>
    <symbolinfo name="replay_10" entity="e059"/>
    <symbolinfo name="replay_30" entity="e05a"/>
    <symbolinfo name="replay_5" entity="e05b"/>
    <symbolinfo name="replay_circle_filled" entity="e9d8"/>
    <symbolinfo name="reply" entity="e15e"/>
    <symbolinfo name="reply_all" entity="e15f"/>
    <symbolinfo name="report" entity="f052"/>
    <symbolinfo name="report_gmailerrorred" entity="f052"/>
    <symbolinfo name="report_off" entity="e170"/>
    <symbolinfo name="report_problem" entity="f083"/>
    <symbolinfo name="request_page" entity="f22c"/>
    <symbolinfo name="request_quote" entity="f1b6"/>
    <symbolinfo name="reset_image" entity="f824"/>
    <symbolinfo name="reset_tv" entity="e9d9"/>
    <symbolinfo name="reset_wrench" entity="f56c"/>
    <symbolinfo name="resize" entity="f707"/>
    <symbolinfo name="respiratory_rate" entity="e127"/>
    <symbolinfo name="restart_alt" entity="f053"/>
    <symbolinfo name="restaurant" entity="e56c"/>
    <symbolinfo name="restaurant_menu" entity="e561"/>
    <symbolinfo name="restore" entity="e8b3"/>
    <symbolinfo name="restore_from_trash" entity="e938"/>
    <symbolinfo name="restore_page" entity="e929"/>
    <symbolinfo name="resume" entity="f7d0"/>
    <symbolinfo name="reviews" entity="f07c"/>
    <symbolinfo name="rewarded_ads" entity="efb6"/>
    <symbolinfo name="rheumatology" entity="e128"/>
    <symbolinfo name="rib_cage" entity="f898"/>
    <symbolinfo name="rice_bowl" entity="f1f5"/>
    <symbolinfo name="right_click" entity="f706"/>
    <symbolinfo name="right_panel_close" entity="f705"/>
    <symbolinfo name="right_panel_open" entity="f704"/>
    <symbolinfo name="ring_volume" entity="f0dd"/>
    <symbolinfo name="ring_volume_filled" entity="f0dd"/>
    <symbolinfo name="ripples" entity="e9db"/>
    <symbolinfo name="robot" entity="f882"/>
    <symbolinfo name="robot_2" entity="f5d0"/>
    <symbolinfo name="rocket" entity="eba5"/>
    <symbolinfo name="rocket_launch" entity="eb9b"/>
    <symbolinfo name="roller_shades" entity="ec12"/>
    <symbolinfo name="roller_shades_closed" entity="ec11"/>
    <symbolinfo name="roller_skating" entity="ebcd"/>
    <symbolinfo name="roofing" entity="f201"/>
    <symbolinfo name="room" entity="f1db"/>
    <symbolinfo name="room_preferences" entity="f1b8"/>
    <symbolinfo name="room_service" entity="eb49"/>
    <symbolinfo name="rotate_90_degrees_ccw" entity="e418"/>
    <symbolinfo name="rotate_90_degrees_cw" entity="eaab"/>
    <symbolinfo name="rotate_left" entity="e419"/>
    <symbolinfo name="rotate_right" entity="e41a"/>
    <symbolinfo name="roundabout_left" entity="eb99"/>
    <symbolinfo name="roundabout_right" entity="eba3"/>
    <symbolinfo name="rounded_corner" entity="e920"/>
    <symbolinfo name="route" entity="eacd"/>
    <symbolinfo name="router" entity="e328"/>
    <symbolinfo name="routine" entity="e20c"/>
    <symbolinfo name="rowing" entity="e921"/>
    <symbolinfo name="rss_feed" entity="e0e5"/>
    <symbolinfo name="rsvp" entity="f055"/>
    <symbolinfo name="rtt" entity="e9ad"/>
    <symbolinfo name="rule" entity="f1c2"/>
    <symbolinfo name="rule_folder" entity="f1c9"/>
    <symbolinfo name="rule_settings" entity="f64c"/>
    <symbolinfo name="run_circle" entity="ef6f"/>
    <symbolinfo name="running_with_errors" entity="e51d"/>
    <symbolinfo name="rv_hookup" entity="e642"/>
    <symbolinfo name="safety_check" entity="ebef"/>
    <symbolinfo name="safety_check_off" entity="f59d"/>
    <symbolinfo name="safety_divider" entity="e1cc"/>
    <symbolinfo name="sailing" entity="e502"/>
    <symbolinfo name="salinity" entity="f876"/>
    <symbolinfo name="sanitizer" entity="f21d"/>
    <symbolinfo name="satellite" entity="e562"/>
    <symbolinfo name="satellite_alt" entity="eb3a"/>
    <symbolinfo name="sauna" entity="f6f7"/>
    <symbolinfo name="save" entity="e161"/>
    <symbolinfo name="save_alt" entity="f090"/>
    <symbolinfo name="save_as" entity="eb60"/>
    <symbolinfo name="saved_search" entity="ea11"/>
    <symbolinfo name="savings" entity="e2eb"/>
    <symbolinfo name="scale" entity="eb5f"/>
    <symbolinfo name="scan" entity="f74e"/>
    <symbolinfo name="scan_delete" entity="f74f"/>
    <symbolinfo name="scanner" entity="e329"/>
    <symbolinfo name="scatter_plot" entity="e268"/>
    <symbolinfo name="scene" entity="e2a7"/>
    <symbolinfo name="schedule" entity="efd6"/>
    <symbolinfo name="schedule_send" entity="ea0a"/>
    <symbolinfo name="schema" entity="e4fd"/>
    <symbolinfo name="school" entity="e80c"/>
    <symbolinfo name="science" entity="ea4b"/>
    <symbolinfo name="score" entity="e269"/>
    <symbolinfo name="scoreboard" entity="ebd0"/>
    <symbolinfo name="screen_lock_landscape" entity="e1be"/>
    <symbolinfo name="screen_lock_portrait" entity="e1bf"/>
    <symbolinfo name="screen_lock_rotation" entity="e1c0"/>
    <symbolinfo name="screen_record" entity="f679"/>
    <symbolinfo name="screen_rotation" entity="e1c1"/>
    <symbolinfo name="screen_rotation_alt" entity="ebee"/>
    <symbolinfo name="screen_rotation_up" entity="f678"/>
    <symbolinfo name="screen_search_desktop" entity="ef70"/>
    <symbolinfo name="screen_share" entity="e0e2"/>
    <symbolinfo name="screenshot" entity="f056"/>
    <symbolinfo name="screenshot_frame" entity="f677"/>
    <symbolinfo name="screenshot_keyboard" entity="f7d3"/>
    <symbolinfo name="screenshot_monitor" entity="ec08"/>
    <symbolinfo name="screenshot_region" entity="f7d2"/>
    <symbolinfo name="screenshot_tablet" entity="f697"/>
    <symbolinfo name="scrollable_header" entity="e9dc"/>
    <symbolinfo name="scuba_diving" entity="ebce"/>
    <symbolinfo name="sd" entity="e9dd"/>
    <symbolinfo name="sd_card" entity="e623"/>
    <symbolinfo name="sd_card_alert" entity="f057"/>
    <symbolinfo name="sd_storage" entity="e623"/>
    <symbolinfo name="search" entity="e8b6"/>
    <symbolinfo name="search_check" entity="f800"/>
    <symbolinfo name="search_off" entity="ea76"/>
    <symbolinfo name="security" entity="e32a"/>
    <symbolinfo name="security_update" entity="f072"/>
    <symbolinfo name="security_update_good" entity="f073"/>
    <symbolinfo name="security_update_warning" entity="f074"/>
    <symbolinfo name="segment" entity="e94b"/>
    <symbolinfo name="select" entity="f74d"/>
    <symbolinfo name="select_all" entity="e162"/>
    <symbolinfo name="select_check_box" entity="f1fe"/>
    <symbolinfo name="select_to_speak" entity="f7cf"/>
    <symbolinfo name="select_window" entity="e6fa"/>
    <symbolinfo name="select_window_off" entity="e506"/>
    <symbolinfo name="self_care" entity="f86d"/>
    <symbolinfo name="self_improvement" entity="ea78"/>
    <symbolinfo name="sell" entity="f05b"/>
    <symbolinfo name="send" entity="e163"/>
    <symbolinfo name="send_and_archive" entity="ea0c"/>
    <symbolinfo name="send_money" entity="e8b7"/>
    <symbolinfo name="send_time_extension" entity="eadb"/>
    <symbolinfo name="send_to_mobile" entity="f05c"/>
    <symbolinfo name="sensor_door" entity="f1b5"/>
    <symbolinfo name="sensor_occupied" entity="ec10"/>
    <symbolinfo name="sensor_window" entity="f1b4"/>
    <symbolinfo name="sensors" entity="e51e"/>
    <symbolinfo name="sensors_krx" entity="f556"/>
    <symbolinfo name="sensors_off" entity="e51f"/>
    <symbolinfo name="sentiment_calm" entity="f6a7"/>
    <symbolinfo name="sentiment_content" entity="f6a6"/>
    <symbolinfo name="sentiment_dissatisfied" entity="e811"/>
    <symbolinfo name="sentiment_excited" entity="f6a5"/>
    <symbolinfo name="sentiment_extremely_dissatisfied" entity="f194"/>
    <symbolinfo name="sentiment_frustrated" entity="f6a4"/>
    <symbolinfo name="sentiment_neutral" entity="e812"/>
    <symbolinfo name="sentiment_sad" entity="f6a3"/>
    <symbolinfo name="sentiment_satisfied" entity="e813"/>
    <symbolinfo name="sentiment_satisfied_alt" entity="e813"/>
    <symbolinfo name="sentiment_stressed" entity="f6a2"/>
    <symbolinfo name="sentiment_very_dissatisfied" entity="e814"/>
    <symbolinfo name="sentiment_very_satisfied" entity="e815"/>
    <symbolinfo name="sentiment_worried" entity="f6a1"/>
    <symbolinfo name="set_meal" entity="f1ea"/>
    <symbolinfo name="settings" entity="e8b8"/>
    <symbolinfo name="settings_accessibility" entity="f05d"/>
    <symbolinfo name="settings_account_box" entity="f835"/>
    <symbolinfo name="settings_alert" entity="f143"/>
    <symbolinfo name="settings_applications" entity="e8b9"/>
    <symbolinfo name="settings_b_roll" entity="f625"/>
    <symbolinfo name="settings_backup_restore" entity="e8ba"/>
    <symbolinfo name="settings_bluetooth" entity="e8bb"/>
    <symbolinfo name="settings_brightness" entity="e8bd"/>
    <symbolinfo name="settings_cell" entity="e8bc"/>
    <symbolinfo name="settings_cinematic_blur" entity="f624"/>
    <symbolinfo name="settings_ethernet" entity="e8be"/>
    <symbolinfo name="settings_input_antenna" entity="e8bf"/>
    <symbolinfo name="settings_input_component" entity="e8c1"/>
    <symbolinfo name="settings_input_composite" entity="e8c1"/>
    <symbolinfo name="settings_input_hdmi" entity="e8c2"/>
    <symbolinfo name="settings_input_svideo" entity="e8c3"/>
    <symbolinfo name="settings_motion_mode" entity="f833"/>
    <symbolinfo name="settings_night_sight" entity="f832"/>
    <symbolinfo name="settings_overscan" entity="e8c4"/>
    <symbolinfo name="settings_panorama" entity="f831"/>
    <symbolinfo name="settings_phone" entity="e8c5"/>
    <symbolinfo name="settings_photo_camera" entity="f834"/>
    <symbolinfo name="settings_power" entity="e8c6"/>
    <symbolinfo name="settings_remote" entity="e8c7"/>
    <symbolinfo name="settings_slow_motion" entity="f623"/>
    <symbolinfo name="settings_suggest" entity="f05e"/>
    <symbolinfo name="settings_system_daydream" entity="e1c3"/>
    <symbolinfo name="settings_timelapse" entity="f622"/>
    <symbolinfo name="settings_video_camera" entity="f621"/>
    <symbolinfo name="settings_voice" entity="e8c8"/>
    <symbolinfo name="settop_component" entity="e2ac"/>
    <symbolinfo name="severe_cold" entity="ebd3"/>
    <symbolinfo name="shadow" entity="e9df"/>
    <symbolinfo name="shadow_add" entity="f584"/>
    <symbolinfo name="shadow_minus" entity="f583"/>
    <symbolinfo name="shape_line" entity="f8d3"/>
    <symbolinfo name="shapes" entity="e602"/>
    <symbolinfo name="share" entity="e80d"/>
    <symbolinfo name="share_location" entity="f05f"/>
    <symbolinfo name="share_off" entity="f6cb"/>
    <symbolinfo name="share_reviews" entity="f8a4"/>
    <symbolinfo name="share_windows" entity="f613"/>
    <symbolinfo name="sheets_rtl" entity="f823"/>
    <symbolinfo name="shelf_auto_hide" entity="f703"/>
    <symbolinfo name="shelf_position" entity="f702"/>
    <symbolinfo name="shelves" entity="f86e"/>
    <symbolinfo name="shield" entity="e9e0"/>
    <symbolinfo name="shield_lock" entity="f686"/>
    <symbolinfo name="shield_locked" entity="f592"/>
    <symbolinfo name="shield_moon" entity="eaa9"/>
    <symbolinfo name="shield_person" entity="f650"/>
    <symbolinfo name="shield_spark" entity="f55d"/>
    <symbolinfo name="shield_with_heart" entity="e78f"/>
    <symbolinfo name="shield_with_house" entity="e78d"/>
    <symbolinfo name="shift" entity="e5f2"/>
    <symbolinfo name="shift_lock" entity="f7ae"/>
    <symbolinfo name="shop" entity="e8c9"/>
    <symbolinfo name="shop_2" entity="e8ca"/>
    <symbolinfo name="shop_two" entity="e8ca"/>
    <symbolinfo name="shopping_bag" entity="f1cc"/>
    <symbolinfo name="shopping_basket" entity="e8cb"/>
    <symbolinfo name="shopping_cart" entity="e8cc"/>
    <symbolinfo name="shopping_cart_checkout" entity="eb88"/>
    <symbolinfo name="short_stay" entity="e4d0"/>
    <symbolinfo name="short_text" entity="e261"/>
    <symbolinfo name="shortcut" entity="f57a"/>
    <symbolinfo name="show_chart" entity="e6e1"/>
    <symbolinfo name="shower" entity="f061"/>
    <symbolinfo name="shuffle" entity="e043"/>
    <symbolinfo name="shuffle_on" entity="e9e1"/>
    <symbolinfo name="shutter_speed" entity="e43d"/>
    <symbolinfo name="shutter_speed_add" entity="f57e"/>
    <symbolinfo name="shutter_speed_minus" entity="f57d"/>
    <symbolinfo name="sick" entity="f220"/>
    <symbolinfo name="side_navigation" entity="e9e2"/>
    <symbolinfo name="sign_language" entity="ebe5"/>
    <symbolinfo name="signal_cellular_0_bar" entity="f0a8"/>
    <symbolinfo name="signal_cellular_1_bar" entity="f0a9"/>
    <symbolinfo name="signal_cellular_2_bar" entity="f0aa"/>
    <symbolinfo name="signal_cellular_3_bar" entity="f0ab"/>
    <symbolinfo name="signal_cellular_4_bar" entity="e1c8"/>
    <symbolinfo name="signal_cellular_add" entity="f7a9"/>
    <symbolinfo name="signal_cellular_alt" entity="e202"/>
    <symbolinfo name="signal_cellular_alt_1_bar" entity="ebdf"/>
    <symbolinfo name="signal_cellular_alt_2_bar" entity="ebe3"/>
    <symbolinfo name="signal_cellular_connected_no_internet_0_bar" entity="f0ac"/>
    <symbolinfo name="signal_cellular_connected_no_internet_4_bar" entity="e1cd"/>
    <symbolinfo name="signal_cellular_no_sim" entity="e1ce"/>
    <symbolinfo name="signal_cellular_nodata" entity="f062"/>
    <symbolinfo name="signal_cellular_null" entity="e1cf"/>
    <symbolinfo name="signal_cellular_off" entity="e1d0"/>
    <symbolinfo name="signal_cellular_pause" entity="f5a7"/>
    <symbolinfo name="signal_disconnected" entity="f239"/>
    <symbolinfo name="signal_wifi_0_bar" entity="f0b0"/>
    <symbolinfo name="signal_wifi_4_bar" entity="f065"/>
    <symbolinfo name="signal_wifi_4_bar_lock" entity="e1e1"/>
    <symbolinfo name="signal_wifi_bad" entity="f064"/>
    <symbolinfo name="signal_wifi_connected_no_internet_4" entity="f064"/>
    <symbolinfo name="signal_wifi_off" entity="e1da"/>
    <symbolinfo name="signal_wifi_statusbar_4_bar" entity="f065"/>
    <symbolinfo name="signal_wifi_statusbar_not_connected" entity="f0ef"/>
    <symbolinfo name="signal_wifi_statusbar_null" entity="f067"/>
    <symbolinfo name="signature" entity="f74c"/>
    <symbolinfo name="signpost" entity="eb91"/>
    <symbolinfo name="sim_card" entity="e32b"/>
    <symbolinfo name="sim_card_alert" entity="f057"/>
    <symbolinfo name="sim_card_download" entity="f068"/>
    <symbolinfo name="single_bed" entity="ea48"/>
    <symbolinfo name="sip" entity="f069"/>
    <symbolinfo name="skateboarding" entity="e511"/>
    <symbolinfo name="skeleton" entity="f899"/>
    <symbolinfo name="skip_next" entity="e044"/>
    <symbolinfo name="skip_previous" entity="e045"/>
    <symbolinfo name="skull" entity="f89a"/>
    <symbolinfo name="sledding" entity="e512"/>
    <symbolinfo name="sleep" entity="e213"/>
    <symbolinfo name="sleep_score" entity="f6b7"/>
    <symbolinfo name="slide_library" entity="f822"/>
    <symbolinfo name="sliders" entity="e9e3"/>
    <symbolinfo name="slideshow" entity="e41b"/>
    <symbolinfo name="slow_motion_video" entity="e068"/>
    <symbolinfo name="smart_button" entity="f1c1"/>
    <symbolinfo name="smart_display" entity="f06a"/>
    <symbolinfo name="smart_outlet" entity="e844"/>
    <symbolinfo name="smart_screen" entity="f06b"/>
    <symbolinfo name="smart_toy" entity="f06c"/>
    <symbolinfo name="smart_ventilation" entity="f55c"/>
    <symbolinfo name="smartphone" entity="e32c"/>
    <symbolinfo name="smb_share" entity="f74b"/>
    <symbolinfo name="smoke_free" entity="eb4a"/>
    <symbolinfo name="smoking_rooms" entity="eb4b"/>
    <symbolinfo name="sms" entity="e625"/>
    <symbolinfo name="sms_failed" entity="e87f"/>
    <symbolinfo name="snippet_folder" entity="f1c7"/>
    <symbolinfo name="snooze" entity="e046"/>
    <symbolinfo name="snowboarding" entity="e513"/>
    <symbolinfo name="snowing" entity="e80f"/>
    <symbolinfo name="snowing_heavy" entity="f61c"/>
    <symbolinfo name="snowmobile" entity="e503"/>
    <symbolinfo name="snowshoeing" entity="e514"/>
    <symbolinfo name="soap" entity="f1b2"/>
    <symbolinfo name="social_distance" entity="e1cb"/>
    <symbolinfo name="social_leaderboard" entity="f6a0"/>
    <symbolinfo name="solar_power" entity="ec0f"/>
    <symbolinfo name="sort" entity="e164"/>
    <symbolinfo name="sort_by_alpha" entity="e053"/>
    <symbolinfo name="sos" entity="ebf7"/>
    <symbolinfo name="sound_detection_dog_barking" entity="f149"/>
    <symbolinfo name="sound_detection_glass_break" entity="f14a"/>
    <symbolinfo name="sound_detection_loud_sound" entity="f14b"/>
    <symbolinfo name="sound_sampler" entity="f6b4"/>
    <symbolinfo name="soup_kitchen" entity="e7d3"/>
    <symbolinfo name="source" entity="f1c8"/>
    <symbolinfo name="source_notes" entity="e12d"/>
    <symbolinfo name="south" entity="f1e3"/>
    <symbolinfo name="south_america" entity="e7e4"/>
    <symbolinfo name="south_east" entity="f1e4"/>
    <symbolinfo name="south_west" entity="f1e5"/>
    <symbolinfo name="spa" entity="eb4c"/>
    <symbolinfo name="space_bar" entity="e256"/>
    <symbolinfo name="space_dashboard" entity="e66b"/>
    <symbolinfo name="spatial_audio" entity="ebeb"/>
    <symbolinfo name="spatial_audio_off" entity="ebe8"/>
    <symbolinfo name="spatial_tracking" entity="ebea"/>
    <symbolinfo name="speaker" entity="e32d"/>
    <symbolinfo name="speaker_group" entity="e32e"/>
    <symbolinfo name="speaker_notes" entity="e8cd"/>
    <symbolinfo name="speaker_notes_off" entity="e92a"/>
    <symbolinfo name="speaker_phone" entity="e0d2"/>
    <symbolinfo name="special_character" entity="f74a"/>
    <symbolinfo name="specific_gravity" entity="f872"/>
    <symbolinfo name="speech_to_text" entity="f8a7"/>
    <symbolinfo name="speed" entity="e9e4"/>
    <symbolinfo name="spellcheck" entity="e8ce"/>
    <symbolinfo name="splitscreen" entity="f06d"/>
    <symbolinfo name="splitscreen_bottom" entity="f676"/>
    <symbolinfo name="splitscreen_left" entity="f675"/>
    <symbolinfo name="splitscreen_right" entity="f674"/>
    <symbolinfo name="splitscreen_top" entity="f673"/>
    <symbolinfo name="spo2" entity="f6db"/>
    <symbolinfo name="spoke" entity="e9a7"/>
    <symbolinfo name="sports" entity="ea30"/>
    <symbolinfo name="sports_bar" entity="f1f3"/>
    <symbolinfo name="sports_baseball" entity="ea51"/>
    <symbolinfo name="sports_basketball" entity="ea26"/>
    <symbolinfo name="sports_cricket" entity="ea27"/>
    <symbolinfo name="sports_esports" entity="ea28"/>
    <symbolinfo name="sports_football" entity="ea29"/>
    <symbolinfo name="sports_golf" entity="ea2a"/>
    <symbolinfo name="sports_gymnastics" entity="ebc4"/>
    <symbolinfo name="sports_handball" entity="ea33"/>
    <symbolinfo name="sports_hockey" entity="ea2b"/>
    <symbolinfo name="sports_kabaddi" entity="ea34"/>
    <symbolinfo name="sports_martial_arts" entity="eae9"/>
    <symbolinfo name="sports_mma" entity="ea2c"/>
    <symbolinfo name="sports_motorsports" entity="ea2d"/>
    <symbolinfo name="sports_rugby" entity="ea2e"/>
    <symbolinfo name="sports_score" entity="f06e"/>
    <symbolinfo name="sports_soccer" entity="ea2f"/>
    <symbolinfo name="sports_tennis" entity="ea32"/>
    <symbolinfo name="sports_volleyball" entity="ea31"/>
    <symbolinfo name="sprinkler" entity="e29a"/>
    <symbolinfo name="sprint" entity="f81f"/>
    <symbolinfo name="square" entity="eb36"/>
    <symbolinfo name="square_foot" entity="ea49"/>
    <symbolinfo name="ssid_chart" entity="eb66"/>
    <symbolinfo name="stack" entity="f609"/>
    <symbolinfo name="stack_off" entity="f608"/>
    <symbolinfo name="stack_star" entity="f607"/>
    <symbolinfo name="stacked_bar_chart" entity="e9e6"/>
    <symbolinfo name="stacked_email" entity="e6c7"/>
    <symbolinfo name="stacked_inbox" entity="e6c9"/>
    <symbolinfo name="stacked_line_chart" entity="f22b"/>
    <symbolinfo name="stadia_controller" entity="f135"/>
    <symbolinfo name="stadium" entity="eb90"/>
    <symbolinfo name="stairs" entity="f1a9"/>
    <symbolinfo name="star" entity="f09a"/>
    <symbolinfo name="star_border" entity="f09a"/>
    <symbolinfo name="star_border_purple500" entity="f09a"/>
    <symbolinfo name="star_half" entity="e839"/>
    <symbolinfo name="star_outline" entity="f09a"/>
    <symbolinfo name="star_purple500" entity="f09a"/>
    <symbolinfo name="star_rate" entity="f0ec"/>
    <symbolinfo name="star_rate_half" entity="ec45"/>
    <symbolinfo name="stars" entity="e8d0"/>
    <symbolinfo name="start" entity="e089"/>
    <symbolinfo name="stat_1" entity="e698"/>
    <symbolinfo name="stat_2" entity="e699"/>
    <symbolinfo name="stat_3" entity="e69a"/>
    <symbolinfo name="stat_minus_1" entity="e69b"/>
    <symbolinfo name="stat_minus_2" entity="e69c"/>
    <symbolinfo name="stat_minus_3" entity="e69d"/>
    <symbolinfo name="stay_current_landscape" entity="e0d3"/>
    <symbolinfo name="stay_current_portrait" entity="e0d4"/>
    <symbolinfo name="stay_primary_landscape" entity="e0d5"/>
    <symbolinfo name="stay_primary_portrait" entity="e0d6"/>
    <symbolinfo name="step" entity="f6fe"/>
    <symbolinfo name="step_into" entity="f701"/>
    <symbolinfo name="step_out" entity="f700"/>
    <symbolinfo name="step_over" entity="f6ff"/>
    <symbolinfo name="steppers" entity="e9e7"/>
    <symbolinfo name="steps" entity="f6da"/>
    <symbolinfo name="stethoscope" entity="f805"/>
    <symbolinfo name="stethoscope_arrow" entity="f807"/>
    <symbolinfo name="stethoscope_check" entity="f806"/>
    <symbolinfo name="sticky_note" entity="e9e8"/>
    <symbolinfo name="sticky_note_2" entity="f1fc"/>
    <symbolinfo name="stock_media" entity="f570"/>
    <symbolinfo name="stop" entity="e047"/>
    <symbolinfo name="stop_circle" entity="ef71"/>
    <symbolinfo name="stop_screen_share" entity="e0e3"/>
    <symbolinfo name="storage" entity="e1db"/>
    <symbolinfo name="store" entity="e8d1"/>
    <symbolinfo name="store_mall_directory" entity="e8d1"/>
    <symbolinfo name="storefront" entity="ea12"/>
    <symbolinfo name="storm" entity="f070"/>
    <symbolinfo name="straight" entity="eb95"/>
    <symbolinfo name="straighten" entity="e41c"/>
    <symbolinfo name="strategy" entity="f5df"/>
    <symbolinfo name="stream" entity="e9e9"/>
    <symbolinfo name="stream_apps" entity="f79f"/>
    <symbolinfo name="streetview" entity="e56e"/>
    <symbolinfo name="stress_management" entity="f6d9"/>
    <symbolinfo name="strikethrough_s" entity="e257"/>
    <symbolinfo name="stroke_full" entity="f749"/>
    <symbolinfo name="stroke_partial" entity="f748"/>
    <symbolinfo name="stroller" entity="f1ae"/>
    <symbolinfo name="style" entity="e41d"/>
    <symbolinfo name="styler" entity="e273"/>
    <symbolinfo name="stylus" entity="f604"/>
    <symbolinfo name="stylus_laser_pointer" entity="f747"/>
    <symbolinfo name="stylus_note" entity="f603"/>
    <symbolinfo name="subdirectory_arrow_left" entity="e5d9"/>
    <symbolinfo name="subdirectory_arrow_right" entity="e5da"/>
    <symbolinfo name="subheader" entity="e9ea"/>
    <symbolinfo name="subject" entity="e8d2"/>
    <symbolinfo name="subscript" entity="f111"/>
    <symbolinfo name="subscriptions" entity="e064"/>
    <symbolinfo name="subtitles" entity="e048"/>
    <symbolinfo name="subtitles_off" entity="ef72"/>
    <symbolinfo name="subway" entity="e56f"/>
    <symbolinfo name="summarize" entity="f071"/>
    <symbolinfo name="sunny" entity="e81a"/>
    <symbolinfo name="sunny_snowing" entity="e819"/>
    <symbolinfo name="superscript" entity="f112"/>
    <symbolinfo name="supervised_user_circle" entity="e939"/>
    <symbolinfo name="supervised_user_circle_off" entity="f60e"/>
    <symbolinfo name="supervisor_account" entity="e8d3"/>
    <symbolinfo name="support" entity="ef73"/>
    <symbolinfo name="support_agent" entity="f0e2"/>
    <symbolinfo name="surfing" entity="e515"/>
    <symbolinfo name="surgical" entity="e131"/>
    <symbolinfo name="surround_sound" entity="e049"/>
    <symbolinfo name="swap_calls" entity="e0d7"/>
    <symbolinfo name="swap_driving_apps_wheel" entity="e69f"/>
    <symbolinfo name="swap_horiz" entity="e8d4"/>
    <symbolinfo name="swap_horizontal_circle" entity="e933"/>
    <symbolinfo name="swap_vert" entity="e8d5"/>
    <symbolinfo name="swap_vertical_circle" entity="e8d6"/>
    <symbolinfo name="sweep" entity="e6ac"/>
    <symbolinfo name="swipe" entity="e9ec"/>
    <symbolinfo name="swipe_down" entity="eb53"/>
    <symbolinfo name="swipe_down_alt" entity="eb30"/>
    <symbolinfo name="swipe_left" entity="eb59"/>
    <symbolinfo name="swipe_left_alt" entity="eb33"/>
    <symbolinfo name="swipe_right" entity="eb52"/>
    <symbolinfo name="swipe_right_alt" entity="eb56"/>
    <symbolinfo name="swipe_up" entity="eb2e"/>
    <symbolinfo name="swipe_up_alt" entity="eb35"/>
    <symbolinfo name="swipe_vertical" entity="eb51"/>
    <symbolinfo name="switch" entity="e1f4"/>
    <symbolinfo name="switch_access" entity="f6fd"/>
    <symbolinfo name="switch_access_shortcut" entity="e7e1"/>
    <symbolinfo name="switch_access_shortcut_add" entity="e7e2"/>
    <symbolinfo name="switch_account" entity="e9ed"/>
    <symbolinfo name="switch_camera" entity="e41e"/>
    <symbolinfo name="switch_left" entity="f1d1"/>
    <symbolinfo name="switch_right" entity="f1d2"/>
    <symbolinfo name="switch_video" entity="e41f"/>
    <symbolinfo name="switches" entity="e733"/>
    <symbolinfo name="sword_rose" entity="f5de"/>
    <symbolinfo name="swords" entity="f889"/>
    <symbolinfo name="symptoms" entity="e132"/>
    <symbolinfo name="synagogue" entity="eab0"/>
    <symbolinfo name="sync" entity="e627"/>
    <symbolinfo name="sync_alt" entity="ea18"/>
    <symbolinfo name="sync_disabled" entity="e628"/>
    <symbolinfo name="sync_lock" entity="eaee"/>
    <symbolinfo name="sync_problem" entity="e629"/>
    <symbolinfo name="sync_saved_locally" entity="f820"/>
    <symbolinfo name="syringe" entity="e133"/>
    <symbolinfo name="system_security_update" entity="f072"/>
    <symbolinfo name="system_security_update_good" entity="f073"/>
    <symbolinfo name="system_security_update_warning" entity="f074"/>
    <symbolinfo name="system_update" entity="f072"/>
    <symbolinfo name="system_update_alt" entity="e8d7"/>
    <symbolinfo name="tab" entity="e8d8"/>
    <symbolinfo name="tab_close" entity="f745"/>
    <symbolinfo name="tab_close_right" entity="f746"/>
    <symbolinfo name="tab_duplicate" entity="f744"/>
    <symbolinfo name="tab_group" entity="f743"/>
    <symbolinfo name="tab_move" entity="f742"/>
    <symbolinfo name="tab_new_right" entity="f741"/>
    <symbolinfo name="tab_recent" entity="f740"/>
    <symbolinfo name="tab_unselected" entity="e8d9"/>
    <symbolinfo name="table" entity="f191"/>
    <symbolinfo name="table_bar" entity="ead2"/>
    <symbolinfo name="table_chart" entity="e265"/>
    <symbolinfo name="table_chart_view" entity="f6ef"/>
    <symbolinfo name="table_lamp" entity="e1f2"/>
    <symbolinfo name="table_restaurant" entity="eac6"/>
    <symbolinfo name="table_rows" entity="f101"/>
    <symbolinfo name="table_rows_narrow" entity="f73f"/>
    <symbolinfo name="table_view" entity="f1be"/>
    <symbolinfo name="tablet" entity="e32f"/>
    <symbolinfo name="tablet_android" entity="e330"/>
    <symbolinfo name="tablet_mac" entity="e331"/>
    <symbolinfo name="tabs" entity="e9ee"/>
    <symbolinfo name="tactic" entity="f564"/>
    <symbolinfo name="tag" entity="e9ef"/>
    <symbolinfo name="tag_faces" entity="ea22"/>
    <symbolinfo name="takeout_dining" entity="ea74"/>
    <symbolinfo name="tamper_detection_off" entity="e82e"/>
    <symbolinfo name="tamper_detection_on" entity="f8c8"/>
    <symbolinfo name="tap_and_play" entity="e62b"/>
    <symbolinfo name="tapas" entity="f1e9"/>
    <symbolinfo name="target" entity="e719"/>
    <symbolinfo name="task" entity="f075"/>
    <symbolinfo name="task_alt" entity="e2e6"/>
    <symbolinfo name="taunt" entity="f69f"/>
    <symbolinfo name="taxi_alert" entity="ef74"/>
    <symbolinfo name="team_dashboard" entity="e013"/>
    <symbolinfo name="temp_preferences_custom" entity="f8c9"/>
    <symbolinfo name="temp_preferences_eco" entity="f8ca"/>
    <symbolinfo name="temple_buddhist" entity="eab3"/>
    <symbolinfo name="temple_hindu" entity="eaaf"/>
    <symbolinfo name="tenancy" entity="f0e3"/>
    <symbolinfo name="terminal" entity="eb8e"/>
    <symbolinfo name="terrain" entity="e564"/>
    <symbolinfo name="text_ad" entity="e728"/>
    <symbolinfo name="text_decrease" entity="eadd"/>
    <symbolinfo name="text_fields" entity="e262"/>
    <symbolinfo name="text_format" entity="e165"/>
    <symbolinfo name="text_increase" entity="eae2"/>
    <symbolinfo name="text_rotate_up" entity="e93a"/>
    <symbolinfo name="text_rotate_vertical" entity="e93b"/>
    <symbolinfo name="text_rotation_angledown" entity="e93c"/>
    <symbolinfo name="text_rotation_angleup" entity="e93d"/>
    <symbolinfo name="text_rotation_down" entity="e93e"/>
    <symbolinfo name="text_rotation_none" entity="e93f"/>
    <symbolinfo name="text_select_end" entity="f73e"/>
    <symbolinfo name="text_select_jump_to_beginning" entity="f73d"/>
    <symbolinfo name="text_select_jump_to_end" entity="f73c"/>
    <symbolinfo name="text_select_move_back_character" entity="f73b"/>
    <symbolinfo name="text_select_move_back_word" entity="f73a"/>
    <symbolinfo name="text_select_move_down" entity="f739"/>
    <symbolinfo name="text_select_move_forward_character" entity="f738"/>
    <symbolinfo name="text_select_move_forward_word" entity="f737"/>
    <symbolinfo name="text_select_move_up" entity="f736"/>
    <symbolinfo name="text_select_start" entity="f735"/>
    <symbolinfo name="text_snippet" entity="f1c6"/>
    <symbolinfo name="text_to_speech" entity="f1bc"/>
    <symbolinfo name="textsms" entity="e625"/>
    <symbolinfo name="texture" entity="e421"/>
    <symbolinfo name="texture_add" entity="f57c"/>
    <symbolinfo name="texture_minus" entity="f57b"/>
    <symbolinfo name="theater_comedy" entity="ea66"/>
    <symbolinfo name="theaters" entity="e8da"/>
    <symbolinfo name="thermometer" entity="e846"/>
    <symbolinfo name="thermometer_add" entity="f582"/>
    <symbolinfo name="thermometer_gain" entity="f6d8"/>
    <symbolinfo name="thermometer_loss" entity="f6d7"/>
    <symbolinfo name="thermometer_minus" entity="f581"/>
    <symbolinfo name="thermostat" entity="f076"/>
    <symbolinfo name="thermostat_auto" entity="f077"/>
    <symbolinfo name="thermostat_carbon" entity="f178"/>
    <symbolinfo name="thumb_down" entity="f578"/>
    <symbolinfo name="thumb_down_alt" entity="f578"/>
    <symbolinfo name="thumb_down_filled" entity="f578"/>
    <symbolinfo name="thumb_down_off" entity="f578"/>
    <symbolinfo name="thumb_down_off_alt" entity="f578"/>
    <symbolinfo name="thumb_up" entity="f577"/>
    <symbolinfo name="thumb_up_alt" entity="f577"/>
    <symbolinfo name="thumb_up_filled" entity="f577"/>
    <symbolinfo name="thumb_up_off" entity="f577"/>
    <symbolinfo name="thumb_up_off_alt" entity="f577"/>
    <symbolinfo name="thumbnail_bar" entity="f734"/>
    <symbolinfo name="thumbs_up_down" entity="e8dd"/>
    <symbolinfo name="thunderstorm" entity="ebdb"/>
    <symbolinfo name="tibia" entity="f89b"/>
    <symbolinfo name="tibia_alt" entity="f89c"/>
    <symbolinfo name="time_auto" entity="f0e4"/>
    <symbolinfo name="time_to_leave" entity="eff7"/>
    <symbolinfo name="timelapse" entity="e422"/>
    <symbolinfo name="timeline" entity="e922"/>
    <symbolinfo name="timer" entity="e425"/>
    <symbolinfo name="timer_10" entity="e423"/>
    <symbolinfo name="timer_10_alt_1" entity="efbf"/>
    <symbolinfo name="timer_10_select" entity="f07a"/>
    <symbolinfo name="timer_3" entity="e424"/>
    <symbolinfo name="timer_3_alt_1" entity="efc0"/>
    <symbolinfo name="timer_3_select" entity="f07b"/>
    <symbolinfo name="timer_off" entity="e426"/>
    <symbolinfo name="tips_and_updates" entity="e79a"/>
    <symbolinfo name="tire_repair" entity="ebc8"/>
    <symbolinfo name="title" entity="e264"/>
    <symbolinfo name="toast" entity="efc1"/>
    <symbolinfo name="toc" entity="e8de"/>
    <symbolinfo name="today" entity="e8df"/>
    <symbolinfo name="toggle_off" entity="e9f5"/>
    <symbolinfo name="toggle_on" entity="e9f6"/>
    <symbolinfo name="token" entity="ea25"/>
    <symbolinfo name="toll" entity="e8e0"/>
    <symbolinfo name="tonality" entity="e427"/>
    <symbolinfo name="toolbar" entity="e9f7"/>
    <symbolinfo name="tools_flat_head" entity="f8cb"/>
    <symbolinfo name="tools_installation_kit" entity="e2ab"/>
    <symbolinfo name="tools_ladder" entity="e2cb"/>
    <symbolinfo name="tools_level" entity="e77b"/>
    <symbolinfo name="tools_phillips" entity="f8cc"/>
    <symbolinfo name="tools_pliers_wire_stripper" entity="e2aa"/>
    <symbolinfo name="tools_power_drill" entity="e1e9"/>
    <symbolinfo name="tools_wrench" entity="f8cd"/>
    <symbolinfo name="tooltip" entity="e9f8"/>
    <symbolinfo name="top_panel_close" entity="f733"/>
    <symbolinfo name="top_panel_open" entity="f732"/>
    <symbolinfo name="topic" entity="f1c8"/>
    <symbolinfo name="tornado" entity="e199"/>
    <symbolinfo name="total_dissolved_solids" entity="f877"/>
    <symbolinfo name="touch_app" entity="e913"/>
    <symbolinfo name="touchpad_mouse" entity="f687"/>
    <symbolinfo name="tour" entity="ef75"/>
    <symbolinfo name="toys" entity="e332"/>
    <symbolinfo name="toys_fan" entity="f887"/>
    <symbolinfo name="track_changes" entity="e8e1"/>
    <symbolinfo name="traffic" entity="e565"/>
    <symbolinfo name="trail_length" entity="eb5e"/>
    <symbolinfo name="trail_length_medium" entity="eb63"/>
    <symbolinfo name="trail_length_short" entity="eb6d"/>
    <symbolinfo name="train" entity="e570"/>
    <symbolinfo name="tram" entity="e571"/>
    <symbolinfo name="transcribe" entity="f8ec"/>
    <symbolinfo name="transfer_within_a_station" entity="e572"/>
    <symbolinfo name="transform" entity="e428"/>
    <symbolinfo name="transgender" entity="e58d"/>
    <symbolinfo name="transit_enterexit" entity="e579"/>
    <symbolinfo name="translate" entity="e8e2"/>
    <symbolinfo name="transportation" entity="e21d"/>
    <symbolinfo name="travel" entity="ef93"/>
    <symbolinfo name="travel_explore" entity="e2db"/>
    <symbolinfo name="trending_down" entity="e8e3"/>
    <symbolinfo name="trending_flat" entity="e8e4"/>
    <symbolinfo name="trending_up" entity="e8e5"/>
    <symbolinfo name="trip_origin" entity="e57b"/>
    <symbolinfo name="trolley" entity="f86b"/>
    <symbolinfo name="trophy" entity="ea23"/>
    <symbolinfo name="troubleshoot" entity="e1d2"/>
    <symbolinfo name="try" entity="f07c"/>
    <symbolinfo name="tsunami" entity="ebd8"/>
    <symbolinfo name="tsv" entity="e6d6"/>
    <symbolinfo name="tty" entity="f1aa"/>
    <symbolinfo name="tune" entity="e429"/>
    <symbolinfo name="tungsten" entity="f07d"/>
    <symbolinfo name="turn_left" entity="eba6"/>
    <symbolinfo name="turn_right" entity="ebab"/>
    <symbolinfo name="turn_sharp_left" entity="eba7"/>
    <symbolinfo name="turn_sharp_right" entity="ebaa"/>
    <symbolinfo name="turn_slight_left" entity="eba4"/>
    <symbolinfo name="turn_slight_right" entity="eb9a"/>
    <symbolinfo name="turned_in" entity="e8e7"/>
    <symbolinfo name="turned_in_not" entity="e8e7"/>
    <symbolinfo name="tv" entity="e63b"/>
    <symbolinfo name="tv_gen" entity="e830"/>
    <symbolinfo name="tv_guide" entity="e1dc"/>
    <symbolinfo name="tv_off" entity="e647"/>
    <symbolinfo name="tv_options_edit_channels" entity="e1dd"/>
    <symbolinfo name="tv_remote" entity="f5d9"/>
    <symbolinfo name="tv_signin" entity="e71b"/>
    <symbolinfo name="tv_with_assistant" entity="e785"/>
    <symbolinfo name="two_wheeler" entity="e9f9"/>
    <symbolinfo name="type_specimen" entity="f8f0"/>
    <symbolinfo name="u_turn_left" entity="eba1"/>
    <symbolinfo name="u_turn_right" entity="eba2"/>
    <symbolinfo name="ulna_radius" entity="f89d"/>
    <symbolinfo name="ulna_radius_alt" entity="f89e"/>
    <symbolinfo name="umbrella" entity="f1ad"/>
    <symbolinfo name="unarchive" entity="e169"/>
    <symbolinfo name="undo" entity="e166"/>
    <symbolinfo name="unfold_less" entity="e5d6"/>
    <symbolinfo name="unfold_less_double" entity="f8cf"/>
    <symbolinfo name="unfold_more" entity="e5d7"/>
    <symbolinfo name="unfold_more_double" entity="f8d0"/>
    <symbolinfo name="ungroup" entity="f731"/>
    <symbolinfo name="universal_currency_alt" entity="e734"/>
    <symbolinfo name="unknown_2" entity="e6a2"/>
    <symbolinfo name="unknown_5" entity="e6a5"/>
    <symbolinfo name="unknown_document" entity="f804"/>
    <symbolinfo name="unknown_med" entity="eabd"/>
    <symbolinfo name="unpublished" entity="f236"/>
    <symbolinfo name="unsubscribe" entity="e0eb"/>
    <symbolinfo name="upcoming" entity="f07e"/>
    <symbolinfo name="update" entity="e923"/>
    <symbolinfo name="update_disabled" entity="e075"/>
    <symbolinfo name="upgrade" entity="f0fb"/>
    <symbolinfo name="upload" entity="f09b"/>
    <symbolinfo name="upload_file" entity="e9fc"/>
    <symbolinfo name="urology" entity="e137"/>
    <symbolinfo name="usb" entity="e1e0"/>
    <symbolinfo name="usb_off" entity="e4fa"/>
    <symbolinfo name="vaccines" entity="e138"/>
    <symbolinfo name="valve" entity="e224"/>
    <symbolinfo name="vape_free" entity="ebc6"/>
    <symbolinfo name="vaping_rooms" entity="ebcf"/>
    <symbolinfo name="variables" entity="f851"/>
    <symbolinfo name="ventilator" entity="e139"/>
    <symbolinfo name="verified" entity="ef76"/>
    <symbolinfo name="verified_user" entity="f013"/>
    <symbolinfo name="vertical_align_bottom" entity="e258"/>
    <symbolinfo name="vertical_align_center" entity="e259"/>
    <symbolinfo name="vertical_align_top" entity="e25a"/>
    <symbolinfo name="vertical_distribute" entity="e076"/>
    <symbolinfo name="vertical_shades" entity="ec0e"/>
    <symbolinfo name="vertical_shades_closed" entity="ec0d"/>
    <symbolinfo name="vertical_split" entity="e949"/>
    <symbolinfo name="vibration" entity="e62d"/>
    <symbolinfo name="video_call" entity="e070"/>
    <symbolinfo name="video_camera_back" entity="f07f"/>
    <symbolinfo name="video_camera_front" entity="f080"/>
    <symbolinfo name="video_camera_front_off" entity="f83b"/>
    <symbolinfo name="video_chat" entity="f8a0"/>
    <symbolinfo name="video_file" entity="eb87"/>
    <symbolinfo name="video_label" entity="e071"/>
    <symbolinfo name="video_library" entity="e04a"/>
    <symbolinfo name="video_search" entity="efc6"/>
    <symbolinfo name="video_settings" entity="ea75"/>
    <symbolinfo name="video_stable" entity="f081"/>
    <symbolinfo name="videocam" entity="e04b"/>
    <symbolinfo name="videocam_off" entity="e04c"/>
    <symbolinfo name="videogame_asset" entity="e338"/>
    <symbolinfo name="videogame_asset_off" entity="e500"/>
    <symbolinfo name="view_agenda" entity="e8e9"/>
    <symbolinfo name="view_array" entity="e8ea"/>
    <symbolinfo name="view_carousel" entity="e8eb"/>
    <symbolinfo name="view_column" entity="e8ec"/>
    <symbolinfo name="view_column_2" entity="f847"/>
    <symbolinfo name="view_comfy" entity="e42a"/>
    <symbolinfo name="view_comfy_alt" entity="eb73"/>
    <symbolinfo name="view_compact" entity="e42b"/>
    <symbolinfo name="view_compact_alt" entity="eb74"/>
    <symbolinfo name="view_cozy" entity="eb75"/>
    <symbolinfo name="view_day" entity="e8ed"/>
    <symbolinfo name="view_headline" entity="e8ee"/>
    <symbolinfo name="view_in_ar" entity="efc9"/>
    <symbolinfo name="view_in_ar_new" entity="efc9"/>
    <symbolinfo name="view_in_ar_off" entity="f61b"/>
    <symbolinfo name="view_kanban" entity="eb7f"/>
    <symbolinfo name="view_list" entity="e8ef"/>
    <symbolinfo name="view_module" entity="e8f0"/>
    <symbolinfo name="view_quilt" entity="e8f1"/>
    <symbolinfo name="view_sidebar" entity="f114"/>
    <symbolinfo name="view_stream" entity="e8f2"/>
    <symbolinfo name="view_timeline" entity="eb85"/>
    <symbolinfo name="view_week" entity="e8f3"/>
    <symbolinfo name="vignette" entity="e435"/>
    <symbolinfo name="villa" entity="e586"/>
    <symbolinfo name="visibility" entity="e8f4"/>
    <symbolinfo name="visibility_lock" entity="f653"/>
    <symbolinfo name="visibility_off" entity="e8f5"/>
    <symbolinfo name="vital_signs" entity="e650"/>
    <symbolinfo name="vitals" entity="e13b"/>
    <symbolinfo name="voice_chat" entity="e62e"/>
    <symbolinfo name="voice_over_off" entity="e94a"/>
    <symbolinfo name="voice_selection" entity="f58a"/>
    <symbolinfo name="voicemail" entity="e0d9"/>
    <symbolinfo name="volcano" entity="ebda"/>
    <symbolinfo name="volume_down" entity="e04d"/>
    <symbolinfo name="volume_down_alt" entity="e79c"/>
    <symbolinfo name="volume_mute" entity="e04e"/>
    <symbolinfo name="volume_off" entity="e04f"/>
    <symbolinfo name="volume_up" entity="e050"/>
    <symbolinfo name="volunteer_activism" entity="ea70"/>
    <symbolinfo name="voting_chip" entity="f852"/>
    <symbolinfo name="vpn_key" entity="e0da"/>
    <symbolinfo name="vpn_key_alert" entity="f6cc"/>
    <symbolinfo name="vpn_key_off" entity="eb7a"/>
    <symbolinfo name="vpn_lock" entity="e62f"/>
    <symbolinfo name="vr180_create2d" entity="efca"/>
    <symbolinfo name="vr180_create2d_off" entity="f571"/>
    <symbolinfo name="vrpano" entity="f082"/>
    <symbolinfo name="wall_art" entity="efcb"/>
    <symbolinfo name="wall_lamp" entity="e2b4"/>
    <symbolinfo name="wallet" entity="f8ff"/>
    <symbolinfo name="wallpaper" entity="e1bc"/>
    <symbolinfo name="wallpaper_slideshow" entity="f672"/>
    <symbolinfo name="ward" entity="e13c"/>
    <symbolinfo name="warehouse" entity="ebb8"/>
    <symbolinfo name="warning" entity="f083"/>
    <symbolinfo name="warning_amber" entity="f083"/>
    <symbolinfo name="warning_off" entity="f7ad"/>
    <symbolinfo name="wash" entity="f1b1"/>
    <symbolinfo name="watch" entity="e334"/>
    <symbolinfo name="watch_button_press" entity="f6aa"/>
    <symbolinfo name="watch_later" entity="efd6"/>
    <symbolinfo name="watch_off" entity="eae3"/>
    <symbolinfo name="watch_screentime" entity="f6ae"/>
    <symbolinfo name="watch_wake" entity="f6a9"/>
    <symbolinfo name="water" entity="f084"/>
    <symbolinfo name="water_bottle" entity="f69d"/>
    <symbolinfo name="water_bottle_large" entity="f69e"/>
    <symbolinfo name="water_damage" entity="f203"/>
    <symbolinfo name="water_do" entity="f870"/>
    <symbolinfo name="water_drop" entity="e798"/>
    <symbolinfo name="water_ec" entity="f875"/>
    <symbolinfo name="water_full" entity="f6d6"/>
    <symbolinfo name="water_heater" entity="e284"/>
    <symbolinfo name="water_lock" entity="f6ad"/>
    <symbolinfo name="water_loss" entity="f6d5"/>
    <symbolinfo name="water_lux" entity="f874"/>
    <symbolinfo name="water_medium" entity="f6d4"/>
    <symbolinfo name="water_orp" entity="f878"/>
    <symbolinfo name="water_ph" entity="f87a"/>
    <symbolinfo name="water_pump" entity="f5d8"/>
    <symbolinfo name="water_voc" entity="f87b"/>
    <symbolinfo name="waterfall_chart" entity="ea00"/>
    <symbolinfo name="waves" entity="e176"/>
    <symbolinfo name="waving_hand" entity="e766"/>
    <symbolinfo name="wb_auto" entity="e42c"/>
    <symbolinfo name="wb_cloudy" entity="f15c"/>
    <symbolinfo name="wb_incandescent" entity="e42e"/>
    <symbolinfo name="wb_iridescent" entity="f07d"/>
    <symbolinfo name="wb_shade" entity="ea01"/>
    <symbolinfo name="wb_sunny" entity="e430"/>
    <symbolinfo name="wb_twilight" entity="e1c6"/>
    <symbolinfo name="wc" entity="e63d"/>
    <symbolinfo name="weather_hail" entity="f67f"/>
    <symbolinfo name="weather_mix" entity="f60b"/>
    <symbolinfo name="weather_snowy" entity="e2cd"/>
    <symbolinfo name="web" entity="e051"/>
    <symbolinfo name="web_asset" entity="e069"/>
    <symbolinfo name="web_asset_off" entity="ef47"/>
    <symbolinfo name="web_stories" entity="e595"/>
    <symbolinfo name="webhook" entity="eb92"/>
    <symbolinfo name="weekend" entity="e16b"/>
    <symbolinfo name="weight" entity="e13d"/>
    <symbolinfo name="west" entity="f1e6"/>
    <symbolinfo name="whatshot" entity="e80e"/>
    <symbolinfo name="wheelchair_pickup" entity="f1ab"/>
    <symbolinfo name="where_to_vote" entity="e177"/>
    <symbolinfo name="widgets" entity="e1bd"/>
    <symbolinfo name="width" entity="f730"/>
    <symbolinfo name="width_full" entity="f8f5"/>
    <symbolinfo name="width_normal" entity="f8f6"/>
    <symbolinfo name="width_wide" entity="f8f7"/>
    <symbolinfo name="wifi" entity="e63e"/>
    <symbolinfo name="wifi_1_bar" entity="e4ca"/>
    <symbolinfo name="wifi_2_bar" entity="e4d9"/>
    <symbolinfo name="wifi_add" entity="f7a8"/>
    <symbolinfo name="wifi_calling" entity="ef77"/>
    <symbolinfo name="wifi_calling_1" entity="f0f6"/>
    <symbolinfo name="wifi_calling_2" entity="f0f6"/>
    <symbolinfo name="wifi_calling_3" entity="f0f6"/>
    <symbolinfo name="wifi_channel" entity="eb6a"/>
    <symbolinfo name="wifi_find" entity="eb31"/>
    <symbolinfo name="wifi_home" entity="f671"/>
    <symbolinfo name="wifi_lock" entity="e1e1"/>
    <symbolinfo name="wifi_notification" entity="f670"/>
    <symbolinfo name="wifi_off" entity="e648"/>
    <symbolinfo name="wifi_password" entity="eb6b"/>
    <symbolinfo name="wifi_protected_setup" entity="f0fc"/>
    <symbolinfo name="wifi_proxy" entity="f7a7"/>
    <symbolinfo name="wifi_tethering" entity="e1e2"/>
    <symbolinfo name="wifi_tethering_error" entity="ead9"/>
    <symbolinfo name="wifi_tethering_off" entity="f087"/>
    <symbolinfo name="wind_power" entity="ec0c"/>
    <symbolinfo name="window" entity="f088"/>
    <symbolinfo name="window_closed" entity="e77e"/>
    <symbolinfo name="window_open" entity="e78c"/>
    <symbolinfo name="window_sensor" entity="e2bb"/>
    <symbolinfo name="wine_bar" entity="f1e8"/>
    <symbolinfo name="woman" entity="e13e"/>
    <symbolinfo name="woman_2" entity="f8e7"/>
    <symbolinfo name="work" entity="e943"/>
    <symbolinfo name="work_alert" entity="f5f7"/>
    <symbolinfo name="work_history" entity="ec09"/>
    <symbolinfo name="work_off" entity="e942"/>
    <symbolinfo name="work_outline" entity="e943"/>
    <symbolinfo name="work_update" entity="f5f8"/>
    <symbolinfo name="workflow" entity="ea04"/>
    <symbolinfo name="workspace_premium" entity="e7af"/>
    <symbolinfo name="workspaces" entity="ea0f"/>
    <symbolinfo name="workspaces_outline" entity="ea0f"/>
    <symbolinfo name="wounds_injuries" entity="e13f"/>
    <symbolinfo name="wrap_text" entity="e25b"/>
    <symbolinfo name="wrist" entity="f69c"/>
    <symbolinfo name="wrong_location" entity="ef78"/>
    <symbolinfo name="wysiwyg" entity="f1c3"/>
    <symbolinfo name="yard" entity="f089"/>
    <symbolinfo name="your_trips" entity="eb2b"/>
    <symbolinfo name="youtube_activity" entity="f85a"/>
    <symbolinfo name="youtube_searched_for" entity="e8fa"/>
    <symbolinfo name="zone_person_alert" entity="e781"/>
    <symbolinfo name="zone_person_idle" entity="e77a"/>
    <symbolinfo name="zone_person_urgent" entity="e788"/>
    <symbolinfo name="zoom_in" entity="e8ff"/>
    <symbolinfo name="zoom_in_map" entity="eb2d"/>
    <symbolinfo name="zoom_out" entity="e900"/>
    <symbolinfo name="zoom_out_map" entity="e56b"/>
</xsl:variable>

</xsl:stylesheet>