"""
Django settings for unicom_project project.

Generated by 'django-admin startproject' using Django 4.2.20.

For more information on this file, see
https://docs.djangoproject.com/en/4.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/4.2/ref/settings/
"""

from pathlib import Path
from dotenv import load_dotenv
from urllib.parse import urlparse
import os
import sys


# Load env from db.env if exists
load_dotenv(dotenv_path=Path(__file__).resolve().parent.parent / 'db.env', override=True)

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


UNICOM_TINYMCE_API_KEY = "47omvjk8csmi1w7xy7tew3vgivvfsut62b1zjsmm8p9ya95z"

# Load OpenAI API key from .env
OPENAI_API_KEY = os.environ.get('OPENAI_API_KEY', '')

# Credential encryption key (URL-safe base64-encoded 32-byte key)
CREDENTIAL_ENCRYPTION_KEY = os.environ.get('CREDENTIAL_ENCRYPTION_KEY')

# Directory containing tool and bot definitions for sync command
UNIBOT_DEFINITIONS_DIR = BASE_DIR / 'unicom_project' / 'definitions'

MEDIA_URL = '/media/'
MEDIA_ROOT = os.path.join(BASE_DIR, '')


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/4.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'INSECURE_DJANGO_SECRET_KEY_FOR_TESTING_ONLY'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

origin = os.environ.get('DJANGO_PUBLIC_ORIGIN', 'localhost')

print(f"DJANGO_PUBLIC_ORIGIN: {origin}")
parsed = urlparse(origin)
ALLOWED_HOSTS = [parsed.hostname] if parsed.hostname else []

CSRF_TRUSTED_ORIGINS = [origin] if origin else []


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django_ace',
    'unicom',  # Required dependency for unibot
    'unibot',
    'reversion',  # Required for model versioning
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'reversion.middleware.RevisionMiddleware',
]

ROOT_URLCONF = 'unicom_project.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'unicom_project.wsgi.application'


# Database
# https://docs.djangoproject.com/en/4.2/ref/settings/#databases

# Detect Docker (use an env var or hostname trick)
IS_DOCKER = os.environ.get("DOCKER") == "true"
DB_NAME = 'temp_unicom_test' if "pytest" in sys.argv[0] else os.environ["POSTGRES_DB"]

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.postgresql',
        'NAME': DB_NAME,
        'USER': os.environ.get('POSTGRES_USER', 'unicom'),
        'PASSWORD': os.environ.get('POSTGRES_PASSWORD', 'password'),
        'HOST': os.environ.get('POSTGRES_HOST', 'db' if IS_DOCKER else 'localhost'),
        'PORT': os.environ.get('POSTGRES_PORT', '5432') if IS_DOCKER else '6432',
    }
}


# Password validation
# https://docs.djangoproject.com/en/4.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/4.2/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/4.2/howto/static-files/

STATIC_URL = 'static/'

# Default primary key field type
# https://docs.djangoproject.com/en/4.2/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'
