# SPDX-FileCopyrightText: 2024 Justin Myers
#
# SPDX-License-Identifier: MIT
"""
Board stub for NUCLEO STM32F746
 - port: stm
 - board_id: nucleo_f746zg
 - NVM size: Unknown
 - Included modules: _asyncio, _bleio, _bleio (HCI co-processor), _pixelmap, adafruit_bus_device, adafruit_pixelbuf, aesio, array, atexit, binascii, bitbangio, bitmapfilter, bitmaptools, board, builtins, builtins.pow3, busdisplay, busio, busio.SPI, busio.UART, codeop, collections, digitalio, displayio, epaperdisplay, errno, fontio, fourwire, framebufferio, getpass, gifio, i2cdisplaybus, io, jpegio, json, keypad, keypad.KeyMatrix, keypad.Keys, keypad.ShiftRegisterKeys, keypad_demux, keypad_demux.DemuxKeyMatrix, locale, lvfontio, math, microcontroller, msgpack, onewireio, os, os.getenv, pulseio, pwmio, rainbowio, random, re, rtc, sdcardio, select, sharpdisplay, storage, struct, supervisor, sys, terminalio, tilepalettemapper, time, touchio, traceback, ulab, usb_cdc, usb_hid, usb_midi, vectorio, warnings, zlib
 - Frozen libraries: 
"""

# Imports
import microcontroller


# Board Info:
board_id: str


# Pins:
A0: microcontroller.Pin  # PA03
A1: microcontroller.Pin  # PC00
A2: microcontroller.Pin  # PC03
A3: microcontroller.Pin  # PF03
A4: microcontroller.Pin  # PF05
A5: microcontroller.Pin  # PF10
D0: microcontroller.Pin  # PG09
D1: microcontroller.Pin  # PG14
D2: microcontroller.Pin  # PF15
D3: microcontroller.Pin  # PE13
D4: microcontroller.Pin  # PF14
D5: microcontroller.Pin  # PE11
D6: microcontroller.Pin  # PE09
D7: microcontroller.Pin  # PF13
D8: microcontroller.Pin  # PF12
D9: microcontroller.Pin  # PD15
D10: microcontroller.Pin  # PD14
D11: microcontroller.Pin  # PA07
D12: microcontroller.Pin  # PA06
D13: microcontroller.Pin  # PA05
D14: microcontroller.Pin  # PB09
D15: microcontroller.Pin  # PB08
D16: microcontroller.Pin  # PC06
D17: microcontroller.Pin  # PB15
D18: microcontroller.Pin  # PB13
D19: microcontroller.Pin  # PB12
D20: microcontroller.Pin  # PA15
D21: microcontroller.Pin  # PC07
D22: microcontroller.Pin  # PB05
D23: microcontroller.Pin  # PB03
D24: microcontroller.Pin  # PA04
D25: microcontroller.Pin  # PB04
LED1: microcontroller.Pin  # PB00
LED2: microcontroller.Pin  # PB07
LED3: microcontroller.Pin  # PB14
SW: microcontroller.Pin  # PC13
TP1: microcontroller.Pin  # PH02
TP2: microcontroller.Pin  # PI08
TP3: microcontroller.Pin  # PH15
AUDIO_INT: microcontroller.Pin  # PD06
AUDIO_SDA: microcontroller.Pin  # PH08
AUDIO_SCL: microcontroller.Pin  # PH07
EXT_SDA: microcontroller.Pin  # PB09
EXT_SCL: microcontroller.Pin  # PB08
EXT_RST: microcontroller.Pin  # PG03
SD_SW: microcontroller.Pin  # PC13
LCD_BL_CTRL: microcontroller.Pin  # PK03
LCD_INT: microcontroller.Pin  # PI13
LCD_SDA: microcontroller.Pin  # PH08
LCD_SCL: microcontroller.Pin  # PH07
OTG_FS_POWER: microcontroller.Pin  # PD05
OTG_FS_OVER_CURRENT: microcontroller.Pin  # PD04
OTG_HS_OVER_CURRENT: microcontroller.Pin  # PE03
USB_VBUS: microcontroller.Pin  # PA09
USB_ID: microcontroller.Pin  # PA10
USB_DM: microcontroller.Pin  # PA11
USB_DP: microcontroller.Pin  # PA12
UART2_TX: microcontroller.Pin  # PD05
UART2_RX: microcontroller.Pin  # PD06
UART2_RTS: microcontroller.Pin  # PD04
UART2_CTS: microcontroller.Pin  # PD03
UART6_TX: microcontroller.Pin  # PG14
UART6_RX: microcontroller.Pin  # PG09
SPI_B_NSS: microcontroller.Pin  # PA04
SPI_B_SCK: microcontroller.Pin  # PB03
SPI_B_MOSI: microcontroller.Pin  # PB05


# Members:

# Unmapped:
#   none
