"""deprecate_current_pref_v1

Revision ID: 23e01f8f4652
Revises: 9e83545ed9b6
Create Date: 2024-04-29 23:16:41.909736

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "23e01f8f4652"
down_revision = "9e83545ed9b6"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_lastservednotice_created_at", table_name="lastservednotice")
    op.drop_index("ix_lastservednotice_feature", table_name="lastservednotice")
    op.drop_index(
        "ix_lastservednotice_fides_user_device_provided_identity_id",
        table_name="lastservednotice",
    )
    op.drop_index("ix_lastservednotice_id", table_name="lastservednotice")
    op.drop_index(
        "ix_lastservednotice_privacy_notice_history_id", table_name="lastservednotice"
    )
    op.drop_index(
        "ix_lastservednotice_privacy_notice_id", table_name="lastservednotice"
    )
    op.drop_index(
        "ix_lastservednotice_provided_identity_id", table_name="lastservednotice"
    )
    op.drop_index("ix_lastservednotice_purpose_consent", table_name="lastservednotice")
    op.drop_index(
        "ix_lastservednotice_purpose_legitimate_interests",
        table_name="lastservednotice",
    )
    op.drop_index("ix_lastservednotice_special_feature", table_name="lastservednotice")
    op.drop_index("ix_lastservednotice_special_purpose", table_name="lastservednotice")
    op.drop_index("ix_lastservednotice_system_consent", table_name="lastservednotice")
    op.drop_index(
        "ix_lastservednotice_system_legitimate_interests", table_name="lastservednotice"
    )
    op.drop_index("ix_lastservednotice_updated_at", table_name="lastservednotice")
    op.drop_index("ix_lastservednotice_vendor_consent", table_name="lastservednotice")
    op.drop_index(
        "ix_lastservednotice_vendor_legitimate_interests", table_name="lastservednotice"
    )
    op.drop_table("lastservednotice")
    op.drop_index(
        "ix_currentprivacypreference_created_at", table_name="currentprivacypreference"
    )
    op.drop_index(
        "ix_currentprivacypreference_feature", table_name="currentprivacypreference"
    )
    op.drop_index(
        "ix_currentprivacypreference_fides_user_device_provided__d6ea",
        table_name="currentprivacypreference",
    )
    op.drop_index(
        "ix_currentprivacypreference_id", table_name="currentprivacypreference"
    )
    op.drop_index(
        "ix_currentprivacypreference_preference", table_name="currentprivacypreference"
    )
    op.drop_index(
        "ix_currentprivacypreference_privacy_notice_history_id",
        table_name="currentprivacypreference",
    )
    op.drop_index(
        "ix_currentprivacypreference_privacy_notice_id",
        table_name="currentprivacypreference",
    )
    op.drop_index(
        "ix_currentprivacypreference_provided_identity_id",
        table_name="currentprivacypreference",
    )
    op.drop_index(
        "ix_currentprivacypreference_purpose_consent",
        table_name="currentprivacypreference",
    )
    op.drop_index(
        "ix_currentprivacypreference_purpose_legitimate_interests",
        table_name="currentprivacypreference",
    )
    op.drop_index(
        "ix_currentprivacypreference_special_feature",
        table_name="currentprivacypreference",
    )
    op.drop_index(
        "ix_currentprivacypreference_special_purpose",
        table_name="currentprivacypreference",
    )
    op.drop_index(
        "ix_currentprivacypreference_system_consent",
        table_name="currentprivacypreference",
    )
    op.drop_index(
        "ix_currentprivacypreference_system_legitimate_interests",
        table_name="currentprivacypreference",
    )
    op.drop_index(
        "ix_currentprivacypreference_updated_at", table_name="currentprivacypreference"
    )
    op.drop_index(
        "ix_currentprivacypreference_vendor_consent",
        table_name="currentprivacypreference",
    )
    op.drop_index(
        "ix_currentprivacypreference_vendor_legitimate_interests",
        table_name="currentprivacypreference",
    )
    op.drop_table("currentprivacypreference")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "currentprivacypreference",
        sa.Column("id", sa.VARCHAR(length=255), autoincrement=False, nullable=False),
        sa.Column(
            "created_at",
            postgresql.TIMESTAMP(timezone=True),
            server_default=sa.text("now()"),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            postgresql.TIMESTAMP(timezone=True),
            server_default=sa.text("now()"),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column("preference", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column(
            "provided_identity_id", sa.VARCHAR(), autoincrement=False, nullable=True
        ),
        sa.Column(
            "privacy_notice_id", sa.VARCHAR(), autoincrement=False, nullable=True
        ),
        sa.Column(
            "privacy_notice_history_id",
            sa.VARCHAR(),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "fides_user_device_provided_identity_id",
            sa.VARCHAR(),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column("tcf_version", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column("feature", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("special_feature", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("special_purpose", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("purpose_consent", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column(
            "purpose_legitimate_interests",
            sa.INTEGER(),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column("vendor_consent", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column(
            "vendor_legitimate_interests",
            sa.VARCHAR(),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column("system_consent", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column(
            "system_legitimate_interests",
            sa.VARCHAR(),
            autoincrement=False,
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["fides_user_device_provided_identity_id"],
            ["providedidentity.id"],
            name="currentprivacypreference_fides_user_device_provided_identi_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["privacy_notice_history_id"],
            ["privacynoticehistory.id"],
            name="currentprivacypreference_privacy_notice_history_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["privacy_notice_id"],
            ["privacynotice.id"],
            name="currentprivacypreference_privacy_notice_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["provided_identity_id"],
            ["providedidentity.id"],
            name="currentprivacypreference_provided_identity_id_fkey",
        ),
        sa.PrimaryKeyConstraint("id", name="currentprivacypreference_pkey"),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "feature",
            name="fides_user_device_identity_feature",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "privacy_notice_id",
            name="fides_user_device_identity_privacy_notice",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "purpose_consent",
            name="fides_user_device_identity_purpose_consent",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "purpose_legitimate_interests",
            name="fides_user_device_identity_purpose_leg_interests",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "special_feature",
            name="fides_user_device_identity_special_feature",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "special_purpose",
            name="fides_user_device_identity_special_purpose",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "system_consent",
            name="fides_user_device_identity_system_consent",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "system_legitimate_interests",
            name="fides_user_device_identity_system_leg_interests",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "vendor_consent",
            name="fides_user_device_identity_vendor_consent",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "vendor_legitimate_interests",
            name="fides_user_device_identity_vendor_leg_interests",
        ),
        sa.UniqueConstraint("provided_identity_id", "feature", name="identity_feature"),
        sa.UniqueConstraint(
            "provided_identity_id", "privacy_notice_id", name="identity_privacy_notice"
        ),
        sa.UniqueConstraint(
            "provided_identity_id", "purpose_consent", name="identity_purpose_consent"
        ),
        sa.UniqueConstraint(
            "provided_identity_id",
            "purpose_legitimate_interests",
            name="identity_purpose_leg_interests",
        ),
        sa.UniqueConstraint(
            "provided_identity_id", "special_feature", name="identity_special_feature"
        ),
        sa.UniqueConstraint(
            "provided_identity_id", "special_purpose", name="identity_special_purpose"
        ),
        sa.UniqueConstraint(
            "provided_identity_id", "system_consent", name="identity_system_consent"
        ),
        sa.UniqueConstraint(
            "provided_identity_id",
            "system_legitimate_interests",
            name="identity_system_leg_interests",
        ),
        sa.UniqueConstraint(
            "provided_identity_id", "vendor_consent", name="identity_vendor_consent"
        ),
        sa.UniqueConstraint(
            "provided_identity_id",
            "vendor_legitimate_interests",
            name="identity_vendor_leg_interests",
        ),
    )
    op.create_index(
        "ix_currentprivacypreference_vendor_legitimate_interests",
        "currentprivacypreference",
        ["vendor_legitimate_interests"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_vendor_consent",
        "currentprivacypreference",
        ["vendor_consent"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_updated_at",
        "currentprivacypreference",
        ["updated_at"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_system_legitimate_interests",
        "currentprivacypreference",
        ["system_legitimate_interests"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_system_consent",
        "currentprivacypreference",
        ["system_consent"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_special_purpose",
        "currentprivacypreference",
        ["special_purpose"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_special_feature",
        "currentprivacypreference",
        ["special_feature"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_purpose_legitimate_interests",
        "currentprivacypreference",
        ["purpose_legitimate_interests"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_purpose_consent",
        "currentprivacypreference",
        ["purpose_consent"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_provided_identity_id",
        "currentprivacypreference",
        ["provided_identity_id"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_privacy_notice_id",
        "currentprivacypreference",
        ["privacy_notice_id"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_privacy_notice_history_id",
        "currentprivacypreference",
        ["privacy_notice_history_id"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_preference",
        "currentprivacypreference",
        ["preference"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_id",
        "currentprivacypreference",
        ["id"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_fides_user_device_provided__d6ea",
        "currentprivacypreference",
        ["fides_user_device_provided_identity_id"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_feature",
        "currentprivacypreference",
        ["feature"],
        unique=False,
    )
    op.create_index(
        "ix_currentprivacypreference_created_at",
        "currentprivacypreference",
        ["created_at"],
        unique=False,
    )
    op.create_table(
        "lastservednotice",
        sa.Column("id", sa.VARCHAR(length=255), autoincrement=False, nullable=False),
        sa.Column(
            "created_at",
            postgresql.TIMESTAMP(timezone=True),
            server_default=sa.text("now()"),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            postgresql.TIMESTAMP(timezone=True),
            server_default=sa.text("now()"),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "provided_identity_id", sa.VARCHAR(), autoincrement=False, nullable=True
        ),
        sa.Column(
            "fides_user_device_provided_identity_id",
            sa.VARCHAR(),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "privacy_notice_id", sa.VARCHAR(), autoincrement=False, nullable=True
        ),
        sa.Column(
            "privacy_notice_history_id",
            sa.VARCHAR(),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column("tcf_version", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column("feature", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("special_feature", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("special_purpose", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("purpose_consent", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column(
            "purpose_legitimate_interests",
            sa.INTEGER(),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column("vendor_consent", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column(
            "vendor_legitimate_interests",
            sa.VARCHAR(),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column("system_consent", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column(
            "system_legitimate_interests",
            sa.VARCHAR(),
            autoincrement=False,
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["fides_user_device_provided_identity_id"],
            ["providedidentity.id"],
            name="lastservednotice_fides_user_device_provided_identity_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["privacy_notice_history_id"],
            ["privacynoticehistory.id"],
            name="lastservednotice_privacy_notice_history_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["privacy_notice_id"],
            ["privacynotice.id"],
            name="lastservednotice_privacy_notice_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["provided_identity_id"],
            ["providedidentity.id"],
            name="lastservednotice_provided_identity_id_fkey",
        ),
        sa.PrimaryKeyConstraint("id", name="lastservednotice_pkey"),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "feature",
            name="last_served_fides_user_device_identity_feature",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "privacy_notice_id",
            name="last_served_fides_user_device_identity_privacy_notice",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "purpose_consent",
            name="last_served_fides_user_device_identity_purpose_consent",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "purpose_legitimate_interests",
            name="last_served_fides_user_device_identity_purpose_leg_interests",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "special_feature",
            name="last_served_fides_user_device_identity_special_feature",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "special_purpose",
            name="last_served_fides_user_device_identity_special_purpose",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "system_consent",
            name="last_served_fides_user_device_identity_system_consent",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "system_legitimate_interests",
            name="last_served_fides_user_device_identity_system_leg_interests",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "vendor_consent",
            name="last_served_fides_user_device_identity_vendor_consent",
        ),
        sa.UniqueConstraint(
            "fides_user_device_provided_identity_id",
            "vendor_legitimate_interests",
            name="last_served_fides_user_device_identity_vendor_leg_interests",
        ),
        sa.UniqueConstraint(
            "provided_identity_id", "feature", name="last_served_identity_feature"
        ),
        sa.UniqueConstraint(
            "provided_identity_id",
            "privacy_notice_id",
            name="last_served_identity_privacy_notice",
        ),
        sa.UniqueConstraint(
            "provided_identity_id",
            "purpose_consent",
            name="last_served_identity_purpose_consent",
        ),
        sa.UniqueConstraint(
            "provided_identity_id",
            "purpose_legitimate_interests",
            name="last_served_identity_purpose_legitimate_interests",
        ),
        sa.UniqueConstraint(
            "provided_identity_id",
            "special_feature",
            name="last_served_identity_special_feature",
        ),
        sa.UniqueConstraint(
            "provided_identity_id",
            "special_purpose",
            name="last_served_identity_special_purpose",
        ),
        sa.UniqueConstraint(
            "provided_identity_id",
            "system_consent",
            name="last_served_identity_system_consent",
        ),
        sa.UniqueConstraint(
            "provided_identity_id",
            "system_legitimate_interests",
            name="last_served_identity_system_leg_interests",
        ),
        sa.UniqueConstraint(
            "provided_identity_id",
            "vendor_consent",
            name="last_served_identity_vendor_consent",
        ),
        sa.UniqueConstraint(
            "provided_identity_id",
            "vendor_legitimate_interests",
            name="last_served_identity_vendor_leg_interests",
        ),
    )
    op.create_index(
        "ix_lastservednotice_vendor_legitimate_interests",
        "lastservednotice",
        ["vendor_legitimate_interests"],
        unique=False,
    )
    op.create_index(
        "ix_lastservednotice_vendor_consent",
        "lastservednotice",
        ["vendor_consent"],
        unique=False,
    )
    op.create_index(
        "ix_lastservednotice_updated_at",
        "lastservednotice",
        ["updated_at"],
        unique=False,
    )
    op.create_index(
        "ix_lastservednotice_system_legitimate_interests",
        "lastservednotice",
        ["system_legitimate_interests"],
        unique=False,
    )
    op.create_index(
        "ix_lastservednotice_system_consent",
        "lastservednotice",
        ["system_consent"],
        unique=False,
    )
    op.create_index(
        "ix_lastservednotice_special_purpose",
        "lastservednotice",
        ["special_purpose"],
        unique=False,
    )
    op.create_index(
        "ix_lastservednotice_special_feature",
        "lastservednotice",
        ["special_feature"],
        unique=False,
    )
    op.create_index(
        "ix_lastservednotice_purpose_legitimate_interests",
        "lastservednotice",
        ["purpose_legitimate_interests"],
        unique=False,
    )
    op.create_index(
        "ix_lastservednotice_purpose_consent",
        "lastservednotice",
        ["purpose_consent"],
        unique=False,
    )
    op.create_index(
        "ix_lastservednotice_provided_identity_id",
        "lastservednotice",
        ["provided_identity_id"],
        unique=False,
    )
    op.create_index(
        "ix_lastservednotice_privacy_notice_id",
        "lastservednotice",
        ["privacy_notice_id"],
        unique=False,
    )
    op.create_index(
        "ix_lastservednotice_privacy_notice_history_id",
        "lastservednotice",
        ["privacy_notice_history_id"],
        unique=False,
    )
    op.create_index("ix_lastservednotice_id", "lastservednotice", ["id"], unique=False)
    op.create_index(
        "ix_lastservednotice_fides_user_device_provided_identity_id",
        "lastservednotice",
        ["fides_user_device_provided_identity_id"],
        unique=False,
    )
    op.create_index(
        "ix_lastservednotice_feature", "lastservednotice", ["feature"], unique=False
    )
    op.create_index(
        "ix_lastservednotice_created_at",
        "lastservednotice",
        ["created_at"],
        unique=False,
    )
    # ### end Alembic commands ###
