"""add cookie table

Revision ID: 2be84e68df32
Revises: c1885270b3cc
Create Date: 2023-06-13 23:08:35.011377

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "2be84e68df32"
down_revision = "c1885270b3cc"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "cookies",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("domain", sa.String(), nullable=True),
        sa.Column("path", sa.String(), nullable=True),
        sa.Column("system_id", sa.String(), nullable=True),
        sa.Column("privacy_declaration_id", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["privacy_declaration_id"], ["privacydeclaration.id"], ondelete="SET NULL"
        ),
        sa.ForeignKeyConstraint(["system_id"], ["ctl_systems.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint(
            "name", "privacy_declaration_id", name="_cookie_name_privacy_declaration_uc"
        ),
    )
    op.create_index(op.f("ix_cookies_id"), "cookies", ["id"], unique=False)
    op.create_index(op.f("ix_cookies_name"), "cookies", ["name"], unique=False)
    op.create_index(
        op.f("ix_cookies_privacy_declaration_id"),
        "cookies",
        ["privacy_declaration_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_cookies_system_id"), "cookies", ["system_id"], unique=False
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_cookies_system_id"), table_name="cookies")
    op.drop_index(op.f("ix_cookies_privacy_declaration_id"), table_name="cookies")
    op.drop_index(op.f("ix_cookies_name"), table_name="cookies")
    op.drop_index(op.f("ix_cookies_id"), table_name="cookies")
    op.drop_table("cookies")
    # ### end Alembic commands ###
